/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.world;

import com.aragon.client.Client;
import com.aragon.client.ClientSettings;
import com.aragon.client.api.event.TileMarkerAddedEvent;
import com.aragon.client.plugins.TileMarkerEditor;
import com.aragon.entity.Animable;
import com.aragon.entity.GroundItem;
import com.aragon.graphics.DrawingArea;
import com.aragon.graphics.Rasterizer;
import com.aragon.graphics.model.Model;
import com.aragon.graphics.model.VertexNormal;
import com.aragon.util.Deque;
import com.aragon.world.CullingCluster;
import com.aragon.world.GroundDecoration;
import com.aragon.world.HighlightTile;
import com.aragon.world.InteractableObject;
import com.aragon.world.PlainTile;
import com.aragon.world.ShapedTile;
import com.aragon.world.Tile;
import com.aragon.world.WallDecoration;
import com.aragon.world.WallObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class WorldController {
    private int regionBaseX = 0;
    private int regionBaseY = 0;
    private int nextMarkerId = 1;
    public Map<Integer, HighlightTile> userMarkers = new HashMap<Integer, HighlightTile>();
    public HighlightTile playerStandingHighlight = null;
    public HighlightTile hoverHighlightTile = null;
    private HighlightTile walkDestinationHighlight = null;
    public static boolean lowMem = true;
    private final int zMapSize;
    private final int xMapSize;
    private final int yMapSize;
    private final int[][][] heightMap;
    public final Tile[][][] tileArray;
    public HighlightTile[][][] highlightTiles;
    private int currentHL;
    private int amountOfInteractableObjects;
    private final InteractableObject[] interactableObjectCache;
    private final int[][][] anIntArrayArrayArray445;
    private static int anInt446;
    private static int plane__;
    private static int anInt448;
    private static int anInt449;
    private static int anInt450;
    private static int anInt451;
    private static int anInt452;
    private static int xCamPosTile;
    private static int yCamPosTile;
    private static int xCamPos;
    private static int zCamPos;
    private static int yCamPos;
    private static int yCurveSin;
    private static int yCUrveCos;
    private static int xCurveSin;
    private static int xCurveCos;
    private static InteractableObject[] aClass28Array462;
    private static final int[] faceXoffset2;
    private static final int[] faceYOffset2;
    private static final int[] faceXOffset3;
    private static final int[] faceYOffset3;
    private static boolean isClicked;
    private static int clickX;
    private static int clickY;
    public static int clickedTileX;
    public static int clickedTileY;
    private static int hoveringX;
    private static int hoveringY;
    public static int hoveredTileX;
    public static int hoveredTileY;
    private static final int amountOfCullingClusters;
    private static int[] cullingClusterPointer;
    private static CullingCluster[][] cullingClusters;
    private static int processedClusterPtr;
    private static final CullingCluster[] processedClusters;
    private static Deque tileDeque;
    private static final int[] anIntArray478;
    private static final int[] anIntArray479;
    private static final int[] anIntArray480;
    private static final int[] anIntArray481;
    private static final int[] anIntArray482;
    private static final int[] anIntArray483;
    private static final int[] anIntArray484;
    private static final int[] anIntArray485;
    private final int[] anIntArray486;
    private final int[] anIntArray487;
    private int anInt488;
    private final int[][] tileSHapePoints;
    private final int[][] tileShapeIndices;
    private static boolean[][][][] tile_visibility_maps;
    private static boolean[][] tile_visibility_map;
    private static int midX;
    private static int midY;
    private static int left;
    private static int top;
    private static int right;
    private static int bottom;
    public static int focalLength;

    static {
        aClass28Array462 = new InteractableObject[100];
        faceXoffset2 = new int[]{53, -53, -53, 53};
        faceYOffset2 = new int[]{-53, -53, 53, 53};
        faceXOffset3 = new int[]{-45, 45, 45, -45};
        faceYOffset3 = new int[]{45, 45, -45, -45};
        clickedTileX = -1;
        clickedTileY = -1;
        hoveredTileX = -1;
        hoveredTileY = -1;
        processedClusters = new CullingCluster[500];
        tileDeque = new Deque();
        anIntArray478 = new int[]{19, 55, 38, 155, 255, 110, 137, 205, 76};
        int[] nArray = new int[9];
        nArray[0] = 160;
        nArray[1] = 192;
        nArray[2] = 80;
        nArray[3] = 96;
        nArray[5] = 144;
        nArray[6] = 80;
        nArray[7] = 48;
        nArray[8] = 160;
        anIntArray479 = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = 76;
        nArray2[1] = 8;
        nArray2[2] = 137;
        nArray2[3] = 4;
        nArray2[5] = 1;
        nArray2[6] = 38;
        nArray2[7] = 2;
        nArray2[8] = 19;
        anIntArray480 = nArray2;
        int[] nArray3 = new int[9];
        nArray3[2] = 2;
        nArray3[5] = 2;
        nArray3[6] = 1;
        nArray3[7] = 1;
        anIntArray481 = nArray3;
        int[] nArray4 = new int[9];
        nArray4[0] = 2;
        nArray4[3] = 2;
        nArray4[7] = 4;
        nArray4[8] = 4;
        anIntArray482 = nArray4;
        int[] nArray5 = new int[9];
        nArray5[1] = 4;
        nArray5[2] = 4;
        nArray5[3] = 8;
        nArray5[6] = 8;
        anIntArray483 = nArray5;
        int[] nArray6 = new int[9];
        nArray6[0] = 1;
        nArray6[1] = 1;
        nArray6[5] = 8;
        nArray6[8] = 8;
        anIntArray484 = nArray6;
        anIntArray485 = new int[]{41, 39248, 41, 4643, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 43086, 41, 41, 41, 41, 41, 41, 41, 8602, 41, 28992, 41, 41, 41, 41, 41, 5056, 41, 41, 41, 7079, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 3131, 41, 41, 41};
        tile_visibility_maps = new boolean[8][32][51][51];
        focalLength = 512;
        amountOfCullingClusters = 4;
        cullingClusterPointer = new int[amountOfCullingClusters];
        cullingClusters = new CullingCluster[amountOfCullingClusters][500];
    }

    public WorldController(int[][][] ai) {
        int[][] nArrayArray = new int[13][];
        nArrayArray[0] = new int[16];
        nArrayArray[1] = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray = new int[16];
        nArray[0] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        nArray[14] = 1;
        nArray[15] = 1;
        nArrayArray[2] = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[8] = 1;
        nArray2[12] = 1;
        nArrayArray[3] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[11] = 1;
        nArray3[15] = 1;
        nArrayArray[4] = nArray3;
        int[] nArray4 = new int[16];
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[8] = 1;
        nArray4[9] = 1;
        nArray4[10] = 1;
        nArray4[11] = 1;
        nArray4[12] = 1;
        nArray4[13] = 1;
        nArray4[14] = 1;
        nArray4[15] = 1;
        nArrayArray[5] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[0] = 1;
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        nArray5[8] = 1;
        nArray5[9] = 1;
        nArray5[10] = 1;
        nArray5[11] = 1;
        nArray5[12] = 1;
        nArray5[13] = 1;
        nArray5[14] = 1;
        nArray5[15] = 1;
        nArrayArray[6] = nArray5;
        int[] nArray6 = new int[16];
        nArray6[0] = 1;
        nArray6[1] = 1;
        nArray6[4] = 1;
        nArray6[5] = 1;
        nArray6[8] = 1;
        nArray6[9] = 1;
        nArray6[12] = 1;
        nArray6[13] = 1;
        nArrayArray[7] = nArray6;
        int[] nArray7 = new int[16];
        nArray7[8] = 1;
        nArray7[12] = 1;
        nArray7[13] = 1;
        nArrayArray[8] = nArray7;
        int[] nArray8 = new int[16];
        nArray8[0] = 1;
        nArray8[1] = 1;
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[4] = 1;
        nArray8[5] = 1;
        nArray8[6] = 1;
        nArray8[7] = 1;
        nArray8[9] = 1;
        nArray8[10] = 1;
        nArray8[11] = 1;
        nArray8[14] = 1;
        nArray8[15] = 1;
        nArrayArray[9] = nArray8;
        int[] nArray9 = new int[16];
        nArray9[0] = 1;
        nArray9[1] = 1;
        nArray9[2] = 1;
        nArray9[3] = 1;
        nArray9[4] = 1;
        nArray9[5] = 1;
        nArray9[8] = 1;
        nArray9[12] = 1;
        nArrayArray[10] = nArray9;
        int[] nArray10 = new int[16];
        nArray10[6] = 1;
        nArray10[7] = 1;
        nArray10[9] = 1;
        nArray10[10] = 1;
        nArray10[11] = 1;
        nArray10[13] = 1;
        nArray10[14] = 1;
        nArray10[15] = 1;
        nArrayArray[11] = nArray10;
        int[] nArray11 = new int[16];
        nArray11[9] = 1;
        nArray11[10] = 1;
        nArray11[12] = 1;
        nArray11[13] = 1;
        nArray11[14] = 1;
        nArray11[15] = 1;
        nArrayArray[12] = nArray11;
        this.tileSHapePoints = nArrayArray;
        int[][] nArrayArray2 = new int[4][];
        int[] nArray12 = new int[16];
        nArray12[1] = 1;
        nArray12[2] = 2;
        nArray12[3] = 3;
        nArray12[4] = 4;
        nArray12[5] = 5;
        nArray12[6] = 6;
        nArray12[7] = 7;
        nArray12[8] = 8;
        nArray12[9] = 9;
        nArray12[10] = 10;
        nArray12[11] = 11;
        nArray12[12] = 12;
        nArray12[13] = 13;
        nArray12[14] = 14;
        nArray12[15] = 15;
        nArrayArray2[0] = nArray12;
        int[] nArray13 = new int[16];
        nArray13[0] = 12;
        nArray13[1] = 8;
        nArray13[2] = 4;
        nArray13[4] = 13;
        nArray13[5] = 9;
        nArray13[6] = 5;
        nArray13[7] = 1;
        nArray13[8] = 14;
        nArray13[9] = 10;
        nArray13[10] = 6;
        nArray13[11] = 2;
        nArray13[12] = 15;
        nArray13[13] = 11;
        nArray13[14] = 7;
        nArray13[15] = 3;
        nArrayArray2[1] = nArray13;
        int[] nArray14 = new int[16];
        nArray14[0] = 15;
        nArray14[1] = 14;
        nArray14[2] = 13;
        nArray14[3] = 12;
        nArray14[4] = 11;
        nArray14[5] = 10;
        nArray14[6] = 9;
        nArray14[7] = 8;
        nArray14[8] = 7;
        nArray14[9] = 6;
        nArray14[10] = 5;
        nArray14[11] = 4;
        nArray14[12] = 3;
        nArray14[13] = 2;
        nArray14[14] = 1;
        nArrayArray2[2] = nArray14;
        int[] nArray15 = new int[16];
        nArray15[0] = 3;
        nArray15[1] = 7;
        nArray15[2] = 11;
        nArray15[3] = 15;
        nArray15[4] = 2;
        nArray15[5] = 6;
        nArray15[6] = 10;
        nArray15[7] = 14;
        nArray15[8] = 1;
        nArray15[9] = 5;
        nArray15[10] = 9;
        nArray15[11] = 13;
        nArray15[13] = 4;
        nArray15[14] = 8;
        nArray15[15] = 12;
        nArrayArray2[3] = nArray15;
        this.tileShapeIndices = nArrayArray2;
        int height = 104;
        int width = 104;
        int depth = 4;
        this.highlightTiles = new HighlightTile[depth][width][height];
        this.interactableObjectCache = new InteractableObject[5000];
        this.anIntArray486 = new int[10000];
        this.anIntArray487 = new int[10000];
        this.zMapSize = depth;
        this.xMapSize = width;
        this.yMapSize = height;
        this.tileArray = new Tile[depth][width][height];
        this.anIntArrayArrayArray445 = new int[depth][width + 1][height + 1];
        this.heightMap = ai;
        this.initToNull();
    }

    public WallObject fetchWallObject(int i, int j, int k) {
        Tile tile = this.tileArray[i][j][k];
        if (tile == null || tile.wallObject == null) {
            return null;
        }
        return tile.wallObject;
    }

    public WallDecoration fetchWallDecoration(int i, int j, int l) {
        Tile tile = this.tileArray[i][j][l];
        if (tile == null || tile.wallDecoration == null) {
            return null;
        }
        return tile.wallDecoration;
    }

    public InteractableObject fetchInteractableObject(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return null;
        }
        int l = 0;
        while (l < tile.entityCount) {
            InteractableObject interactableObject = tile.interactableObjects[l];
            if (interactableObject.tileLeft == x && interactableObject.tileTop == y) {
                return interactableObject;
            }
            ++l;
        }
        return null;
    }

    public GroundDecoration fetchGroundDecoration(int i, int j, int k) {
        Tile tile = this.tileArray[i][j][k];
        if (tile == null || tile.groundDecoration == null) {
            return null;
        }
        return tile.groundDecoration;
    }

    public int fetchWallObjectNewUID(int i, int j, int k) {
        Tile tile = this.tileArray[i][j][k];
        if (tile == null || tile.wallObject == null) {
            return 0;
        }
        return tile.wallObject.wallObjUID;
    }

    public int fetchWallDecorationNewUID(int i, int j, int l) {
        Tile tile = this.tileArray[i][j][l];
        if (tile == null || tile.wallDecoration == null) {
            return 0;
        }
        return tile.wallDecoration.wallDecorUID;
    }

    public int fetchObjectMeshNewUID(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return 0;
        }
        int l = 0;
        while (l < tile.entityCount) {
            InteractableObject interactableObject = tile.interactableObjects[l];
            if (interactableObject.tileLeft == x && interactableObject.tileTop == y) {
                return interactableObject.interactiveObjUID;
            }
            ++l;
        }
        return 0;
    }

    public int fetchGroundDecorationNewUID(int i, int j, int k) {
        Tile tile = this.tileArray[i][j][k];
        if (tile == null || tile.groundDecoration == null) {
            return 0;
        }
        return tile.groundDecoration.groundDecorUID;
    }

    public static void nullLoader() {
        aClass28Array462 = null;
        cullingClusterPointer = null;
        cullingClusters = null;
        tileDeque = null;
        tile_visibility_maps = null;
        tile_visibility_map = null;
    }

    public void initToNull() {
        int z = 0;
        while (z < this.zMapSize) {
            int x = 0;
            while (x < this.xMapSize) {
                int y = 0;
                while (y < this.yMapSize) {
                    this.tileArray[z][x][y] = null;
                    ++y;
                }
                ++x;
            }
            ++z;
        }
        int l = 0;
        while (l < amountOfCullingClusters) {
            int j1 = 0;
            while (j1 < cullingClusterPointer[l]) {
                WorldController.cullingClusters[l][j1] = null;
                ++j1;
            }
            WorldController.cullingClusterPointer[l] = 0;
            ++l;
        }
        int k1 = 0;
        while (k1 < this.amountOfInteractableObjects) {
            this.interactableObjectCache[k1] = null;
            ++k1;
        }
        this.amountOfInteractableObjects = 0;
        int l1 = 0;
        while (l1 < aClass28Array462.length) {
            WorldController.aClass28Array462[l1] = null;
            ++l1;
        }
    }

    public void initTiles(int hl) {
        this.currentHL = hl;
        int k = 0;
        while (k < this.xMapSize) {
            int l = 0;
            while (l < this.yMapSize) {
                if (this.tileArray[hl][k][l] == null) {
                    this.tileArray[hl][k][l] = new Tile(hl, k, l);
                }
                ++l;
            }
            ++k;
        }
    }

    public void setRegionBase(int baseX, int baseY) {
        boolean regionChanged = this.regionBaseX != baseX || this.regionBaseY != baseY;
        this.regionBaseX = baseX;
        this.regionBaseY = baseY;
        if (regionChanged) {
            this.clearAllHighlights();
            this.restorePersistentHighlights();
        }
    }

    private int worldToLocalX(int worldX) {
        return worldX - this.regionBaseX;
    }

    private int worldToLocalY(int worldY) {
        return worldY - this.regionBaseY;
    }

    private boolean isValidLocal(int localX, int localY) {
        return localX >= 0 && localY >= 0 && localX < this.xMapSize && localY < this.yMapSize;
    }

    public void addHighlightWorld(int plane, int worldX, int worldY, int color, int alpha, int borderSize, HighlightTile.HighlightType type) {
        int localY;
        int localX = this.worldToLocalX(worldX);
        if (!this.isValidLocal(localX, localY = this.worldToLocalY(worldY))) {
            System.out.println("Highlight out of bounds: World(" + worldX + "," + worldY + ") -> Local(" + localX + "," + localY + ")");
            return;
        }
        this.addHighlightLocal(plane, localX, localY, worldX, worldY, color, alpha, borderSize, type);
    }

    public void addHighlightLocal(int plane, int localX, int localY, int worldX, int worldY, int color, int alpha, int borderSize, HighlightTile.HighlightType type) {
        boolean hasUserMarker;
        if (!this.isValidLocal(localX, localY)) {
            return;
        }
        HighlightTile existing = this.highlightTiles[plane][localX][localY];
        boolean bl = hasUserMarker = existing != null && existing.type == HighlightTile.HighlightType.USER_MARKER;
        if (hasUserMarker && type != HighlightTile.HighlightType.USER_MARKER) {
            switch (type) {
                case PLAYER_STANDING: {
                    int oldY;
                    int oldX;
                    int oldPlane;
                    HighlightTile atOldPos;
                    if (this.playerStandingHighlight != null && (atOldPos = this.highlightTiles[oldPlane = this.playerStandingHighlight.plane][oldX = this.playerStandingHighlight.localX][oldY = this.playerStandingHighlight.localY]) == this.playerStandingHighlight) {
                        this.highlightTiles[oldPlane][oldX][oldY] = null;
                        this.restoreUserMarkerAt(oldPlane, oldX, oldY);
                    }
                    this.playerStandingHighlight = null;
                    break;
                }
                case WALK_DESTINATION: {
                    int oldY;
                    int oldX;
                    int oldPlane;
                    HighlightTile atOldPos;
                    if (this.walkDestinationHighlight != null && (atOldPos = this.highlightTiles[oldPlane = this.walkDestinationHighlight.plane][oldX = this.walkDestinationHighlight.localX][oldY = this.walkDestinationHighlight.localY]) == this.walkDestinationHighlight) {
                        this.highlightTiles[oldPlane][oldX][oldY] = null;
                        this.restoreUserMarkerAt(oldPlane, oldX, oldY);
                    }
                    this.walkDestinationHighlight = null;
                    break;
                }
                case HOVER_TILE: {
                    int oldY;
                    int oldX;
                    int oldPlane;
                    HighlightTile atOldPos;
                    if (this.hoverHighlightTile != null && (atOldPos = this.highlightTiles[oldPlane = this.hoverHighlightTile.plane][oldX = this.hoverHighlightTile.localX][oldY = this.hoverHighlightTile.localY]) == this.hoverHighlightTile) {
                        this.highlightTiles[oldPlane][oldX][oldY] = null;
                        this.restoreUserMarkerAt(oldPlane, oldX, oldY);
                    }
                    this.hoverHighlightTile = null;
                }
            }
            System.out.println("Skipping temporary highlight - user marker exists at (" + localX + "," + localY + ")");
            return;
        }
        HighlightTile highlight = new HighlightTile(plane, localX, localY, color, alpha, borderSize, type);
        if (type == HighlightTile.HighlightType.USER_MARKER) {
            highlight.worldX = worldX;
            highlight.worldY = worldY;
        }
        switch (type) {
            case PLAYER_STANDING: {
                int oldY;
                int oldX;
                int oldPlane;
                HighlightTile atOldPos;
                if (this.playerStandingHighlight != null && (atOldPos = this.highlightTiles[oldPlane = this.playerStandingHighlight.plane][oldX = this.playerStandingHighlight.localX][oldY = this.playerStandingHighlight.localY]) == this.playerStandingHighlight) {
                    this.highlightTiles[oldPlane][oldX][oldY] = null;
                    this.restoreUserMarkerAt(oldPlane, oldX, oldY);
                }
                this.playerStandingHighlight = highlight;
                break;
            }
            case WALK_DESTINATION: {
                int oldY;
                int oldX;
                int oldPlane;
                HighlightTile atOldPos;
                if (this.walkDestinationHighlight != null && (atOldPos = this.highlightTiles[oldPlane = this.walkDestinationHighlight.plane][oldX = this.walkDestinationHighlight.localX][oldY = this.walkDestinationHighlight.localY]) == this.walkDestinationHighlight) {
                    this.highlightTiles[oldPlane][oldX][oldY] = null;
                    this.restoreUserMarkerAt(oldPlane, oldX, oldY);
                }
                this.walkDestinationHighlight = highlight;
                break;
            }
            case HOVER_TILE: {
                int oldY;
                int oldX;
                int oldPlane;
                HighlightTile atOldPos;
                if (this.hoverHighlightTile != null && (atOldPos = this.highlightTiles[oldPlane = this.hoverHighlightTile.plane][oldX = this.hoverHighlightTile.localX][oldY = this.hoverHighlightTile.localY]) == this.hoverHighlightTile) {
                    this.highlightTiles[oldPlane][oldX][oldY] = null;
                    this.restoreUserMarkerAt(oldPlane, oldX, oldY);
                }
                this.hoverHighlightTile = highlight;
                break;
            }
            case USER_MARKER: {
                highlight.markerId = this.nextMarkerId++;
                highlight.persistent = true;
                this.userMarkers.put(highlight.markerId, highlight);
            }
        }
        this.highlightTiles[plane][localX][localY] = highlight;
    }

    private void restoreUserMarkerAt(int plane, int localX, int localY) {
        int worldX = localX + this.regionBaseX;
        int worldY = localY + this.regionBaseY;
        for (HighlightTile marker : this.userMarkers.values()) {
            if (marker.plane != plane || marker.worldX != worldX || marker.worldY != worldY) continue;
            marker.localX = localX;
            marker.localY = localY;
            this.highlightTiles[plane][localX][localY] = marker;
            System.out.println("Restored user marker #" + marker.markerId + " at (" + localX + "," + localY + ")");
            break;
        }
    }

    public void removeHighlightWorld(int plane, int worldX, int worldY) {
        int localY;
        int localX = this.worldToLocalX(worldX);
        if (!this.isValidLocal(localX, localY = this.worldToLocalY(worldY))) {
            return;
        }
        this.removeHighlightLocal(plane, localX, localY);
    }

    public void removeHighlightTile(HighlightTile highlightTile) {
        int localY;
        int localX = this.worldToLocalX(highlightTile.worldX);
        if (!this.isValidLocal(localX, localY = this.worldToLocalY(highlightTile.worldY))) {
            return;
        }
        this.removeHighlightLocal(highlightTile.plane, localX, localY);
    }

    public void removeHighlightLocal(int plane, int localX, int localY) {
        if (!this.isValidLocal(localX, localY)) {
            return;
        }
        HighlightTile highlight = this.highlightTiles[plane][localX][localY];
        if (highlight != null) {
            if (highlight.type == HighlightTile.HighlightType.USER_MARKER) {
                System.out.println("Cannot remove user marker with removeHighlightLocal - use removeUserMarker instead");
                return;
            }
            if (highlight == this.playerStandingHighlight) {
                this.playerStandingHighlight = null;
            } else if (highlight == this.walkDestinationHighlight) {
                this.walkDestinationHighlight = null;
            } else if (highlight == this.hoverHighlightTile) {
                this.hoverHighlightTile = null;
            }
            this.highlightTiles[plane][localX][localY] = null;
            this.restoreUserMarkerAt(plane, localX, localY);
        }
    }

    public int addUserMarker(int plane, int worldX, int worldY, int color, int alpha, int borderSize, String label) {
        int localY;
        int localX = this.worldToLocalX(worldX);
        if (!this.isValidLocal(localX, localY = this.worldToLocalY(worldY))) {
            System.out.println("Cannot add user marker - out of current region bounds");
            return -1;
        }
        HighlightTile marker = new HighlightTile(plane, localX, localY, color, alpha, borderSize, HighlightTile.HighlightType.USER_MARKER, true);
        marker.markerId = this.nextMarkerId++;
        marker.markerLabel = label;
        marker.worldX = worldX;
        marker.worldY = worldY;
        this.userMarkers.put(marker.markerId, marker);
        this.highlightTiles[plane][localX][localY] = marker;
        System.out.println("Added user marker #" + marker.markerId + " at world(" + worldX + "," + worldY + ") -> local(" + localX + "," + localY + ")");
        if (Client.getClient() != null) {
            Client.getClient();
            if (Client.getPluginManager() != null) {
                TileMarkerAddedEvent event = new TileMarkerAddedEvent(marker.markerId, worldX, worldY, plane);
                Client.getClient();
                Client.getPluginManager().triggerEvent(event);
            }
        }
        return marker.markerId;
    }

    public void removeUserMarker(int markerId) {
        HighlightTile marker = this.userMarkers.get(markerId);
        if (marker != null) {
            this.highlightTiles[marker.plane][marker.localX][marker.localY] = null;
            this.userMarkers.remove(markerId);
        }
    }

    public void removeUserMarkerByCoords(int localX, int localY, int plane) {
        if (!this.isValidLocal(localX, localY)) {
            return;
        }
        HighlightTile highlight = this.highlightTiles[plane][localX][localY];
        if (highlight != null && highlight.type == HighlightTile.HighlightType.USER_MARKER) {
            this.highlightTiles[plane][localX][localY] = null;
            this.userMarkers.remove(highlight.markerId);
            System.out.println("Removed user marker #" + highlight.markerId + " at local(" + localX + "," + localY + ") plane=" + plane);
        }
    }

    public void removeUserMarkerByWorldCoords(int worldX, int worldY, int plane) {
        int localX = this.worldToLocalX(worldX);
        int localY = this.worldToLocalY(worldY);
        this.removeUserMarkerByCoords(localX, localY, plane);
    }

    public Collection<HighlightTile> getUserMarkers() {
        return this.userMarkers.values();
    }

    public void clearAllHighlights() {
        int z = 0;
        while (z < this.zMapSize) {
            int x = 0;
            while (x < this.xMapSize) {
                int y = 0;
                while (y < this.yMapSize) {
                    this.highlightTiles[z][x][y] = null;
                    ++y;
                }
                ++x;
            }
            ++z;
        }
        this.playerStandingHighlight = null;
        this.walkDestinationHighlight = null;
    }

    public void restorePersistentHighlights() {
        int restored = 0;
        for (HighlightTile marker : this.userMarkers.values()) {
            int localY;
            int localX = this.worldToLocalX(marker.worldX);
            if (!this.isValidLocal(localX, localY = this.worldToLocalY(marker.worldY))) continue;
            marker.localX = localX;
            marker.localY = localY;
            this.highlightTiles[marker.plane][localX][localY] = marker;
            ++restored;
        }
        System.out.println("Restored " + restored + " / " + this.userMarkers.size() + " user markers in current region");
    }

    public void applyBridgeMode(int y, int x) {
        Tile tile = this.tileArray[0][x][y];
        int l = 0;
        while (l < 3) {
            this.tileArray[l][x][y] = this.tileArray[l + 1][x][y];
            Tile tile_ = this.tileArray[l][x][y];
            if (tile_ != null) {
                --tile_.tileZ;
                int entityPtr = 0;
                while (entityPtr < tile_.entityCount) {
                    InteractableObject iObject = tile_.interactableObjects[entityPtr];
                    if ((iObject.uid >> 29 & 3) == 2 && iObject.tileLeft == x && iObject.tileTop == y) {
                        --iObject.zPos;
                    }
                    ++entityPtr;
                }
            }
            ++l;
        }
        if (this.tileArray[0][x][y] == null) {
            this.tileArray[0][x][y] = new Tile(0, x, y);
        }
        this.tileArray[0][x][y].tileBelowThisTile = tile;
        this.tileArray[3][x][y] = null;
    }

    public static void createCullingCluster(int id, int tileStartX, int worldEndZ, int tileEndX, int tileEndY, int worldStartZ, int tileStartY, int searchMask) {
        CullingCluster cluster = new CullingCluster();
        cluster.tileStartX = tileStartX / 128;
        cluster.tileEndX = tileEndX / 128;
        cluster.tileStartY = tileStartY / 128;
        cluster.tileEndY = tileEndY / 128;
        cluster.searchMask = searchMask;
        cluster.worldStartX = tileStartX;
        cluster.worldEndX = tileEndX;
        cluster.worldStartY = tileStartY;
        cluster.worldEndY = tileEndY;
        cluster.worldStartZ = worldStartZ;
        cluster.worldEndZ = worldEndZ;
        int n = id;
        int n2 = cullingClusterPointer[n];
        cullingClusterPointer[n] = n2 + 1;
        WorldController.cullingClusters[id][n2] = cluster;
    }

    public void setVisiblePlanesFor(int z, int x, int y, int logicHeight) {
        Tile tile = this.tileArray[z][x][y];
        if (tile != null) {
            this.tileArray[z][x][y].logicHeight = logicHeight;
        }
    }

    public void method279(int i, int j, int k, int l, int i1, int overlaytex, int underlaytex, int k1, int l1, int i2, int j2, int k2, int l2, int i3, int j3, int k3, int l3, int i4, int j4, int k4, int l4, boolean tex) {
        if (l == 0) {
            PlainTile class43 = new PlainTile(k2, l2, i3, j3, underlaytex, k4, false, tex);
            int i5 = i;
            while (i5 >= 0) {
                if (this.tileArray[i5][j][k] == null) {
                    this.tileArray[i5][j][k] = new Tile(i5, j, k);
                }
                --i5;
            }
            this.tileArray[i][j][k].plainTile = class43;
            return;
        }
        if (l == 1) {
            PlainTile class43_1 = new PlainTile(k3, l3, i4, j4, overlaytex, l4, k1 == l1 && k1 == i2 && k1 == j2, tex);
            int j5 = i;
            while (j5 >= 0) {
                if (this.tileArray[j5][j][k] == null) {
                    this.tileArray[j5][j][k] = new Tile(j5, j, k);
                }
                --j5;
            }
            this.tileArray[i][j][k].plainTile = class43_1;
            return;
        }
        ShapedTile class40 = new ShapedTile(k, k3, j3, i2, overlaytex, underlaytex, i4, i1, k2, k4, i3, j2, l1, k1, l, j4, l3, l2, j, l4, tex);
        int k5 = i;
        while (k5 >= 0) {
            if (this.tileArray[k5][j][k] == null) {
                this.tileArray[k5][j][k] = new Tile(k5, j, k);
            }
            --k5;
        }
        this.tileArray[i][j][k].shapedTile = class40;
    }

    public void addGroundDecoration(int plane, int zPos, int yPos, Animable animable, byte byte0, int uid, int xPos, int groundDecorUID) {
        if (animable == null) {
            return;
        }
        GroundDecoration decoration = new GroundDecoration();
        decoration.node = animable;
        decoration.groundDecorUID = groundDecorUID;
        decoration.xPos = xPos * 128 + 64;
        decoration.yPos = yPos * 128 + 64;
        decoration.zPos = zPos;
        decoration.uid = uid;
        decoration.objConfig = byte0;
        if (this.tileArray[plane][xPos][yPos] == null) {
            this.tileArray[plane][xPos][yPos] = new Tile(plane, xPos, yPos);
        }
        this.tileArray[plane][xPos][yPos].groundDecoration = decoration;
    }

    public void addGroundItemTile(int xPos, int uid, Animable secondItem, int zPos, Animable thirdItem, Animable firstItem, int plane, int yPos) {
        GroundItem groundItem = new GroundItem();
        groundItem.firstGroundItem = firstItem;
        groundItem.xPos = xPos * 128 + 64;
        groundItem.yPos = yPos * 128 + 64;
        groundItem.zPos = zPos;
        groundItem.uid = uid;
        groundItem.secondGroundItem = secondItem;
        groundItem.thirdGroundItem = thirdItem;
        int isHighestPriority = 0;
        Tile tile = this.tileArray[plane][xPos][yPos];
        if (tile != null) {
            int k1 = 0;
            while (k1 < tile.entityCount) {
                int tempInt;
                if (tile.interactableObjects[k1].node instanceof Model && (tempInt = ((Model)tile.interactableObjects[k1].node).myPriority) > isHighestPriority) {
                    isHighestPriority = tempInt;
                }
                ++k1;
            }
        }
        groundItem.topItem = isHighestPriority;
        if (this.tileArray[plane][xPos][yPos] == null) {
            this.tileArray[plane][xPos][yPos] = new Tile(plane, xPos, yPos);
        }
        this.tileArray[plane][xPos][yPos].groundItem = groundItem;
    }

    public void addWallObject(int orientation, Animable node, int uid, int yPos, byte objConfig, int xPos, Animable node2, int zPos, int orientation_2, int plane, int wallObjUID) {
        if (node == null && node2 == null) {
            return;
        }
        WallObject wallObject = new WallObject();
        wallObject.uid = uid;
        wallObject.objConfig = objConfig;
        wallObject.xPos = xPos * 128 + 64;
        wallObject.yPos = yPos * 128 + 64;
        wallObject.zPos = zPos;
        wallObject.node1 = node;
        wallObject.node2 = node2;
        wallObject.wallObjUID = wallObjUID;
        wallObject.orientation = orientation;
        wallObject.orientation1 = orientation_2;
        int zPtr = plane;
        while (zPtr >= 0) {
            if (this.tileArray[zPtr][xPos][yPos] == null) {
                this.tileArray[zPtr][xPos][yPos] = new Tile(zPtr, xPos, yPos);
            }
            --zPtr;
        }
        this.tileArray[plane][xPos][yPos].wallObject = wallObject;
    }

    public void addWallDecoration(int uid, int yPos, int rotation, int plane, int xOff, int zPos, Animable node, int xPos, byte config, int yOff, int configBits, int wallDecorUID) {
        if (node == null) {
            return;
        }
        WallDecoration dec = new WallDecoration();
        dec.uid = uid;
        dec.objConfig = config;
        dec.xPos = xPos * 128 + 64 + xOff;
        dec.yPos = yPos * 128 + 64 + yOff;
        dec.zPos = zPos;
        dec.node = node;
        dec.wallDecorUID = wallDecorUID;
        dec.configurationBits = configBits;
        dec.rotation = rotation;
        int zPtr = plane;
        while (zPtr >= 0) {
            if (this.tileArray[zPtr][xPos][yPos] == null) {
                this.tileArray[zPtr][xPos][yPos] = new Tile(zPtr, xPos, yPos);
            }
            --zPtr;
        }
        this.tileArray[plane][xPos][yPos].wallDecoration = dec;
    }

    public boolean addInteractableEntity(int ui, byte config, int worldZ, int tileBottom, Animable node, int tileRight, int z, int rotation, int tileTop, int tileLeft, int interactiveUID) {
        if (node == null) {
            return true;
        }
        int worldX = tileLeft * 128 + 64 * tileRight;
        int worldY = tileTop * 128 + 64 * tileBottom;
        return this.addEntity(z, tileLeft, tileTop, tileRight, tileBottom, worldX, worldY, worldZ, node, rotation, false, ui, config, interactiveUID);
    }

    public boolean addMutipleTileEntity(int z, int rotation, int worldZ, int ui, int worldY, int j1, int worldX, Animable nodeToAdd, boolean flag) {
        if (nodeToAdd == null) {
            return true;
        }
        int tileLeft = worldX - j1;
        int tileTop = worldY - j1;
        int tileRight = worldX + j1;
        int tileBottom = worldY + j1;
        if (flag) {
            if (rotation > 640 && rotation < 1408) {
                tileBottom += 128;
            }
            if (rotation > 1152 && rotation < 1920) {
                tileRight += 128;
            }
            if (rotation > 1664 || rotation < 384) {
                tileTop -= 128;
            }
            if (rotation > 128 && rotation < 896) {
                tileLeft -= 128;
            }
        }
        return this.addEntity(z, tileLeft /= 128, tileTop /= 128, (tileRight /= 128) - tileLeft + 1, (tileBottom /= 128) - tileTop + 1, worldX, worldY, worldZ, nodeToAdd, rotation, true, ui, (byte)0, 0);
    }

    public boolean addSingleTileEntity(int z, int worldY, Animable node, int rotation, int tileBottom, int worldX, int worldZ, int tileLeft, int tileRight, int ui, int tileTop) {
        return node == null || this.addEntity(z, tileLeft, tileTop, tileRight - tileLeft + 1, tileBottom - tileTop + 1, worldX, worldY, worldZ, node, rotation, true, ui, (byte)0, 0);
    }

    private boolean addEntity(int z, int tileLeft, int tileTop, int tileRight, int tileBottom, int worldX, int worldY, int worldZ, Animable node, int rotation, boolean flag, int ui, byte objConf, int interactiveObjUID) {
        int _x = tileLeft;
        while (_x < tileLeft + tileRight) {
            int _y = tileTop;
            while (_y < tileTop + tileBottom) {
                if (_x < 0 || _y < 0 || _x >= this.xMapSize || _y >= this.yMapSize) {
                    return false;
                }
                Tile tile = this.tileArray[z][_x][_y];
                if (tile != null && tile.entityCount >= 5) {
                    return false;
                }
                ++_y;
            }
            ++_x;
        }
        InteractableObject io = new InteractableObject();
        io.uid = ui;
        io.objConf = objConf;
        io.zPos = z;
        io.worldX = worldX;
        io.worldY = worldY;
        io.interactiveObjUID = interactiveObjUID;
        io.worldZ = worldZ;
        io.node = node;
        io.rotation = rotation;
        io.tileLeft = tileLeft;
        io.tileTop = tileTop;
        io.tileRight = tileLeft + tileRight - 1;
        io.tileBottom = tileTop + tileBottom - 1;
        int x = tileLeft;
        while (x < tileLeft + tileRight) {
            int y = tileTop;
            while (y < tileTop + tileBottom) {
                int position = 0;
                if (x > tileLeft) {
                    ++position;
                }
                if (x < tileLeft + tileRight - 1) {
                    position += 4;
                }
                if (y > tileTop) {
                    position += 8;
                }
                if (y < tileTop + tileBottom - 1) {
                    position += 2;
                }
                int zPtr = z;
                while (zPtr >= 0) {
                    if (this.tileArray[zPtr][x][y] == null) {
                        this.tileArray[zPtr][x][y] = new Tile(zPtr, x, y);
                    }
                    --zPtr;
                }
                Tile tile = this.tileArray[z][x][y];
                tile.interactableObjects[tile.entityCount] = io;
                tile.anIntArray1319[tile.entityCount] = position;
                tile.anInt1320 |= position;
                ++tile.entityCount;
                ++y;
            }
            ++x;
        }
        if (flag) {
            this.interactableObjectCache[this.amountOfInteractableObjects++] = io;
        }
        return true;
    }

    public void clearInteractableObjects() {
        int i = 0;
        while (i < this.amountOfInteractableObjects) {
            InteractableObject iObject = this.interactableObjectCache[i];
            this.updateObjectEntities(iObject);
            this.interactableObjectCache[i] = null;
            ++i;
        }
        this.amountOfInteractableObjects = 0;
    }

    private void updateObjectEntities(InteractableObject iObject) {
        int j = iObject.tileLeft;
        while (j <= iObject.tileRight) {
            int k = iObject.tileTop;
            while (k <= iObject.tileBottom) {
                Tile tile = this.tileArray[iObject.zPos][j][k];
                if (tile != null) {
                    int l = 0;
                    while (l < tile.entityCount) {
                        if (tile.interactableObjects[l] == iObject) {
                            --tile.entityCount;
                            int entityPtr = l;
                            while (entityPtr < tile.entityCount) {
                                tile.interactableObjects[entityPtr] = tile.interactableObjects[entityPtr + 1];
                                tile.anIntArray1319[entityPtr] = tile.anIntArray1319[entityPtr + 1];
                                ++entityPtr;
                            }
                            tile.interactableObjects[tile.entityCount] = null;
                            break;
                        }
                        ++l;
                    }
                    tile.anInt1320 = 0;
                    int j1 = 0;
                    while (j1 < tile.entityCount) {
                        tile.anInt1320 |= tile.anIntArray1319[j1];
                        ++j1;
                    }
                }
                ++k;
            }
            ++j;
        }
    }

    public void moveWallDec(int y, int moveAmt, int x, int z) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return;
        }
        WallDecoration wallDec = tile.wallDecoration;
        if (wallDec != null) {
            int xCoord = x * 128 + 64;
            int yCoord = y * 128 + 64;
            wallDec.xPos = xCoord + (wallDec.xPos - xCoord) * moveAmt / 16;
            wallDec.yPos = yCoord + (wallDec.yPos - yCoord) * moveAmt / 16;
        }
    }

    public void removeWallObject(int x, int y, int z) {
        Tile tile = this.tileArray[y][x][z];
        if (tile != null) {
            tile.wallObject = null;
        }
    }

    public void removeWallDecoration(int y, int z, int x) {
        Tile tile = this.tileArray[z][x][y];
        if (tile != null) {
            tile.wallDecoration = null;
        }
    }

    public void removeInteractableObject(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return;
        }
        int i = 0;
        while (i < tile.entityCount) {
            InteractableObject subObject = tile.interactableObjects[i];
            if ((subObject.uid >> 29 & 3) == 2 && subObject.tileLeft == x && subObject.tileTop == y) {
                this.updateObjectEntities(subObject);
                return;
            }
            ++i;
        }
    }

    public void removeGroundDecoration(int z, int y, int x) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return;
        }
        tile.groundDecoration = null;
    }

    public void removeGroundItemFromTIle(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile != null) {
            tile.groundItem = null;
        }
    }

    public WallObject getWallObject(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return null;
        }
        return tile.wallObject;
    }

    public WallDecoration getWallDecoration(int x, int y, int z) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return null;
        }
        return tile.wallDecoration;
    }

    public InteractableObject getInteractableObject(int x, int y, int z) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return null;
        }
        int l = 0;
        while (l < tile.entityCount) {
            InteractableObject subObject = tile.interactableObjects[l];
            if ((subObject.uid >> 29 & 3) == 2 && subObject.tileLeft == x && subObject.tileTop == y) {
                return subObject;
            }
            ++l;
        }
        return null;
    }

    public GroundDecoration getGroundDecoration(int y, int x, int z) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null || tile.groundDecoration == null) {
            return null;
        }
        return tile.groundDecoration;
    }

    public int getWallObjectUID(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null || tile.wallObject == null) {
            return 0;
        }
        return tile.wallObject.uid;
    }

    public int getWallDecorationUID(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null || tile.wallDecoration == null) {
            return 0;
        }
        return tile.wallDecoration.uid;
    }

    public int getInteractableObjectUID(int plane, int x, int y) {
        Tile tile = this.tileArray[plane][x][y];
        if (tile == null) {
            return 0;
        }
        int i = 0;
        while (i < tile.entityCount) {
            InteractableObject iObject = tile.interactableObjects[i];
            if (iObject.tileLeft == x && iObject.tileTop == y) {
                return iObject.uid;
            }
            ++i;
        }
        return 0;
    }

    public int getGroundDecorationUID(int z, int x, int y) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null || tile.groundDecoration == null) {
            return 0;
        }
        return tile.groundDecoration.uid;
    }

    public int getIDTagForXYZ(int z, int x, int y, int uidMatch) {
        Tile tile = this.tileArray[z][x][y];
        if (tile == null) {
            return -1;
        }
        if (tile.wallObject != null && tile.wallObject.uid == uidMatch) {
            return tile.wallObject.objConfig & 0xFF;
        }
        if (tile.wallDecoration != null && tile.wallDecoration.uid == uidMatch) {
            return tile.wallDecoration.objConfig & 0xFF;
        }
        if (tile.groundDecoration != null && tile.groundDecoration.uid == uidMatch) {
            return tile.groundDecoration.objConfig & 0xFF;
        }
        int entityPtr = 0;
        while (entityPtr < tile.entityCount) {
            if (tile.interactableObjects[entityPtr].uid == uidMatch) {
                return tile.interactableObjects[entityPtr].objConf & 0xFF;
            }
            ++entityPtr;
        }
        return -1;
    }

    public void shadeModels(int i, int k, int i1) {
        int j = 100;
        int l = 5500;
        int j1 = (int)Math.sqrt(k * k + i * i + i1 * i1);
        int k1 = l >> 4;
        int l1 = 0;
        while (l1 < this.zMapSize) {
            int i2 = 0;
            while (i2 < this.xMapSize) {
                int j2 = 0;
                while (j2 < this.yMapSize) {
                    Tile class30_sub3 = this.tileArray[l1][i2][j2];
                    if (class30_sub3 != null) {
                        WallObject class10 = class30_sub3.wallObject;
                        if (class10 != null && class10.node1 != null && class10.node1.vertexNormals != null) {
                            this.mergeModels(l1, 1, 1, i2, j2, (Model)class10.node1);
                            if (class10.node2 != null && class10.node2.vertexNormals != null) {
                                this.mergeModels(l1, 1, 1, i2, j2, (Model)class10.node2);
                                this.renderModels((Model)class10.node1, (Model)class10.node2, 0, 0, 0, false);
                                ((Model)class10.node2).method480(j, k1, k, i, i1);
                            }
                            ((Model)class10.node1).method480(j, k1, k, i, i1);
                        }
                        int k2 = 0;
                        while (k2 < class30_sub3.entityCount) {
                            InteractableObject class28 = class30_sub3.interactableObjects[k2];
                            if (class28 != null && class28.node != null && class28.node.vertexNormals != null) {
                                this.mergeModels(l1, class28.tileRight - class28.tileLeft + 1, class28.tileBottom - class28.tileTop + 1, i2, j2, (Model)class28.node);
                                ((Model)class28.node).method480(j, k1, k, i, i1);
                            }
                            ++k2;
                        }
                        GroundDecoration class49 = class30_sub3.groundDecoration;
                        if (class49 != null && class49.node.vertexNormals != null) {
                            this.renderGrounDec(i2, l1, (Model)class49.node, j2);
                            ((Model)class49.node).method480(j, k1, k, i, i1);
                        }
                    }
                    ++j2;
                }
                ++i2;
            }
            ++l1;
        }
    }

    private void renderGrounDec(int i, int j, Model model, int k) {
        Tile class30_sub3_3;
        Tile class30_sub3_2;
        Tile class30_sub3_1;
        Tile class30_sub3;
        if (ClientSettings.showGroundDecorations == 0) {
            return;
        }
        if (i < this.xMapSize && (class30_sub3 = this.tileArray[j][i + 1][k]) != null && class30_sub3.groundDecoration != null && class30_sub3.groundDecoration.node.vertexNormals != null) {
            this.renderModels(model, (Model)class30_sub3.groundDecoration.node, 128, 0, 0, true);
        }
        if (k < this.xMapSize && (class30_sub3_1 = this.tileArray[j][i][k + 1]) != null && class30_sub3_1.groundDecoration != null && class30_sub3_1.groundDecoration.node.vertexNormals != null) {
            this.renderModels(model, (Model)class30_sub3_1.groundDecoration.node, 0, 0, 128, true);
        }
        if (i < this.xMapSize && k < this.yMapSize && (class30_sub3_2 = this.tileArray[j][i + 1][k + 1]) != null && class30_sub3_2.groundDecoration != null && class30_sub3_2.groundDecoration.node.vertexNormals != null) {
            this.renderModels(model, (Model)class30_sub3_2.groundDecoration.node, 128, 0, 128, true);
        }
        if (i < this.xMapSize && k > 0 && (class30_sub3_3 = this.tileArray[j][i + 1][k - 1]) != null && class30_sub3_3.groundDecoration != null && class30_sub3_3.groundDecoration.node.vertexNormals != null) {
            this.renderModels(model, (Model)class30_sub3_3.groundDecoration.node, 128, 0, -128, true);
        }
    }

    private void mergeModels(int z, int j, int k, int x, int y, Model model) {
        boolean flag = true;
        int j1 = x;
        int k1 = x + j;
        int l1 = y - 1;
        int i2 = y + k;
        System.out.println("This method was called rendering: " + model.getModelId());
        int j2 = z;
        while (j2 <= z + 1) {
            if (j2 != this.zMapSize) {
                int k2 = j1;
                while (k2 <= k1) {
                    if (k2 >= 0 && k2 < this.xMapSize) {
                        int l2 = l1;
                        while (l2 <= i2) {
                            Tile class30_sub3;
                            if (l2 >= 0 && l2 < this.yMapSize && (!flag || k2 >= k1 || l2 >= i2 || l2 < y && k2 != x) && (class30_sub3 = this.tileArray[j2][k2][l2]) != null) {
                                int i3 = (this.heightMap[j2][k2][l2] + this.heightMap[j2][k2 + 1][l2] + this.heightMap[j2][k2][l2 + 1] + this.heightMap[j2][k2 + 1][l2 + 1]) / 4 - (this.heightMap[z][x][y] + this.heightMap[z][x + 1][y] + this.heightMap[z][x][y + 1] + this.heightMap[z][x + 1][y + 1]) / 4;
                                WallObject class10 = class30_sub3.wallObject;
                                if (class10 != null && class10.node1 != null && class10.node1.vertexNormals != null) {
                                    this.renderModels(model, (Model)class10.node1, (k2 - x) * 128 + (1 - j) * 64, i3, (l2 - y) * 128 + (1 - k) * 64, flag);
                                }
                                if (class10 != null && class10.node2 != null && class10.node2.vertexNormals != null) {
                                    this.renderModels(model, (Model)class10.node2, (k2 - x) * 128 + (1 - j) * 64, i3, (l2 - y) * 128 + (1 - k) * 64, flag);
                                }
                                int j3 = 0;
                                while (j3 < class30_sub3.entityCount) {
                                    InteractableObject class28 = class30_sub3.interactableObjects[j3];
                                    if (class28 != null && class28.node != null && class28.node.vertexNormals != null) {
                                        int k3 = class28.tileRight - class28.tileLeft + 1;
                                        int l3 = class28.tileBottom - class28.tileTop + 1;
                                        this.renderModels(model, (Model)class28.node, (class28.tileLeft - x) * 128 + (k3 - j) * 64, i3, (class28.tileTop - y) * 128 + (l3 - k) * 64, flag);
                                    }
                                    ++j3;
                                }
                            }
                            ++l2;
                        }
                    }
                    ++k2;
                }
                --j1;
                flag = false;
            }
            ++j2;
        }
    }

    private void renderModels(Model model, Model model_1, int i, int j, int k, boolean flag) {
        ++this.anInt488;
        int l = 0;
        int[] ai = model_1.anIntArray1627;
        int amtOfVertices = model_1.anInt1626;
        int verticeId = 0;
        while (verticeId < model.anInt1626) {
            int vertZ;
            int vertX;
            int vertY;
            VertexNormal vertexNormal = model.vertexNormals[verticeId];
            VertexNormal vertexNormalOff = model.vertexNormalOffset[verticeId];
            if (vertexNormalOff.anInt605 != 0 && (vertY = model.anIntArray1628[verticeId] - j) <= model_1.anInt1651 && (vertX = model.anIntArray1627[verticeId] - i) >= model_1.anInt1646 && vertX <= model_1.anInt1647 && (vertZ = model.anIntArray1629[verticeId] - k) >= model_1.anInt1649 && vertZ <= model_1.anInt1648) {
                int vertId_1 = 0;
                while (vertId_1 < amtOfVertices) {
                    VertexNormal class33_2 = model_1.vertexNormals[vertId_1];
                    VertexNormal class33_3 = model_1.vertexNormalOffset[vertId_1];
                    if (vertX == ai[vertId_1] && vertZ == model_1.anIntArray1629[vertId_1] && vertY == model_1.anIntArray1628[vertId_1] && class33_3.anInt605 != 0) {
                        vertexNormal.anInt602 += class33_3.anInt602;
                        vertexNormal.anInt603 += class33_3.anInt603;
                        vertexNormal.anInt604 += class33_3.anInt604;
                        vertexNormal.anInt605 += class33_3.anInt605;
                        class33_2.anInt602 += vertexNormalOff.anInt602;
                        class33_2.anInt603 += vertexNormalOff.anInt603;
                        class33_2.anInt604 += vertexNormalOff.anInt604;
                        class33_2.anInt605 += vertexNormalOff.anInt605;
                        ++l;
                        this.anIntArray486[verticeId] = this.anInt488;
                        this.anIntArray487[vertId_1] = this.anInt488;
                    }
                    ++vertId_1;
                }
            }
            ++verticeId;
        }
        if (l < 3 || !flag) {
            return;
        }
        int k1 = 0;
        while (k1 < model.anInt1630) {
            if (this.anIntArray486[model.anIntArray1631[k1]] == this.anInt488 && this.anIntArray486[model.anIntArray1632[k1]] == this.anInt488 && this.anIntArray486[model.anIntArray1633[k1]] == this.anInt488) {
                model.anIntArray1637[k1] = -1;
            }
            ++k1;
        }
        int l1 = 0;
        while (l1 < model_1.anInt1630) {
            if (this.anIntArray487[model_1.anIntArray1631[l1]] == this.anInt488 && this.anIntArray487[model_1.anIntArray1632[l1]] == this.anInt488 && this.anIntArray487[model_1.anIntArray1633[l1]] == this.anInt488) {
                model_1.anIntArray1637[l1] = -1;
            }
            ++l1;
        }
    }

    public void drawTileMinimap(int[] pixels, int pixelOffset, int z, int x, int y) {
        Tile class30_sub3 = this.tileArray[z][x][y];
        if (class30_sub3 == null) {
            return;
        }
        PlainTile class43 = class30_sub3.plainTile;
        if (class43 != null) {
            if (class43.anInt716 != 12345678 && class43.anInt718 != 12345678) {
                if (class43.anInt722 == 0) {
                    return;
                }
                int hs = class43.anInt716 & 0xFFFFFF80;
                int l1 = class43.anInt719 & 0x7F;
                int l2 = class43.anInt718 & 0x7F;
                int l3 = (class43.anInt716 & 0x7F) - l1;
                int l4 = (class43.anInt717 & 0x7F) - l2;
                l1 <<= 2;
                l2 <<= 2;
                int k1 = 0;
                while (k1 < 4) {
                    if (!class43.textured) {
                        pixels[pixelOffset] = Rasterizer.anIntArray1482[hs | l1 >> 2];
                        pixels[pixelOffset + 1] = Rasterizer.anIntArray1482[hs | l1 * 3 + l2 >> 4];
                        pixels[pixelOffset + 2] = Rasterizer.anIntArray1482[hs | l1 + l2 >> 3];
                        pixels[pixelOffset + 3] = Rasterizer.anIntArray1482[hs | l1 + l2 * 3 >> 4];
                    } else {
                        int j1 = class43.anInt722;
                        int lig = 255 - ((l1 >> 1) * (l1 >> 1) >> 8);
                        pixels[pixelOffset] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                        lig = 255 - ((l1 * 3 + l2 >> 3) * (l1 * 3 + l2 >> 3) >> 8);
                        pixels[pixelOffset + 1] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                        lig = 255 - ((l1 + l2 >> 2) * (l1 + l2 >> 2) >> 8);
                        pixels[pixelOffset + 2] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                        lig = 255 - ((l1 + l2 * 3 >> 3) * (l1 + l2 * 3 >> 3) >> 8);
                        pixels[pixelOffset + 3] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                    l1 += l3;
                    l2 += l4;
                    pixelOffset += 512;
                    ++k1;
                }
                return;
            }
            int mapColor = class43.anInt722;
            if (mapColor == 0) {
                return;
            }
            int k1 = 0;
            while (k1 < 4) {
                pixels[pixelOffset] = mapColor;
                pixels[pixelOffset + 1] = mapColor;
                pixels[pixelOffset + 2] = mapColor;
                pixels[pixelOffset + 3] = mapColor;
                pixelOffset += 512;
                ++k1;
            }
            return;
        }
        ShapedTile class40 = class30_sub3.shapedTile;
        if (class40 == null) {
            return;
        }
        int l1 = class40.anInt684;
        int i2 = class40.anInt685;
        int j2 = class40.anInt686;
        int k2 = class40.anInt687;
        int[] ai1 = this.tileSHapePoints[l1];
        int[] ai2 = this.tileShapeIndices[i2];
        int l2 = 0;
        if (class40.color62 != 12345678) {
            int hs1 = class40.color62 & 0xFFFFFF80;
            int l11 = class40.color92 & 0x7F;
            int l21 = class40.color82 & 0x7F;
            int l31 = (class40.color62 & 0x7F) - l11;
            int l41 = (class40.color72 & 0x7F) - l21;
            l11 <<= 2;
            l21 <<= 2;
            int k1 = 0;
            while (k1 < 4) {
                if (!class40.textured) {
                    if (ai1[ai2[l2++]] != 0) {
                        pixels[pixelOffset] = Rasterizer.anIntArray1482[hs1 | l11 >> 2];
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        pixels[pixelOffset + 1] = Rasterizer.anIntArray1482[hs1 | l11 * 3 + l21 >> 4];
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        pixels[pixelOffset + 2] = Rasterizer.anIntArray1482[hs1 | l11 + l21 >> 3];
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        pixels[pixelOffset + 3] = Rasterizer.anIntArray1482[hs1 | l11 + l21 * 3 >> 4];
                    }
                } else {
                    int lig;
                    int j1 = k2;
                    if (ai1[ai2[l2++]] != 0) {
                        lig = 255 - ((l11 >> 1) * (l11 >> 1) >> 8);
                        pixels[pixelOffset] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        lig = 255 - ((l11 * 3 + l21 >> 3) * (l11 * 3 + l21 >> 3) >> 8);
                        pixels[pixelOffset + 1] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        lig = 255 - ((l11 + l21 >> 2) * (l11 + l21 >> 2) >> 8);
                        pixels[pixelOffset + 2] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                    if (ai1[ai2[l2++]] != 0) {
                        lig = 255 - ((l11 + l21 * 3 >> 3) * (l11 + l21 * 3 >> 3) >> 8);
                        pixels[pixelOffset + 3] = ((j1 & 0xFF00FF) * lig & 0xFF00FF00) + ((j1 & 0xFF00) * lig & 0xFF0000) >> 8;
                    }
                }
                l11 += l31;
                l21 += l41;
                pixelOffset += 512;
                ++k1;
            }
            if (j2 != 0 && class40.color61 != 12345678) {
                pixelOffset -= 2048;
                l2 -= 16;
                hs1 = class40.color61 & 0xFFFFFF80;
                l11 = class40.color91 & 0x7F;
                l21 = class40.color81 & 0x7F;
                l31 = (class40.color61 & 0x7F) - l11;
                l41 = (class40.color71 & 0x7F) - l21;
                l11 <<= 2;
                l21 <<= 2;
                k1 = 0;
                while (k1 < 4) {
                    if (ai1[ai2[l2++]] == 0) {
                        pixels[pixelOffset] = Rasterizer.anIntArray1482[hs1 | l11 >> 2];
                    }
                    if (ai1[ai2[l2++]] == 0) {
                        pixels[pixelOffset + 1] = Rasterizer.anIntArray1482[hs1 | l11 * 3 + l21 >> 4];
                    }
                    if (ai1[ai2[l2++]] == 0) {
                        pixels[pixelOffset + 2] = Rasterizer.anIntArray1482[hs1 | l11 + l21 >> 3];
                    }
                    if (ai1[ai2[l2++]] == 0) {
                        pixels[pixelOffset + 3] = Rasterizer.anIntArray1482[hs1 | l11 + l21 * 3 >> 4];
                    }
                    l11 += l31;
                    l21 += l41;
                    pixelOffset += 512;
                    ++k1;
                }
            }
            return;
        }
        if (j2 != 0) {
            int i3 = 0;
            while (i3 < 4) {
                pixels[pixelOffset] = ai1[ai2[l2++]] != 0 ? k2 : j2;
                pixels[pixelOffset + 1] = ai1[ai2[l2++]] != 0 ? k2 : j2;
                pixels[pixelOffset + 2] = ai1[ai2[l2++]] != 0 ? k2 : j2;
                pixels[pixelOffset + 3] = ai1[ai2[l2++]] != 0 ? k2 : j2;
                pixelOffset += 512;
                ++i3;
            }
            return;
        }
        int j3 = 0;
        while (j3 < 4) {
            if (ai1[ai2[l2++]] != 0) {
                pixels[pixelOffset] = k2;
            }
            if (ai1[ai2[l2++]] != 0) {
                pixels[pixelOffset + 1] = k2;
            }
            if (ai1[ai2[l2++]] != 0) {
                pixels[pixelOffset + 2] = k2;
            }
            if (ai1[ai2[l2++]] != 0) {
                pixels[pixelOffset + 3] = k2;
            }
            pixelOffset += 512;
            ++j3;
        }
    }

    public static void setupViewport(int minZ, int maxZ, int width, int height, int[] ai) {
        left = 0;
        top = 0;
        right = width;
        bottom = height;
        midX = width / 2;
        midY = height / 2;
        tile_visibility_maps = new boolean[9][32][ClientSettings.viewDistance * 2 + 1][ClientSettings.viewDistance * 2 + 1];
        boolean[][][][] isOnScreen = new boolean[9][32][ClientSettings.viewDistance * 2 + 3][ClientSettings.viewDistance * 2 + 3];
        int yAngle = 128;
        while (yAngle <= 384) {
            int xAngle = 0;
            while (xAngle < 2048) {
                yCurveSin = Model.SINE[yAngle];
                yCUrveCos = Model.COSINE[yAngle];
                xCurveSin = Model.SINE[xAngle];
                xCurveCos = Model.COSINE[xAngle];
                int l1 = (yAngle - 128) / 32;
                int j2 = xAngle / 64;
                int l2 = -(ClientSettings.viewDistance + 1);
                while (l2 <= ClientSettings.viewDistance + 1) {
                    int j3 = -(ClientSettings.viewDistance + 1);
                    while (j3 <= ClientSettings.viewDistance + 1) {
                        int k3 = l2 * 128;
                        int i4 = j3 * 128;
                        boolean flag2 = false;
                        int k4 = -minZ;
                        while (k4 <= maxZ) {
                            if (WorldController.isOnScreen(ai[l1] + k4, i4, k3)) {
                                flag2 = true;
                                break;
                            }
                            k4 += 128;
                        }
                        isOnScreen[l1][j2][l2 + ClientSettings.viewDistance + 1][j3 + ClientSettings.viewDistance + 1] = flag2;
                        ++j3;
                    }
                    ++l2;
                }
                xAngle += 64;
            }
            yAngle += 32;
        }
        int k1 = 0;
        while (k1 < 8) {
            int i2 = 0;
            while (i2 < 32) {
                int k2 = -ClientSettings.viewDistance;
                while (k2 < ClientSettings.viewDistance) {
                    int i3 = -ClientSettings.viewDistance;
                    while (i3 < ClientSettings.viewDistance) {
                        boolean flag1 = false;
                        int l3 = -1;
                        block9: while (l3 <= 1) {
                            int j4 = -1;
                            while (j4 <= 1) {
                                if (isOnScreen[k1][i2][k2 + l3 + ClientSettings.viewDistance + 1][i3 + j4 + ClientSettings.viewDistance + 1]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (isOnScreen[k1][(i2 + 1) % 31][k2 + l3 + ClientSettings.viewDistance + 1][i3 + j4 + ClientSettings.viewDistance + 1]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (isOnScreen[k1 + 1][i2][k2 + l3 + ClientSettings.viewDistance + 1][i3 + j4 + ClientSettings.viewDistance + 1]) {
                                    flag1 = true;
                                    break block9;
                                }
                                if (isOnScreen[k1 + 1][(i2 + 1) % 31][k2 + l3 + ClientSettings.viewDistance + 1][i3 + j4 + ClientSettings.viewDistance + 1]) {
                                    flag1 = true;
                                    break block9;
                                }
                                ++j4;
                            }
                            ++l3;
                        }
                        WorldController.tile_visibility_maps[k1][i2][k2 + ClientSettings.viewDistance][i3 + ClientSettings.viewDistance] = flag1;
                        ++i3;
                    }
                    ++k2;
                }
                ++i2;
            }
            ++k1;
        }
    }

    private static boolean isOnScreen(int z, int y, int x) {
        int l = y * xCurveSin + x * xCurveCos >> 16;
        int i1 = y * xCurveCos - x * xCurveSin >> 16;
        int dist = z * yCurveSin + i1 * yCUrveCos >> 16;
        int k1 = z * yCUrveCos - i1 * yCurveSin >> 16;
        if (dist < 50 || dist > Model.farClip) {
            return false;
        }
        int l1 = midX + l * focalLength / dist;
        int i2 = midY + k1 * focalLength / dist;
        return l1 >= left && l1 <= right && i2 >= top && i2 <= bottom;
    }

    public void request2DTrace(int x, int y) {
        isClicked = true;
        clickX = y;
        clickY = x;
        clickedTileX = -1;
        clickedTileY = -1;
    }

    public void request2DTraceHover(int x, int y) {
        hoveringX = x;
        hoveringY = y;
        hoveredTileX = -1;
        hoveredTileY = -1;
    }

    public void render(int xCam, int yCam, int xCurve, int zCam, int plane, int yCurve) {
        Rasterizer.resetDepthBuffer();
        if (xCam < 0) {
            xCam = 0;
        } else if (xCam >= this.xMapSize * 128) {
            xCam = this.xMapSize * 128 - 1;
        }
        if (yCam < 0) {
            yCam = 0;
        } else if (yCam >= this.yMapSize * 128) {
            yCam = this.yMapSize * 128 - 1;
        }
        ++anInt448;
        yCurveSin = Model.SINE[yCurve];
        yCUrveCos = Model.COSINE[yCurve];
        xCurveSin = Model.SINE[xCurve];
        xCurveCos = Model.COSINE[xCurve];
        tile_visibility_map = tile_visibility_maps[(yCurve - 128) / 32][xCurve / 64];
        xCamPos = xCam;
        zCamPos = zCam;
        yCamPos = yCam;
        xCamPosTile = xCam / 128;
        yCamPosTile = yCam / 128;
        plane__ = plane;
        anInt449 = xCamPosTile - ClientSettings.viewDistance;
        if (anInt449 < 0) {
            anInt449 = 0;
        }
        if ((anInt451 = yCamPosTile - ClientSettings.viewDistance) < 0) {
            anInt451 = 0;
        }
        if ((anInt450 = xCamPosTile + ClientSettings.viewDistance) > this.xMapSize) {
            anInt450 = this.xMapSize;
        }
        if ((anInt452 = yCamPosTile + ClientSettings.viewDistance) > this.yMapSize) {
            anInt452 = this.yMapSize;
        }
        this.processCulling();
        anInt446 = 0;
        int k1 = this.currentHL;
        while (k1 < this.zMapSize) {
            Tile[][] tiles = this.tileArray[k1];
            int x_ = anInt449;
            while (x_ < anInt450) {
                int y_ = anInt451;
                while (y_ < anInt452) {
                    Tile tile = tiles[x_][y_];
                    if (tile != null) {
                        if (tile.logicHeight > plane || !tile_visibility_map[x_ - xCamPosTile + ClientSettings.viewDistance][y_ - yCamPosTile + ClientSettings.viewDistance] && this.heightMap[k1][x_][y_] - zCam < 2000) {
                            tile.aBoolean1322 = false;
                            tile.aBoolean1323 = false;
                            tile.anInt1325 = 0;
                        } else {
                            tile.aBoolean1322 = true;
                            tile.aBoolean1323 = true;
                            tile.aBoolean1324 = tile.entityCount > 0;
                            ++anInt446;
                        }
                    }
                    ++y_;
                }
                ++x_;
            }
            ++k1;
        }
        int l1 = this.currentHL;
        while (l1 < this.zMapSize) {
            Tile[][] aclass30_sub3_1 = this.tileArray[l1];
            int l2 = -ClientSettings.viewDistance;
            while (l2 <= 0) {
                int i3 = xCamPosTile + l2;
                int k3 = xCamPosTile - l2;
                if (i3 >= anInt449 || k3 < anInt450) {
                    int i4 = -ClientSettings.viewDistance;
                    while (i4 <= 0) {
                        int k4 = yCamPosTile + i4;
                        int i5 = yCamPosTile - i4;
                        if (i3 >= anInt449) {
                            Tile class30_sub3_2;
                            Tile class30_sub3_1;
                            if (k4 >= anInt451 && (class30_sub3_1 = aclass30_sub3_1[i3][k4]) != null && class30_sub3_1.aBoolean1322) {
                                this.renderTile(class30_sub3_1, true);
                            }
                            if (i5 < anInt452 && (class30_sub3_2 = aclass30_sub3_1[i3][i5]) != null && class30_sub3_2.aBoolean1322) {
                                this.renderTile(class30_sub3_2, true);
                            }
                        }
                        if (k3 < anInt450) {
                            Tile class30_sub3_4;
                            Tile class30_sub3_3;
                            if (k4 >= anInt451 && (class30_sub3_3 = aclass30_sub3_1[k3][k4]) != null && class30_sub3_3.aBoolean1322) {
                                this.renderTile(class30_sub3_3, true);
                            }
                            if (i5 < anInt452 && (class30_sub3_4 = aclass30_sub3_1[k3][i5]) != null && class30_sub3_4.aBoolean1322) {
                                this.renderTile(class30_sub3_4, true);
                            }
                        }
                        if (anInt446 == 0) {
                            isClicked = false;
                            focalLength = 512;
                            return;
                        }
                        ++i4;
                    }
                }
                ++l2;
            }
            ++l1;
        }
        int j2 = this.currentHL;
        while (j2 < this.zMapSize) {
            Tile[][] aclass30_sub3_2 = this.tileArray[j2];
            int j3 = -ClientSettings.viewDistance;
            while (j3 <= 0) {
                int l3 = xCamPosTile + j3;
                int j4 = xCamPosTile - j3;
                if (l3 >= anInt449 || j4 < anInt450) {
                    int l4 = -ClientSettings.viewDistance;
                    while (l4 <= 0) {
                        int j5 = yCamPosTile + l4;
                        int k5 = yCamPosTile - l4;
                        if (l3 >= anInt449) {
                            Tile class30_sub3_6;
                            Tile class30_sub3_5;
                            if (j5 >= anInt451 && (class30_sub3_5 = aclass30_sub3_2[l3][j5]) != null && class30_sub3_5.aBoolean1322) {
                                this.renderTile(class30_sub3_5, false);
                            }
                            if (k5 < anInt452 && (class30_sub3_6 = aclass30_sub3_2[l3][k5]) != null && class30_sub3_6.aBoolean1322) {
                                this.renderTile(class30_sub3_6, false);
                            }
                        }
                        if (j4 < anInt450) {
                            Tile tile;
                            Tile class30_sub3_7;
                            if (j5 >= anInt451 && (class30_sub3_7 = aclass30_sub3_2[j4][j5]) != null && class30_sub3_7.aBoolean1322) {
                                this.renderTile(class30_sub3_7, false);
                            }
                            if (k5 < anInt452 && (tile = aclass30_sub3_2[j4][k5]) != null && tile.aBoolean1322) {
                                this.renderTile(tile, false);
                            }
                        }
                        if (anInt446 == 0) {
                            isClicked = false;
                            focalLength = 512;
                            return;
                        }
                        ++l4;
                    }
                }
                ++j3;
            }
            ++j2;
        }
        isClicked = false;
        focalLength = 512;
    }

    private void renderSingleHighlight(HighlightTile highlight, int camX, int camY, int camZ) {
        if (highlight.type == HighlightTile.HighlightType.USER_MARKER) {
            Client.getClient();
            if (!Client.getPluginManager().isPluginEnabled(TileMarkerEditor.class)) {
                return;
            }
        }
        int tileWorldX = highlight.localX * 128 + 64;
        int tileWorldY = highlight.localY * 128 + 64;
        Tile tile = this.tileArray[highlight.plane][highlight.localX][highlight.localY];
        if (tile == null) {
            return;
        }
        int height = -camZ;
        if (highlight.plane < this.zMapSize && highlight.localX < this.xMapSize && highlight.localY < this.yMapSize) {
            height = this.heightMap[highlight.plane][highlight.localX][highlight.localY] - camZ;
        }
        int borderSize = highlight.borderSize;
        this.drawHighlightSquare(highlight.localX * 128, highlight.localY * 128, height + 1, highlight.color, highlight.alpha, borderSize);
    }

    private void drawHighlightSquare(int worldX, int worldY, int worldZ, int color, int alpha, int borderSize) {
        int[][] corners = new int[4][3];
        corners[0][0] = worldX;
        corners[0][1] = worldZ;
        corners[0][2] = worldY;
        corners[1][0] = worldX + 128;
        corners[1][1] = worldZ;
        corners[1][2] = worldY;
        corners[2][0] = worldX + 128;
        corners[2][1] = worldZ;
        corners[2][2] = worldY + 128;
        corners[3][0] = worldX;
        corners[3][1] = worldZ;
        corners[3][2] = worldY + 128;
        int[] screenX = new int[4];
        int[] screenY = new int[4];
        int i = 0;
        while (i < 4) {
            int x = corners[i][0] - xCamPos;
            int z = corners[i][1];
            int y = corners[i][2] - yCamPos;
            int rotatedX = x * xCurveCos + y * xCurveSin >> 16;
            int rotatedY = y * xCurveCos - x * xCurveSin >> 16;
            int rotatedZ = z * yCUrveCos - rotatedY * yCurveSin >> 16;
            if ((rotatedY = z * yCurveSin + rotatedY * yCUrveCos >> 16) < 50) {
                return;
            }
            screenX[i] = Rasterizer.textureInt1 + rotatedX * focalLength / rotatedY;
            screenY[i] = Rasterizer.textureInt2 + rotatedZ * focalLength / rotatedY;
            ++i;
        }
        DrawingArea.fillPolygon(screenX, screenY, 4, color, alpha);
        if (borderSize > 0) {
            this.drawInwardBorder(worldX, worldY, worldZ, color, borderSize);
        } else {
            DrawingArea.drawLine(screenX[0], screenY[0], screenX[1], screenY[1], color, 255);
            DrawingArea.drawLine(screenX[1], screenY[1], screenX[2], screenY[2], color, 255);
            DrawingArea.drawLine(screenX[2], screenY[2], screenX[3], screenY[3], color, 255);
            DrawingArea.drawLine(screenX[3], screenY[3], screenX[0], screenY[0], color, 255);
        }
    }

    private void drawInwardBorder(int worldX, int worldY, int worldZ, int color, int borderSize) {
        this.drawBorderStrip(worldX, worldY, worldZ, worldX + 128, worldY + borderSize, worldZ, color);
        this.drawBorderStrip(worldX + 128 - borderSize, worldY, worldZ, worldX + 128, worldY + 128, worldZ, color);
        this.drawBorderStrip(worldX, worldY + 128 - borderSize, worldZ, worldX + 128, worldY + 128, worldZ, color);
        this.drawBorderStrip(worldX, worldY, worldZ, worldX + borderSize, worldY + 128, worldZ, color);
    }

    private void drawBorderStrip(int x1, int y1, int z1, int x2, int y2, int z2, int color) {
        int[][] corners = new int[4][3];
        corners[0][0] = x1;
        corners[0][1] = z1;
        corners[0][2] = y1;
        corners[1][0] = x2;
        corners[1][1] = z1;
        corners[1][2] = y1;
        corners[2][0] = x2;
        corners[2][1] = z2;
        corners[2][2] = y2;
        corners[3][0] = x1;
        corners[3][1] = z2;
        corners[3][2] = y2;
        int[] screenX = new int[4];
        int[] screenY = new int[4];
        int i = 0;
        while (i < 4) {
            int x = corners[i][0] - xCamPos;
            int z = corners[i][1];
            int y = corners[i][2] - yCamPos;
            int rotatedX = x * xCurveCos + y * xCurveSin >> 16;
            int rotatedY = y * xCurveCos - x * xCurveSin >> 16;
            int rotatedZ = z * yCUrveCos - rotatedY * yCurveSin >> 16;
            if ((rotatedY = z * yCurveSin + rotatedY * yCUrveCos >> 16) < 50) {
                return;
            }
            screenX[i] = Rasterizer.textureInt1 + rotatedX * focalLength / rotatedY;
            screenY[i] = Rasterizer.textureInt2 + rotatedZ * focalLength / rotatedY;
            ++i;
        }
        DrawingArea.fillPolygon(screenX, screenY, 4, color, 255);
    }

    private void drawScreenLine(int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            if (x1 >= 0 && x1 < Rasterizer.width && y1 >= 0 && y1 < Rasterizer.height) {
                Rasterizer.pixels[x1 + y1 * Rasterizer.width] = color;
            }
            if (x1 == x2 && y1 == y2) break;
            int e2 = err * 2;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    private void renderTile(Tile mainTile, boolean flag) {
        tileDeque.insertBack(mainTile);
        Tile tempTile;
        while ((tempTile = (Tile)tileDeque.popFront()) != null) {
            Tile class30_sub3_16;
            Tile class30_sub3_15;
            Tile class30_sub3_14;
            Tile class30_sub3_13;
            Tile class30_sub3_12;
            Tile class30_sub3_11;
            Tile class30_sub3_10;
            Tile class30_sub3_9;
            Tile class30_sub3_8;
            if (!tempTile.aBoolean1323) continue;
            int i = tempTile.tileX;
            int j = tempTile.tileY;
            int k = tempTile.tileZ;
            int l = tempTile.plane;
            Tile[][] tiles = this.tileArray[k];
            if (tempTile.aBoolean1322) {
                int k4;
                if (flag) {
                    Tile class30_sub3_6;
                    Tile class30_sub3_5;
                    Tile tile;
                    if (k > 0 && (tile = this.tileArray[k - 1][i][j]) != null && tile.aBoolean1323 || i <= xCamPosTile && i > anInt449 && (tile = tiles[i - 1][j]) != null && tile.aBoolean1323 && (tile.aBoolean1322 || (tempTile.anInt1320 & 1) == 0) || i >= xCamPosTile && i < anInt450 - 1 && (tile = tiles[i + 1][j]) != null && tile.aBoolean1323 && (tile.aBoolean1322 || (tempTile.anInt1320 & 4) == 0) || j <= yCamPosTile && j > anInt451 && (class30_sub3_5 = tiles[i][j - 1]) != null && class30_sub3_5.aBoolean1323 && (class30_sub3_5.aBoolean1322 || (tempTile.anInt1320 & 8) == 0) || j >= yCamPosTile && j < anInt452 - 1 && (class30_sub3_6 = tiles[i][j + 1]) != null && class30_sub3_6.aBoolean1323 && (class30_sub3_6.aBoolean1322 || (tempTile.anInt1320 & 2) == 0)) {
                        continue;
                    }
                } else {
                    flag = true;
                }
                tempTile.aBoolean1322 = false;
                if (tempTile.tileBelowThisTile != null) {
                    WallObject wallObject;
                    Tile lowerTile = tempTile.tileBelowThisTile;
                    if (lowerTile.plainTile != null) {
                        if (!this.method320(0, i, j)) {
                            this.drawPlainTile(lowerTile.plainTile, 0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, i, j);
                        }
                    } else if (lowerTile.shapedTile != null && !this.method320(0, i, j)) {
                        this.drawShapedTile(i, yCurveSin, xCurveSin, lowerTile.shapedTile, yCUrveCos, j, xCurveCos);
                    }
                    if ((wallObject = lowerTile.wallObject) != null) {
                        wallObject.node1.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, wallObject.xPos - xCamPos, wallObject.zPos - zCamPos, wallObject.yPos - yCamPos, wallObject.uid, wallObject.wallObjUID);
                    }
                    int i2 = 0;
                    while (i2 < lowerTile.entityCount) {
                        InteractableObject iObject = lowerTile.interactableObjects[i2];
                        if (iObject != null) {
                            iObject.node.renderAtPoint(iObject.rotation, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, iObject.worldX - xCamPos, iObject.worldZ - zCamPos, iObject.worldY - yCamPos, iObject.uid, iObject.interactiveObjUID);
                        }
                        ++i2;
                    }
                }
                boolean flag1 = false;
                if (tempTile.plainTile != null) {
                    if (!this.method320(l, i, j)) {
                        flag1 = true;
                        this.drawPlainTile(tempTile.plainTile, l, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, i, j);
                    }
                } else if (tempTile.shapedTile != null && !this.method320(l, i, j)) {
                    flag1 = true;
                    this.drawShapedTile(i, yCurveSin, xCurveSin, tempTile.shapedTile, yCUrveCos, j, xCurveCos);
                }
                int j1 = 0;
                int j2 = 0;
                WallObject class10_3 = tempTile.wallObject;
                WallDecoration class26_1 = tempTile.wallDecoration;
                if (class10_3 != null || class26_1 != null) {
                    if (xCamPosTile == i) {
                        ++j1;
                    } else if (xCamPosTile < i) {
                        j1 += 2;
                    }
                    if (yCamPosTile == j) {
                        j1 += 3;
                    } else if (yCamPosTile > j) {
                        j1 += 6;
                    }
                    j2 = anIntArray478[j1];
                    tempTile.anInt1328 = anIntArray480[j1];
                }
                if (class10_3 != null) {
                    if ((class10_3.orientation & anIntArray479[j1]) != 0) {
                        if (class10_3.orientation == 16) {
                            tempTile.anInt1325 = 3;
                            tempTile.anInt1326 = anIntArray481[j1];
                            tempTile.anInt1327 = 3 - tempTile.anInt1326;
                        } else if (class10_3.orientation == 32) {
                            tempTile.anInt1325 = 6;
                            tempTile.anInt1326 = anIntArray482[j1];
                            tempTile.anInt1327 = 6 - tempTile.anInt1326;
                        } else if (class10_3.orientation == 64) {
                            tempTile.anInt1325 = 12;
                            tempTile.anInt1326 = anIntArray483[j1];
                            tempTile.anInt1327 = 12 - tempTile.anInt1326;
                        } else {
                            tempTile.anInt1325 = 9;
                            tempTile.anInt1326 = anIntArray484[j1];
                            tempTile.anInt1327 = 9 - tempTile.anInt1326;
                        }
                    } else {
                        tempTile.anInt1325 = 0;
                    }
                    if ((class10_3.orientation & j2) != 0 && !this.method321(l, i, j, class10_3.orientation)) {
                        class10_3.node1.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_3.xPos - xCamPos, class10_3.zPos - zCamPos, class10_3.yPos - yCamPos, class10_3.uid, class10_3.wallObjUID);
                    }
                    if ((class10_3.orientation1 & j2) != 0 && !this.method321(l, i, j, class10_3.orientation1)) {
                        class10_3.node2.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_3.xPos - xCamPos, class10_3.zPos - zCamPos, class10_3.yPos - yCamPos, class10_3.uid, class10_3.wallObjUID);
                    }
                }
                if (class26_1 != null && !this.method322(l, i, j, class26_1.node.modelHeight)) {
                    if ((class26_1.configurationBits & j2) != 0) {
                        class26_1.node.renderAtPoint(class26_1.rotation, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class26_1.xPos - xCamPos, class26_1.zPos - zCamPos, class26_1.yPos - yCamPos, class26_1.uid, class26_1.wallDecorUID);
                    } else if ((class26_1.configurationBits & 0x300) != 0) {
                        int j4 = class26_1.xPos - xCamPos;
                        int l5 = class26_1.zPos - zCamPos;
                        int k6 = class26_1.yPos - yCamPos;
                        int i8 = class26_1.rotation;
                        int k9 = i8 == 1 || i8 == 2 ? -j4 : j4;
                        int k10 = i8 == 2 || i8 == 3 ? -k6 : k6;
                        if ((class26_1.configurationBits & 0x100) != 0 && k10 < k9) {
                            int i11 = j4 + faceXoffset2[i8];
                            int k11 = k6 + faceYOffset2[i8];
                            class26_1.node.renderAtPoint(i8 * 512 + 256, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, i11, l5, k11, class26_1.uid, class26_1.wallDecorUID);
                        }
                        if ((class26_1.configurationBits & 0x200) != 0 && k10 > k9) {
                            int j11 = j4 + faceXOffset3[i8];
                            int l11 = k6 + faceYOffset3[i8];
                            class26_1.node.renderAtPoint(i8 * 512 + 1280 & 0x7FF, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, j11, l5, l11, class26_1.uid, class26_1.wallDecorUID);
                        }
                    }
                }
                if (flag1) {
                    GroundItem object4_1;
                    HighlightTile highlight;
                    GroundDecoration class49 = tempTile.groundDecoration;
                    if (class49 != null && ClientSettings.showGroundDecorations == 1) {
                        class49.node.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class49.xPos - xCamPos, class49.zPos - zCamPos, class49.yPos - yCamPos, class49.uid, class49.groundDecorUID);
                    }
                    if ((highlight = this.highlightTiles[k][i][j]) != null) {
                        this.renderSingleHighlight(highlight, xCamPos, yCamPos, zCamPos);
                    }
                    if ((object4_1 = tempTile.groundItem) != null && object4_1.topItem == 0) {
                        if (object4_1.secondGroundItem != null) {
                            object4_1.secondGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4_1.xPos - xCamPos, object4_1.zPos - zCamPos, object4_1.yPos - yCamPos, object4_1.uid, object4_1.newuid);
                        }
                        if (object4_1.thirdGroundItem != null) {
                            object4_1.thirdGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4_1.xPos - xCamPos, object4_1.zPos - zCamPos, object4_1.yPos - yCamPos, object4_1.uid, object4_1.newuid);
                        }
                        if (object4_1.firstGroundItem != null) {
                            object4_1.firstGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4_1.xPos - xCamPos, object4_1.zPos - zCamPos, object4_1.yPos - yCamPos, object4_1.uid, object4_1.newuid);
                        }
                    }
                }
                if ((k4 = tempTile.anInt1320) != 0) {
                    Tile class30_sub3_20;
                    Tile class30_sub3_19;
                    Tile class30_sub3_18;
                    Tile class30_sub3_17;
                    if (i < xCamPosTile && (k4 & 4) != 0 && (class30_sub3_17 = tiles[i + 1][j]) != null && class30_sub3_17.aBoolean1323) {
                        tileDeque.insertBack(class30_sub3_17);
                    }
                    if (j < yCamPosTile && (k4 & 2) != 0 && (class30_sub3_18 = tiles[i][j + 1]) != null && class30_sub3_18.aBoolean1323) {
                        tileDeque.insertBack(class30_sub3_18);
                    }
                    if (i > xCamPosTile && (k4 & 1) != 0 && (class30_sub3_19 = tiles[i - 1][j]) != null && class30_sub3_19.aBoolean1323) {
                        tileDeque.insertBack(class30_sub3_19);
                    }
                    if (j > yCamPosTile && (k4 & 8) != 0 && (class30_sub3_20 = tiles[i][j - 1]) != null && class30_sub3_20.aBoolean1323) {
                        tileDeque.insertBack(class30_sub3_20);
                    }
                }
            }
            if (tempTile.anInt1325 != 0) {
                boolean flag2 = true;
                int k1 = 0;
                while (k1 < tempTile.entityCount) {
                    if (tempTile.interactableObjects[k1].height != anInt448 && (tempTile.anIntArray1319[k1] & tempTile.anInt1325) == tempTile.anInt1326) {
                        flag2 = false;
                        break;
                    }
                    ++k1;
                }
                if (flag2) {
                    WallObject class10_1 = tempTile.wallObject;
                    if (!this.method321(l, i, j, class10_1.orientation)) {
                        class10_1.node1.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_1.xPos - xCamPos, class10_1.zPos - zCamPos, class10_1.yPos - yCamPos, class10_1.uid, class10_1.wallObjUID);
                    }
                    tempTile.anInt1325 = 0;
                }
            }
            if (tempTile.aBoolean1324) {
                try {
                    int i1 = tempTile.entityCount;
                    tempTile.aBoolean1324 = false;
                    int l1 = 0;
                    int k2 = 0;
                    while (k2 < i1) {
                        block105: {
                            InteractableObject class28_1 = tempTile.interactableObjects[k2];
                            if (class28_1.height != anInt448) {
                                int i7;
                                int j8;
                                int k3 = class28_1.tileLeft;
                                while (k3 <= class28_1.tileRight) {
                                    int l4 = class28_1.tileTop;
                                    while (l4 <= class28_1.tileBottom) {
                                        Tile class30_sub3_21 = tiles[k3][l4];
                                        if (class30_sub3_21.aBoolean1322) {
                                            tempTile.aBoolean1324 = true;
                                            break block105;
                                        }
                                        if (class30_sub3_21.anInt1325 != 0) {
                                            int l6 = 0;
                                            if (k3 > class28_1.tileLeft) {
                                                ++l6;
                                            }
                                            if (k3 < class28_1.tileRight) {
                                                l6 += 4;
                                            }
                                            if (l4 > class28_1.tileTop) {
                                                l6 += 8;
                                            }
                                            if (l4 < class28_1.tileBottom) {
                                                l6 += 2;
                                            }
                                            if ((l6 & class30_sub3_21.anInt1325) == tempTile.anInt1327) {
                                                tempTile.aBoolean1324 = true;
                                                break block105;
                                            }
                                        }
                                        ++l4;
                                    }
                                    ++k3;
                                }
                                WorldController.aClass28Array462[l1++] = class28_1;
                                int i6 = class28_1.tileRight - xCamPosTile;
                                int i5 = xCamPosTile - class28_1.tileLeft;
                                if (i6 > i5) {
                                    i5 = i6;
                                }
                                class28_1.anInt527 = (j8 = class28_1.tileBottom - yCamPosTile) > (i7 = yCamPosTile - class28_1.tileTop) ? i5 + j8 : i5 + i7;
                            }
                        }
                        ++k2;
                    }
                    while (l1 > 0) {
                        int i3 = -50;
                        int l3 = -1;
                        int j5 = 0;
                        while (j5 < l1) {
                            InteractableObject class28_2 = aClass28Array462[j5];
                            if (class28_2.height != anInt448) {
                                int l10;
                                int l9;
                                int k8;
                                int j7;
                                if (class28_2.anInt527 > i3) {
                                    i3 = class28_2.anInt527;
                                    l3 = j5;
                                } else if (class28_2.anInt527 == i3 && (j7 = class28_2.worldX - xCamPos) * j7 + (k8 = class28_2.worldY - yCamPos) * k8 > (l9 = WorldController.aClass28Array462[l3].worldX - xCamPos) * l9 + (l10 = WorldController.aClass28Array462[l3].worldY - yCamPos) * l10) {
                                    l3 = j5;
                                }
                            }
                            ++j5;
                        }
                        if (l3 == -1) break;
                        InteractableObject class28_3 = aClass28Array462[l3];
                        class28_3.height = anInt448;
                        if (!this.method323(l, class28_3.tileLeft, class28_3.tileRight, class28_3.tileTop, class28_3.tileBottom, class28_3.node.modelHeight)) {
                            class28_3.node.renderAtPoint(class28_3.rotation, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class28_3.worldX - xCamPos, class28_3.worldZ - zCamPos, class28_3.worldY - yCamPos, class28_3.uid, class28_3.interactiveObjUID);
                        }
                        int k7 = class28_3.tileLeft;
                        while (k7 <= class28_3.tileRight) {
                            int l8 = class28_3.tileTop;
                            while (l8 <= class28_3.tileBottom) {
                                Tile class30_sub3_22 = tiles[k7][l8];
                                if (class30_sub3_22.anInt1325 != 0) {
                                    tileDeque.insertBack(class30_sub3_22);
                                } else if ((k7 != i || l8 != j) && class30_sub3_22.aBoolean1323) {
                                    tileDeque.insertBack(class30_sub3_22);
                                }
                                ++l8;
                            }
                            ++k7;
                        }
                    }
                    if (tempTile.aBoolean1324) {
                        continue;
                    }
                }
                catch (Exception _ex) {
                    _ex.printStackTrace();
                    tempTile.aBoolean1324 = false;
                }
            }
            if (!tempTile.aBoolean1323 || tempTile.anInt1325 != 0 || i <= xCamPosTile && i > anInt449 && (class30_sub3_8 = tiles[i - 1][j]) != null && class30_sub3_8.aBoolean1323 || i >= xCamPosTile && i < anInt450 - 1 && (class30_sub3_9 = tiles[i + 1][j]) != null && class30_sub3_9.aBoolean1323 || j <= yCamPosTile && j > anInt451 && (class30_sub3_10 = tiles[i][j - 1]) != null && class30_sub3_10.aBoolean1323 || j >= yCamPosTile && j < anInt452 - 1 && (class30_sub3_11 = tiles[i][j + 1]) != null && class30_sub3_11.aBoolean1323) continue;
            tempTile.aBoolean1323 = false;
            --anInt446;
            GroundItem object4 = tempTile.groundItem;
            if (object4 != null && object4.topItem != 0) {
                if (object4.secondGroundItem != null) {
                    object4.secondGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4.xPos - xCamPos, object4.zPos - zCamPos - object4.topItem, object4.yPos - yCamPos, object4.uid, object4.newuid);
                }
                if (object4.thirdGroundItem != null) {
                    object4.thirdGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4.xPos - xCamPos, object4.zPos - zCamPos - object4.topItem, object4.yPos - yCamPos, object4.uid, object4.newuid);
                }
                if (object4.firstGroundItem != null) {
                    object4.firstGroundItem.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, object4.xPos - xCamPos, object4.zPos - zCamPos - object4.topItem, object4.yPos - yCamPos, object4.uid, object4.newuid);
                }
            }
            if (tempTile.anInt1328 != 0) {
                WallObject class10_2;
                WallDecoration class26 = tempTile.wallDecoration;
                if (class26 != null && !this.method322(l, i, j, class26.node.modelHeight)) {
                    if ((class26.configurationBits & tempTile.anInt1328) != 0) {
                        class26.node.renderAtPoint(class26.rotation, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class26.xPos - xCamPos, class26.zPos - zCamPos, class26.yPos - yCamPos, class26.uid, class26.wallDecorUID);
                    } else if ((class26.configurationBits & 0x300) != 0) {
                        int l2 = class26.xPos - xCamPos;
                        int j3 = class26.zPos - zCamPos;
                        int i4 = class26.yPos - yCamPos;
                        int k5 = class26.rotation;
                        int j6 = k5 == 1 || k5 == 2 ? -l2 : l2;
                        int l7 = k5 == 2 || k5 == 3 ? -i4 : i4;
                        if ((class26.configurationBits & 0x100) != 0 && l7 >= j6) {
                            int i9 = l2 + faceXoffset2[k5];
                            int i10 = i4 + faceYOffset2[k5];
                            class26.node.renderAtPoint(k5 * 512 + 256, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, i9, j3, i10, class26.uid, class26.wallDecorUID);
                        }
                        if ((class26.configurationBits & 0x200) != 0 && l7 <= j6) {
                            int j9 = l2 + faceXOffset3[k5];
                            int j10 = i4 + faceYOffset3[k5];
                            class26.node.renderAtPoint(k5 * 512 + 1280 & 0x7FF, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, j9, j3, j10, class26.uid, class26.wallDecorUID);
                        }
                    }
                }
                if ((class10_2 = tempTile.wallObject) != null) {
                    if ((class10_2.orientation1 & tempTile.anInt1328) != 0 && !this.method321(l, i, j, class10_2.orientation1)) {
                        class10_2.node2.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_2.xPos - xCamPos, class10_2.zPos - zCamPos, class10_2.yPos - yCamPos, class10_2.uid, class10_2.wallObjUID);
                    }
                    if ((class10_2.orientation & tempTile.anInt1328) != 0 && !this.method321(l, i, j, class10_2.orientation)) {
                        class10_2.node1.renderAtPoint(0, yCurveSin, yCUrveCos, xCurveSin, xCurveCos, class10_2.xPos - xCamPos, class10_2.zPos - zCamPos, class10_2.yPos - yCamPos, class10_2.uid, class10_2.wallObjUID);
                    }
                }
            }
            if (k < this.zMapSize - 1 && (class30_sub3_12 = this.tileArray[k + 1][i][j]) != null && class30_sub3_12.aBoolean1323) {
                tileDeque.insertBack(class30_sub3_12);
            }
            if (i < xCamPosTile && (class30_sub3_13 = tiles[i + 1][j]) != null && class30_sub3_13.aBoolean1323) {
                tileDeque.insertBack(class30_sub3_13);
            }
            if (j < yCamPosTile && (class30_sub3_14 = tiles[i][j + 1]) != null && class30_sub3_14.aBoolean1323) {
                tileDeque.insertBack(class30_sub3_14);
            }
            if (i > xCamPosTile && (class30_sub3_15 = tiles[i - 1][j]) != null && class30_sub3_15.aBoolean1323) {
                tileDeque.insertBack(class30_sub3_15);
            }
            if (j <= yCamPosTile || (class30_sub3_16 = tiles[i][j - 1]) == null || !class30_sub3_16.aBoolean1323) continue;
            tileDeque.insertBack(class30_sub3_16);
        }
        return;
    }

    private void drawPlainTile(PlainTile class43, int i, int j, int k, int l, int i1, int j1, int k1) {
        int j3;
        int l2;
        int j2;
        int l1;
        int i2 = l1 = (j1 << 7) - xCamPos;
        int k2 = j2 = (k1 << 7) - yCamPos;
        int i3 = l2 = i2 + 128;
        int k3 = j3 = k2 + 128;
        int l3 = this.heightMap[i][j1][k1] - zCamPos;
        int i4 = this.heightMap[i][j1 + 1][k1] - zCamPos;
        int j4 = this.heightMap[i][j1 + 1][k1 + 1] - zCamPos;
        int k4 = this.heightMap[i][j1][k1 + 1] - zCamPos;
        int l4 = k2 * l + i2 * i1 >> 16;
        k2 = k2 * i1 - i2 * l >> 16;
        i2 = l4;
        l4 = l3 * k - k2 * j >> 16;
        k2 = l3 * j + k2 * k >> 16;
        l3 = l4;
        if (k2 < 50) {
            return;
        }
        l4 = j2 * l + i3 * i1 >> 16;
        j2 = j2 * i1 - i3 * l >> 16;
        i3 = l4;
        l4 = i4 * k - j2 * j >> 16;
        j2 = i4 * j + j2 * k >> 16;
        i4 = l4;
        if (j2 < 50) {
            return;
        }
        l4 = k3 * l + l2 * i1 >> 16;
        k3 = k3 * i1 - l2 * l >> 16;
        l2 = l4;
        l4 = j4 * k - k3 * j >> 16;
        k3 = j4 * j + k3 * k >> 16;
        j4 = l4;
        if (k3 < 50) {
            return;
        }
        l4 = j3 * l + l1 * i1 >> 16;
        j3 = j3 * i1 - l1 * l >> 16;
        l1 = l4;
        l4 = k4 * k - j3 * j >> 16;
        j3 = k4 * j + j3 * k >> 16;
        k4 = l4;
        if (j3 < 50) {
            return;
        }
        int i5 = Rasterizer.textureInt1 + i2 * focalLength / k2;
        int j5 = Rasterizer.textureInt2 + l3 * focalLength / k2;
        int k5 = Rasterizer.textureInt1 + i3 * focalLength / j2;
        int l5 = Rasterizer.textureInt2 + i4 * focalLength / j2;
        int i6 = Rasterizer.textureInt1 + l2 * focalLength / k3;
        int j6 = Rasterizer.textureInt2 + j4 * focalLength / k3;
        int k6 = Rasterizer.textureInt1 + l1 * focalLength / j3;
        int l6 = Rasterizer.textureInt2 + k4 * focalLength / j3;
        Rasterizer.anInt1465 = 0;
        if ((i6 - k6) * (l5 - l6) - (j6 - l6) * (k5 - k6) > 0) {
            boolean bl = Rasterizer.aBoolean1462 = i6 < 0 || k6 < 0 || k5 < 0 || i6 > DrawingArea.viewportRX || k6 > DrawingArea.viewportRX || k5 > DrawingArea.viewportRX;
            if (isClicked && this.mouseWithinTriangle(clickX, clickY, j6, l6, l5, i6, k6, k5)) {
                clickedTileX = j1;
                clickedTileY = k1;
            }
            if (this.mouseWithinTriangle(hoveringX, hoveringY, j6, l6, l5, i6, k6, k5)) {
                hoveredTileX = j1;
                hoveredTileY = k1;
            }
            if (class43.anInt720 == -1 || class43.anInt720 > 50 && class43.anInt718 != 12345678) {
                if (Client.getOption("hd_tex") && class43.anInt720 != -1) {
                    if (class43.aBoolean721) {
                        Rasterizer.drawMaterializedTriangle(j6, l6, l5, i6, k6, k5, class43.anInt718, class43.anInt719, class43.anInt717, i2, i3, l1, l3, i4, k4, k2, j2, j3, class43.anInt720, k3, j3, j2);
                    } else {
                        Rasterizer.drawMaterializedTriangle(j6, l6, l5, i6, k6, k5, class43.anInt718, class43.anInt719, class43.anInt717, l2, l1, i3, j4, k4, i4, k3, j3, j2, class43.anInt720, k3, j3, j2);
                    }
                } else if (class43.anInt718 != 12345678) {
                    Rasterizer.drawGouraudTriangle(j6, l6, l5, i6, k6, k5, class43.anInt718, class43.anInt719, class43.anInt717, k3, j3, j2);
                }
            } else if (!lowMem) {
                if (class43.aBoolean721) {
                    Rasterizer.drawTexturedTriangle(j6, l6, l5, i6, k6, k5, class43.anInt718, class43.anInt719, class43.anInt717, i2, i3, l1, l3, i4, k4, k2, j2, j3, class43.anInt720, k3, j3, j2);
                } else {
                    Rasterizer.drawTexturedTriangle(j6, l6, l5, i6, k6, k5, class43.anInt718, class43.anInt719, class43.anInt717, l2, l1, i3, j4, k4, i4, k3, j3, j2, class43.anInt720, k3, j3, j2);
                }
            } else {
                int i7 = anIntArray485[class43.anInt720];
                Rasterizer.drawGouraudTriangle(j6, l6, l5, i6, k6, k5, this.mixColour(i7, class43.anInt718), this.mixColour(i7, class43.anInt719), this.mixColour(i7, class43.anInt717), k3, j3, j2);
            }
        }
        if ((i5 - k5) * (l6 - l5) - (j5 - l5) * (k6 - k5) > 0) {
            boolean bl = Rasterizer.aBoolean1462 = i5 < 0 || k5 < 0 || k6 < 0 || i5 > DrawingArea.viewportRX || k5 > DrawingArea.viewportRX || k6 > DrawingArea.viewportRX;
            if (isClicked && this.mouseWithinTriangle(clickX, clickY, j5, l5, l6, i5, k5, k6)) {
                clickedTileX = j1;
                clickedTileY = k1;
            }
            if (this.mouseWithinTriangle(hoveringX, hoveringY, j5, l5, l6, i5, k5, k6)) {
                hoveredTileX = j1;
                hoveredTileY = k1;
            }
            if (class43.anInt720 == -1 || class43.anInt720 > 50 && class43.anInt716 != 12345678) {
                if (class43.anInt716 != 12345678) {
                    if (Client.getOption("hd_tex") && class43.anInt720 != -1) {
                        Rasterizer.drawMaterializedTriangle(j5, l5, l6, i5, k5, k6, class43.anInt716, class43.anInt717, class43.anInt719, i2, i3, l1, l3, i4, k4, k2, j2, j3, class43.anInt720, k2, j2, j3);
                    } else {
                        Rasterizer.drawGouraudTriangle(j5, l5, l6, i5, k5, k6, class43.anInt716, class43.anInt717, class43.anInt719, k2, j2, j3);
                    }
                }
            } else {
                if (!lowMem) {
                    Rasterizer.drawTexturedTriangle(j5, l5, l6, i5, k5, k6, class43.anInt716, class43.anInt717, class43.anInt719, i2, i3, l1, l3, i4, k4, k2, j2, j3, class43.anInt720, k2, j2, j3);
                    return;
                }
                int j7 = anIntArray485[class43.anInt720];
                Rasterizer.drawGouraudTriangle(j5, l5, l6, i5, k5, k6, this.mixColour(j7, class43.anInt716), this.mixColour(j7, class43.anInt717), this.mixColour(j7, class43.anInt719), k2, j2, j3);
            }
        }
    }

    private void drawShapedTile(int i, int j, int k, ShapedTile class40, int l, int i1, int j1) {
        int k1 = class40.anIntArray673.length;
        int l1 = 0;
        while (l1 < k1) {
            int i2 = class40.anIntArray673[l1] - xCamPos;
            int k2 = class40.anIntArray674[l1] - zCamPos;
            int i3 = class40.anIntArray675[l1] - yCamPos;
            int k3 = i3 * k + i2 * j1 >> 16;
            i3 = i3 * j1 - i2 * k >> 16;
            i2 = k3;
            k3 = k2 * l - i3 * j >> 16;
            i3 = k2 * j + i3 * l >> 16;
            k2 = k3;
            if (i3 < 50) {
                return;
            }
            if (Client.getOption("hd_tex") || class40.anIntArray682 != null) {
                ShapedTile.anIntArray690[l1] = i2;
                ShapedTile.anIntArray691[l1] = k2;
                ShapedTile.anIntArray692[l1] = i3;
            }
            ShapedTile.anIntArray688[l1] = Rasterizer.textureInt1 + i2 * focalLength / i3;
            ShapedTile.anIntArray689[l1] = Rasterizer.textureInt2 + k2 * focalLength / i3;
            ShapedTile.depthPoint[l1] = i3;
            ++l1;
        }
        Rasterizer.anInt1465 = 0;
        k1 = class40.anIntArray679.length;
        int j2 = 0;
        while (j2 < k1) {
            int l2 = class40.anIntArray679[j2];
            int j3 = class40.anIntArray680[j2];
            int l3 = class40.anIntArray681[j2];
            int i4 = ShapedTile.anIntArray688[l2];
            int j4 = ShapedTile.anIntArray688[j3];
            int k4 = ShapedTile.anIntArray688[l3];
            int l4 = ShapedTile.anIntArray689[l2];
            int i5 = ShapedTile.anIntArray689[j3];
            int j5 = ShapedTile.anIntArray689[l3];
            int z1 = ShapedTile.depthPoint[l2];
            int z2 = ShapedTile.depthPoint[j3];
            int z3 = ShapedTile.depthPoint[l3];
            if ((i4 - j4) * (j5 - i5) - (l4 - i5) * (k4 - j4) > 0) {
                boolean bl = Rasterizer.aBoolean1462 = i4 < 0 || j4 < 0 || k4 < 0 || i4 > DrawingArea.viewportRX || j4 > DrawingArea.viewportRX || k4 > DrawingArea.viewportRX;
                if (isClicked && this.mouseWithinTriangle(clickX, clickY, l4, i5, j5, i4, j4, k4)) {
                    clickedTileX = i;
                    clickedTileY = i1;
                }
                if (this.mouseWithinTriangle(hoveringX, hoveringY, l4, i5, j5, i4, j4, k4)) {
                    hoveredTileX = i;
                    hoveredTileY = i1;
                }
                if (class40.anIntArray682 == null || class40.anIntArray682[j2] == -1 || class40.anIntArray682[j2] > 50) {
                    if (Client.getOption("hd_tex") && class40.anIntArray682 != null && class40.anIntArray682[j2] != -1 && class40.anIntArray676[j2] != 12345678) {
                        if (class40.aBoolean683 || class40.anIntArray682[j2] == 505) {
                            Rasterizer.drawMaterializedTriangle(l4, i5, j5, i4, j4, k4, class40.anIntArray676[j2], class40.anIntArray677[j2], class40.anIntArray678[j2], ShapedTile.anIntArray690[0], ShapedTile.anIntArray690[1], ShapedTile.anIntArray690[3], ShapedTile.anIntArray691[0], ShapedTile.anIntArray691[1], ShapedTile.anIntArray691[3], ShapedTile.anIntArray692[0], ShapedTile.anIntArray692[1], ShapedTile.anIntArray692[3], class40.anIntArray682[j2], z1, z2, z3);
                        } else {
                            Rasterizer.drawMaterializedTriangle(l4, i5, j5, i4, j4, k4, class40.anIntArray676[j2], class40.anIntArray677[j2], class40.anIntArray678[j2], ShapedTile.anIntArray690[l2], ShapedTile.anIntArray690[j3], ShapedTile.anIntArray690[l3], ShapedTile.anIntArray691[l2], ShapedTile.anIntArray691[j3], ShapedTile.anIntArray691[l3], ShapedTile.anIntArray692[l2], ShapedTile.anIntArray692[j3], ShapedTile.anIntArray692[l3], class40.anIntArray682[j2], z1, z2, z3);
                        }
                    } else if (class40.anIntArray676[j2] != 12345678) {
                        Rasterizer.drawGouraudTriangle(l4, i5, j5, i4, j4, k4, class40.anIntArray676[j2], class40.anIntArray677[j2], class40.anIntArray678[j2], ShapedTile.anIntArray692[l2], ShapedTile.anIntArray692[j3], ShapedTile.anIntArray692[l3]);
                    }
                } else if (!lowMem) {
                    if (class40.aBoolean683) {
                        Rasterizer.drawTexturedTriangle(l4, i5, j5, i4, j4, k4, class40.anIntArray676[j2], class40.anIntArray677[j2], class40.anIntArray678[j2], ShapedTile.anIntArray690[0], ShapedTile.anIntArray690[1], ShapedTile.anIntArray690[3], ShapedTile.anIntArray691[0], ShapedTile.anIntArray691[1], ShapedTile.anIntArray691[3], ShapedTile.anIntArray692[0], ShapedTile.anIntArray692[1], ShapedTile.anIntArray692[3], class40.anIntArray682[j2], z1, z2, z3);
                    } else {
                        Rasterizer.drawTexturedTriangle(l4, i5, j5, i4, j4, k4, class40.anIntArray676[j2], class40.anIntArray677[j2], class40.anIntArray678[j2], ShapedTile.anIntArray690[l2], ShapedTile.anIntArray690[j3], ShapedTile.anIntArray690[l3], ShapedTile.anIntArray691[l2], ShapedTile.anIntArray691[j3], ShapedTile.anIntArray691[l3], ShapedTile.anIntArray692[l2], ShapedTile.anIntArray692[j3], ShapedTile.anIntArray692[l3], class40.anIntArray682[j2], z1, z2, z3);
                    }
                } else {
                    int k5 = anIntArray485[class40.anIntArray682[j2]];
                    Rasterizer.drawGouraudTriangle(l4, i5, j5, i4, j4, k4, this.mixColour(k5, class40.anIntArray676[j2]), this.mixColour(k5, class40.anIntArray677[j2]), this.mixColour(k5, class40.anIntArray678[j2]), z1, z2, z3);
                }
            }
            ++j2;
        }
    }

    private int mixColour(int colour1, int colour2) {
        colour2 = 127 - colour2;
        if ((colour2 = colour2 * (colour1 & 0x7F) / 160) < 2) {
            colour2 = 2;
        } else if (colour2 > 126) {
            colour2 = 126;
        }
        return (colour1 & 0xFF80) + colour2;
    }

    private boolean mouseWithinTriangle(int mouseX, int mouseY, int triangleYA, int triangleYB, int triangleYC, int triangleXA, int triangleXB, int triangleXC) {
        if (mouseY < triangleYA && mouseY < triangleYB && mouseY < triangleYC) {
            return false;
        }
        if (mouseY > triangleYA && mouseY > triangleYB && mouseY > triangleYC) {
            return false;
        }
        if (mouseX < triangleXA && mouseX < triangleXB && mouseX < triangleXC) {
            return false;
        }
        if (mouseX > triangleXA && mouseX > triangleXB && mouseX > triangleXC) {
            return false;
        }
        int i2 = (mouseY - triangleYA) * (triangleXB - triangleXA) - (mouseX - triangleXA) * (triangleYB - triangleYA);
        int j2 = (mouseY - triangleYC) * (triangleXA - triangleXC) - (mouseX - triangleXC) * (triangleYA - triangleYC);
        int k2 = (mouseY - triangleYB) * (triangleXC - triangleXB) - (mouseX - triangleXB) * (triangleYC - triangleYB);
        return i2 * k2 > 0 && k2 * j2 > 0;
    }

    private void processCulling() {
        int count = cullingClusterPointer[plane__];
        CullingCluster[] clusters = cullingClusters[plane__];
        processedClusterPtr = 0;
        int k = 0;
        while (k < count) {
            block22: {
                int yDistFromCamStartReal;
                int yDistFromCamEnd;
                int yDistFromCamStart;
                CullingCluster cluster;
                block25: {
                    int yDistFromCamStartReal2;
                    block27: {
                        block26: {
                            int xDistFromCamEnd;
                            block21: {
                                int xDistFromCamStartReal;
                                block24: {
                                    block23: {
                                        cluster = clusters[k];
                                        if (cluster.searchMask != 1) break block21;
                                        int xDistFromCamStart = cluster.tileStartX - xCamPosTile + ClientSettings.viewDistance;
                                        if (xDistFromCamStart < 0 || xDistFromCamStart > 50) break block22;
                                        yDistFromCamStart = cluster.tileStartY - yCamPosTile + ClientSettings.viewDistance;
                                        if (yDistFromCamStart < 0) {
                                            yDistFromCamStart = 0;
                                        }
                                        if ((yDistFromCamEnd = cluster.tileEndY - yCamPosTile + ClientSettings.viewDistance) > 50) {
                                            yDistFromCamEnd = 50;
                                        }
                                        boolean visisble = false;
                                        while (yDistFromCamStart <= yDistFromCamEnd) {
                                            if (!tile_visibility_map[xDistFromCamStart][yDistFromCamStart++]) continue;
                                            visisble = true;
                                            break;
                                        }
                                        if (!visisble) break block22;
                                        xDistFromCamStartReal = xCamPos - cluster.worldStartX;
                                        if (xDistFromCamStartReal <= 32) break block23;
                                        cluster.tileDistanceEnum = 1;
                                        break block24;
                                    }
                                    if (xDistFromCamStartReal >= -32) break block22;
                                    cluster.tileDistanceEnum = 2;
                                    xDistFromCamStartReal = -xDistFromCamStartReal;
                                }
                                cluster.worldDistanceFromCameraStartY = (cluster.worldStartY - yCamPos << 8) / xDistFromCamStartReal;
                                cluster.worldDistanceFromCameraEndY = (cluster.worldEndY - yCamPos << 8) / xDistFromCamStartReal;
                                cluster.worldDistanceFromCameraStartZ = (cluster.worldStartZ - zCamPos << 8) / xDistFromCamStartReal;
                                cluster.worldDistanceFromCameraEndZ = (cluster.worldEndZ - zCamPos << 8) / xDistFromCamStartReal;
                                WorldController.processedClusters[WorldController.processedClusterPtr++] = cluster;
                                break block22;
                            }
                            if (cluster.searchMask != 2) break block25;
                            int yDIstFromCamStart = cluster.tileStartY - yCamPosTile + ClientSettings.viewDistance;
                            if (yDIstFromCamStart < 0 || yDIstFromCamStart > 50) break block22;
                            int xDistFromCamStart = cluster.tileStartX - xCamPosTile + ClientSettings.viewDistance;
                            if (xDistFromCamStart < 0) {
                                xDistFromCamStart = 0;
                            }
                            if ((xDistFromCamEnd = cluster.tileEndX - xCamPosTile + ClientSettings.viewDistance) > 50) {
                                xDistFromCamEnd = 50;
                            }
                            boolean visible = false;
                            while (xDistFromCamStart <= xDistFromCamEnd) {
                                if (!tile_visibility_map[xDistFromCamStart++][yDIstFromCamStart]) continue;
                                visible = true;
                                break;
                            }
                            if (!visible) break block22;
                            yDistFromCamStartReal2 = yCamPos - cluster.worldStartY;
                            if (yDistFromCamStartReal2 <= 32) break block26;
                            cluster.tileDistanceEnum = 3;
                            break block27;
                        }
                        if (yDistFromCamStartReal2 >= -32) break block22;
                        cluster.tileDistanceEnum = 4;
                        yDistFromCamStartReal2 = -yDistFromCamStartReal2;
                    }
                    cluster.worldDistanceFromCameraStartX = (cluster.worldStartX - xCamPos << 8) / yDistFromCamStartReal2;
                    cluster.worldDistanceFromCameraEndX = (cluster.worldEndX - xCamPos << 8) / yDistFromCamStartReal2;
                    cluster.worldDistanceFromCameraStartZ = (cluster.worldStartZ - zCamPos << 8) / yDistFromCamStartReal2;
                    cluster.worldDistanceFromCameraEndZ = (cluster.worldEndZ - zCamPos << 8) / yDistFromCamStartReal2;
                    WorldController.processedClusters[WorldController.processedClusterPtr++] = cluster;
                    break block22;
                }
                if (cluster.searchMask == 4 && (yDistFromCamStartReal = cluster.worldStartZ - zCamPos) > 128) {
                    yDistFromCamStart = cluster.tileStartY - yCamPosTile + ClientSettings.viewDistance;
                    if (yDistFromCamStart < 0) {
                        yDistFromCamStart = 0;
                    }
                    if ((yDistFromCamEnd = cluster.tileEndY - yCamPosTile + ClientSettings.viewDistance) > 50) {
                        yDistFromCamEnd = 50;
                    }
                    if (yDistFromCamStart <= yDistFromCamEnd) {
                        int xDistFromCamEnd;
                        int xDistFromCamStart = cluster.tileStartX - xCamPosTile + ClientSettings.viewDistance;
                        if (xDistFromCamStart < 0) {
                            xDistFromCamStart = 0;
                        }
                        if ((xDistFromCamEnd = cluster.tileEndX - xCamPosTile + ClientSettings.viewDistance) > 50) {
                            xDistFromCamEnd = 50;
                        }
                        boolean visisble = false;
                        int _x = xDistFromCamStart;
                        block3: while (_x <= xDistFromCamEnd) {
                            int _y = yDistFromCamStart;
                            while (_y <= yDistFromCamEnd) {
                                if (tile_visibility_map[_x][_y]) {
                                    visisble = true;
                                    break block3;
                                }
                                ++_y;
                            }
                            ++_x;
                        }
                        if (visisble) {
                            cluster.tileDistanceEnum = 5;
                            cluster.worldDistanceFromCameraStartX = (cluster.worldStartX - xCamPos << 8) / yDistFromCamStartReal;
                            cluster.worldDistanceFromCameraEndX = (cluster.worldEndX - xCamPos << 8) / yDistFromCamStartReal;
                            cluster.worldDistanceFromCameraStartY = (cluster.worldStartY - yCamPos << 8) / yDistFromCamStartReal;
                            cluster.worldDistanceFromCameraEndY = (cluster.worldEndY - yCamPos << 8) / yDistFromCamStartReal;
                            WorldController.processedClusters[WorldController.processedClusterPtr++] = cluster;
                        }
                    }
                }
            }
            ++k;
        }
    }

    private boolean method320(int y, int x, int z) {
        int l = this.anIntArrayArrayArray445[y][x][z];
        if (l == -anInt448) {
            return false;
        }
        if (l == anInt448) {
            return true;
        }
        int i1 = x << 7;
        int j1 = z << 7;
        if (this.method324(i1 + 1, this.heightMap[y][x][z], j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[y][x + 1][z], j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[y][x + 1][z + 1], j1 + 128 - 1) && this.method324(i1 + 1, this.heightMap[y][x][z + 1], j1 + 128 - 1)) {
            this.anIntArrayArrayArray445[y][x][z] = anInt448;
            return true;
        }
        this.anIntArrayArrayArray445[y][x][z] = -anInt448;
        return false;
    }

    private boolean method321(int z, int x, int y, int l) {
        if (!this.method320(z, x, y)) {
            return false;
        }
        int i1 = x << 7;
        int j1 = y << 7;
        int k1 = this.heightMap[z][x][y] - 1;
        int l1 = k1 - 120;
        int i2 = k1 - 230;
        int j2 = k1 - 238;
        if (l < 16) {
            if (l == 1) {
                if (i1 > xCamPos) {
                    if (!this.method324(i1, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (z > 0) {
                    if (!this.method324(i1, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1) && this.method324(i1, i2, j1 + 128);
            }
            if (l == 2) {
                if (j1 < yCamPos) {
                    if (!this.method324(i1, k1, j1 + 128)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (z > 0) {
                    if (!this.method324(i1, l1, j1 + 128)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1 + 128) && this.method324(i1 + 128, i2, j1 + 128);
            }
            if (l == 4) {
                if (i1 < xCamPos) {
                    if (!this.method324(i1 + 128, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1 + 128)) {
                        return false;
                    }
                }
                if (z > 0) {
                    if (!this.method324(i1 + 128, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1 + 128)) {
                        return false;
                    }
                }
                return this.method324(i1 + 128, i2, j1) && this.method324(i1 + 128, i2, j1 + 128);
            }
            if (l == 8) {
                if (j1 > yCamPos) {
                    if (!this.method324(i1, k1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, k1, j1)) {
                        return false;
                    }
                }
                if (z > 0) {
                    if (!this.method324(i1, l1, j1)) {
                        return false;
                    }
                    if (!this.method324(i1 + 128, l1, j1)) {
                        return false;
                    }
                }
                return this.method324(i1, i2, j1) && this.method324(i1 + 128, i2, j1);
            }
        }
        if (!this.method324(i1 + 64, j2, j1 + 64)) {
            return false;
        }
        if (l == 16) {
            return this.method324(i1, i2, j1 + 128);
        }
        if (l == 32) {
            return this.method324(i1 + 128, i2, j1 + 128);
        }
        if (l == 64) {
            return this.method324(i1 + 128, i2, j1);
        }
        if (l == 128) {
            return this.method324(i1, i2, j1);
        }
        System.out.println("Warning unsupported wall type");
        return true;
    }

    private boolean method322(int i, int j, int k, int l) {
        if (!this.method320(i, j, k)) {
            return false;
        }
        int i1 = j << 7;
        int j1 = k << 7;
        return this.method324(i1 + 1, this.heightMap[i][j][k] - l, j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[i][j + 1][k] - l, j1 + 1) && this.method324(i1 + 128 - 1, this.heightMap[i][j + 1][k + 1] - l, j1 + 128 - 1) && this.method324(i1 + 1, this.heightMap[i][j][k + 1] - l, j1 + 128 - 1);
    }

    private boolean method323(int y, int x, int k, int z, int i1, int j1) {
        if (x == k && z == i1) {
            if (!this.method320(y, x, z)) {
                return false;
            }
            int k1 = x << 7;
            int i2 = z << 7;
            return this.method324(k1 + 1, this.heightMap[y][x][z] - j1, i2 + 1) && this.method324(k1 + 128 - 1, this.heightMap[y][x + 1][z] - j1, i2 + 1) && this.method324(k1 + 128 - 1, this.heightMap[y][x + 1][z + 1] - j1, i2 + 128 - 1) && this.method324(k1 + 1, this.heightMap[y][x][z + 1] - j1, i2 + 128 - 1);
        }
        int l1 = x;
        while (l1 <= k) {
            int j2 = z;
            while (j2 <= i1) {
                if (this.anIntArrayArrayArray445[y][l1][j2] == -anInt448) {
                    return false;
                }
                ++j2;
            }
            ++l1;
        }
        int k2 = (x << 7) + 1;
        int i3 = this.heightMap[y][x][z] - j1;
        int l2 = (z << 7) + 2;
        if (!this.method324(k2, i3, l2)) {
            return false;
        }
        int j3 = (k << 7) - 1;
        if (!this.method324(j3, i3, l2)) {
            return false;
        }
        int k3 = (i1 << 7) - 1;
        return this.method324(k2, i3, k3) && this.method324(j3, i3, k3);
    }

    private boolean method324(int x, int y, int z) {
        int l = 0;
        while (l < processedClusterPtr) {
            int i2;
            CullingCluster cluster = processedClusters[l];
            if (cluster.tileDistanceEnum == 1) {
                int i1 = cluster.worldStartX - x;
                if (i1 > 0) {
                    int j2 = cluster.worldStartY + (cluster.worldDistanceFromCameraStartY * i1 >> 8);
                    int k3 = cluster.worldEndY + (cluster.worldDistanceFromCameraEndY * i1 >> 8);
                    int l4 = cluster.worldStartZ + (cluster.worldDistanceFromCameraStartZ * i1 >> 8);
                    int i6 = cluster.worldEndZ + (cluster.worldDistanceFromCameraEndZ * i1 >> 8);
                    if (z >= j2 && z <= k3 && y >= l4 && y <= i6) {
                        return true;
                    }
                }
            } else if (cluster.tileDistanceEnum == 2) {
                int j1 = x - cluster.worldStartX;
                if (j1 > 0) {
                    int k2 = cluster.worldStartY + (cluster.worldDistanceFromCameraStartY * j1 >> 8);
                    int l3 = cluster.worldEndY + (cluster.worldDistanceFromCameraEndY * j1 >> 8);
                    int i5 = cluster.worldStartZ + (cluster.worldDistanceFromCameraStartZ * j1 >> 8);
                    int j6 = cluster.worldEndZ + (cluster.worldDistanceFromCameraEndZ * j1 >> 8);
                    if (z >= k2 && z <= l3 && y >= i5 && y <= j6) {
                        return true;
                    }
                }
            } else if (cluster.tileDistanceEnum == 3) {
                int k1 = cluster.worldStartY - z;
                if (k1 > 0) {
                    int l2 = cluster.worldStartX + (cluster.worldDistanceFromCameraStartX * k1 >> 8);
                    int i4 = cluster.worldEndX + (cluster.worldDistanceFromCameraEndX * k1 >> 8);
                    int j5 = cluster.worldStartZ + (cluster.worldDistanceFromCameraStartZ * k1 >> 8);
                    int k6 = cluster.worldEndZ + (cluster.worldDistanceFromCameraEndZ * k1 >> 8);
                    if (x >= l2 && x <= i4 && y >= j5 && y <= k6) {
                        return true;
                    }
                }
            } else if (cluster.tileDistanceEnum == 4) {
                int l1 = z - cluster.worldStartY;
                if (l1 > 0) {
                    int i3 = cluster.worldStartX + (cluster.worldDistanceFromCameraStartX * l1 >> 8);
                    int j4 = cluster.worldEndX + (cluster.worldDistanceFromCameraEndX * l1 >> 8);
                    int k5 = cluster.worldStartZ + (cluster.worldDistanceFromCameraStartZ * l1 >> 8);
                    int l6 = cluster.worldEndZ + (cluster.worldDistanceFromCameraEndZ * l1 >> 8);
                    if (x >= i3 && x <= j4 && y >= k5 && y <= l6) {
                        return true;
                    }
                }
            } else if (cluster.tileDistanceEnum == 5 && (i2 = y - cluster.worldStartZ) > 0) {
                int j3 = cluster.worldStartX + (cluster.worldDistanceFromCameraStartX * i2 >> 8);
                int k4 = cluster.worldEndX + (cluster.worldDistanceFromCameraEndX * i2 >> 8);
                int l5 = cluster.worldStartY + (cluster.worldDistanceFromCameraStartY * i2 >> 8);
                int i7 = cluster.worldEndY + (cluster.worldDistanceFromCameraEndY * i2 >> 8);
                if (x >= j3 && x <= k4 && z >= l5 && z <= i7) {
                    return true;
                }
            }
            ++l;
        }
        return false;
    }
}

