/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.util;

import com.aragon.entity.Item;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public final class RandomUtility {
    public static final Random RANDOM = new Random(System.currentTimeMillis());

    private RandomUtility() {
    }

    public static final int random(int min, int max) {
        int n = Math.abs(max - min);
        return Math.min(min, max) + (n == 0 ? 0 : RandomUtility.random(n));
    }

    public static final double random(double min, double max) {
        double n = Math.abs(max - min);
        return Math.min(min, max) + (double)(n == 0.0 ? 0 : RandomUtility.random((int)n));
    }

    public static final int next(int max, int min) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static final double getRandomDouble(double maxValue) {
        return Math.random() * (maxValue + 1.0);
    }

    public static final int random(int maxValue) {
        if (maxValue <= 0) {
            return 0;
        }
        return RANDOM.nextInt(maxValue);
    }

    public static int getRandom(int range) {
        return (int)(Math.random() * (double)(range + 1));
    }

    public static int exclusiveRandom(int min, int max) {
        if (max <= min) {
            max = min + 1;
        }
        return RANDOM.nextInt(max - min) + min;
    }

    public static int exclusiveRandom(int range) {
        return RandomUtility.exclusiveRandom(0, range);
    }

    public static int inclusiveRandom(int min, int max) {
        if (max < min) {
            max = min + 1;
        }
        return RandomUtility.exclusiveRandom(max - min + 1) + min;
    }

    public static int inclusiveRandom(int range) {
        return RandomUtility.inclusiveRandom(0, range);
    }

    public static <T> T randomElement(T[] array) {
        return array[(int)(RANDOM.nextDouble() * (double)array.length)];
    }

    public static <T> T randomElement(List<T> list) {
        return list.get((int)(RANDOM.nextDouble() * (double)list.size()));
    }

    public static <T> T randomElement(Set<T> set) {
        int index = RANDOM.nextInt(set.size());
        Iterator<T> iter = set.iterator();
        int i = 0;
        while (i < index) {
            iter.next();
            ++i;
        }
        return iter.next();
    }

    public static Item randomItem(Item[] item) {
        return item[RandomUtility.inclusiveRandom(item.length)];
    }
}

