/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.util;

import com.aragon.util.HashTable;
import com.aragon.util.Queue;
import com.aragon.util.QueueNode;

public final class MemCache {
    private final QueueNode queue_head = new QueueNode();
    private final int max_size;
    private int free_slots;
    private final HashTable hashTable;
    private final Queue usageList = new Queue();

    public MemCache(int size) {
        this.max_size = size;
        this.free_slots = size;
        this.hashTable = new HashTable(1024);
    }

    public QueueNode get(long hash) {
        QueueNode node = (QueueNode)this.hashTable.get(hash);
        if (node != null) {
            this.usageList.insertBack(node);
        }
        return node;
    }

    public void put(QueueNode entry, long hash) {
        try {
            if (this.free_slots == 0) {
                QueueNode dropEntry = this.usageList.popFront();
                dropEntry.unlink();
                dropEntry.unlinkQueue();
                if (dropEntry == this.queue_head) {
                    dropEntry = this.usageList.popFront();
                    dropEntry.unlink();
                    dropEntry.unlinkQueue();
                }
            } else {
                --this.free_slots;
            }
            this.hashTable.put(entry, hash);
            this.usageList.insertBack(entry);
            return;
        }
        catch (RuntimeException runtimeexception) {
            System.out.println("47547, " + entry + ", " + hash + ", " + 2 + ", " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    public void clear() {
        QueueNode node;
        while ((node = this.usageList.popFront()) != null) {
            node.unlink();
            node.unlinkQueue();
        }
        this.free_slots = this.max_size;
    }

    public Queue getUsageList() {
        return this.usageList;
    }

    public HashTable getHashTable() {
        return this.hashTable;
    }
}

