/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.util;

import javafx.scene.paint.Color;

public class JagexColor {
    public static final int[] hsl2rgb;
    public static final int[] map;

    static {
        map = new int[65536];
        hsl2rgb = map;
        int[] out = map;
        double d = 0.7;
        int i = 0;
        int i1 = 0;
        while (i1 != 512) {
            float f = ((float)(i1 >> 3) / 64.0f + 0.0078125f) * 360.0f;
            float f1 = 0.0625f + (float)(7 & i1) / 8.0f;
            int i2 = 0;
            while (i2 != 128) {
                float f2 = (float)i2 / 128.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                float f6 = f / 60.0f;
                int i3 = (int)f6;
                int i4 = i3 % 6;
                float f7 = f6 - (float)i3;
                float f8 = f2 * (-f1 + 1.0f);
                float f9 = f2 * (-(f7 * f1) + 1.0f);
                float f10 = (1.0f - f1 * (-f7 + 1.0f)) * f2;
                if (i4 == 0) {
                    f3 = f2;
                    f5 = f8;
                    f4 = f10;
                } else if (i4 == 1) {
                    f5 = f8;
                    f3 = f9;
                    f4 = f2;
                } else if (i4 == 2) {
                    f3 = f8;
                    f4 = f2;
                    f5 = f10;
                } else if (i4 == 3) {
                    f4 = f9;
                    f3 = f8;
                    f5 = f2;
                } else if (i4 == 4) {
                    f5 = f2;
                    f3 = f10;
                    f4 = f8;
                } else {
                    f4 = f8;
                    f5 = f9;
                    f3 = f2;
                }
                out[i++] = (int)((float)Math.pow(f3, d) * 256.0f) << 16 | (int)((float)Math.pow(f4, d) * 256.0f) << 8 | (int)((float)Math.pow(f5, d) * 256.0f);
                ++i2;
            }
            ++i1;
        }
        i1 = 0;
        while (i1 < map.length) {
            int index = i1 & 0xFFFF;
            if (index < hsl2rgb.length) {
                JagexColor.map[index] = i1;
            }
            ++i1;
        }
    }

    public static int[] hslToRGB(int color) {
        int rgb = hsl2rgb[color & 0xFFFF];
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return new int[]{red, green, blue};
    }

    public static int rgbToHSL(int color) {
        java.awt.Color col = new java.awt.Color(color);
        float[] hsb = java.awt.Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), null);
        int H6bit = (int)(hsb[0] * 63.0f);
        int S3bit = (int)(hsb[1] * 7.0f);
        int L7bit = (int)(hsb[2] * 127.0f);
        return (H6bit << 10) + (S3bit << 7) + L7bit;
    }

    public static int RGB_to_RS2HSB(int red, int green, int blue) {
        float[] HSB = java.awt.Color.RGBtoHSB(red, green, blue, null);
        float hue = HSB[0];
        float saturation = HSB[1];
        float brightness = HSB[2];
        int encode_hue = (int)(hue * 63.0f);
        int encode_saturation = (int)(saturation * 7.0f);
        int encode_brightness = (int)(brightness * 127.0f);
        return (encode_hue << 10) + (encode_saturation << 7) + encode_brightness;
    }

    public static Color RS2HSB_to_RGB(int RS2HSB) {
        int decode_hue = RS2HSB >> 10 & 0x3F;
        int decode_saturation = RS2HSB >> 7 & 7;
        int decode_brightness = RS2HSB & 0x7F;
        java.awt.Color awtColor = new java.awt.Color(java.awt.Color.HSBtoRGB((float)decode_hue / 63.0f, (float)decode_saturation / 7.0f, (float)decode_brightness / 127.0f));
        int r = awtColor.getRed();
        int g = awtColor.getGreen();
        int b = awtColor.getBlue();
        int a = awtColor.getAlpha();
        double opacity = (double)a / 255.0;
        Color fxColor = Color.rgb((int)r, (int)g, (int)b, (double)opacity);
        return fxColor;
    }

    public static int jagex_color_to_hex(Color color) {
        return 1;
    }

    public static void main(String[] args) throws Exception {
        int rgb = hsl2rgb[926];
        System.out.println(String.format("%02x%02x%02x", rgb & 0xFF, rgb >> 8 & 0xFF, rgb >> 16 & 0xFF));
    }

    public static int toHSB(int red, int green, int blue) {
        float[] HSB = java.awt.Color.RGBtoHSB(red, green, blue, null);
        int hue = (int)(HSB[0] * 63.0f);
        int saturation = (int)(HSB[1] * 7.0f);
        int brightness = (int)(HSB[2] * 127.0f);
        return (hue << 10) + (saturation << 7) + brightness;
    }

    public static int toRGB(int hsb) {
        int hue = hsb >> 10 & 0x3F;
        int saturation = hsb >> 7 & 7;
        int brightness = hsb & 0x7F;
        return java.awt.Color.HSBtoRGB((float)hue / 63.0f, (float)saturation / 7.0f, (float)brightness / 127.0f);
    }

    public static int fromHEX(String hex) {
        int[] rgb = JagexColor.hex2Rgb(hex);
        return JagexColor.fromRGB(rgb[0], rgb[1], rgb[2]);
    }

    public static int fromRGB(java.awt.Color color) {
        return JagexColor.fromRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static int fromRGB(int red, int green, int blue) {
        return JagexColor.fromRGB((red << 16) + (green << 8) + blue);
    }

    public static int fromRGB(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        rgb = (blue << 16) + (green << 8) + red & 0xFFFF;
        int i = 0;
        while (i < hsl2rgb.length) {
            if (hsl2rgb[i] == rgb) {
                return map[i] & 0xFFFF;
            }
            ++i;
        }
        return -1;
    }

    public static int fromHSL(int color) {
        int rgb = hsl2rgb[color & 0xFFFF];
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return (blue << 16) + (green << 8) + red;
    }

    public static int[] hex2Rgb(String color) {
        int hex = Integer.parseInt(color, 16);
        int red = (hex & 0xFF0000) >> 16;
        int green = (hex & 0xFF00) >> 8;
        int blue = hex & 0xFF;
        return new int[]{red, green, blue};
    }
}

