/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.util;

import com.aragon.util.Node;

public final class HashTable {
    private final int size;
    private final Node[] cache;

    public HashTable(int size) {
        this.size = size;
        this.cache = new Node[size];
        int ptr = 0;
        while (ptr < size) {
            Node node;
            node.next = node = (this.cache[ptr] = new Node());
            node.prev = node;
            ++ptr;
        }
    }

    public Node get(long hash) {
        Node node = this.cache[(int)(hash & (long)(this.size - 1))];
        Node entry = node.next;
        while (entry != node) {
            if (entry.hash == hash) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public void put(Node entry, long hash) {
        try {
            if (entry.prev != null) {
                entry.unlink();
            }
            Node node_1 = this.cache[(int)(hash & (long)(this.size - 1))];
            entry.prev = node_1.prev;
            entry.next = node_1;
            entry.prev.next = entry;
            entry.next.prev = entry;
            entry.hash = hash;
            return;
        }
        catch (RuntimeException runtimeexception) {
            System.out.println("91499, " + entry + ", " + hash + ", " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }
}

