/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.util;

import com.aragon.util.signlink;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public enum GamePreferences {
    PARTICLES(1);

    private static final File SAVED_PREF;
    private int state = 0;
    private int[] revisions;

    static {
        SAVED_PREF = new File(String.valueOf(signlink.findcachedir()) + ".preference.sim");
    }

    private GamePreferences(int state) {
        this.state = state;
    }

    private GamePreferences(int ... revisions) {
        this.revisions = revisions;
        this.state = revisions[0];
    }

    public void toggle() {
        if (this.state > 1) {
            new IllegalStateException("You can not toggle this setting.");
        }
        this.state = this.toggled() ? 0 : 1;
        this.save();
    }

    public void cycle() {
        int index = 0;
        while (index < this.revisions.length) {
            if (index == this.revisions[index]) {
                this.state = index == this.revisions.length - 1 ? this.revisions[0] : this.revisions[index + 1];
                this.save();
                return;
            }
            ++index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void load() throws IOException {
        if (!SAVED_PREF.exists()) return;
        Throwable throwable = null;
        Object var1_2 = null;
        try {
            FileReader fr = new FileReader(SAVED_PREF);
            try {
                try (BufferedReader br = new BufferedReader(fr);){
                    GamePreferences[] gamePreferencesArray = GamePreferences.values();
                    int n = gamePreferencesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GamePreferences preference = gamePreferencesArray[n2];
                        preference.setState(br.read());
                        ++n2;
                    }
                }
                if (fr == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fr == null) throw throwable;
                fr.close();
                throw throwable;
            }
            fr.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void save() {
        try {
            if (!SAVED_PREF.exists()) {
                SAVED_PREF.createNewFile();
            }
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                FileWriter fw = new FileWriter(SAVED_PREF);
                try {
                    try (BufferedWriter bw = new BufferedWriter(fw);){
                        GamePreferences[] gamePreferencesArray = GamePreferences.values();
                        int n = gamePreferencesArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            GamePreferences preference = gamePreferencesArray[n2];
                            bw.write(preference.getState());
                            ++n2;
                        }
                    }
                    if (fw == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                fw.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean toggled() {
        return this.state == 1;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }
}

