/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.util;

public class ColorUtils {
    public static int darkenColor(int color) {
        return ColorUtils.adjustBrightness(color, 0.8);
    }

    public static int lightenColor(int color) {
        return ColorUtils.adjustBrightness(color, 1.2);
    }

    public static int darkenColor(int color, double value) {
        return ColorUtils.adjustBrightness(color, value);
    }

    public static int lightenColor(int color, double value) {
        return ColorUtils.adjustBrightness(color, value);
    }

    private static int adjustBrightness(int color, double factor) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = Math.min((int)((double)red * factor), 255);
        green = Math.min((int)((double)green * factor), 255);
        blue = Math.min((int)((double)blue * factor), 255);
        return red << 16 | green << 8 | blue;
    }

    public static int toGrayscale(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int gray = (int)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue);
        return gray << 16 | gray << 8 | gray;
    }

    public static int blendColors(int color1, int color2, double ratio) {
        ratio = Math.max(0.0, Math.min(1.0, ratio));
        int red1 = color1 >> 16 & 0xFF;
        int green1 = color1 >> 8 & 0xFF;
        int blue1 = color1 & 0xFF;
        int red2 = color2 >> 16 & 0xFF;
        int green2 = color2 >> 8 & 0xFF;
        int blue2 = color2 & 0xFF;
        int red = (int)((double)red1 * ratio + (double)red2 * (1.0 - ratio));
        int green = (int)((double)green1 * ratio + (double)green2 * (1.0 - ratio));
        int blue = (int)((double)blue1 * ratio + (double)blue2 * (1.0 - ratio));
        return red << 16 | green << 8 | blue;
    }

    public static int blendAlphaColors(int background, int foreground, int alpha) {
        if (alpha >= 255) {
            return foreground;
        }
        if (alpha <= 0) {
            return background;
        }
        float a = (float)alpha / 255.0f;
        int br = background >> 16 & 0xFF;
        int bg = background >> 8 & 0xFF;
        int bb = background & 0xFF;
        int fr = foreground >> 16 & 0xFF;
        int fg = foreground >> 8 & 0xFF;
        int fb = foreground & 0xFF;
        int r = (int)((float)br * (1.0f - a) + (float)fr * a);
        int g = (int)((float)bg * (1.0f - a) + (float)fg * a);
        int b = (int)((float)bb * (1.0f - a) + (float)fb * a);
        return r << 16 | g << 8 | b;
    }

    public static void main(String[] args) {
        int originalColor = 0xFFFFFF;
        int darkerColor = ColorUtils.darkenColor(originalColor);
        int lighterColor = ColorUtils.lightenColor(originalColor);
        int grayscaleColor = ColorUtils.toGrayscale(originalColor);
        int blendedColor = ColorUtils.blendColors(originalColor, 0xFF0000, 0.5);
        System.out.printf("Original color: #%06X\n", originalColor);
        System.out.printf("Darker color: #%06X\n", darkerColor);
        System.out.printf("Lighter color: #%06X\n", lighterColor);
        System.out.printf("Grayscale color: #%06X\n", grayscaleColor);
        System.out.printf("Blended color: #%06X\n", blendedColor);
    }

    public static int interpolateColor(int color1, int color2, float fraction) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * fraction);
        int g = (int)((float)g1 + (float)(g2 - g1) * fraction);
        int b = (int)((float)b1 + (float)(b2 - b1) * fraction);
        return r << 16 | g << 8 | b;
    }
}

