/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.util;

import com.aragon.cache.CacheArchive;
import com.aragon.client.Client;
import com.aragon.util.Stream;

public final class Censor {
    private static int[] fragmentSenc;
    private static char[][] badChars;
    private static byte[][][] badEncByteArray;
    private static char[][] domainEnc;
    private static char[][] tldList;
    private static int[] tdlArray;
    private static final String[] exceptions;

    static {
        exceptions = new String[]{"cook", "cook's", "cooks", "seeks", "sheet", "woop", "woops", "faq", "noob", "noobs"};
    }

    public static void loadConfig(CacheArchive streamLoader) {
        Stream stream = new Stream(streamLoader.getDataForName("fragmentsenc.txt"));
        Stream stream_1 = new Stream(streamLoader.getDataForName("badenc.txt"));
        Stream stream_2 = new Stream(streamLoader.getDataForName("domainenc.txt"));
        Stream stream_3 = new Stream(streamLoader.getDataForName("tldlist.txt"));
        Censor.readValues(stream, stream_1, stream_2, stream_3);
    }

    private static void readValues(Stream stream, Stream stream_1, Stream stream_2, Stream stream_3) {
        Censor.readBadEnc(stream_1);
        Censor.readDomainEnc(stream_2);
        Censor.readFragmentsEnc(stream);
        Censor.readTldList(stream_3);
    }

    private static void readTldList(Stream stream) {
        int i = stream.readDWord();
        tldList = new char[i][];
        tdlArray = new int[i];
        int j = 0;
        while (j < i) {
            Censor.tdlArray[j] = stream.readUnsignedByte();
            char[] ac = new char[stream.readUnsignedByte()];
            int k = 0;
            while (k < ac.length) {
                ac[k] = (char)stream.readUnsignedByte();
                ++k;
            }
            Censor.tldList[j] = ac;
            ++j;
        }
    }

    private static void readBadEnc(Stream stream) {
        int amount = stream.readDWord();
        badChars = new char[amount][];
        badEncByteArray = new byte[amount][][];
        Censor.readBadEnc(stream, badChars, badEncByteArray);
    }

    private static void readDomainEnc(Stream stream) {
        int i = stream.readDWord();
        domainEnc = new char[i][];
        Censor.initDomainEnc(domainEnc, stream);
    }

    private static void readFragmentsEnc(Stream stream) {
        fragmentSenc = new int[stream.readDWord()];
        int i = 0;
        while (i < fragmentSenc.length) {
            Censor.fragmentSenc[i] = stream.readUnsignedWord();
            ++i;
        }
    }

    private static void readBadEnc(Stream stream, char[][] badCharsArray, byte[][][] badCharsByteArray) {
        int j = 0;
        while (j < badCharsArray.length) {
            char[] bdChar = new char[stream.readUnsignedByte()];
            int k = 0;
            while (k < bdChar.length) {
                bdChar[k] = (char)stream.readUnsignedByte();
                ++k;
            }
            badCharsArray[j] = bdChar;
            byte[][] abyte1 = new byte[stream.readUnsignedByte()][2];
            int l = 0;
            while (l < abyte1.length) {
                abyte1[l][0] = (byte)stream.readUnsignedByte();
                abyte1[l][1] = (byte)stream.readUnsignedByte();
                ++l;
            }
            if (abyte1.length > 0) {
                badCharsByteArray[j] = abyte1;
            }
            ++j;
        }
    }

    private static void initDomainEnc(char[][] ac, Stream stream) {
        int j = 0;
        while (j < ac.length) {
            char[] ac1 = new char[stream.readUnsignedByte()];
            int k = 0;
            while (k < ac1.length) {
                ac1[k] = (char)stream.readUnsignedByte();
                ++k;
            }
            ac[j] = ac1;
            ++j;
        }
    }

    private static void stripNonlegalChars(char[] ac) {
        int i = 0;
        int j = 0;
        while (j < ac.length) {
            ac[i] = Censor.charIsLegal(ac[j]) ? ac[j] : 32;
            if (i == 0 || ac[i] != ' ' || ac[i - 1] != ' ') {
                ++i;
            }
            ++j;
        }
        int k = i;
        while (k < ac.length) {
            ac[k] = 32;
            ++k;
        }
    }

    private static boolean charIsLegal(char c) {
        return c >= ' ' && c <= '\u007f' || c == ' ' || c == '\n' || c == '\t' || c == '\u00a3' || c == '\u20ac';
    }

    public static String doCensor(String s) {
        if (!Client.getOption("censor_active")) {
            return s;
        }
        long l = System.currentTimeMillis();
        char[] ac = s.toCharArray();
        Censor.stripNonlegalChars(ac);
        String s1 = new String(ac).trim();
        ac = s1.toLowerCase().toCharArray();
        String s2 = s1.toLowerCase();
        Censor.removeTlds(ac);
        Censor.processBadenc(ac);
        Censor.removeEmails(ac);
        Censor.censorBigNumbers(ac);
        int j = 0;
        while (j < exceptions.length) {
            int k = -1;
            while ((k = s2.indexOf(exceptions[j], k + 1)) != -1) {
                char[] ac1 = exceptions[j].toCharArray();
                System.arraycopy(ac1, 0, ac, k, ac1.length);
            }
            ++j;
        }
        Censor.restoreOriginalCase(s1.toCharArray(), ac);
        Censor.fixCases(ac);
        long l1 = System.currentTimeMillis();
        return new String(ac).trim();
    }

    private static void restoreOriginalCase(char[] ac, char[] ac1) {
        int j = 0;
        while (j < ac.length) {
            if (ac1[j] != '*' && Censor.isUpperCaseLetter(ac[j])) {
                ac1[j] = ac[j];
            }
            ++j;
        }
    }

    private static void fixCases(char[] ac) {
        boolean flag = true;
        int j = 0;
        while (j < ac.length) {
            char c = ac[j];
            if (Censor.isLetter(c)) {
                if (flag) {
                    if (Censor.isLowerCaseLetter(c)) {
                        flag = false;
                    }
                } else if (Censor.isUpperCaseLetter(c)) {
                    ac[j] = (char)(c + 97 - 65);
                }
            } else {
                flag = true;
            }
            ++j;
        }
    }

    private static void processBadenc(char[] ac) {
        int i = 0;
        while (i < 2) {
            int j = badChars.length - 1;
            while (j >= 0) {
                Censor.censorStringIn(badEncByteArray[j], ac, badChars[j]);
                --j;
            }
            ++i;
        }
    }

    private static void removeEmails(char[] ac) {
        char[] ac1 = (char[])ac.clone();
        char[] ac2 = new char[]{'(', 'a', ')'};
        Censor.censorStringIn(null, ac1, ac2);
        char[] ac3 = (char[])ac.clone();
        char[] ac4 = new char[]{'d', 'o', 't'};
        Censor.censorStringIn(null, ac3, ac4);
        int i = domainEnc.length - 1;
        while (i >= 0) {
            Censor.removeEmailFrom(ac, domainEnc[i], ac3, ac1);
            --i;
        }
    }

    private static void removeEmailFrom(char[] ac, char[] ac1, char[] ac2, char[] ac3) {
        if (ac1.length > ac.length) {
            return;
        }
        int k = 0;
        while (k <= ac.length - ac1.length) {
            int l = k;
            int i1 = 0;
            int j = 1;
            while (l < ac.length) {
                int j1;
                char c = ac[l];
                char c1 = '\u0000';
                if (l + 1 < ac.length) {
                    c1 = ac[l + 1];
                }
                if (i1 < ac1.length && (j1 = Censor.checkForCharBasicLeetspeak(c, ac1[i1], c1)) > 0) {
                    l += j1;
                    ++i1;
                    continue;
                }
                if (i1 == 0) break;
                j1 = Censor.checkForCharBasicLeetspeak(c, ac1[i1 - 1], c1);
                if (j1 > 0) {
                    l += j1;
                    if (i1 != 1) continue;
                    ++j;
                    continue;
                }
                if (i1 >= ac1.length || !Censor.isNotAlphaNumeric(c)) break;
                ++l;
            }
            if (i1 >= ac1.length) {
                boolean flag1 = false;
                int k1 = Censor.isAtSignBeforeDomain(ac, ac3, k);
                int l1 = Censor.isDotAfterDomain(ac2, l - 1, ac);
                if (k1 > 2 || l1 > 2) {
                    flag1 = true;
                }
                if (flag1) {
                    int i2 = k;
                    while (i2 < l) {
                        ac[i2] = 42;
                        ++i2;
                    }
                }
            }
            k += j;
        }
    }

    private static int isAtSignBeforeDomain(char[] ac, char[] ac1, int j) {
        if (j == 0) {
            return 2;
        }
        int k = j - 1;
        while (k >= 0) {
            if (!Censor.isNotAlphaNumeric(ac[k])) break;
            if (ac[k] == '@') {
                return 3;
            }
            --k;
        }
        int l = 0;
        int i1 = j - 1;
        while (i1 >= 0) {
            if (!Censor.isNotAlphaNumeric(ac1[i1])) break;
            if (ac1[i1] == '*') {
                ++l;
            }
            --i1;
        }
        if (l >= 3) {
            return 4;
        }
        return !Censor.isNotAlphaNumeric(ac[j - 1]) ? 0 : 1;
    }

    private static int isDotAfterDomain(char[] ac, int i, char[] ac1) {
        if (i + 1 == ac1.length) {
            return 2;
        }
        int j = i + 1;
        while (j < ac1.length) {
            if (!Censor.isNotAlphaNumeric(ac1[j])) break;
            if (ac1[j] == '.' || ac1[j] == ',') {
                return 3;
            }
            ++j;
        }
        int k = 0;
        int l = i + 1;
        while (l < ac1.length) {
            if (!Censor.isNotAlphaNumeric(ac[l])) break;
            if (ac[l] == '*') {
                ++k;
            }
            ++l;
        }
        if (k >= 3) {
            return 4;
        }
        return !Censor.isNotAlphaNumeric(ac1[i + 1]) ? 0 : 1;
    }

    private static void removeTlds(char[] ac) {
        char[] ac1 = (char[])ac.clone();
        char[] ac2 = new char[]{'d', 'o', 't'};
        Censor.censorStringIn(null, ac1, ac2);
        char[] ac3 = (char[])ac.clone();
        char[] ac4 = new char[]{'s', 'l', 'a', 's', 'h'};
        Censor.censorStringIn(null, ac3, ac4);
        int i = 0;
        while (i < tldList.length) {
            Censor.removeTldFrom(ac3, tldList[i], tdlArray[i], ac1, ac);
            ++i;
        }
    }

    private static void removeTldFrom(char[] ac, char[] ac1, int i, char[] ac2, char[] ac3) {
        if (ac1.length > ac3.length) {
            return;
        }
        int k = 0;
        while (k <= ac3.length - ac1.length) {
            int l = k;
            int i1 = 0;
            int j = 1;
            while (l < ac3.length) {
                int j1;
                char c = ac3[l];
                char c1 = '\u0000';
                if (l + 1 < ac3.length) {
                    c1 = ac3[l + 1];
                }
                if (i1 < ac1.length && (j1 = Censor.checkForCharBasicLeetspeak(c, ac1[i1], c1)) > 0) {
                    l += j1;
                    ++i1;
                    continue;
                }
                if (i1 == 0) break;
                j1 = Censor.checkForCharBasicLeetspeak(c, ac1[i1 - 1], c1);
                if (j1 > 0) {
                    l += j1;
                    if (i1 != 1) continue;
                    ++j;
                    continue;
                }
                if (i1 >= ac1.length || !Censor.isNotAlphaNumeric(c)) break;
                ++l;
            }
            if (i1 >= ac1.length) {
                boolean _tmp;
                boolean flag1 = false;
                int k1 = Censor.isDotBeforeTld(ac3, k, ac2);
                int l1 = Censor.isSlashAfterTld(ac3, ac, l - 1);
                if (i == 1 && k1 > 0 && l1 > 0) {
                    flag1 = true;
                }
                if (i == 2 && (k1 > 2 && l1 > 0 || k1 > 0 && l1 > 2)) {
                    flag1 = true;
                }
                if (i == 3 && k1 > 0 && l1 > 2) {
                    flag1 = true;
                }
                boolean bl = _tmp = i == 3 && k1 > 2 && l1 > 0;
                if (flag1) {
                    int i2 = k;
                    int j2 = l - 1;
                    if (k1 > 2) {
                        if (k1 == 4) {
                            boolean flag2 = false;
                            int l2 = i2 - 1;
                            while (l2 >= 0) {
                                if (flag2) {
                                    if (ac2[l2] != '*') break;
                                    i2 = l2;
                                } else if (ac2[l2] == '*') {
                                    i2 = l2;
                                    flag2 = true;
                                }
                                --l2;
                            }
                        }
                        boolean flag3 = false;
                        int i3 = i2 - 1;
                        while (i3 >= 0) {
                            if (flag3) {
                                if (Censor.isNotAlphaNumeric(ac3[i3])) break;
                                i2 = i3;
                            } else if (!Censor.isNotAlphaNumeric(ac3[i3])) {
                                flag3 = true;
                                i2 = i3;
                            }
                            --i3;
                        }
                    }
                    if (l1 > 2) {
                        if (l1 == 4) {
                            boolean flag4 = false;
                            int j3 = j2 + 1;
                            while (j3 < ac3.length) {
                                if (flag4) {
                                    if (ac[j3] != '*') break;
                                    j2 = j3;
                                } else if (ac[j3] == '*') {
                                    j2 = j3;
                                    flag4 = true;
                                }
                                ++j3;
                            }
                        }
                        boolean flag5 = false;
                        int k3 = j2 + 1;
                        while (k3 < ac3.length) {
                            if (flag5) {
                                if (Censor.isNotAlphaNumeric(ac3[k3])) break;
                                j2 = k3;
                            } else if (!Censor.isNotAlphaNumeric(ac3[k3])) {
                                flag5 = true;
                                j2 = k3;
                            }
                            ++k3;
                        }
                    }
                    int k2 = i2;
                    while (k2 <= j2) {
                        ac3[k2] = 42;
                        ++k2;
                    }
                }
            }
            k += j;
        }
    }

    private static int isDotBeforeTld(char[] ac, int j, char[] ac1) {
        if (j == 0) {
            return 2;
        }
        int k = j - 1;
        while (k >= 0) {
            if (!Censor.isNotAlphaNumeric(ac[k])) break;
            if (ac[k] == ',' || ac[k] == '.') {
                return 3;
            }
            --k;
        }
        int l = 0;
        int i1 = j - 1;
        while (i1 >= 0) {
            if (!Censor.isNotAlphaNumeric(ac1[i1])) break;
            if (ac1[i1] == '*') {
                ++l;
            }
            --i1;
        }
        if (l >= 3) {
            return 4;
        }
        return !Censor.isNotAlphaNumeric(ac[j - 1]) ? 0 : 1;
    }

    private static int isSlashAfterTld(char[] ac, char[] ac1, int i) {
        if (i + 1 == ac.length) {
            return 2;
        }
        int j = i + 1;
        while (j < ac.length) {
            if (!Censor.isNotAlphaNumeric(ac[j])) break;
            if (ac[j] == '\\' || ac[j] == '/') {
                return 3;
            }
            ++j;
        }
        int k = 0;
        int l = i + 1;
        while (l < ac.length) {
            if (!Censor.isNotAlphaNumeric(ac1[l])) break;
            if (ac1[l] == '*') {
                ++k;
            }
            ++l;
        }
        if (k >= 5) {
            return 4;
        }
        return !Censor.isNotAlphaNumeric(ac[i + 1]) ? 0 : 1;
    }

    private static void censorStringIn(byte[][] abyte0, char[] ac, char[] ac1) {
        if (ac1.length > ac.length) {
            return;
        }
        boolean flag = true;
        int k = 0;
        while (k <= ac.length - ac1.length) {
            int l = k;
            int i1 = 0;
            int j1 = 0;
            int j = 1;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            while (!(l >= ac.length || flag2 && flag3)) {
                int k1;
                char c = ac[l];
                char c2 = '\u0000';
                if (l + 1 < ac.length) {
                    c2 = ac[l + 1];
                }
                if (i1 < ac1.length && (k1 = Censor.checkForCharAdvancedLeetspeak(c2, c, ac1[i1])) > 0) {
                    if (k1 == 1 && Censor.isDigit(c)) {
                        flag2 = true;
                    }
                    if (k1 == 2 && (Censor.isDigit(c) || Censor.isDigit(c2))) {
                        flag2 = true;
                    }
                    l += k1;
                    ++i1;
                    continue;
                }
                if (i1 == 0) break;
                k1 = Censor.checkForCharAdvancedLeetspeak(c2, c, ac1[i1 - 1]);
                if (k1 > 0) {
                    l += k1;
                    if (i1 != 1) continue;
                    ++j;
                    continue;
                }
                if (i1 >= ac1.length || !Censor.isDigitOrSymbol(c)) break;
                if (Censor.isNotAlphaNumeric(c) && c != '\'') {
                    flag1 = true;
                }
                if (Censor.isDigit(c)) {
                    flag3 = true;
                }
                if (++j1 * 100 / (++l - k) > 90) break;
            }
            if (!(i1 < ac1.length || flag2 && flag3)) {
                boolean flag4 = true;
                if (!flag1) {
                    char c1 = ' ';
                    if (k - 1 >= 0) {
                        c1 = ac[k - 1];
                    }
                    char c3 = ' ';
                    if (l < ac.length) {
                        c3 = ac[l];
                    }
                    byte byte0 = Censor.getCharCodeDependingOnType(c1);
                    byte byte1 = Censor.getCharCodeDependingOnType(c3);
                    if (abyte0 != null && Censor.charCodesAllowCensoring(byte0, abyte0, byte1)) {
                        flag4 = false;
                    }
                } else {
                    boolean flag5 = false;
                    boolean flag6 = false;
                    if (k - 1 < 0 || Censor.isNotAlphaNumeric(ac[k - 1]) && ac[k - 1] != '\'') {
                        flag5 = true;
                    }
                    if (l >= ac.length || Censor.isNotAlphaNumeric(ac[l]) && ac[l] != '\'') {
                        flag6 = true;
                    }
                    if (!flag5 || !flag6) {
                        boolean flag7 = false;
                        int k2 = k - 2;
                        if (flag5) {
                            k2 = k;
                        }
                        while (!flag7 && k2 < l) {
                            if (!(k2 < 0 || Censor.isNotAlphaNumeric(ac[k2]) && ac[k2] != '\'')) {
                                char[] ac2 = new char[3];
                                int j3 = 0;
                                while (j3 < 3) {
                                    if (k2 + j3 >= ac.length || Censor.isNotAlphaNumeric(ac[k2 + j3]) && ac[k2 + j3] != '\'') break;
                                    ac2[j3] = ac[k2 + j3];
                                    ++j3;
                                }
                                boolean flag8 = true;
                                if (j3 == 0) {
                                    flag8 = false;
                                }
                                if (!(j3 >= 3 || k2 - 1 < 0 || Censor.isNotAlphaNumeric(ac[k2 - 1]) && ac[k2 - 1] != '\'')) {
                                    flag8 = false;
                                }
                                if (flag8 && !Censor.charsMatchFragment(ac2)) {
                                    flag7 = true;
                                }
                            }
                            ++k2;
                        }
                        if (!flag7) {
                            flag4 = false;
                        }
                    }
                }
                if (flag4) {
                    int l1 = 0;
                    int i2 = 0;
                    int j2 = -1;
                    int l2 = k;
                    while (l2 < l) {
                        if (Censor.isDigit(ac[l2])) {
                            ++l1;
                        } else if (Censor.isLetter(ac[l2])) {
                            ++i2;
                            j2 = l2;
                        }
                        ++l2;
                    }
                    if (j2 > -1) {
                        l1 -= l - 1 - j2;
                    }
                    if (l1 <= i2) {
                        int i3 = k;
                        while (i3 < l) {
                            ac[i3] = 42;
                            ++i3;
                        }
                    } else {
                        j = 1;
                    }
                }
            }
            k += j;
        }
    }

    private static boolean charCodesAllowCensoring(byte byte0, byte[][] abyte0, byte byte2) {
        int i = 0;
        if (abyte0[i][0] == byte0 && abyte0[i][1] == byte2) {
            return true;
        }
        int j = abyte0.length - 1;
        if (abyte0[j][0] == byte0 && abyte0[j][1] == byte2) {
            return true;
        }
        do {
            int k;
            if (abyte0[k = (i + j) / 2][0] == byte0 && abyte0[k][1] == byte2) {
                return true;
            }
            if (byte0 < abyte0[k][0] || byte0 == abyte0[k][0] && byte2 < abyte0[k][1]) {
                j = k;
                continue;
            }
            i = k;
        } while (i != j && i + 1 != j);
        return false;
    }

    private static int checkForCharBasicLeetspeak(char c, char c1, char c2) {
        if (c1 == c) {
            return 1;
        }
        if (c1 == 'o' && c == '0') {
            return 1;
        }
        if (c1 == 'o' && c == '(' && c2 == ')') {
            return 2;
        }
        if (c1 == 'c' && (c == '(' || c == '<' || c == '[')) {
            return 1;
        }
        if (c1 == 'e' && c == '\u20ac') {
            return 1;
        }
        if (c1 == 's' && c == '$') {
            return 1;
        }
        return c1 != 'l' || c != 'i' ? 0 : 1;
    }

    private static int checkForCharAdvancedLeetspeak(char c, char c1, char c2) {
        if (c2 == c1) {
            return 1;
        }
        if (c2 >= 'a' && c2 <= 'm') {
            if (c2 == 'a') {
                if (c1 == '4' || c1 == '@' || c1 == '^') {
                    return 1;
                }
                return c1 != '/' || c != '\\' ? 0 : 2;
            }
            if (c2 == 'b') {
                if (c1 == '6' || c1 == '8') {
                    return 1;
                }
                return !(c1 == '1' && c == '3' || c1 == 'i' && c == '3') ? 0 : 2;
            }
            if (c2 == 'c') {
                return c1 != '(' && c1 != '<' && c1 != '{' && c1 != '[' ? 0 : 1;
            }
            if (c2 == 'd') {
                return !(c1 == '[' && c == ')' || c1 == 'i' && c == ')') ? 0 : 2;
            }
            if (c2 == 'e') {
                return c1 != '3' && c1 != '\u20ac' ? 0 : 1;
            }
            if (c2 == 'f') {
                if (c1 == 'p' && c == 'h') {
                    return 2;
                }
                return c1 != '\u00a3' ? 0 : 1;
            }
            if (c2 == 'g') {
                return c1 != '9' && c1 != '6' && c1 != 'q' ? 0 : 1;
            }
            if (c2 == 'h') {
                return c1 != '#' ? 0 : 1;
            }
            if (c2 == 'i') {
                return c1 != 'y' && c1 != 'l' && c1 != 'j' && c1 != '1' && c1 != '!' && c1 != ':' && c1 != ';' && c1 != '|' ? 0 : 1;
            }
            if (c2 == 'j') {
                return 0;
            }
            if (c2 == 'k') {
                return 0;
            }
            if (c2 == 'l') {
                return c1 != '1' && c1 != '|' && c1 != 'i' ? 0 : 1;
            }
            if (c2 == 'm') {
                return 0;
            }
        }
        if (c2 >= 'n' && c2 <= 'z') {
            if (c2 == 'n') {
                return 0;
            }
            if (c2 == 'o') {
                if (c1 == '0' || c1 == '*') {
                    return 1;
                }
                return !(c1 == '(' && c == ')' || c1 == '[' && c == ']' || c1 == '{' && c == '}' || c1 == '<' && c == '>') ? 0 : 2;
            }
            if (c2 == 'p') {
                return 0;
            }
            if (c2 == 'q') {
                return 0;
            }
            if (c2 == 'r') {
                return 0;
            }
            if (c2 == 's') {
                return c1 != '5' && c1 != 'z' && c1 != '$' && c1 != '2' ? 0 : 1;
            }
            if (c2 == 't') {
                return c1 != '7' && c1 != '+' ? 0 : 1;
            }
            if (c2 == 'u') {
                if (c1 == 'v') {
                    return 1;
                }
                return !(c1 == '\\' && c == '/' || c1 == '\\' && c == '|' || c1 == '|' && c == '/') ? 0 : 2;
            }
            if (c2 == 'v') {
                return !(c1 == '\\' && c == '/' || c1 == '\\' && c == '|' || c1 == '|' && c == '/') ? 0 : 2;
            }
            if (c2 == 'w') {
                return c1 != 'v' || c != 'v' ? 0 : 2;
            }
            if (c2 == 'x') {
                return !(c1 == ')' && c == '(' || c1 == '}' && c == '{' || c1 == ']' && c == '[' || c1 == '>' && c == '<') ? 0 : 2;
            }
            if (c2 == 'y') {
                return 0;
            }
            if (c2 == 'z') {
                return 0;
            }
        }
        if (c2 >= '0' && c2 <= '9') {
            if (c2 == '0') {
                if (c1 == 'o' || c1 == 'O') {
                    return 1;
                }
                return !(c1 == '(' && c == ')' || c1 == '{' && c == '}' || c1 == '[' && c == ']') ? 0 : 2;
            }
            if (c2 == '1') {
                return c1 != 'l' ? 0 : 1;
            }
            return 0;
        }
        if (c2 == ',') {
            return c1 != '.' ? 0 : 1;
        }
        if (c2 == '.') {
            return c1 != ',' ? 0 : 1;
        }
        if (c2 == '!') {
            return c1 != 'i' ? 0 : 1;
        }
        return 0;
    }

    private static byte getCharCodeDependingOnType(char c) {
        if (c >= 'a' && c <= 'z') {
            return (byte)(c - 97 + 1);
        }
        if (c == '\'') {
            return 28;
        }
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48 + 29);
        }
        return 27;
    }

    private static void censorBigNumbers(char[] ac) {
        int j;
        int k = 0;
        int l = 0;
        int i1 = 0;
        while ((j = Censor.getFirstDigit(ac, k)) != -1) {
            boolean flag = false;
            int j1 = k;
            while (j1 >= 0 && j1 < j && !flag) {
                if (!Censor.isNotAlphaNumeric(ac[j1]) && !Censor.isDigitOrSymbol(ac[j1])) {
                    flag = true;
                }
                ++j1;
            }
            if (flag) {
                l = 0;
            }
            if (l == 0) {
                i1 = j;
            }
            k = Censor.getFirstNonDigit(ac, j);
            int k1 = 0;
            int l1 = j;
            while (l1 < k) {
                k1 = k1 * 10 + ac[l1] - 48;
                ++l1;
            }
            l = k1 > 255 || k - j > 8 ? 0 : ++l;
            if (l != 4) continue;
            int i2 = i1;
            while (i2 < k) {
                ac[i2] = 42;
                ++i2;
            }
            l = 0;
        }
    }

    private static int getFirstDigit(char[] ac, int i) {
        int k = i;
        while (k < ac.length && k >= 0) {
            if (ac[k] >= '0' && ac[k] <= '9') {
                return k;
            }
            ++k;
        }
        return -1;
    }

    private static int getFirstNonDigit(char[] ac, int j) {
        int k = j;
        while (k < ac.length && k >= 0) {
            if (ac[k] < '0' || ac[k] > '9') {
                return k;
            }
            ++k;
        }
        return ac.length;
    }

    private static boolean isNotAlphaNumeric(char c) {
        return !Censor.isLetter(c) && !Censor.isDigit(c);
    }

    private static boolean isDigitOrSymbol(char c) {
        return c < 'a' || c > 'z' || c == 'v' || c == 'x' || c == 'j' || c == 'q' || c == 'z';
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLowerCaseLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isUpperCaseLetter(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean charsMatchFragment(char[] ac) {
        boolean flag = true;
        int i = 0;
        while (i < ac.length) {
            if (!Censor.isDigit(ac[i]) && ac[i] != '\u0000') {
                flag = false;
            }
            ++i;
        }
        if (flag) {
            return true;
        }
        int j = Censor.hashCode(ac);
        int k = 0;
        int l = fragmentSenc.length - 1;
        if (j == fragmentSenc[k] || j == fragmentSenc[l]) {
            return true;
        }
        do {
            int i1;
            if (j == fragmentSenc[i1 = (k + l) / 2]) {
                return true;
            }
            if (j < fragmentSenc[i1]) {
                l = i1;
                continue;
            }
            k = i1;
        } while (k != l && k + 1 != l);
        return false;
    }

    private static int hashCode(char[] chars) {
        if (chars.length > 6) {
            return 0;
        }
        int code = 0;
        int l = 0;
        while (l < chars.length) {
            char c = chars[chars.length - l - 1];
            if (c >= 'a' && c <= 'z') {
                code = code * 38 + (c - 97 + 1);
            } else if (c == '\'') {
                code = code * 38 + 27;
            } else if (c >= '0' && c <= '9') {
                code = code * 38 + (c - 48 + 28);
            } else if (c != '\u0000') {
                return 0;
            }
            ++l;
        }
        return code;
    }
}

