/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.widgets.tabbed;

import com.aragon.ui.WidgetGroup;
import java.util.ArrayList;
import java.util.List;

public class TabbedWidget {
    private final List<Tab> tabs = new ArrayList<Tab>();
    private int selectedIndex = 0;
    private TabPosition tabPosition = TabPosition.TOP;
    private int tabWidth = 150;
    private int tabHeight = 34;

    public void addTab(String name, WidgetGroup group) {
        this.tabs.add(new Tab(name, group));
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.tabs.size()) {
            this.selectedIndex = index;
        }
    }

    public Tab getSelectedTab() {
        return this.tabs.isEmpty() ? null : this.tabs.get(this.selectedIndex);
    }

    public List<Tab> getTabs() {
        return this.tabs;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setTabPosition(TabPosition pos) {
        this.tabPosition = pos;
    }

    public TabPosition getTabPosition() {
        return this.tabPosition;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public int getTabHeight() {
        return this.tabHeight;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public static class Tab {
        private final String name;
        private final WidgetGroup content;

        public Tab(String name, WidgetGroup content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public WidgetGroup getContent() {
            return this.content;
        }
    }

    public static enum TabPosition {
        TOP,
        LEFT,
        DROPDOWN_CYCLER;

    }
}

