/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.widgets.achievements;

import com.aragon.graphics.TextDrawingArea;
import java.util.List;

public class AchievementContainer {
    private AchievementEntry[] achievementEntries;

    public AchievementContainer(AchievementEntry ... achievementEntries) {
        this.achievementEntries = achievementEntries;
    }

    public AchievementEntry[] getAchievementEntries() {
        return this.achievementEntries;
    }

    public void toggleExpansion(int index) {
        this.getAchievementEntries()[index].toggle();
    }

    public static class AchievementEntry {
        private final String name;
        private final String description;
        private final int spriteId;
        private final List<Reward> rewards;
        private String category;
        private String difficulty;
        private int points;
        private boolean completed;
        private int currentProgress;
        private int progressPercentage;
        private String progressString;
        private boolean expanded = false;
        private int heightCollapsed = 40;
        private int heightExpanded = 96;

        public AchievementEntry(String name, String description, int spriteId, List<Reward> rewards) {
            this.name = name;
            this.description = description;
            this.spriteId = spriteId;
            this.rewards = rewards;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void toggle() {
            this.expanded = !this.expanded;
        }

        public int getCurrentHeight() {
            return this.expanded ? this.heightExpanded : this.heightCollapsed;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getSpriteId() {
            return this.spriteId;
        }

        public List<Reward> getRewards() {
            return this.rewards;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getDifficulty() {
            return this.difficulty;
        }

        public void setDifficulty(String difficulty) {
            this.difficulty = difficulty;
        }

        public int getPoints() {
            return this.points;
        }

        public void setPoints(int points) {
            this.points = points;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }

        public int getCurrentProgress() {
            return this.currentProgress;
        }

        public void setCurrentProgress(int currentProgress) {
            this.currentProgress = currentProgress;
        }

        public int getProgressPercentage() {
            return this.progressPercentage;
        }

        public void setProgressPercentage(int progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        public String getProgressString() {
            return this.progressString;
        }

        public void setProgressString(String progressString) {
            this.progressString = progressString;
        }

        public int computeExpandedHeight(TextDrawingArea font, int maxWidth) {
            int paddingTop = 10;
            int paddingBottom = 10;
            int descSpacing = 10;
            int rewardSpacing = 10;
            List<String> lines = font.wrapText(this.description, maxWidth);
            int descHeight = 15;
            int rewardBoxSize = 42;
            int rewardBoxMargin = 3;
            int itemsPerRow = Math.max(1, maxWidth / (rewardBoxSize + rewardBoxMargin));
            int rows = (int)Math.ceil((double)this.rewards.size() / (double)itemsPerRow);
            int rewardHeight = rows * (rewardBoxSize + rewardBoxMargin);
            return paddingTop + descHeight + descSpacing + rewardHeight + rewardSpacing + paddingBottom;
        }

        public static class Reward {
            private int itemId;
            private int amount;

            public Reward(int itemId, int amount) {
                this.itemId = itemId;
                this.amount = amount;
            }

            public int getItemId() {
                return this.itemId;
            }

            public int getAmount() {
                return this.amount;
            }
        }
    }
}

