/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.listener;

import com.aragon.client.Client;
import com.aragon.ui.RSInterface;
import com.aragon.ui.components.ProgressBar;

public class UpgradeSystemListener {
    private final int PROGRESS_BAR_CONTAINER = 64488;
    private boolean jumping = false;
    private int jumpsRemaining = 0;
    private int currentJump = 0;
    private int totalJumps = 30;
    private int targetIndex = -1;
    private long lastJumpTime = 0L;
    private int jumpDelay = 50;
    private boolean skipAnimation = false;

    public void init(int winningIndex) {
        this.init(winningIndex, false);
    }

    public void init(int winningIndex, boolean skip) {
        this.targetIndex = winningIndex;
        this.skipAnimation = skip;
        this.jumping = true;
        this.currentJump = 0;
        this.totalJumps = 30;
        this.jumpsRemaining = 30;
        this.lastJumpTime = System.currentTimeMillis();
        RSInterface.interfaceCache[64489].message = "";
    }

    public void jump() {
        if (!this.jumping) {
            return;
        }
        if (this.skipAnimation) {
            this.onFinish();
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastJumpTime < (long)this.jumpDelay) {
            return;
        }
        this.lastJumpTime = currentTime;
        System.out.println("currentJump: " + this.currentJump + " / totalJumps: " + this.totalJumps);
        int percentage = this.getPercentage(this.currentJump, this.totalJumps);
        System.out.println("Percentage: " + percentage);
        ProgressBar rsInterface = (ProgressBar)RSInterface.interfaceCache[64488];
        rsInterface.progressBarPercentage = percentage;
        rsInterface.colorTypes = new int[]{12567094};
        if (this.jumpsRemaining <= 0) {
            rsInterface.progressBarPercentage = 100;
            if (this.targetIndex == 1) {
                rsInterface.colorTypes = new int[]{0x9A0000};
                RSInterface.interfaceCache[64489].message = "Failed to Upgrade";
            } else if (this.targetIndex == 0) {
                rsInterface.colorTypes = new int[]{3329330};
                RSInterface.interfaceCache[64489].message = "Successfully Upgraded";
            }
            RSInterface.interfaceCache[64488] = rsInterface;
            this.onFinish();
            return;
        }
        ++this.currentJump;
        --this.jumpsRemaining;
        RSInterface.interfaceCache[64488] = rsInterface;
        this.determineSpeed();
    }

    private void determineSpeed() {
        this.jumpDelay = 25;
    }

    private int getPercentage(int current, int total) {
        if (total == 0) {
            return 100;
        }
        float proportion = (float)current / (float)total;
        return (int)(proportion * 100.0f);
    }

    private void onFinish() {
        this.jumping = false;
        Client.stream.createFrame(239);
        Client.stream.writeWord(this.targetIndex);
        System.out.println("Lootbox landed on index: " + this.targetIndex);
    }

    public boolean isJumping() {
        return this.jumping;
    }
}

