/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.listener;

import com.aragon.client.Client;
import com.aragon.ui.RSInterface;
import java.util.ArrayList;
import java.util.List;

public class LootboxJumpListener {
    private final int LOOTBOX_WINDOW_ID = 90478;
    private final int FIRST_HIGHLIGHT_CHILD_INDEX = 8;
    private boolean jumping = false;
    private int jumpsRemaining = 0;
    private int currentJump = 0;
    private int totalJumps = 0;
    private int targetIndex = -1;
    private int currentIndex = 0;
    private int previousIndex = -1;
    private final int TOTAL_ITEMS = 48;
    private final int GRID_COLS = 12;
    private final int GRID_ROWS = 5;
    private long lastJumpTime = 0L;
    private int jumpDelay = 50;
    private boolean skipAnimation = false;
    private List<Integer> validItemIndices = new ArrayList<Integer>();

    public void init(int winningIndex) {
        this.init(winningIndex, false);
    }

    public void init(int winningIndex, boolean skip) {
        this.targetIndex = winningIndex;
        this.skipAnimation = skip;
        this.jumping = true;
        this.currentJump = 0;
        this.previousIndex = -1;
        this.buildValidItemIndices();
        if (this.validItemIndices.isEmpty()) {
            System.out.println("No valid items to jump to!");
            this.jumping = false;
            return;
        }
        if (!this.validItemIndices.contains(this.targetIndex)) {
            System.out.println("WARNING: Target index " + this.targetIndex + " is not in valid items list!");
            if (!this.validItemIndices.contains(this.targetIndex)) {
                this.validItemIndices.add(this.targetIndex);
            }
        }
        this.currentIndex = this.validItemIndices.get(0);
        this.hideAllHighlights();
        if (skip) {
            this.totalJumps = 1;
            this.jumpsRemaining = 0;
        } else {
            this.jumpsRemaining = this.totalJumps = 30 + (int)(Math.random() * 5.0);
            this.jumpDelay = 50;
        }
        this.lastJumpTime = System.currentTimeMillis();
        this.showHighlight(this.currentIndex);
    }

    private void buildValidItemIndices() {
        this.validItemIndices.clear();
        RSInterface window = RSInterface.interfaceCache[90478];
        if (window == null) {
            System.out.println("ERROR: Lootbox window not found!");
            return;
        }
        System.out.println("=== DEBUG: Scanning for valid items (FIXED) ===");
        System.out.println("Window has " + window.children.length + " children");
        System.out.println("Starting from child index: 8");
        int i = 0;
        while (i < 48) {
            int childIndex = 9 + i * 2;
            if (childIndex >= window.children.length) {
                System.out.println("Child index " + childIndex + " is out of bounds");
                break;
            }
            int itemContainerId = window.children[childIndex];
            RSInterface itemContainer = RSInterface.interfaceCache[itemContainerId];
            if (itemContainer == null) {
                System.out.println("Item " + i + " (child " + childIndex + ", id " + itemContainerId + "): container is null");
            } else if (itemContainer.inv == null || itemContainer.inv.length == 0) {
                System.out.println("Item " + i + " (child " + childIndex + ", id " + itemContainerId + "): no inv array");
            } else {
                int itemId = itemContainer.inv[0];
                if (itemId > 0) {
                    this.validItemIndices.add(i);
                    System.out.println("Item " + i + " (child " + childIndex + ", id " + itemContainerId + "): inv[0] = " + itemId + " \u2713");
                }
            }
            ++i;
        }
        System.out.println("=== Found " + this.validItemIndices.size() + " valid items: " + this.validItemIndices + " ===");
    }

    private boolean isValidIndex(int index) {
        return this.validItemIndices.contains(index);
    }

    public void jump() {
        if (!this.jumping) {
            return;
        }
        if (this.skipAnimation) {
            this.jumpToTarget();
            this.onFinish();
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastJumpTime < (long)this.jumpDelay) {
            return;
        }
        this.lastJumpTime = currentTime;
        if (this.jumpsRemaining <= 0) {
            this.jumpToTarget();
            this.onFinish();
            return;
        }
        this.previousIndex = this.currentIndex;
        if (this.jumpsRemaining <= 2) {
            this.moveTowardsTarget();
        } else {
            this.jumpToRandom();
        }
        if (this.previousIndex != this.currentIndex) {
            this.hideHighlight(this.previousIndex);
            this.showHighlight(this.currentIndex);
        }
        ++this.currentJump;
        --this.jumpsRemaining;
        this.determineSpeed();
    }

    private void jumpToRandom() {
        if (this.validItemIndices.isEmpty()) {
            return;
        }
        int randomValidIndex = (int)(Math.random() * (double)this.validItemIndices.size());
        int newIndex = this.validItemIndices.get(randomValidIndex);
        int attempts = 0;
        while (newIndex == this.currentIndex && this.validItemIndices.size() > 1 && attempts < 10) {
            randomValidIndex = (int)(Math.random() * (double)this.validItemIndices.size());
            newIndex = this.validItemIndices.get(randomValidIndex);
            ++attempts;
        }
        this.currentIndex = newIndex;
    }

    private void moveTowardsTarget() {
        if (this.currentIndex == this.targetIndex) {
            return;
        }
        int currentValidIndex = this.validItemIndices.indexOf(this.currentIndex);
        int targetValidIndex = this.validItemIndices.indexOf(this.targetIndex);
        if (currentValidIndex == -1 || targetValidIndex == -1) {
            this.currentIndex = this.targetIndex;
            return;
        }
        if (currentValidIndex < targetValidIndex) {
            this.currentIndex = this.validItemIndices.get(currentValidIndex + 1);
        } else if (currentValidIndex > targetValidIndex) {
            this.currentIndex = this.validItemIndices.get(currentValidIndex - 1);
        }
    }

    private void jumpToTarget() {
        this.hideAllHighlights();
        this.currentIndex = this.targetIndex;
        this.showHighlight(this.currentIndex);
    }

    private void showHighlight(int itemIndex) {
        int highlightBoxId;
        RSInterface highlightBox;
        if (itemIndex < 0 || itemIndex >= 48) {
            return;
        }
        int childIndex = 8 + itemIndex * 2;
        RSInterface window = RSInterface.interfaceCache[90478];
        if (window != null && childIndex < window.children.length && (highlightBox = RSInterface.interfaceCache[highlightBoxId = window.children[childIndex]]) != null) {
            highlightBox.setDoNotDraw(false);
        }
    }

    private void hideHighlight(int itemIndex) {
        int highlightBoxId;
        RSInterface highlightBox;
        if (itemIndex < 0 || itemIndex >= 48) {
            return;
        }
        int childIndex = 8 + itemIndex * 2;
        RSInterface window = RSInterface.interfaceCache[90478];
        if (window != null && childIndex < window.children.length && (highlightBox = RSInterface.interfaceCache[highlightBoxId = window.children[childIndex]]) != null) {
            highlightBox.setDoNotDraw(true);
        }
    }

    private void hideAllHighlights() {
        int i = 0;
        while (i < 48) {
            this.hideHighlight(i);
            ++i;
        }
    }

    private void determineSpeed() {
        int percentage = this.getPercentage(this.currentJump, this.totalJumps);
        this.jumpDelay = percentage > 95 ? 700 : (percentage > 90 ? 500 : (percentage > 80 ? 400 : (percentage > 60 ? 350 : 200)));
    }

    private int getPercentage(int current, int total) {
        if (total == 0) {
            return 100;
        }
        float proportion = (float)current / (float)total;
        return (int)(proportion * 100.0f);
    }

    private void onFinish() {
        this.jumping = false;
        this.hideAllHighlights();
        this.showHighlight(this.targetIndex);
        Client.stream.createFrame(239);
        Client.stream.writeWord(this.targetIndex);
        System.out.println("Lootbox landed on index: " + this.targetIndex);
    }

    public boolean isJumping() {
        return this.jumping;
    }
}

