/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.components.tree;

import com.aragon.graphics.DrawingArea;
import com.aragon.ui.components.tree.TreeBranch;
import com.aragon.ui.components.tree.TreeNode;

public class TreeWidget {
    private final TreeBranch root;
    private final int nodeSize = 8;
    private final int vSpacing = 50;
    private final int hSpacing = 70;
    private final int nodeSpacing = 25;
    private final int[] nodeColors = new int[]{3682339, 5919301, 4867388, 7038296, 2762012};
    private final int[] selectedNodeColors = new int[]{8012825, 10115626, 9064229, 11167029, 5910549};
    private final int[] lockedNodeColors = new int[]{0x2A2A2A, 0x3A3A3A, 0x333333, 0x4A4A4A, 0x1A1A1A};

    public TreeWidget(TreeBranch root) {
        this.root = root;
    }

    public void draw(int x, int y) {
        this.drawBranch(this.root, x, y, null, 0, 0);
    }

    private void drawBranch(TreeBranch branch, int x, int y, TreeBranch parent, int parentX, int parentY) {
        if (parent != null && branch.hasConnections) {
            this.drawStyledBranch(parentX, parentY, x, y, branch.branchThickness, branch.branchColor);
        }
        int nodeX = x;
        int nodeY = y;
        int i = 0;
        while (i < branch.nodes.size()) {
            TreeNode node = branch.nodes.get(i);
            this.drawStyledNode(nodeX, nodeY, node);
            nodeY += 25;
            ++i;
        }
        int connectionX = x;
        int connectionY = y;
        if (branch.east != null) {
            int ex = x + 70;
            int ey = connectionY;
            this.drawBranch(branch.east, ex, ey, branch, connectionX, connectionY);
        }
        if (branch.west != null) {
            int wx = x - 70;
            int wy = connectionY;
            this.drawBranch(branch.west, wx, wy, branch, connectionX, connectionY);
        }
        if (branch.north != null) {
            int nx = x;
            int ny = y - 50;
            this.drawBranch(branch.north, nx, ny, branch, connectionX, connectionY);
        }
        if (branch.south != null) {
            int sx = x;
            int sy = y + 50;
            this.drawBranch(branch.south, sx, sy, branch, connectionX, connectionY);
        }
    }

    private void drawStyledNode(int x, int y, TreeNode node) {
        int[] colors = !node.unlocked ? this.lockedNodeColors : (node.selected ? this.selectedNodeColors : this.nodeColors);
        int size = 8;
        DrawingArea.drawPixels(size * 2 + 4, y - size - 2, x - size - 2, colors[0], size * 2 + 4);
        DrawingArea.drawPixels(size * 2 + 2, y - size - 1, x - size - 1, colors[1], size * 2 + 2);
        DrawingArea.drawPixels(size * 2, y - size, x - size, colors[2], size * 2);
        if (node.count > 1) {
            DrawingArea.drawPixels(4, y - 2, x - 2, 16766720, 4);
        }
        switch (node.nodeType) {
            case 1: {
                DrawingArea.drawPixels(2, y - size - 3, x - size - 3, 16766720, size * 2 + 6);
                DrawingArea.drawPixels(2, y + size + 1, x - size - 3, 16766720, size * 2 + 6);
                DrawingArea.drawPixels(size * 2 + 6, y - size - 3, x - size - 3, 16766720, 2);
                DrawingArea.drawPixels(size * 2 + 6, y - size - 3, x + size + 1, 16766720, 2);
                break;
            }
            case 2: {
                if (node.unlocked) break;
                DrawingArea.drawPixels(2, y - 1, x - 2, 0x666666, 4);
                DrawingArea.drawPixels(1, y - 3, x - 1, 0x666666, 2);
            }
        }
    }

    private void drawStyledBranch(int x1, int y1, int x2, int y2, int thickness, int color) {
        DrawingArea.drawLine(x1, y1, x2, y2, color, 255);
        int i = 1;
        while (i <= thickness) {
            DrawingArea.drawLine(x1, y1 + i, x2, y2 + i, color, 200);
            DrawingArea.drawLine(x1, y1 - i, x2, y2 - i, color, 200);
            ++i;
        }
        DrawingArea.drawLine(x1, y1 - thickness - 1, x2, y2 - thickness - 1, this.lightenColor(color, 1.3f), 128);
        DrawingArea.drawLine(x1, y1 + thickness + 1, x2, y2 + thickness + 1, this.darkenColor(color, 0.7f), 128);
    }

    private int lightenColor(int color, float factor) {
        int r = (int)Math.min(255.0f, (float)(color >> 16 & 0xFF) * factor);
        int g = (int)Math.min(255.0f, (float)(color >> 8 & 0xFF) * factor);
        int b = (int)Math.min(255.0f, (float)(color & 0xFF) * factor);
        return r << 16 | g << 8 | b;
    }

    private int darkenColor(int color, float factor) {
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return r << 16 | g << 8 | b;
    }

    public TreeNode getNodeAt(int mouseX, int mouseY, int treeX, int treeY) {
        return this.findNodeAt(this.root, treeX, treeY, mouseX, mouseY);
    }

    private TreeNode findNodeAt(TreeBranch branch, int x, int y, int mouseX, int mouseY) {
        TreeNode found;
        int nodeX = x;
        int nodeY = y;
        for (TreeNode node : branch.nodes) {
            int distance = (int)Math.sqrt(Math.pow(mouseX - nodeX, 2.0) + Math.pow(mouseY - nodeY, 2.0));
            if (distance <= 10) {
                return node;
            }
            nodeY += 25;
        }
        if (branch.east != null && (found = this.findNodeAt(branch.east, x + 70, y, mouseX, mouseY)) != null) {
            return found;
        }
        if (branch.west != null && (found = this.findNodeAt(branch.west, x - 70, y, mouseX, mouseY)) != null) {
            return found;
        }
        if (branch.north != null && (found = this.findNodeAt(branch.north, x, y - 50, mouseX, mouseY)) != null) {
            return found;
        }
        if (branch.south != null && (found = this.findNodeAt(branch.south, x, y + 50, mouseX, mouseY)) != null) {
            return found;
        }
        return null;
    }
}

