/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.components.tree;

import com.aragon.ui.components.tree.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class TreeBranch {
    public List<TreeNode> nodes = new ArrayList<TreeNode>();
    public TreeBranch east;
    public TreeBranch west;
    public TreeBranch north;
    public TreeBranch south;
    public boolean isMainTrunk = false;
    public int branchThickness = 2;
    public int branchColor = 5917242;
    public boolean hasConnections = true;

    private TreeBranch() {
    }

    public static TreeBranch create() {
        return new TreeBranch();
    }

    public static TreeBranch createMainTrunk() {
        TreeBranch trunk = new TreeBranch();
        trunk.isMainTrunk = true;
        trunk.branchThickness = 4;
        return trunk;
    }

    public TreeBranch addNode(TreeNode n) {
        this.nodes.add(n);
        return this;
    }

    public TreeBranch addEast(TreeBranch branch) {
        this.east = branch;
        return branch;
    }

    public TreeBranch addWest(TreeBranch branch) {
        this.west = branch;
        return branch;
    }

    public TreeBranch addNorth(TreeBranch branch) {
        this.north = branch;
        return branch;
    }

    public TreeBranch addSouth(TreeBranch branch) {
        this.south = branch;
        return branch;
    }

    public TreeBranch setMainTrunk(boolean isMainTrunk) {
        this.isMainTrunk = isMainTrunk;
        if (isMainTrunk) {
            this.branchThickness = 4;
        }
        return this;
    }

    public TreeBranch setBranchThickness(int thickness) {
        this.branchThickness = thickness;
        return this;
    }

    public TreeBranch setBranchColor(int color) {
        this.branchColor = color;
        return this;
    }
}

