/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.components.inputfield;

import com.aragon.ui.components.inputfield.InputRule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

public class RuleSet {
    private final Set<InputRule> rules = new HashSet<InputRule>();
    private Predicate<Character> numberRangePredicate = null;
    private Predicate<String> valuePredicate = s -> true;
    private Predicate<String> stringLength = s -> true;
    private boolean allowAbbreviations = false;
    private int maxValue = Integer.MAX_VALUE;
    private int maxLength = 20;

    public RuleSet(InputRule ... rules) {
        this.rules.addAll(Arrays.asList(rules));
    }

    public RuleSet withNumberRange(String range) {
        this.numberRangePredicate = this.buildRangePredicate(range);
        this.rules.add(InputRule.NUMBERS_RANGE);
        return this;
    }

    public RuleSet withMaxValue(int max) {
        this.maxValue = max;
        this.rules.add(InputRule.MAX_NUMERIC_VALUE);
        this.valuePredicate = this.valuePredicate.and(s -> {
            try {
                return Integer.parseInt(s) <= this.maxValue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        return this;
    }

    public RuleSet maxLength(int maxLength) {
        this.maxLength = maxLength;
        this.rules.add(InputRule.MAX_LENGTH);
        this.stringLength = this.stringLength.and(s -> s != null && s.length() < maxLength);
        return this;
    }

    public boolean isCharAllowed(char c) {
        if (this.rules.contains((Object)InputRule.NO_CHARACTERS) && Character.isLetter(c)) {
            return false;
        }
        if (this.rules.contains((Object)InputRule.NO_SPECIAL_CHARACTERS) && !Character.isLetterOrDigit(c)) {
            return false;
        }
        if (this.rules.contains((Object)InputRule.NUMBERS_RANGE) && !this.numberRangePredicate.test(Character.valueOf(c))) {
            return false;
        }
        if (this.rules.contains((Object)InputRule.ONLY_INTEGERS) && !Character.isDigit(c)) {
            return false;
        }
        return !this.rules.contains((Object)InputRule.NUMERIC_INPUT_WITH_OPTIONAL_SUFFIX) || Character.isDigit(c) || c == 'k' || c == 'm' || c == 'b' || c == '.';
    }

    public boolean isValueAllowed(String value) {
        return this.valuePredicate.test(value);
    }

    public boolean canType(String value) {
        return this.stringLength.test(value);
    }

    public boolean isValidAfterAppend(String currentValue, char nextChar) {
        if (!this.isCharAllowed(nextChar)) {
            return false;
        }
        if (!this.canType(currentValue)) {
            return false;
        }
        String updated = String.valueOf(currentValue) + nextChar;
        if (this.rules.contains((Object)InputRule.ONLY_INTEGERS) && (updated.contains(".") || updated.contains(","))) {
            return false;
        }
        if (this.rules.contains((Object)InputRule.NUMERIC_INPUT_WITH_OPTIONAL_SUFFIX) && !this.isAbbreviationValid(updated)) {
            return false;
        }
        if (this.rules.contains((Object)InputRule.MAX_NUMERIC_VALUE)) {
            try {
                int expanded = this.parseAbbreviationToInt(updated);
                if (expanded > this.maxValue) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.isValueAllowed(updated);
    }

    public boolean isValidAfterAppend(String fullValue) {
        if (!this.canType(fullValue)) {
            return false;
        }
        if (this.rules.contains((Object)InputRule.ONLY_INTEGERS) && (fullValue.contains(".") || fullValue.contains(","))) {
            return false;
        }
        if (this.rules.contains((Object)InputRule.NUMERIC_INPUT_WITH_OPTIONAL_SUFFIX) && !this.isAbbreviationValid(fullValue)) {
            return false;
        }
        if (this.rules.contains((Object)InputRule.MAX_NUMERIC_VALUE)) {
            try {
                int expanded = this.parseAbbreviationToInt(fullValue);
                if (expanded > this.maxValue) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.isValueAllowed(fullValue);
    }

    public int parseAbbreviationToInt(String input) {
        if (input == null || input.isEmpty()) {
            return 0;
        }
        if ((input = input.toLowerCase().replace(",", "").trim()).endsWith("k")) {
            return (int)(Double.parseDouble(input.replace("k", "")) * 1000.0);
        }
        if (input.endsWith("m")) {
            return (int)(Double.parseDouble(input.replace("m", "")) * 1000000.0);
        }
        if (input.endsWith("b")) {
            return (int)(Double.parseDouble(input.replace("b", "")) * 1.0E9);
        }
        return Integer.parseInt(input.replaceFirst("^0+(?!$)", ""));
    }

    private boolean isAbbreviationValid(String input) {
        if (input == null || input.isEmpty()) {
            return true;
        }
        if ((input = input.toLowerCase()).matches("^[kmb]$") || input.matches("^\\.k$") || input.matches("^\\.m$") || input.matches("^\\.b$")) {
            return false;
        }
        return input.matches("^\\d*(\\.\\d*)?[kmb]?$");
    }

    private Predicate<Character> buildRangePredicate(String range) {
        String[] parts = range.split("-");
        if (parts.length != 2) {
            return c -> false;
        }
        char start = parts[0].charAt(0);
        char end = parts[1].charAt(0);
        return c3 -> c3.charValue() >= start && c3.charValue() <= end;
    }

    public boolean contains(InputRule rule) {
        return this.rules.contains((Object)rule);
    }

    public Set<InputRule> getRules() {
        return this.rules;
    }
}

