/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.components.inputfield;

import com.aragon.ui.components.inputfield.RuleSet;
import java.util.function.Consumer;

public class InputField {
    private final int height;
    private final int width;
    private boolean open;
    private String defaultText;
    private String action;
    public Consumer<Integer> onSelect;
    public int childId;
    private RuleSet rules;
    private int maxLength;
    private long lastRejectedTime = -1L;
    private static final long REJECTION_FLASH_DURATION = 600L;

    public InputField(int width, int height, String defaultText, String action, RuleSet ruleSet, int maxLength) {
        this(width, height, defaultText, action, null, ruleSet, maxLength);
    }

    public InputField(int width, int height, String defaultText, String action, RuleSet ruleSet) {
        this(width, height, defaultText, action, null, ruleSet, 20);
    }

    public InputField(int width, int height, String defaultText, String action, Consumer<Integer> onSelect, RuleSet rules, int maxLenght) {
        this.width = width;
        this.height = height;
        this.defaultText = defaultText;
        this.open = false;
        this.onSelect = onSelect;
        this.rules = rules;
        this.maxLength = maxLenght;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean b) {
        this.open = b;
    }

    public void reset() {
        this.setOpen(false);
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public RuleSet getRules() {
        return this.rules;
    }

    public void setRules(RuleSet rules) {
        this.rules = rules;
    }

    public void markRejected() {
        this.lastRejectedTime = System.currentTimeMillis();
    }

    public boolean isRejectFlashing() {
        return System.currentTimeMillis() - this.lastRejectedTime < 600L;
    }

    public int getMaxLength() {
        return this.maxLength;
    }
}

