/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.components.dropdown;

import com.aragon.client.Client;
import com.aragon.ui.components.dropdown.Dropdown;
import java.util.function.Consumer;

public class DropdownMenu {
    private final int height;
    private final int width;
    private final String[] options;
    private final Dropdown dropdown;
    private final boolean split;
    private boolean open;
    private String optionSelected;
    public Consumer<Integer> onSelect;

    public DropdownMenu(int width, boolean split, int defaultOption, String[] options, Dropdown d) {
        this(width, split, defaultOption, options, d, null);
    }

    public DropdownMenu(int width, boolean split, int defaultOption, String[] options, Dropdown d, Consumer<Integer> onSelect) {
        this.width = width;
        this.height = split ? 14 * options.length / 2 + 3 : 14 * options.length + 3;
        this.options = options;
        this.optionSelected = defaultOption == -1 ? "Select an option" : options[defaultOption];
        this.open = false;
        this.dropdown = d;
        this.split = split;
        this.onSelect = onSelect;
    }

    public DropdownMenu(boolean split, int defaultOption, String[] options, Dropdown d, Consumer<Integer> onSelect) {
        this.width = this.getMaxWidth(options);
        this.height = split ? 14 * options.length / 2 + 3 : 14 * options.length + 3;
        this.options = options;
        this.optionSelected = defaultOption == -1 ? "Select an option" : options[defaultOption];
        this.open = false;
        this.dropdown = d;
        this.split = split;
        this.onSelect = onSelect;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String[] getOptions() {
        return this.options;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean b) {
        this.open = b;
    }

    public int getSelectedIndex() {
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i] == this.optionSelected) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getSelected() {
        return this.optionSelected;
    }

    public void setSelected(String s) {
        this.optionSelected = s;
    }

    public int setSelectedIndex(int index) {
        int i = 0;
        while (i < this.options.length) {
            if (i == index) {
                this.setSelected(this.options[i]);
                return i;
            }
            ++i;
        }
        this.setSelected(this.options[this.options.length - 1]);
        return this.options.length - 1;
    }

    public Dropdown getDrop() {
        return this.dropdown;
    }

    public boolean doesSplit() {
        return this.split;
    }

    public void reset() {
        this.setOpen(false);
        this.optionSelected = this.options[0];
    }

    private int getMaxWidth(String[] options) {
        int maxWidth = 0;
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            int width = Client.getClient().newSmallFont.getTextWidth(option);
            maxWidth = Math.max(width, maxWidth);
            ++n2;
        }
        return 36 + maxWidth;
    }
}

