/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.components.accordion;

import java.util.ArrayList;
import java.util.List;

public class Accordion {
    private AccordionInfo[] accordions;

    public Accordion(AccordionInfo ... accordionInfo) {
        this.accordions = accordionInfo;
    }

    public AccordionInfo[] getAccordions() {
        return this.accordions;
    }

    public void expandAccordion(int index) {
        this.accordions[index].toggleExpansion();
    }

    public static class AccordionInfo {
        private String accordionName;
        private boolean expanded;
        private List<String> accordionList;
        private List<List<EntryIcon>> entryIcons;

        public AccordionInfo(String accordionName, boolean expanded) {
            this.accordionName = accordionName;
            this.expanded = expanded;
            this.accordionList = new ArrayList<String>();
            this.entryIcons = new ArrayList<List<EntryIcon>>();
        }

        public void addToList(String name) {
            this.accordionList.add(name);
            this.entryIcons.add(new ArrayList());
        }

        public void addIconToEntry(int entryIndex, EntryIcon icon) {
            if (entryIndex >= 0 && entryIndex < this.entryIcons.size()) {
                this.entryIcons.get(entryIndex).add(icon);
            }
        }

        public void addIconToAllEntries(EntryIcon icon) {
            int i = 0;
            while (i < this.entryIcons.size()) {
                this.entryIcons.get(i).add(icon.copy());
                ++i;
            }
        }

        public void setIconsForEntry(int entryIndex, List<EntryIcon> icons) {
            if (entryIndex >= 0 && entryIndex < this.entryIcons.size()) {
                this.entryIcons.set(entryIndex, new ArrayList<EntryIcon>(icons));
            }
        }

        public void setIconsForAllEntries(List<EntryIcon> icons) {
            ArrayList<EntryIcon> copiedIcons = new ArrayList<EntryIcon>(icons);
            int i = 0;
            while (i < this.entryIcons.size()) {
                this.entryIcons.set(i, new ArrayList<EntryIcon>(copiedIcons));
                ++i;
            }
        }

        public List<EntryIcon> getIconsForEntry(int entryIndex) {
            if (entryIndex >= 0 && entryIndex < this.entryIcons.size()) {
                return this.entryIcons.get(entryIndex);
            }
            return new ArrayList<EntryIcon>();
        }

        public void removeFromList(String name) {
            int index = this.accordionList.indexOf(name);
            if (index >= 0) {
                this.accordionList.remove(index);
                this.entryIcons.remove(index);
            }
        }

        public void clear() {
            this.accordionList.clear();
            this.entryIcons.clear();
        }

        public void toggleExpansion() {
            this.expanded = !this.expanded;
        }

        public List<String> getAccordionList() {
            return this.accordionList;
        }

        public String getAccordionName() {
            return this.accordionName;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setAccordionName(String accordionName) {
            this.accordionName = accordionName;
        }
    }

    public static class EntryIcon {
        private final int spriteId;
        private final String tooltip;
        private final Runnable action;
        private final boolean isToggle;
        private final int toggleSpriteOn;
        private final int toggleSpriteOff;
        private boolean toggled;

        public EntryIcon(int spriteId, String tooltip, Runnable action) {
            this.spriteId = spriteId;
            this.tooltip = tooltip;
            this.action = action;
            this.isToggle = false;
            this.toggleSpriteOn = -1;
            this.toggleSpriteOff = -1;
        }

        public EntryIcon(int toggleSpriteOn, int toggleSpriteOff, String tooltip, boolean defaultState, Runnable action) {
            this.spriteId = -1;
            this.tooltip = tooltip;
            this.action = action;
            this.isToggle = true;
            this.toggleSpriteOn = toggleSpriteOn;
            this.toggleSpriteOff = toggleSpriteOff;
            this.toggled = defaultState;
        }

        public int getSpriteId() {
            return this.isToggle ? (this.toggled ? this.toggleSpriteOn : this.toggleSpriteOff) : this.spriteId;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public boolean isToggle() {
            return this.isToggle;
        }

        public void toggle() {
            if (this.isToggle) {
                this.toggled = !this.toggled;
            }
        }

        public boolean isToggled() {
            return this.toggled;
        }

        public void onClick() {
            if (this.action != null) {
                this.action.run();
            }
            if (this.isToggle) {
                this.toggle();
            }
        }

        public EntryIcon copy() {
            if (this.isToggle) {
                return new EntryIcon(this.toggleSpriteOn, this.toggleSpriteOff, this.tooltip, this.toggled, this.action);
            }
            return new EntryIcon(this.spriteId, this.tooltip, this.action);
        }
    }
}

