/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.components;

import com.aragon.graphics.sprite.Sprite;
import com.aragon.util.MathUtils;

public class WidgetSlider {
    private final float minValue;
    private final float maxValue;
    private float value;
    private final int sliderWidth;
    private final Sprite background;
    private final Sprite handle;
    private boolean moving = false;

    public WidgetSlider(int minValue, int maxValue, int defaultValue, Sprite background, Sprite handle) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = defaultValue;
        this.background = background;
        this.handle = handle;
        this.sliderWidth = background.myWidth;
    }

    public void render(int x, int y) {
        this.background.drawSprite(x, y);
        int handleX = (int)MathUtils.map(this.value, this.minValue, this.maxValue, 0.0f, (float)this.sliderWidth - (float)this.handle.myWidth / 2.0f);
        this.handle.drawSprite(x + handleX, y - 1);
    }

    public void handleSlider(int x) {
        this.setMoving(true);
        this.value = MathUtils.map(x, 0.0f, this.sliderWidth - 1, this.minValue, this.maxValue);
    }

    public boolean isMoving() {
        return this.moving;
    }

    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }
}

