/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DissolveData {
    private final Map<String, List<DissolveDataInfo>> breakItemMap = new LinkedHashMap<String, List<DissolveDataInfo>>();

    public void put(String category, DissolveDataInfo dissolve) {
        this.breakItemMap.computeIfAbsent(category, k -> new ArrayList()).add(dissolve);
    }

    public Map<String, List<DissolveDataInfo>> getBreakItemMap() {
        return this.breakItemMap;
    }

    public List<DissolveDataInfo> getByCategory(String category) {
        return this.breakItemMap.getOrDefault(category, Collections.emptyList());
    }

    public static class DissolveDataInfo {
        private final int breakItem;
        private final int resultItem;
        private final int resultItemPerBreak;
        private final int totalAmountToBreak;

        public DissolveDataInfo(int breakItem, int resultItem, int resultItemPerBreak, int totalAmountToBreak) {
            this.breakItem = breakItem;
            this.resultItem = resultItem;
            this.resultItemPerBreak = resultItemPerBreak;
            this.totalAmountToBreak = totalAmountToBreak;
        }

        public int getBreakItem() {
            return this.breakItem;
        }

        public int getResultItem() {
            return this.resultItem;
        }

        public int getResultItemPerBreak() {
            return this.resultItemPerBreak;
        }

        public int getTotalAmountToBreak() {
            return this.totalAmountToBreak;
        }
    }
}

