/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.ui;

import com.aragon.client.Client;
import com.aragon.content.talents.TalentWidget;
import com.aragon.graphics.TextDrawingArea;
import com.aragon.graphics.sprite.Sprite;
import com.aragon.ui.RSInterface;
import com.aragon.ui.Widget;
import com.aragon.ui.WidgetComponent;
import com.aragon.ui.WidgetGroup;
import com.aragon.ui.components.DissolveData;
import com.aragon.ui.components.ProgressBar;
import com.aragon.ui.components.accordion.Accordion;
import com.aragon.ui.components.dropdown.Dropdown;
import com.aragon.ui.components.inputfield.RuleSet;
import com.aragon.ui.components.listbox.ListBox;
import com.aragon.ui.components.tree.TreeWidget;
import com.aragon.ui.listener.WidgetAnimationListener;
import com.aragon.ui.listener.WidgetButtonListener;
import com.aragon.ui.listener.WidgetContainerListener;
import com.aragon.ui.listener.WidgetEnterInputListener;
import com.aragon.ui.listener.WidgetInputFieldListener;
import com.aragon.ui.listener.WidgetStateListener;
import com.aragon.ui.listener.WidgetStringListener;
import com.aragon.ui.widgets.achievements.AchievementContainer;
import com.aragon.ui.widgets.tabbed.TabbedWidget;
import java.awt.Point;
import java.util.ArrayList;

public abstract class CustomWidget {
    public static final int OR1 = 0xFFB000;
    public int frame;
    public int id;
    public WidgetButtonListener buttonListener;
    public WidgetStateListener stateListener;
    public WidgetStringListener stringListener;
    public WidgetAnimationListener animListener;
    public WidgetContainerListener containerListener;
    public WidgetEnterInputListener enterInputListener;
    public WidgetInputFieldListener inputFieldListener;
    private boolean isWidgetScrollable = false;
    public ArrayList<WidgetComponent> components;
    public int mainId;
    public static final int TYPE_TAB_UI = 5146;
    public static final int WRAPPED_TEXT = 20;
    public static final int TREE_BRANCHES = 9200;
    public static final int TYPE_HEADER = 3835;

    public CustomWidget(int id) {
        this.mainId = id;
        this.id = id + 1;
        this.components = new ArrayList();
    }

    public CustomWidget(int id, boolean scrollable) {
        this.mainId = id;
        this.id = id + 1;
        this.components = new ArrayList();
        this.isWidgetScrollable = scrollable;
    }

    public void clear() {
        this.id = this.mainId + 1;
        this.components = new ArrayList();
    }

    public void addButtonListener(WidgetButtonListener listener) {
        this.buttonListener = listener;
    }

    public void addStateListener(WidgetStateListener listener) {
        this.stateListener = listener;
    }

    public void addStringListener(WidgetStringListener listener) {
        this.stringListener = listener;
    }

    public void addAnimListener(WidgetAnimationListener listener) {
        this.animListener = listener;
    }

    public void addContainerListener(WidgetContainerListener listener) {
        this.containerListener = listener;
    }

    public void addEnterInputListener(WidgetEnterInputListener listener) {
        this.enterInputListener = listener;
    }

    public void addInputFieldListener(WidgetInputFieldListener listener) {
        this.inputFieldListener = listener;
    }

    public abstract void init();

    public abstract String getName();

    public void add(RSInterface widget, int x, int y) {
        this.add(widget, x, y, 0);
    }

    public void add(RSInterface widget, int x, int y, int priority) {
        widget.id = widget.id;
        if (RSInterface.interfaceCache[widget.id] != null) {
            Widget.componentForMain.get(widget.id);
        }
        Widget.componentForMain.put(widget.id, this.mainId);
        WidgetComponent component = new WidgetComponent(new Point(x, y), widget);
        component.componentId = widget.id;
        component.parentId = this.mainId;
        component.priority = priority;
        this.components.add(component);
    }

    public void add(WidgetComponent component, int x, int y) {
        Widget.componentForMain.put(component.componentId, this.mainId);
        this.components.add(component);
    }

    public void addCenteredX(RSInterface widget, int y) {
        int x = 256 - widget.width / 2;
        this.add(widget, x, y);
    }

    public void addWidget(int id, int x, int y) {
        Widget.componentForMain.put(id, this.mainId);
        WidgetComponent component = new WidgetComponent(new Point(x, y), RSInterface.interfaceCache[id]);
        component.componentId = id;
        component.parentId = this.mainId;
        this.components.add(component);
    }

    public void setComponent(int index, int id) {
        if (index >= this.components.size() || this.components.get(index) == null) {
            return;
        }
        WidgetComponent component = this.components.get(index);
        component.componentId = id;
        component.component = RSInterface.interfaceCache[id];
        RSInterface tab = RSInterface.interfaceCache[this.mainId];
        tab.child(index, component.componentId, component.point.x, component.point.y);
    }

    public void setScrollMax(int amount) {
        this.getInterface().setScrollMax(amount);
    }

    public RSInterface copyWidget(int from, int x, int y) {
        RSInterface rsi = RSInterface.copy(this.id, from);
        Widget.componentForMain.put(this.id, this.mainId);
        WidgetComponent component = new WidgetComponent(new Point(x, y), RSInterface.interfaceCache[this.id]);
        component.componentId = this.id++;
        component.parentId = this.mainId;
        this.components.add(component);
        return rsi;
    }

    public RSInterface addBox(int width, int height, int border, int borderColor, int color, int transparency) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id;
        tab.id = this.id++;
        tab.type = 34;
        tab.width = width;
        tab.height = height;
        tab.borderWidth = border;
        tab.borderColor = borderColor;
        tab.disabledColor = color;
        tab.transparency = transparency;
        return tab;
    }

    public RSInterface addTabUI(int width, int tabHeight, int headerHeight, String ... tabNames) {
        RSInterface tabUI = RSInterface.addTabInterface(this.id);
        tabUI.id = this.id;
        RSInterface.parentID = this.id++;
        tabUI.type = 5146;
        tabUI.width = width;
        tabUI.height = tabHeight + headerHeight;
        tabUI.tabNames = tabNames;
        tabUI.selectedTab = 0;
        tabUI.tabs = new RSInterface[tabNames.length];
        tabUI.headerHeight = headerHeight;
        tabUI.tabHeight = tabHeight;
        return tabUI;
    }

    public RSInterface addThemedBox(int width, int height, boolean odd) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 5145;
        tab.width = width;
        tab.height = height;
        tab.drawOddBox = odd;
        return tab;
    }

    public RSInterface addThemedBox(int width, int height, boolean odd, String message) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id;
        tab.type = 5145;
        tab.width = width;
        tab.height = height;
        tab.drawOddBox = odd;
        tab.message = message.contains("#") ? String.valueOf(message) + ":" + this.id : message;
        ++this.id;
        return tab;
    }

    public RSInterface addThemedBox(int width, int height, boolean odd, int[] colours) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 5145;
        tab.width = width;
        tab.height = height;
        tab.drawOddBox = odd;
        tab.dropdownColours = colours;
        return tab;
    }

    public RSInterface addThemedBox(int width, int height, boolean odd, int[] colours, String message) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id;
        tab.type = 5145;
        tab.width = width;
        tab.height = height;
        tab.drawOddBox = odd;
        tab.dropdownColours = colours;
        tab.message = message.contains("#") ? String.valueOf(message) + ":" + this.id : message;
        ++this.id;
        return tab;
    }

    public RSInterface addTalentUI(int width, int height) {
        RSInterface rsi = RSInterface.addTabInterface(this.id);
        rsi.id = this.id++;
        rsi.type = 481;
        rsi.width = width;
        rsi.height = height;
        rsi.scrollMax = height;
        rsi.talentWidget = new TalentWidget();
        return rsi;
    }

    public RSInterface addCartItem(int itemId, int itemQuantity, double price, int width, int height) {
        return RSInterface.addCartItem(this.id++, itemId, itemQuantity, price, width, height);
    }

    public RSInterface addCartItemUI(int itemId, int itemQuantity, double price, int width, int height) {
        return RSInterface.addCartItemUI(this.id++, itemId, itemQuantity, price, width, height);
    }

    public RSInterface addBox(int width, int height, int border, int borderColor, int color, int transparency, int fillColor, int fillTransparency) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 34;
        tab.width = width;
        tab.height = height;
        tab.borderWidth = border;
        tab.borderColor = borderColor;
        tab.disabledColor = color;
        tab.transparency = transparency;
        tab.fillColor = fillColor;
        tab.customOpacity = fillTransparency;
        tab.filled = true;
        return tab;
    }

    public RSInterface addBoxWithItemOnHover(int width, int height, int border, int borderColor, int color, int transparency, int fillColor, int fillTransparency) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 34;
        tab.width = width;
        tab.height = height;
        tab.borderWidth = border;
        tab.borderColor = borderColor;
        tab.disabledColor = color;
        tab.transparency = transparency;
        tab.fillColor = fillColor;
        tab.customOpacity = fillTransparency;
        tab.filled = true;
        tab.inv = new int[1];
        tab.invStackSizes = new int[1];
        return tab;
    }

    public RSInterface addClickableBox(int width, int height, int border, int borderColor, int color, int transparency, int fillColor, int fillTransparency, String ... actions) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 34;
        tab.width = width;
        tab.height = height;
        tab.borderWidth = border;
        tab.borderColor = borderColor;
        tab.disabledColor = color;
        tab.transparency = transparency;
        tab.atActionType = 5;
        tab.contentType = 0;
        tab.fillColor = fillColor;
        tab.customOpacity = fillTransparency;
        tab.filled = true;
        tab.atActionType = 1;
        tab.actions = actions;
        return tab;
    }

    public RSInterface createHover(int width, int height, String message) {
        RSInterface hover = RSInterface.addTabInterface(this.id);
        hover.id = this.id;
        RSInterface.parentID = this.id++;
        hover.type = 5151;
        hover.message = message;
        hover.width = width;
        hover.height = height;
        hover.inventoryHover = true;
        return hover;
    }

    public RSInterface createHover(int width, String message) {
        return this.createHover(width, 28, message);
    }

    public RSInterface addRoundedRectangle(int width, int height, int radius, int color, int transparency, String ... actions) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 515;
        tab.radius = radius;
        tab.width = width;
        tab.height = height;
        tab.disabledColor = color;
        tab.transparency = transparency;
        tab.atActionType = 5;
        tab.contentType = 0;
        tab.fillColor = color;
        tab.filled = true;
        tab.atActionType = 1;
        tab.actions = actions;
        return tab;
    }

    public RSInterface addClickableBoxWithTitle(String title, int width, int height, int border, int borderColor, int color, int transparency, int fillColor, int fillTransparency, String ... actions) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 35;
        tab.width = width;
        tab.height = height;
        tab.borderWidth = border;
        tab.borderColor = borderColor;
        tab.disabledColor = color;
        tab.transparency = transparency;
        tab.atActionType = 5;
        tab.contentType = 0;
        tab.fillColor = fillColor;
        tab.customOpacity = fillTransparency;
        tab.filled = true;
        tab.atActionType = 1;
        tab.actions = actions;
        tab.message = title;
        tab.enabledColor = 0xFFB000;
        tab.textDrawingAreas = RSInterface.fonts[0];
        tab.centerText = true;
        return tab;
    }

    public RSInterface addClickableThemedBox(int width, int height, boolean odd, String message, String ... actions) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id;
        tab.type = 5145;
        tab.width = width;
        tab.height = height;
        tab.drawOddBox = odd;
        tab.message = message.contains("#") ? String.valueOf(message) + ":" + this.id : message;
        tab.atActionType = 1;
        tab.actions = actions;
        ++this.id;
        return tab;
    }

    public RSInterface addInputField(int width, int height) {
        RSInterface tab = RSInterface.inpuField(this.id, width, height);
        ++this.id;
        return tab;
    }

    public RSInterface addInputField(int width, int height, RuleSet ruleSet) {
        RSInterface tab = RSInterface.inpuField(this.id, width, height, ruleSet);
        ++this.id;
        return tab;
    }

    public RSInterface addInputField(int width, int height, int maxLength, RuleSet ruleSet) {
        RSInterface tab = RSInterface.inpuField(this.id, width, height, ruleSet, maxLength);
        ++this.id;
        return tab;
    }

    public RSInterface addCheckBox(String label, boolean rightAlignedText) {
        RSInterface tab = RSInterface.CheckBox(this.id, 23, 23, label, rightAlignedText);
        ++this.id;
        return tab;
    }

    public RSInterface addCheckBox(String label) {
        RSInterface tab = RSInterface.CheckBox(this.id, 23, 23, label, false);
        ++this.id;
        return tab;
    }

    public RSInterface addAccordionMenu(int width, Accordion.AccordionInfo ... accordionInfos) {
        RSInterface tabInterface = RSInterface.accordionMenu(this.id, width, accordionInfos);
        ++this.id;
        return tabInterface;
    }

    public RSInterface addListBoxMenu(int width, ListBox.ListBoxInfo ... listBoxInfos) {
        RSInterface tabInterface = RSInterface.listBoxMenu(this.id, width, listBoxInfos);
        ++this.id;
        return tabInterface;
    }

    public RSInterface addDissolveWidget(int width, DissolveData data) {
        RSInterface tabInterface = RSInterface.dissolveWidget(this.id, width, data);
        ++this.id;
        return tabInterface;
    }

    public RSInterface addAchievementContainer(int width, AchievementContainer.AchievementEntry ... achievementEntries) {
        RSInterface tabInterface = RSInterface.achievementContainer(this.id, width, achievementEntries);
        ++this.id;
        return tabInterface;
    }

    public RSInterface addTabbedWidget(int width, int height, TabbedWidget widget) {
        widget.setTabWidth(width);
        RSInterface tabInterface = RSInterface.tabbedWidget(this.id, width, height, widget);
        ++this.id;
        return tabInterface;
    }

    public RSInterface addBoxWithTitle(String title, int width, int height, int border, int borderColor, int color, int transparency, int fillColor, int fillTransparency, String ... actions) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 35;
        tab.width = width;
        tab.height = height;
        tab.borderWidth = border;
        tab.borderColor = borderColor;
        tab.disabledColor = color;
        tab.transparency = transparency;
        tab.fillColor = fillColor;
        tab.customOpacity = fillTransparency;
        tab.filled = true;
        tab.message = title;
        tab.enabledColor = 0xFFB000;
        tab.textDrawingAreas = RSInterface.fonts[0];
        tab.centerText = true;
        return tab;
    }

    public RSInterface addRectangleClickable(int opacity, int color, boolean filled, int width, int height, String ... actions) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id;
        tab.layerId = this.mainId;
        RSInterface.parentID = this.id;
        tab.id = this.id++;
        tab.disabledColor = color;
        tab.filled = filled;
        tab.type = 3;
        tab.atActionType = 5;
        tab.contentType = 0;
        tab.opacity = (byte)opacity;
        tab.width = width;
        tab.height = height;
        tab.atActionType = 1;
        tab.actions = actions;
        return tab;
    }

    public RSInterface addRectangle(int width, int height, int colour, int alpha, boolean filled) {
        RSInterface rsi = RSInterface.addRectangleWidget(this.id, width, height, colour, alpha, filled);
        rsi.id = this.id++;
        return rsi;
    }

    public RSInterface fillRectangle(int width, int height, int colour, int alpha) {
        RSInterface rsi = RSInterface.fillRectangle(this.id, width, height, colour, alpha);
        rsi.id = this.id++;
        return rsi;
    }

    public RSInterface addVerticalLine(int h, int color, int transparency) {
        RSInterface r = RSInterface.addInterface(this.id);
        r.id = this.id;
        r.id = this.id;
        RSInterface.parentID = this.id++;
        r.type = 27;
        r.width = 1;
        r.height = h;
        r.disabledColor = color;
        r.transparency = transparency;
        return r;
    }

    public RSInterface addHorizontalLine(int w, int color, int transparency) {
        RSInterface r = RSInterface.addInterface(this.id);
        r.id = this.id;
        r.id = this.id;
        RSInterface.parentID = this.id++;
        r.type = 28;
        r.width = w;
        r.height = 1;
        r.disabledColor = color;
        r.transparency = transparency;
        return r;
    }

    public RSInterface addBackground(int background) {
        return this.addBackground(background, this.getName());
    }

    public RSInterface addBackground(int background, String title) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id++;
        Sprite sprite = Client.cacheSprite[background];
        int x = (512 - sprite.myWidth) / 2;
        int y = (334 - sprite.myHeight) / 2;
        int frame = 0;
        tab.totalChildren(3);
        RSInterface.addSprite(this.id, background);
        tab.child(frame++, this.id, x, y);
        ++this.id;
        int closeX = sprite.myWidth - 73;
        if (closeX < 260) {
            closeX = 330;
        }
        RSInterface.addTextClose(40000, RSInterface.fonts);
        tab.child(frame++, 40000, closeX, y + 12);
        ++this.id;
        RSInterface.addText(this.id, "@or1@" + title, RSInterface.fonts, 2, 0xFFFFFF, true, true);
        tab.child(frame++, this.id, 256, y + 11);
        ++this.id;
        return tab;
    }

    public RSInterface addClosableWindow(int width, int height, boolean modernBorder, String title) {
        return this.addClosableWindow(width, height, modernBorder, true, true, title);
    }

    public RSInterface addClosableWindow(int width, int height, boolean modernBorder, boolean separator, boolean bigCloseButton, String title) {
        RSInterface tab = RSInterface.addInterface(this.id, width, height);
        tab.id = this.id++;
        tab.totalChildren(separator ? 4 : 3);
        int child = 0;
        RSInterface window = this.addWindow(width, height, modernBorder);
        RSInterface titles = this.addCenteredText(title, 2, 16750623);
        RSInterface close = this.hoverButton(bigCloseButton ? 740 : 1018, bigCloseButton ? 741 : 1019, "Close Window").setActionType(3);
        this.id += 3;
        tab.child(child++, window.id, 0, 0);
        tab.child(child++, titles.id, width / 2, 10);
        tab.child(child++, close.id, width - (modernBorder ? 30 : 28), modernBorder ? 7 : 7);
        if (separator) {
            tab.child(child++, this.addHorizontalSeparator((int)(width - 10), (boolean)modernBorder).id, 5, 29);
        }
        return tab;
    }

    public RSInterface addThemedClosableWindow(int width, int height, boolean modernBorder, boolean separator, boolean bigCloseButton, String title) {
        RSInterface tab = RSInterface.addInterface(this.id, width, height);
        tab.id = this.id++;
        tab.totalChildren(separator ? 4 : 3);
        int child = 0;
        RSInterface window = this.addThemedWindow(width, height, modernBorder);
        RSInterface titles = this.addCenteredText(title, 2, 16750623);
        RSInterface close = this.hoverButton(bigCloseButton ? 740 : 1018, bigCloseButton ? 741 : 1019, "Close Window").setActionType(3);
        this.id += 3;
        tab.child(child++, window.id, 0, 0);
        tab.child(child++, titles.id, width / 2, 10);
        tab.child(child++, close.id, width - (modernBorder ? 30 : 28), modernBorder ? 7 : 7);
        if (separator) {
            tab.child(child++, this.addHorizontalSeparator((int)(width - 10), (boolean)modernBorder).id, 5, 29);
        }
        return tab;
    }

    public RSInterface addWindow(int width, int height, boolean modernBorder, String title) {
        return this.addWindow(width, height, modernBorder, true, title);
    }

    public RSInterface addWindow(int width, int height, boolean modernBorder, boolean separator, String title) {
        RSInterface tab = RSInterface.addInterface(this.id, width, height);
        tab.id = this.id++;
        tab.totalChildren(separator ? 3 : 2);
        int child = 0;
        RSInterface window = this.addWindow(width, height, modernBorder);
        RSInterface titles = this.addCenteredText(title, 2, 16750623);
        this.id += 2;
        tab.child(child++, window.id, 0, 0);
        tab.child(child++, titles.id, width / 2, 10);
        if (separator) {
            tab.child(child++, this.addHorizontalSeparator((int)(width - 10), (boolean)modernBorder).id, 5, 29);
        }
        return tab;
    }

    public RSInterface addWindow(int width, int height, boolean modernBorder) {
        RSInterface window = RSInterface.addWindow(this.id, width, height, modernBorder);
        window.id = this.id++;
        return this.addWrapper(width, height, window);
    }

    public RSInterface addThemedWindow(int width, int height, boolean modernBorder) {
        RSInterface window = RSInterface.addThemedWindow(this.id, width, height, modernBorder, false, false);
        window.id = this.id++;
        return this.addWrapper(width, height, window);
    }

    public RSInterface addHorizontalSeparator(int width, boolean modernBorder) {
        RSInterface rsi = RSInterface.addInterface(this.id);
        rsi.id = this.id++;
        rsi.type = 25;
        rsi.width = width;
        rsi.height = 6;
        rsi.modernWindow = modernBorder;
        return this.addWrapper(width, 6, rsi);
    }

    public RSInterface addVerticalSeparator(int height, boolean modernBorder) {
        RSInterface rsi = RSInterface.addInterface(this.id);
        rsi.id = this.id++;
        rsi.type = 26;
        rsi.width = 10;
        rsi.height = height;
        rsi.modernWindow = modernBorder;
        return this.addWrapper(10, height, rsi);
    }

    public RSInterface addThemedHorizontalSeparator(int width) {
        RSInterface rsi = RSInterface.addInterface(this.id);
        rsi.id = this.id++;
        rsi.type = 25;
        rsi.width = width;
        rsi.height = 4;
        rsi.customTheme = true;
        return this.addWrapper(width, 6, rsi);
    }

    public RSInterface addThemedVerticalSeparator(int height) {
        RSInterface rsi = RSInterface.addInterface(this.id);
        rsi.id = this.id++;
        rsi.type = 26;
        rsi.width = 4;
        rsi.height = height;
        rsi.customTheme = true;
        return this.addWrapper(10, height, rsi);
    }

    public RSInterface addWrapper(int width, int height, RSInterface rsi) {
        RSInterface wrapper = RSInterface.addInterface(this.id, width, height);
        wrapper.id = this.id++;
        wrapper.totalChildren(1);
        wrapper.child(0, rsi.id, 0, 0);
        return wrapper;
    }

    public RSInterface addScrollableWrapper(int width, int height) {
        RSInterface wrapper = RSInterface.addInterface(this.id, width, height);
        wrapper.scrollMax = height + 2;
        wrapper.id = this.id++;
        return wrapper;
    }

    public RSInterface addSpriteRepeatX(int spriteId, int width) {
        return RSInterface.addSpriteRepeatX(this.id++, spriteId, width);
    }

    public RSInterface addSpriteRepeatY(int spriteId, int height) {
        return RSInterface.addSpriteRepeatY(this.id++, spriteId, height);
    }

    public RSInterface addSpriteRepeatBoth(int spriteId, int width, int height) {
        return RSInterface.addSpriteRepeatBoth(this.id++, spriteId, width, height);
    }

    public RSInterface drawBox(int width, int height, int border, int color, int transparency) {
        return RSInterface.drawBox(this.id++, width, height, border, 0, color, transparency);
    }

    public RSInterface drawBox(int width, int height, int border, int borderColor, int color, int transparency) {
        return RSInterface.drawBox(this.id++, width, height, border, borderColor, color, transparency);
    }

    public RSInterface hoverButton(int disabledSprite, int enabledSprite, String tooltip) {
        return RSInterface.hoverButton(this.id++, disabledSprite, enabledSprite, tooltip).setLayer(this.mainId);
    }

    public RSInterface hoverButtonResize(int disabledSprite, int enabledSprite, String tooltip, int width, int height) {
        return RSInterface.hoverButtonResize(this.id++, disabledSprite, enabledSprite, tooltip, width, height).setLayer(this.mainId);
    }

    public RSInterface hoverButton(int disabledSprite, int enabledSprite, String[] actions) {
        return RSInterface.hoverButton(this.id++, disabledSprite, enabledSprite, actions).setLayer(this.mainId);
    }

    public RSInterface addConfigButton(String tooltip, int sprite1, int sprite2, int aT, int configSlot, int configId) {
        RSInterface tab = RSInterface.addInterface(this.id);
        RSInterface.parentID = this.id;
        tab.id = this.id;
        tab.type = 5;
        tab.atActionType = aT;
        tab.id = this.id++;
        tab.layerId = this.mainId;
        tab.contentType = 0;
        Sprite sprite = Client.cacheSprite[sprite1];
        tab.width = sprite.myWidth;
        tab.height = sprite.myHeight;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.valueCompareType = new int[1];
        tab.requiredValues = new int[1];
        tab.valueCompareType[0] = 1;
        tab.requiredValues[0] = configSlot;
        tab.valueIndexArray = new int[1][3];
        tab.valueIndexArray[0][0] = 5;
        tab.valueIndexArray[0][1] = configId;
        tab.valueIndexArray[0][2] = 0;
        tab.disabledSprite = sprite;
        tab.enabledSprite = Client.cacheSprite[sprite2];
        tab.tooltip = tooltip;
        return tab;
    }

    public RSInterface addConfigButtonWithText(String text, String tooltip, int sprite1, int sprite2, int aT, int configSlot, int configId) {
        RSInterface tab = RSInterface.addInterface(this.id);
        RSInterface.parentID = this.id;
        tab.id = this.id;
        tab.type = 5;
        tab.atActionType = aT;
        tab.id = this.id++;
        tab.layerId = this.mainId;
        tab.contentType = 0;
        Sprite sprite = Client.cacheSprite[sprite1];
        tab.width = sprite.myWidth;
        tab.height = sprite.myHeight;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.valueCompareType = new int[1];
        tab.requiredValues = new int[1];
        tab.valueCompareType[0] = 1;
        tab.requiredValues[0] = configSlot;
        tab.valueIndexArray = new int[1][3];
        tab.valueIndexArray[0][0] = 5;
        tab.valueIndexArray[0][1] = configId;
        tab.valueIndexArray[0][2] = 0;
        tab.disabledSprite = sprite;
        tab.enabledSprite = Client.cacheSprite[sprite2];
        tab.tooltip = tooltip;
        tab.textDrawingAreas = RSInterface.fonts[0];
        tab.message = text;
        return tab;
    }

    public RSInterface addItemContainer(int w, int h, int x, int y, String[] actions, String string) {
        System.out.println(String.valueOf(string) + " - id: " + this.id);
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        tab.width = w;
        tab.height = h;
        tab.inv = new int[w * h];
        tab.invStackSizes = new int[w * h];
        tab.usableItemInterface = false;
        tab.invSpritePadX = x;
        tab.invSpritePadY = y;
        tab.spritesX = new int[20];
        tab.spritesY = new int[20];
        tab.sprites = new Sprite[20];
        if (actions != null) {
            tab.actions = new String[5];
            tab.actions = actions;
        }
        tab.type = 2;
        ++this.id;
        return tab;
    }

    public RSInterface addItemContainerShopIcons(int w, int h, int x, int y, String[] actions, String string) {
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        tab.width = w;
        tab.height = h;
        tab.inv = new int[w * h];
        tab.invStackSizes = new int[w * h];
        tab.usableItemInterface = false;
        tab.invSpritePadX = x;
        tab.invSpritePadY = y;
        tab.spritesX = new int[20];
        tab.spritesY = new int[20];
        tab.sprites = new Sprite[20];
        if (actions != null) {
            tab.actions = new String[5];
            tab.actions = actions;
        }
        tab.shopIcons = true;
        tab.type = 2;
        ++this.id;
        return tab;
    }

    public RSInterface addDynamicButton(String name, int textSize, int textColor, int width, int height) {
        return this.addDynamicButton(name, textSize, textColor, 0, 0, width, height);
    }

    public RSInterface addDynamicButton(String name, int textSize, int textColor, int textXOff, int textYOff, int width, int height) {
        RSInterface rsi = RSInterface.addInterface(this.id, width, height);
        rsi.id = this.id++;
        rsi.totalChildren(2);
        RSInterface button = RSInterface.addInterface(this.id, width, height);
        button.id = this.id++;
        button.layerId = this.mainId;
        button.type = 41;
        button.atActionType = 1;
        button.contentType = 0;
        button.tooltip = name;
        button.hovers = true;
        int textHeight = 13 + textSize;
        int textDecrease = textSize > 1 ? -1 : 1;
        RSInterface text = this.addText(name, textSize, textColor, true, false, false, true);
        rsi.child(0, button.id, 0, 0);
        rsi.child(1, text.id, width / 2 + textXOff, height / 2 - textHeight / 2 + (textSize == 0 ? textDecrease : -textDecrease) + textYOff);
        Widget.componentForMain.put(button.id, this.mainId);
        Widget.componentForMain.put(text.id, this.mainId);
        return rsi;
    }

    public RSInterface addDynamicButtonWithIcon(String name, int textSize, int textColor, int width, int height, String spriteId) {
        return this.addDynamicButtonWithIcon(name, textSize, textColor, 0, 0, width, height, spriteId);
    }

    public RSInterface addDynamicButtonWithIcon(String name, int textSize, int textColor, int textXOff, int textYOff, int width, int height, String spriteId) {
        RSInterface rsi = RSInterface.addInterface(this.id, width, height);
        rsi.id = this.id++;
        rsi.totalChildren(2);
        RSInterface button = RSInterface.addInterface(this.id, width, height);
        button.id = this.id++;
        button.layerId = this.mainId;
        button.type = 41;
        button.atActionType = 1;
        button.contentType = 0;
        button.tooltip = name;
        button.hovers = true;
        button.spriteIconID = spriteId;
        int textHeight = 13 + textSize;
        int textDecrease = textSize > 1 ? -1 : 1;
        RSInterface text = this.addText(name, textSize, textColor, true, false, false, true);
        rsi.child(0, button.id, 0, 0);
        rsi.child(1, text.id, width / 2 + textXOff, height / 2 - textHeight / 2 + (textSize == 0 ? textDecrease : -textDecrease) + textYOff);
        Widget.componentForMain.put(button.id, this.mainId);
        Widget.componentForMain.put(text.id, this.mainId);
        return rsi;
    }

    public RSInterface addDynamicButtonWithActions(String name, int textSize, int textColor, int width, int height, String ... actions) {
        return this.addDynamicButtonWithActions(name, textSize, textColor, 0, 0, width, height, actions);
    }

    public RSInterface addDynamicButtonWithActions(String name, int textSize, int textColor, int textXOff, int textYOff, int width, int height, String[] actions) {
        RSInterface rsi = RSInterface.addInterface(this.id, width, height);
        rsi.id = this.id++;
        rsi.totalChildren(2);
        RSInterface button = RSInterface.addInterface(this.id, width, height);
        button.id = this.id++;
        button.layerId = this.mainId;
        button.type = 41;
        button.atActionType = 1;
        button.contentType = 0;
        button.tooltip = name;
        button.hovers = true;
        button.actions = actions;
        int textHeight = 13 + textSize;
        int textDecrease = textSize > 1 ? -1 : 1;
        RSInterface text = this.addText(name, textSize, textColor, true, false, false, true);
        rsi.child(0, button.id, 0, 0);
        rsi.child(1, text.id, width / 2 + textXOff, height / 2 - textHeight / 2 + (textSize == 0 ? textDecrease : -textDecrease) + textYOff);
        Widget.componentForMain.put(button.id, this.mainId);
        Widget.componentForMain.put(text.id, this.mainId);
        return rsi;
    }

    public RSInterface addThemedDynamicButton(String name, int textSize, int textColor, int width, int height, String ... actions) {
        RSInterface rsi = RSInterface.addInterface(this.id, width, height);
        rsi.type = 498;
        rsi.textDrawingAreas = RSInterface.fonts[textSize];
        rsi.disabledColor = textColor;
        rsi.message = name;
        rsi.atActionType = 1;
        rsi.contentType = 0;
        rsi.tooltip = name;
        rsi.hovers = true;
        rsi.actions = actions;
        ++this.id;
        return rsi;
    }

    public RSInterface addDiagonalThemedDynamicButton(String name, int textSize, int textColor, int width, int height, String ... actions) {
        RSInterface rsi = RSInterface.addInterface(this.id, width, height);
        rsi.type = 498;
        rsi.textDrawingAreas = RSInterface.fonts[textSize];
        rsi.disabledColor = textColor;
        rsi.message = name;
        rsi.atActionType = 1;
        rsi.contentType = 0;
        rsi.tooltip = name;
        rsi.hovers = true;
        rsi.actions = actions;
        rsi.diagonalBtn = true;
        ++this.id;
        return rsi;
    }

    public RSInterface addProgressBar(int width, int height) {
        return this.addProgressBar(width, height, 0, 100);
    }

    public RSInterface addProgressBar(int width, int height, int current, int max) {
        RSInterface rsi = RSInterface.addProgressBar(this.id, width, height, current, max);
        rsi.id = this.id++;
        return rsi;
    }

    public RSInterface addCustomizeableProgressBar(int width, int height, boolean drawHorizontal, boolean shadow) {
        return new ProgressBar(this.id++, 120, 15, new int[]{39450}, drawHorizontal, shadow, "", new int[]{0x9A0000});
    }

    public RSInterface addCustomizeableProgressBar(int width, int height, boolean drawHorizontal, boolean shadow, int[] colorType, int[] defaultColorType) {
        return new ProgressBar(this.id++, width, height, colorType, drawHorizontal, shadow, "", defaultColorType);
    }

    public RSInterface addSprite(int spriteId) {
        Sprite sprite;
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 5;
        tab.atActionType = 0;
        tab.contentType = 0;
        tab.hoverType = 52;
        tab.enabledSprite = sprite = Client.cacheSprite[spriteId];
        tab.disabledSprite = sprite;
        tab.width = 512;
        tab.height = 334;
        return tab;
    }

    public RSInterface addSprite(String loc, int spriteId) {
        Sprite sprite;
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 5;
        tab.atActionType = 0;
        tab.contentType = 0;
        tab.hoverType = 52;
        tab.enabledSprite = sprite = RSInterface.imageLoader(spriteId, loc);
        tab.disabledSprite = sprite;
        tab.width = 512;
        tab.height = 334;
        tab.advancedSprite = true;
        return tab;
    }

    public RSInterface addSprite(String loc, String message, int spriteId, String ... action) {
        Sprite sprite;
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id;
        tab.type = 5;
        tab.atActionType = 1;
        tab.contentType = 0;
        tab.hoverType = 52;
        tab.enabledSprite = sprite = RSInterface.imageLoader(spriteId, loc);
        tab.disabledSprite = sprite;
        tab.width = sprite.myWidth;
        tab.height = sprite.myHeight;
        tab.advancedSprite = true;
        tab.message = message;
        tab.actions = new String[5];
        int i = 0;
        while (i < tab.actions.length) {
            tab.actions[i] = null;
            ++i;
        }
        if (action != null) {
            i = 0;
            while (i < action.length) {
                tab.actions[i] = action[i];
                ++i;
            }
        }
        ++this.id;
        return tab;
    }

    public RSInterface addSprite(String loc, int spriteId, String ... action) {
        Sprite sprite;
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id;
        tab.type = 5;
        tab.atActionType = 1;
        tab.contentType = 0;
        tab.hoverType = 52;
        tab.enabledSprite = sprite = RSInterface.imageLoader(spriteId, loc);
        tab.disabledSprite = sprite;
        tab.width = sprite.myWidth;
        tab.height = sprite.myHeight;
        tab.advancedSprite = true;
        tab.actions = new String[5];
        int i = 0;
        while (i < tab.actions.length) {
            tab.actions[i] = null;
            ++i;
        }
        if (action != null) {
            i = 0;
            while (i < action.length) {
                tab.actions[i] = action[i];
                ++i;
            }
        }
        ++this.id;
        return tab;
    }

    public RSInterface addSpriteResizeable(String loc, int spriteId, int width, int height) {
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 5;
        tab.atActionType = 0;
        tab.contentType = 0;
        tab.hoverType = 52;
        Sprite sprite = RSInterface.imageLoader(spriteId, loc);
        tab.enabledSprite = sprite = Sprite.resizeSprite(sprite, width, height);
        tab.disabledSprite = sprite;
        tab.width = 512;
        tab.height = 334;
        tab.advancedSprite = true;
        return tab;
    }

    public RSInterface addPrayerSprite(int spriteId) {
        Sprite sprite;
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 5;
        tab.atActionType = 0;
        tab.contentType = 0;
        tab.hoverType = 52;
        tab.enabledSprite = sprite = RSInterface.imageLoader(spriteId, "Interfaces/Prayers/Icon");
        tab.disabledSprite = sprite;
        tab.width = 512;
        tab.height = 334;
        return tab;
    }

    public RSInterface addClickableSprite(int spriteId, int width, int height, String ... actions) {
        Sprite sprite;
        RSInterface tab = RSInterface.addInterface(this.id);
        tab.id = this.id;
        RSInterface.parentID = this.id++;
        tab.type = 5;
        tab.contentType = 0;
        tab.hoverType = 52;
        tab.atActionType = 1;
        tab.actions = actions;
        tab.enabledSprite = sprite = RSInterface.imageLoader(spriteId, "Interfaces/Prayers/Icon");
        tab.disabledSprite = sprite;
        tab.width = width;
        tab.height = height;
        return tab;
    }

    public RSInterface addHoverButton(int sprite, String tooltip) {
        RSInterface.addHoverButton(this.id, sprite, Client.cacheSprite[sprite].myWidth, Client.cacheSprite[sprite].myHeight, tooltip, -1, this.id + 1, 1);
        return RSInterface.interfaceCache[this.id++].setLayer(this.mainId);
    }

    public RSInterface addChar() {
        RSInterface rsi = RSInterface.addCharWidget(this.id);
        rsi.id = this.id++;
        return rsi;
    }

    public RSInterface addField(int width, int height, String text, String tooltip) {
        RSInterface rsi = RSInterface.addInterface(this.id);
        rsi.id = this.id++;
        rsi.layerId = this.mainId;
        rsi.type = 42;
        rsi.width = width;
        rsi.height = height;
        rsi.message = text;
        rsi.atActionType = 5;
        rsi.contentType = 0;
        rsi.atActionType = 1;
        rsi.tooltip = tooltip;
        return rsi;
    }

    public RSInterface dropdownMenu(int width, int defaultOption, String[] options, Dropdown d) {
        return RSInterface.dropdownMenu(this.id++, width, defaultOption, options, d);
    }

    public RSInterface dropdownMenu(int width, int defaultOption, String[] options, Dropdown d, int[] dropdownColours, boolean centerText) {
        return RSInterface.dropdownMenu(this.id++, width, defaultOption, options, d, dropdownColours, centerText);
    }

    public RSInterface addNPC(int npcId) {
        return RSInterface.addNpcWidget(this.id++, npcId);
    }

    public RSInterface addNPCHead() {
        return RSInterface.addNPCHead(this.id++, 75, 50, 875);
    }

    public RSInterface addNPCWithTabbedWidget(int npcId, TabbedWidget tabbedWidget) {
        return RSInterface.addNpcWidget(this.id++, npcId, tabbedWidget);
    }

    public RSInterface addNPCResizeable(int npcId, int width, int height) {
        return RSInterface.addNpcWidgetResizeable(this.id++, npcId, width, height);
    }

    public RSInterface addScrollbarWithText(String text, String tooltip, int size, int colour, int scrollHeight, int scrollWidth, int lineAmount) {
        RSInterface scroll = RSInterface.addInterface(this.id);
        scroll.id = this.id++;
        scroll.totalChildren(lineAmount);
        scroll.height = scrollHeight;
        scroll.width = scrollWidth;
        scroll.scrollMax = scrollHeight + lineAmount * (11 + size);
        int scroll_frame = 0;
        int y = 5;
        int i = 0;
        while (i < lineAmount) {
            RSInterface.addHoverText(this.id, String.valueOf(text) + (text.contains("#") ? "" + this.id : ""), tooltip, RSInterface.fonts, size, colour, false, true, 150);
            RSInterface.setBounds(this.id, 5, y, scroll_frame, scroll);
            ++scroll_frame;
            ++this.id;
            y += 12 + size;
            ++i;
        }
        return scroll;
    }

    public RSInterface addScrollbarWithTextAndTooltips(String text, String tooltip, int size, int colour, int scrollHeight, int scrollWidth, int lineAmount, String customToolTip) {
        RSInterface scroll = RSInterface.addInterface(this.id);
        scroll.id = this.id++;
        scroll.totalChildren(lineAmount);
        scroll.height = scrollHeight;
        scroll.width = scrollWidth;
        scroll.scrollMax = scrollHeight + lineAmount * (11 + size);
        int scroll_frame = 0;
        int y = 5;
        int i = 0;
        while (i < lineAmount) {
            RSInterface.addHoverText(this.id, String.valueOf(text) + (text.contains("#") ? "" + this.id : ""), tooltip, RSInterface.fonts, size, colour, false, true, 150);
            RSInterface.interfaceCache[this.id].setDisplayToolTip(true).setCustomToolTip(String.valueOf(customToolTip) + (customToolTip.contains("#") ? "" + this.id : ""));
            RSInterface.setBounds(this.id, 5, y, scroll_frame, scroll);
            ++scroll_frame;
            ++this.id;
            y += 12 + size;
            ++i;
        }
        return scroll;
    }

    public RSInterface addScrollbarWithItem(int w, int h, int x, int y, String[] action, int scrollHeight, int scrollWidth, boolean autofill) {
        int i;
        System.out.println(String.valueOf(this.getName()) + " scroll item container: " + this.id);
        RSInterface scroll = RSInterface.addInterface(this.id);
        scroll.id = this.id++;
        scroll.totalChildren(1);
        scroll.height = scrollHeight;
        scroll.width = scrollWidth;
        scroll.scrollMax = 38 * h;
        int scroll_frame = 0;
        RSInterface item = RSInterface.addToItemGroupWidget(this.id, w, h, x, y, action != null, "", "", "");
        if (autofill) {
            i = 0;
            while (i < item.inv.length) {
                item.inv[i] = 996;
                item.invStackSizes[i] = Integer.MAX_VALUE;
                ++i;
            }
        }
        item.actions = new String[5];
        i = 0;
        while (i < item.actions.length) {
            item.actions[i] = null;
            ++i;
        }
        if (action != null) {
            i = 0;
            while (i < action.length) {
                item.actions[i] = action[i];
                ++i;
            }
        }
        RSInterface.setBounds(this.id, 5, 2 + y, scroll_frame, scroll);
        ++scroll_frame;
        ++this.id;
        return scroll;
    }

    public RSInterface addScrollbarWithItem(int w, int h, int x, int y, String[] action, int scrollHeight, int scrollWidth) {
        return this.addScrollbarWithItem(w, h, x, y, action, scrollHeight, scrollWidth, false);
    }

    public RSInterface addScrollbarWithClickableBoxes(String text, int scrollHeight, int scrollWidth, int lineAmount, String ... actions) {
        RSInterface scroll = RSInterface.addInterface(this.id);
        scroll.id = this.id++;
        scroll.totalChildren(lineAmount);
        scroll.height = scrollHeight;
        scroll.width = scrollWidth;
        scroll.scrollMax = scrollHeight + lineAmount * 20;
        int scroll_frame = 0;
        int y = 5;
        int i = 0;
        while (i < lineAmount) {
            this.addClickableBoxWithTitle(text, scrollWidth - 10, 25, 1, 65535, 4009505, 105, 9010030, 105, actions).setBoxHoverAble(true);
            scroll.child(scroll_frame++, this.id - 1, 5, y + i * 27);
            ++i;
        }
        ++this.id;
        return scroll;
    }

    public RSInterface addScrollbarWithThemedClickableBoxes(String text, int scrollHeight, int scrollWidth, int lineAmount, String ... actions) {
        System.out.println(String.valueOf(this.getName()) + " scroll container " + this.id);
        RSInterface scroll = RSInterface.addInterface(this.id);
        scroll.id = this.id++;
        scroll.totalChildren(lineAmount);
        scroll.height = scrollHeight;
        scroll.width = scrollWidth;
        scroll.scrollMax = scrollHeight + lineAmount * 26;
        int scroll_frame = 0;
        int y = 5;
        int i = 0;
        while (i < lineAmount) {
            this.addClickableThemedBox(scrollWidth - 10, 25, i % 2 == 0, text, actions).setBoxHoverAble(true);
            scroll.child(scroll_frame++, this.id - 1, 5, y + i * 26);
            ++i;
        }
        ++this.id;
        return scroll;
    }

    public RSInterface addClickText(String text, int idx, int color, boolean center, boolean shadowed) {
        RSInterface tab = RSInterface.addInterface(this.id);
        RSInterface.parentID = this.id;
        tab.id = this.id;
        tab.id = this.id;
        tab.type = 4;
        tab.atActionType = 1;
        tab.width = RSInterface.fonts[idx].getTextWidth(text);
        tab.height = idx == 0 ? 12 : 15;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.shadowed = shadowed;
        tab.textDrawingAreas = RSInterface.fonts[idx];
        tab.message = String.valueOf(text) + " " + (text.contains("#") ? Integer.valueOf(this.id) : "");
        tab.tooltip = "Select @lre@" + text;
        tab.disabledColor = color;
        ++this.id;
        return tab;
    }

    public RSInterface addClickText(String text, int idx, int color) {
        return this.addClickText(text, idx, color, true, true);
    }

    public RSInterface addClickText(String text, int idx, int color, boolean center) {
        return this.addClickText(text, idx, color, center, true);
    }

    public RSInterface addText(String text, int size, int color) {
        return this.addText(text, size, color, false, false, false, true);
    }

    public RSInterface addText(String text, int size, int color, boolean center) {
        return this.addText(text, size, color, center, false, false, true);
    }

    public RSInterface addCenteredText(String text, int size, int color) {
        return this.addText(text, size, color, true, false, false, true);
    }

    public RSInterface addText(String text, int size) {
        return this.addText(text, size, 0xFFB000, false, false, false, true);
    }

    public RSInterface addCenteredText(String text, int size) {
        return this.addText(text, size, 0xFFB000, true, false, false, true);
    }

    public RSInterface addRightAlignedText(String text, int size) {
        return this.addText(text, size, 0xFFB000, true, true, false, true);
    }

    public RSInterface addRightAlignedText(String text, int size, int color) {
        return this.addText(text, size, color, true, true, false, true);
    }

    public RSInterface addTextRight(String text, int size, int color) {
        return RSInterface.addTextRight(this.id++, text, RSInterface.fonts, size, color, false);
    }

    public static RSInterface addWrappingText(int id, String text, TextDrawingArea[] tda, int idx, int color, boolean center, boolean shadow, int width, int lineHeight) {
        RSInterface tab = RSInterface.addTabInterface(id);
        RSInterface.parentID = id;
        tab.id = id;
        tab.type = 20;
        tab.atActionType = 0;
        tab.width = width;
        tab.height = lineHeight;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.shadowed = shadow;
        tab.textDrawingAreas = tda[idx];
        tab.message = CustomWidget.getWrappedText(tab.textDrawingAreas, text, tab.width);
        tab.enabledMessage = "";
        tab.disabledColor = color;
        tab.enabledColor = 0;
        tab.disabledMouseOverColor = 0;
        tab.enabledMouseOverColor = 0;
        tab.bingoReward = false;
        return tab;
    }

    public RSInterface addWrappingText(String text, TextDrawingArea[] tda, int idx, int color, boolean center, boolean shadow, int width, int lineHeight) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        RSInterface.parentID = this.id;
        tab.id = this.id;
        tab.type = 20;
        tab.atActionType = 0;
        tab.width = width;
        tab.height = lineHeight;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.shadowed = shadow;
        tab.textDrawingAreas = tda[idx];
        tab.message = String.valueOf(CustomWidget.getWrappedText(tab.textDrawingAreas, text, tab.width)) + (text.contains("#") ? ": " + this.id : "");
        tab.enabledMessage = "";
        tab.disabledColor = color;
        tab.enabledColor = 0;
        tab.disabledMouseOverColor = 0;
        tab.enabledMouseOverColor = 0;
        tab.bingoReward = false;
        ++this.id;
        return tab;
    }

    protected RSInterface addText(String text, int idx, int color, boolean center, boolean rightAligned, boolean rollingText, boolean shadow) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        RSInterface.parentID = this.id;
        tab.id = this.id;
        tab.id = this.id;
        tab.type = 4;
        tab.atActionType = 0;
        tab.width = 0;
        tab.height = idx == 0 ? 12 : 15;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.shadowed = shadow;
        tab.textDrawingAreas = RSInterface.fonts[idx];
        tab.message = text.contains("#") ? String.valueOf(text) + ":" + this.id : text;
        tab.disabledColor = color;
        ++this.id;
        return tab;
    }

    public RSInterface addWrappedText(String text, int size, int color, int width, int height) {
        return this.addWrappedText(text, size, color, false, false, false, true, width, height);
    }

    public RSInterface addCenteredWrappedText(String text, int size, int color, int width, int height) {
        return this.addWrappedText(text, size, color, true, false, false, false, width, height);
    }

    protected RSInterface addWrappedText(String text, int idx, int color, boolean center, boolean rightAligned, boolean rollingText, boolean shadow, int width, int lineHeight) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        RSInterface.parentID = this.id;
        tab.id = this.id;
        tab.type = 20;
        tab.atActionType = 0;
        tab.width = width;
        tab.height = lineHeight;
        tab.contentType = 0;
        tab.opacity = 0;
        tab.hoverType = -1;
        tab.centerText = center;
        tab.shadowed = shadow;
        tab.textDrawingAreas = RSInterface.fonts[idx];
        tab.message = String.valueOf(CustomWidget.getWrappedText(tab.textDrawingAreas, text, tab.width)) + (text.contains("#") ? ": " + this.id : "");
        tab.disabledColor = color;
        tab.rightText = rightAligned;
        ++this.id;
        return tab;
    }

    public RSInterface addTextList(String[] list, int textSize, int colour, boolean center, int offset, boolean verticle) {
        RSInterface tab = RSInterface.addTabInterface(this.id);
        tab.id = this.id++;
        tab.totalChildren(list.length);
        int frame = 0;
        int y = 0;
        int x = 0;
        int length = offset;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (offset == -1) {
                length = RSInterface.fonts[textSize].getTextWidth(s) + 4;
            }
            RSInterface button = this.addText(String.valueOf(s) + this.id, textSize, colour, center, false, false, true);
            tab.child(frame++, button.id, x, y);
            if (verticle) {
                y += length;
            } else {
                x += length;
            }
            ++n2;
        }
        ++this.id;
        return tab;
    }

    public RSInterface addGroup(WidgetGroup group) {
        RSInterface scroll = RSInterface.addInterface(this.id);
        scroll.id = this.id++;
        scroll.width = group.scrollWidth;
        scroll.height = group.scrollHeight;
        System.out.println(String.valueOf(this.getName()) + "Scroll Container Group: " + scroll.id);
        group.assignedId = scroll.id;
        int totalChildren = group.lines * group.multipleComponents.size() + group.singleComponents.size();
        scroll.totalChildren(totalChildren);
        int scrollMax = group.difference / 2 + group.difference * group.lines;
        if (scrollMax < group.scrollHeight) {
            scrollMax = group.scrollMax > 0 ? group.scrollMax : group.scrollHeight;
        }
        scroll.scrollMax = Math.max(group.scrollMax, group.scrollHeight);
        int index = 0;
        int y = 0;
        int i = 0;
        while (i < group.lines) {
            for (WidgetComponent w : group.multipleComponents) {
                RSInterface child = RSInterface.interfaceCache[w.componentId];
                if (child == null) continue;
                RSInterface.parentID = scroll.id;
                scroll.child(index++, w.componentId, w.point.x + group.offsetX, w.point.y + y + group.offsetY);
            }
            y += group.difference;
            ++i;
        }
        for (WidgetComponent w : group.singleComponents) {
            RSInterface child = RSInterface.interfaceCache[w.componentId];
            if (child == null) continue;
            RSInterface.parentID = scroll.id;
            scroll.child(index++, w.componentId, w.point.x + group.offsetX, w.point.y + group.offsetY);
        }
        return scroll;
    }

    public RSInterface getInterface() {
        return RSInterface.interfaceCache[this.mainId];
    }

    public static RSInterface getWidget(int widgetId) {
        return RSInterface.interfaceCache[widgetId];
    }

    public void clearText(int from, int to) {
        int i = from;
        while (i <= to) {
            RSInterface.interfaceCache[i].message = "";
            ++i;
        }
    }

    public static String getWrappedText(TextDrawingArea tda, String text, int width) {
        boolean last;
        if (text.contains("\\n") || tda.getTextWidth(text) <= width) {
            return text;
        }
        int spaceWidth = tda.getTextWidth(" ");
        StringBuilder result = new StringBuilder(text.length());
        StringBuilder line = new StringBuilder();
        int lineLength = 0;
        int curIndex = 0;
        do {
            String curWord;
            int spaceIndex = text.indexOf(32, curIndex);
            int newLength = lineLength;
            last = false;
            if (spaceIndex < 0) {
                last = true;
                curWord = text.substring(curIndex);
            } else {
                curWord = text.substring(curIndex, spaceIndex);
                newLength += spaceWidth;
            }
            curIndex = spaceIndex + 1;
            int w = tda.getTextWidth(curWord);
            if ((newLength += w) > width) {
                result.append((CharSequence)line);
                result.append("\\n");
                line = new StringBuilder(curWord);
                line.append(' ');
                lineLength = w;
                continue;
            }
            line.append(curWord);
            line.append(' ');
            lineLength = newLength;
        } while (!last);
        result.append((CharSequence)line);
        return result.toString();
    }

    public void setWidgetScrollable(boolean isWidgetScrollable) {
        this.isWidgetScrollable = isWidgetScrollable;
    }

    public boolean isWidgetScrollable() {
        return this.isWidgetScrollable;
    }

    public RSInterface addTreeWidget(TreeWidget treeWidget) {
        RSInterface header = RSInterface.addInterface(this.id);
        header.id = this.id;
        RSInterface.parentID = this.id++;
        header.type = 9200;
        header.treeWidget = treeWidget;
        return header;
    }

    public RSInterface addHeader(int width, int height, HeaderStyle style, int maxCurveDepth) {
        RSInterface header = RSInterface.addInterface(this.id);
        header.id = this.id;
        RSInterface.parentID = this.id++;
        header.type = 3835;
        header.width = width;
        header.height = height;
        header.headerStyle = style.ordinal();
        header.maxCurveDepth = maxCurveDepth;
        return header;
    }

    public RSInterface addHeader(String text, int textColor, int width, int height, HeaderStyle style, int maxCurveDepth) {
        RSInterface header = RSInterface.addInterface(this.id);
        header.id = this.id;
        RSInterface.parentID = this.id++;
        header.type = 3835;
        header.width = width;
        header.height = height;
        header.headerStyle = style.ordinal();
        header.maxCurveDepth = maxCurveDepth;
        header.message = text;
        header.enabledColor = textColor;
        return header;
    }

    public RSInterface addHeader(int width, int height, HeaderStyle style) {
        return this.addHeader(width, height, style, 5);
    }

    public RSInterface addHeader(String text, int textColor, int width, int height, HeaderStyle style) {
        return this.addHeader(text, textColor, width, height, style, 5);
    }

    public RSInterface textWrapperWithIcons(String message, int width, int height, int idx, int colour, boolean centerText) {
        RSInterface textWrapper = RSInterface.addInterface(this.id);
        textWrapper.id = this.id;
        textWrapper.type = 508;
        textWrapper.message = String.valueOf(message) + (message.contains("#") ? ": " + this.id : "");
        textWrapper.width = width;
        textWrapper.height = height;
        textWrapper.textDrawingAreas = RSInterface.fonts[idx];
        textWrapper.centerText = centerText;
        textWrapper.enabledColor = colour;
        textWrapper.disabledColor = colour;
        ++this.id;
        return textWrapper;
    }

    public RSInterface textWrapperWithIcons(String message, int width, int height, int idx, int colour, boolean centerText, int yAdjust) {
        RSInterface textWrapper = RSInterface.addInterface(this.id);
        textWrapper.id = this.id;
        textWrapper.type = 508;
        textWrapper.message = String.valueOf(message) + (message.contains("#") ? ": " + this.id : "");
        textWrapper.width = width;
        textWrapper.height = height;
        textWrapper.textDrawingAreas = RSInterface.fonts[idx];
        textWrapper.centerText = centerText;
        textWrapper.enabledColor = colour;
        textWrapper.disabledColor = colour;
        textWrapper.yIconAdjust = yAdjust;
        ++this.id;
        return textWrapper;
    }

    public RSInterface textWrapperWithIcons(String message, int width, int height, boolean centerText) {
        return this.textWrapperWithIcons(message, width, height, 0, 0xFFB000, centerText);
    }

    public RSInterface textWrapperWithIcons(String message, int width, int height, boolean centerText, int yAdjust) {
        return this.textWrapperWithIcons(message, width, height, 0, 0xFFB000, centerText, yAdjust);
    }

    public RSInterface textWrapperWithIcons(String message, int width, int height, int color, boolean centerText) {
        return this.textWrapperWithIcons(message, width, height, 0, color, centerText, 0);
    }

    public RSInterface textWrapperWithIcons(String message, int width, int height) {
        return this.textWrapperWithIcons(message, width, height, 0, 0xFFB000, false);
    }

    public RSInterface addScrollbarWithWrappedText(String text, String tooltip, int size, int colour, int scrollHeight, int scrollWidth, int lineAmount) {
        RSInterface scroll = RSInterface.addInterface(this.id);
        scroll.id = this.id++;
        scroll.totalChildren(lineAmount);
        scroll.height = scrollHeight;
        scroll.width = scrollWidth;
        scroll.scrollMax = scrollHeight + lineAmount * (11 + size);
        int scroll_frame = 0;
        int y = 5;
        int i = 0;
        while (i < lineAmount) {
            String lineText = text;
            RSInterface childInterface = this.textWrapperWithIcons(lineText, scrollWidth, 14);
            RSInterface.setBounds(childInterface.id, 5, y, scroll_frame, scroll);
            ++scroll_frame;
            y += 12 + size;
            ++i;
        }
        return scroll;
    }

    public RSInterface prayersList() {
        RSInterface tab = RSInterface.addInterface(this.id);
        System.out.println("prayer widget scroll " + this.id);
        tab.id = this.id++;
        tab.width = 174;
        tab.height = 177;
        tab.scrollMax = 385;
        int child = 0;
        tab.totalChildren(93);
        int prayersLength = 11;
        int xTile = 3;
        int yTile = 10;
        int i = 0;
        while (i < 31) {
            if (i < prayersLength) {
                (new String[1])[0] = "Toggle";
                this.addClickableSprite((int)99, (int)32, (int)32, (String[])new String[1]).isCustomPrayer = true;
                tab.child(child++, this.id - 1, xTile, yTile);
                this.addPrayerSprite((int)i).advancedSprite = true;
                tab.child(child++, this.id - 1, xTile + 2, yTile + 2);
                if (i % 4 == 3) {
                    yTile += 44;
                    xTile = 5;
                } else {
                    xTile += 44;
                }
            } else {
                (new String[1])[0] = "Toggle";
                this.addClickableSprite((int)99, (int)32, (int)32, (String[])new String[1]).setDoNotDraw((boolean)true).isCustomPrayer = true;
                tab.child(child++, this.id - 1, xTile, yTile);
                this.addSprite((int)1454).advancedSprite = true;
                tab.child(child++, this.id - 1, xTile, yTile);
                if (i % 4 == 3) {
                    yTile += 44;
                    xTile = 5;
                } else {
                    xTile += 44;
                }
            }
            ++i;
        }
        int xTile1 = 3;
        int yTile1 = 0;
        int i2 = 0;
        while (i2 < 31) {
            if (i2 < prayersLength) {
                this.createHover(34, 34, String.valueOf(this.getName()) + " --- --- lll :\\nHiii kik" + (this.id - 1));
                tab.child(child++, this.id - 1, xTile1, yTile1);
                if (i2 % 4 == 3) {
                    yTile1 += 44;
                    xTile1 = 0;
                } else {
                    xTile1 += 44;
                }
            } else {
                this.createHover(0, 0, "");
                tab.child(child++, this.id - 1, xTile1, yTile1);
                if (i2 % 4 == 3) {
                    yTile1 += 44;
                    xTile1 = 0;
                } else {
                    xTile1 += 44;
                }
            }
            ++i2;
        }
        return tab;
    }

    public static enum HeaderStyle {
        BASIC,
        GRADIENT,
        BEVELED,
        ROUNDED_TOP,
        UNDERLINED,
        TABBED,
        DECORATED,
        SHADOWED,
        CONCAVE,
        CONVEX,
        BRACKET,
        TICKET,
        NOTCHED,
        SCROLL,
        CUSTOM;

    }
}

