/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.tools.fxscenes;

import com.aragon.client.Client;
import com.aragon.graphics.animation.FrameReader;
import com.aragon.graphics.animation.SpotAnim;
import com.aragon.graphics.model.Model;
import com.aragon.graphics.model.ModelUtil;
import com.aragon.util.JagexColor;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javax.swing.SwingUtilities;

public class RecolorSceneController
implements Initializable {
    public ListView<ColorWrapper> colors;
    private ObservableList<ColorWrapper> modelColors = FXCollections.observableArrayList();
    public Button loadModelColors;
    public Button save;
    public Button reset;
    public Button toggle;
    public Slider widthSlider;
    public Slider heightSlider;
    public Slider rotationSlider;
    public TextField gfxIdBox;

    public void initialize(URL location, ResourceBundle resources) {
        SwingUtilities.invokeLater(() -> this.reset());
        this.loadModelColors.setOnAction(event -> this.readColors(this.modelColors));
        this.reset.setOnAction(event -> SwingUtilities.invokeLater(() -> this.reset()));
        this.save.setOnAction(event -> SwingUtilities.invokeLater(() -> this.save()));
        this.toggle.setOnAction(event -> SwingUtilities.invokeLater(() -> {
            boolean bl = ModelUtil.keepPlaying = !ModelUtil.keepPlaying;
            if (ModelUtil.keepPlaying) {
                Client.myPlayer.anInt1520 = ModelUtil.spotAnim.getId();
            }
        }));
        this.rotationSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                SwingUtilities.invokeLater(() -> {
                    ModelUtil.spotAnim.rotation = var3.intValue();
                    SpotAnim.modelCache.clear();
                });
            }
        });
        this.widthSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                SwingUtilities.invokeLater(() -> ModelUtil.spotAnim.setMultiplierWidth(var3.doubleValue()));
            }
        });
        this.heightSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                SwingUtilities.invokeLater(() -> ModelUtil.spotAnim.setMultiplierHeight(var3.doubleValue()));
            }
        });
        this.gfxIdBox.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent var1) {
                if (var1.getCode().equals((Object)KeyCode.ENTER)) {
                    try {
                        int id = Integer.parseInt(RecolorSceneController.this.gfxIdBox.getText().trim());
                        SwingUtilities.invokeLater(() -> {
                            ModelUtil.setGFX(id);
                            Client.myPlayer.anInt1520 = id;
                            Client.myPlayer.currentAnim = 0;
                            RecolorSceneController.this.reset();
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void readColors(ObservableList<ColorWrapper> source) {
        this.colors.getItems().clear();
        this.colors.getItems().addAll(source);
    }

    private void readColorsFromModel() {
        this.modelColors.clear();
        Model model = ModelUtil.spotAnim.getModel();
        if (model.triangleColour != null) {
            for (Map.Entry<Integer, AtomicInteger> entry : ModelUtil.getModelColors(model)) {
                int color = entry.getKey();
                int[] dest = ModelUtil.spotAnim.destColours;
                if (dest != null) {
                    int i = 0;
                    while (i < dest.length) {
                        int dColor = dest[i];
                        if (dColor == color) {
                            color = ModelUtil.spotAnim.originalColours[i];
                            System.out.println("Found a color");
                        }
                        ++i;
                    }
                }
                this.modelColors.add((Object)new ColorWrapper(ModelUtil.spotAnim, entry.getValue().get(), color, entry.getKey()));
            }
            System.out.println("Added " + this.modelColors.size() + " colors");
        } else {
            System.out.println("Model colors: " + Arrays.toString(model.triangleColour));
        }
    }

    private void save() {
        try {
            SpotAnim.saveCustomGFXes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void reset() {
        this.colors.getItems().clear();
        if (ModelUtil.spotAnim != null) {
            if (ModelUtil.spotAnim.getModel() == null) {
                Client.myPlayer.anInt1520 = ModelUtil.spotAnim.getId();
                Client.myPlayer.currentAnim = 0;
                Client.myPlayer.animCycle = 0;
                if (FrameReader.animationlist[Integer.parseInt(Integer.toHexString(SpotAnim.cache[ModelUtil.spotAnim.getId()].animation.frameIDs[0]).substring(0, Integer.toHexString(SpotAnim.cache[ModelUtil.spotAnim.getId()].animation.frameIDs[0]).length() - 4), 16)].length == 0) {
                    Client.instance.onDemandFetcher.requestFileData(1, Integer.parseInt(Integer.toHexString(SpotAnim.cache[ModelUtil.spotAnim.getId()].animation.frameIDs[0]).substring(0, Integer.toHexString(SpotAnim.cache[ModelUtil.spotAnim.getId()].animation.frameIDs[0]).length() - 4), 16));
                }
                while (ModelUtil.spotAnim.getModel() == null) {
                    System.out.println("Waiting on model to load!");
                }
            }
            this.readColorsFromModel();
            this.widthSlider.setValue(ModelUtil.spotAnim.multiplierWidth);
            this.heightSlider.setValue(ModelUtil.spotAnim.multiplierHeight);
            this.rotationSlider.setValue((double)ModelUtil.spotAnim.rotation);
        } else {
            System.out.println("Please first select a gfx, ::selectgfx <id>");
        }
    }

    private static Color convert(int hslColor) {
        return JagexColor.RS2HSB_to_RGB(hslColor);
    }

    private static int convert(Color color) {
        return JagexColor.RGB_to_RS2HSB((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    private final class ColorWrapper
    extends HBox {
        final ColorPicker picker = new ColorPicker();
        final Button reset = new Button("reset");
        final SpotAnim definition;
        int initialColor;
        int targetColor;

        ColorWrapper(SpotAnim definition, int occurences, int initialColor, int targetColor) {
            this.initialColor = initialColor;
            this.targetColor = targetColor;
            this.definition = definition;
            this.getChildren().addAll((Object[])new Node[]{this.picker, this.reset, new Label("Occurences: " + occurences)});
            this.picker.setValue((Object)RecolorSceneController.convert(targetColor));
            this.picker.setOnAction(event -> this.changeColor());
            this.reset.setOnAction(event -> this.resetValueToInitialColor());
        }

        void changeColor() {
            this.targetColor = RecolorSceneController.convert((Color)this.picker.getValue());
            System.out.println("Set color " + this.initialColor + " to " + RecolorSceneController.convert(this.targetColor));
            SwingUtilities.invokeLater(() -> {
                this.definition.recolor(this.initialColor, this.targetColor);
                SpotAnim.modelCache.clear();
            });
        }

        void resetValueToInitialColor() {
            this.picker.setValue((Object)RecolorSceneController.convert(this.initialColor));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ColorWrapper wrapper = (ColorWrapper)((Object)o);
            if (this.initialColor != wrapper.initialColor) {
                return false;
            }
            return this.targetColor == wrapper.targetColor;
        }

        public int hashCode() {
            int result = this.initialColor;
            result = 31 * result + this.targetColor;
            return result;
        }
    }
}

