/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.tools.fxscenes;

import com.aragon.client.Client;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;

public class NpcConfigSceneController
implements Initializable {
    @FXML
    private Button saveButton;
    @FXML
    private Button setCurrentPositionButton;
    @FXML
    private TextField npcIdField;
    @FXML
    private TextField directionField;
    @FXML
    private TextField xPositionField;
    @FXML
    private TextField yPositionField;
    @FXML
    private TextField zPositionField;
    @FXML
    private TextField coordinateField;
    @FXML
    private TextField radiusField;
    private final Client instance = Client.instance;
    @FXML
    private MenuItem northMenu;
    @FXML
    private MenuItem northEastMenu;
    @FXML
    private MenuItem northWestMenu;
    @FXML
    private MenuItem southMenu;
    @FXML
    private MenuItem southEastMenu;
    @FXML
    private MenuItem southWestMenu;
    @FXML
    private MenuItem eastMenu;
    @FXML
    private MenuItem westMenu;
    private int direction = 0;

    public void initialize(URL location, ResourceBundle resources) {
        this.instance.npcEditing = true;
        this.handleMenus();
        this.instance.sendNpcConfigPacket(1, 1, 1, 1, 1, true, 1);
        this.setCurrentPositionButton.setOnMouseClicked(x -> {
            int xPos = Client.getBaseX() + (Client.myPlayer.x - 6 >> 7);
            int yPos = Client.getBaseY() + (Client.myPlayer.y - 6 >> 7);
            int height = this.instance.plane;
            this.xPositionField.setText(String.valueOf(xPos));
            this.yPositionField.setText(String.valueOf(yPos));
            this.zPositionField.setText(String.valueOf(height));
        });
        this.saveButton.setOnMouseClicked(x -> {
            int npcId = Integer.parseInt(this.npcIdField.getText());
            int xPos = Integer.parseInt(this.xPositionField.getText());
            int yPos = Integer.parseInt(this.yPositionField.getText());
            int zPos = Integer.parseInt(this.zPositionField.getText());
            boolean coordinate = Boolean.parseBoolean(this.coordinateField.getText());
            int radius = Integer.parseInt(this.radiusField.getText());
            this.instance.sendNpcConfigPacket(npcId, this.direction, xPos, yPos, zPos, coordinate, radius);
        });
    }

    private void handleMenus() {
        this.northMenu.setOnAction(x -> {
            this.directionField.setText("NORTH");
            this.direction = 1;
        });
        this.northEastMenu.setOnAction(x -> {
            this.directionField.setText("NORTH_EAST");
            this.direction = 2;
        });
        this.northWestMenu.setOnAction(x -> {
            this.directionField.setText("NORTH_WEST");
            this.direction = 0;
        });
        this.southMenu.setOnAction(x -> {
            this.directionField.setText("SOUTH");
            this.direction = 6;
        });
        this.southEastMenu.setOnAction(x -> {
            this.directionField.setText("SOUTH_EAST");
            this.direction = 7;
        });
        this.southWestMenu.setOnAction(x -> {
            this.directionField.setText("SOUTH_WEST");
            this.direction = 5;
        });
        this.eastMenu.setOnAction(x -> {
            this.directionField.setText("EAST");
            this.direction = 4;
        });
        this.westMenu.setOnAction(x -> {
            this.directionField.setText("WEST");
            this.direction = 3;
        });
    }
}

