/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.tools.fxscenes;

import com.aragon.client.Client;
import com.aragon.entity.Player;
import com.aragon.entity.definitions.ItemDef;
import com.aragon.entity.definitions.NPCDef;
import com.aragon.graphics.model.Model;
import com.aragon.graphics.model.ModelUtil;
import com.aragon.graphics.particle.ParticleDefinition;
import com.aragon.ui.RSInterface;
import com.aragon.util.JagexColor;
import com.aragon.util.signlink;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javax.swing.SwingUtilities;

public class DefEditorSceneController
implements Initializable {
    @FXML
    private Button confirmChangesButton;
    @FXML
    private Button loadModelColors;
    @FXML
    private Button saveButton;
    @FXML
    private Button saveButton1;
    @FXML
    private Button defaultsButton;
    @FXML
    private Button loadNpcColorsButton;
    @FXML
    private Button saveNpcDataButton;
    @FXML
    private Button resetNpcData;
    @FXML
    private Slider zoomSlider;
    @FXML
    private Slider xRotationSlider;
    @FXML
    private Slider yRotationSlider;
    @FXML
    private Slider opacitySlider;
    @FXML
    private Slider xAngleSlider;
    @FXML
    private Slider yAngleSlider;
    @FXML
    private Slider zAngleSlider;
    @FXML
    private Slider xOffsetMSlider;
    @FXML
    private Slider yOffsetMSlider;
    @FXML
    private Slider yOffsetFSlider;
    @FXML
    private TextField zoomTextField;
    @FXML
    private TextField xRotationTextField;
    @FXML
    private TextField yRotationTextField;
    @FXML
    private TextField changeIDTextField;
    @FXML
    private TextField opacityTextField;
    @FXML
    private TextField yAngleTextField;
    @FXML
    private TextField xAngleTextField;
    @FXML
    private TextField zAngleTextField;
    @FXML
    private TextField textureField1;
    @FXML
    private TextField textureField2;
    @FXML
    private TextField textureField3;
    @FXML
    private TextField particleHexField;
    @FXML
    private TextField particleIndexField;
    @FXML
    private TextField invModelTextField;
    @FXML
    private TextField maleEquipTextField;
    @FXML
    private TextField femaleEquipTextField;
    @FXML
    private TextField xOffsetMTextField;
    @FXML
    private TextField yOffsetMTextField;
    @FXML
    private TextField yOffsetFTextField;
    @FXML
    private TextField runAnimField;
    @FXML
    private TextField standAnimField;
    @FXML
    private TextField walkAnimField;
    @FXML
    private TextField xzSizeField;
    @FXML
    private TextField ySizeField;
    @FXML
    private TextField npcModelsField;
    @FXML
    private TextField drawDotField;
    @FXML
    private TextField renderPriField;
    @FXML
    private TextField headIconField;
    @FXML
    private TextField combatLvlField;
    @FXML
    private TextField nameField;
    @FXML
    private TextField squaresNeededField;
    @FXML
    private TextField npcIdField;
    @FXML
    private Label zoomLabel;
    @FXML
    private Label rotationXLabel;
    @FXML
    private Label rotationYLabel;
    @FXML
    private Label opacityLabel;
    @FXML
    private Label xAngleLabel;
    @FXML
    private Label yAngleLabel;
    @FXML
    private Label zAngleLabel;
    @FXML
    private Label xOffsetMLabel;
    @FXML
    private Label yOffsetMLabel;
    @FXML
    private Label yOffsetFLabel;
    @FXML
    private Label invModelLabel;
    @FXML
    private Label maleEquipLabel;
    @FXML
    private Label femaleEquipLabel;
    public static int xValue = 0;
    public static int yValue = 0;
    public static int zValue = 0;
    ItemDef def = ItemDef.forID(Client.currentlyEditedItemId);
    private int defaultInvModel;
    private int defaultMaleModel;
    private int defaultFemaleModel;
    private int defaultZoom;
    private int defaultRotationX;
    private int defaultRotationY;
    private int defaultOpacity;
    private int[] defaultModelColors;
    private byte defaultMaleXOffset;
    private byte defaultMaleYOffset;
    private byte defaultFemaleYOffset;
    public ColorPicker particleColorPicker;
    public ListView<ColorWrapper> colors;
    @FXML
    public ListView<ColorWrapper> npcColorsListView;
    public ListView<ColorWrapper> remainingColorsListView;
    public ListView<Integer> modelListView;
    @FXML
    private ImageView itemImageView;
    private ObservableList<ColorWrapper> modelColors;
    private ObservableList<ColorWrapper> npcModelColors;
    NPCDef npcDef;
    private int defaultRunAnim;
    private int defaultStandAnim;
    private int defaultWalkAnim;
    private int defaultXZSize;
    private int defaultYSize;
    private int[] defaultNpcModels;
    private boolean defaultDrawDotSetting;
    private boolean defaultRenderPri;
    private int defaultHeadIcon;
    private int defaultCombatLvl;
    private String defaultNpcName;
    private byte defaultSquaresNeeded;
    private int[] defaultNpcColors;
    private int[] defaultDestColors;
    private List<Integer> colorList;
    private List<Integer> npcColorList;
    private int[] colorArray;
    private int[] npcColorArray;
    private int currentlyEditedIndex;
    private final int[] textureIds;
    private List<Integer> foundTextures;
    int color;
    int npcColor;
    TextField[] fields;
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
    private static final Type TYPE = new TypeToken<HashSet<ItemDef>>(){}.getType();
    private static final Type NPC_TYPE = new TypeToken<HashSet<NPCDef>>(){}.getType();
    public static Set<ItemDef> customItems = new HashSet<ItemDef>();
    public static Set<NPCDef> customNpcs = new HashSet<NPCDef>();
    static final Path PATH = Paths.get(String.valueOf(signlink.findcachedir()) + "customitems.json", new String[0]);
    static final Path NPC_PATH = Paths.get(String.valueOf(signlink.findcachedir()) + "customnpcs.json", new String[0]);
    HashSet<ItemDef> tempSet;

    public DefEditorSceneController() {
        this.defaultInvModel = this.def.modelID;
        this.defaultMaleModel = this.def.maleEquip1;
        this.defaultFemaleModel = this.def.femaleEquip1;
        this.defaultZoom = this.def.modelZoom;
        this.defaultRotationX = this.def.rotationX;
        this.defaultRotationY = this.def.rotationY;
        this.defaultOpacity = this.def.shadow;
        this.defaultModelColors = this.def.originalModelColors;
        this.defaultMaleXOffset = this.def.maleXOffset;
        this.defaultMaleYOffset = this.def.maleYOffset;
        this.defaultFemaleYOffset = this.def.femaleYOffset;
        this.particleColorPicker = new ColorPicker();
        this.colors = new ListView();
        this.remainingColorsListView = new ListView();
        this.modelListView = new ListView();
        this.modelColors = FXCollections.observableArrayList();
        this.npcModelColors = FXCollections.observableArrayList();
        this.npcDef = NPCDef.forID(1);
        this.defaultRunAnim = this.npcDef.runAnim;
        this.defaultStandAnim = this.npcDef.standAnim;
        this.defaultWalkAnim = this.npcDef.walkAnim;
        this.defaultXZSize = this.npcDef.sizeXZ;
        this.defaultYSize = this.npcDef.sizeY;
        this.defaultNpcModels = this.npcDef.models;
        this.defaultDrawDotSetting = this.npcDef.drawMinimapDot;
        this.defaultRenderPri = this.npcDef.hasRenderPriority;
        this.defaultHeadIcon = this.npcDef.headIcon;
        this.defaultCombatLvl = this.npcDef.combatLevel;
        this.defaultNpcName = this.npcDef.name;
        this.defaultSquaresNeeded = this.npcDef.squaresNeeded;
        this.defaultNpcColors = this.npcDef.originalColours;
        this.defaultDestColors = this.npcDef.destColours;
        this.colorList = new ArrayList<Integer>();
        this.npcColorList = new ArrayList<Integer>();
        this.currentlyEditedIndex = -1;
        this.textureIds = new int[]{24, 40, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75};
        this.foundTextures = new ArrayList<Integer>();
        this.color = 0;
        this.npcColor = 0;
        this.fields = null;
        this.tempSet = new HashSet();
    }

    private Color convert(int hslColor) {
        return JagexColor.RS2HSB_to_RGB(hslColor);
    }

    private int convert(Color color) {
        return JagexColor.RGB_to_RS2HSB((int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    private void readColors(ObservableList<ColorWrapper> source) {
        this.colors.setItems(source);
    }

    private void readNpcColors(ObservableList<ColorWrapper> source) {
        this.npcColorsListView.setItems(source);
    }

    private void readRemainingColors(ObservableList<ColorWrapper> source) {
        this.remainingColorsListView.setItems(source);
    }

    private void reset() {
        this.colorList.clear();
        this.colors.getItems().clear();
        ItemDef itemDef = ItemDef.forID(Client.currentlyEditedItemId);
        itemDef.originalModelColors = null;
        itemDef.newModelColor = null;
        this.colorArray = null;
        this.readColorsFromModel();
    }

    private void resetNpcData() {
        this.npcColorList.clear();
        this.npcColorsListView.getItems().clear();
        this.npcDef.originalColours = null;
        this.npcDef.destColours = null;
        this.npcColorArray = null;
        this.readNpcColorsFromModel();
    }

    private void retexture(int index) {
        int originalId = this.foundTextures.get(index);
        int targetId = Integer.parseInt(this.fields[index].getText());
        this.def.originalModelColors[index] = originalId;
        System.out.println("At index: " + this.def.originalModelColors[index]);
        System.out.println("Just original: " + originalId);
        this.def.newModelColor[index] = targetId;
        this.clearCaches();
        this.textureField1.clear();
        this.textureField1.setPromptText("Current texture id: " + targetId);
        System.out.println("Changed from texture: " + originalId + " to " + targetId);
    }

    private void clearCaches() {
        ItemDef.spriteCache.clear();
        ItemDef.modelCache.clear();
        Player.modelCache.clear();
    }

    private void fetchTextures() {
        System.out.println("Starting array: " + this.colorList);
        int[] nArray = this.textureIds;
        int n = this.textureIds.length;
        int n2 = 0;
        while (n2 < n) {
            int textures = nArray[n2];
            if (this.colorList.contains(textures)) {
                this.foundTextures.add(textures);
                this.colorList.remove(this.colorList.indexOf(textures));
            }
            ++n2;
        }
        System.out.println("Ending array " + this.colorList);
    }

    private void readColorsFromModel() {
        this.modelColors.clear();
        Model model = new Model(this.def.modelID);
        if (model.triangleColour != null) {
            for (Map.Entry<Integer, AtomicInteger> entry : ModelUtil.getModelColors(model)) {
                int i;
                this.color = entry.getKey();
                int[] dest = this.def.newModelColor;
                if (dest != null) {
                    i = 0;
                    while (i < dest.length) {
                        int dColor = dest[i];
                        if (dColor == this.color) {
                            this.color = this.def.originalModelColors[i];
                            System.out.println("Found a color");
                        }
                        ++i;
                    }
                }
                this.colorList.add(this.color);
                this.colorArray = new int[this.colorList.size()];
                i = 0;
                while (i < this.colorArray.length) {
                    this.colorArray[i] = this.colorList.get(i);
                    this.def.originalModelColors = this.colorArray;
                    this.def.newModelColor = new int[this.colorArray.length];
                    ++i;
                }
                if (Arrays.stream(this.textureIds).anyMatch(x -> x == this.color)) continue;
                this.modelColors.add((Object)new ColorWrapper(this.def, entry.getValue().get(), this.color, (int)entry.getKey()));
            }
            System.out.println("Original colors components: " + Arrays.toString(this.def.originalModelColors));
        } else {
            System.out.println("Model colors: " + Arrays.toString(model.triangleColour));
        }
    }

    private void readNpcColorsFromModel() {
        this.npcModelColors.clear();
        int[] models = this.npcDef.models;
        System.out.println("npc models: " + Arrays.toString(models));
        System.out.println("Npc id: " + this.npcDef.id);
        int x = 0;
        while (x < models.length) {
            Model model = new Model(models[x]);
            System.out.println("Fetching for model: " + model.getModelId());
            System.out.println("That models triangle colors: " + Arrays.toString(model.triangleColour));
            if (model.triangleColour != null) {
                for (Map.Entry<Integer, AtomicInteger> entry : ModelUtil.getModelColors(model)) {
                    int i;
                    this.npcColor = entry.getKey();
                    int[] npcDest = this.npcDef.destColours;
                    if (npcDest != null) {
                        i = 0;
                        while (i < npcDest.length) {
                            int npcDColor = npcDest[i];
                            if (npcDColor == this.npcColor) {
                                this.npcColor = this.npcDef.originalColours[i];
                            }
                            ++i;
                        }
                    }
                    this.npcColorList.add(this.npcColor);
                    this.npcColorArray = new int[this.npcColorList.size()];
                    i = 0;
                    while (i < this.npcColorArray.length) {
                        this.npcColorArray[i] = this.npcColorList.get(i);
                        this.npcDef.originalColours = this.npcColorArray;
                        this.npcDef.destColours = new int[this.npcColorArray.length];
                        ++i;
                    }
                    this.npcModelColors.add((Object)new ColorWrapper(this.npcDef, entry.getValue().get(), this.npcColor, (int)entry.getKey()));
                }
                System.out.println("Original npc color components: " + Arrays.toString(this.npcDef.originalColours));
            }
            ++x;
        }
    }

    private void changeParticleColor(Color color) {
        int rgb = (int)(color.getRed() * 1.0 * 255.0);
        rgb = (rgb << 8) + (int)(color.getGreen() * 255.0);
        rgb = (rgb << 8) + (int)(color.getBlue() * 255.0);
        ParticleDefinition.cache[this.currentlyEditedIndex].setStartColor(rgb);
        this.particleHexField.setText("0x" + Integer.toHexString(rgb));
    }

    public static final void loadCustomItems() throws FileNotFoundException {
        File file = PATH.toFile();
        FileReader reader = new FileReader(file);
        Set items = (Set)GSON.fromJson((Reader)reader, TYPE);
        if (items == null) {
            return;
        }
        customItems.addAll(items);
        System.out.println(customItems.size());
        for (ItemDef def : items) {
            ItemDef cItem = ItemDef.forID(def.id);
            cItem.modelZoom = def.modelZoom;
            cItem.rotationX = def.rotationX;
            cItem.rotationY = def.rotationY;
            cItem.shadow = def.shadow;
            cItem.originalModelColors = def.originalModelColors;
            cItem.newModelColor = def.newModelColor;
            cItem.modelID = def.modelID;
            cItem.maleEquip1 = def.maleEquip1;
            cItem.femaleEquip1 = def.femaleEquip1;
            cItem.maleXOffset = def.maleXOffset;
            cItem.maleYOffset = def.maleYOffset;
            cItem.femaleYOffset = def.femaleYOffset;
        }
    }

    public static final void loadCustomNpcs() throws FileNotFoundException {
        File file = NPC_PATH.toFile();
        FileReader reader = new FileReader(file);
        Set npcs = (Set)GSON.fromJson((Reader)reader, NPC_TYPE);
        if (npcs == null) {
            return;
        }
        customNpcs.addAll(npcs);
        System.out.println(customNpcs.size());
        for (NPCDef npcDef : npcs) {
            NPCDef customNpc = NPCDef.forID(npcDef.id);
            customNpc.runAnim = npcDef.runAnim;
            customNpc.standAnim = npcDef.standAnim;
            customNpc.walkAnim = npcDef.walkAnim;
            customNpc.sizeXZ = npcDef.sizeXZ;
            customNpc.sizeY = npcDef.sizeY;
            customNpc.models = npcDef.models;
            customNpc.drawMinimapDot = npcDef.drawMinimapDot;
            customNpc.hasRenderPriority = npcDef.hasRenderPriority;
            customNpc.headIcon = npcDef.headIcon;
            customNpc.combatLevel = npcDef.combatLevel;
            customNpc.name = npcDef.name;
            customNpc.squaresNeeded = npcDef.squaresNeeded;
            customNpc.originalColours = npcDef.originalColours;
            customNpc.destColours = npcDef.destColours;
        }
    }

    private final void saveCustomItems() {
        this.def = ItemDef.forID(Client.currentlyEditedItemId);
        try {
            File file = PATH.toFile();
            FileWriter writer = new FileWriter(file);
            if (!customItems.add(this.def)) {
                customItems.remove(this.def);
                customItems.add(this.def);
            }
            GSON.toJson(customItems, TYPE, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void saveCustomNpcData() {
        try {
            File file = NPC_PATH.toFile();
            FileWriter writer = new FileWriter(file);
            if (!customNpcs.add(this.npcDef)) {
                customNpcs.remove(this.npcDef);
                customNpcs.add(this.npcDef);
            }
            GSON.toJson(customNpcs, TYPE, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setItems() {
        Client.instance.askData();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.particleColorPicker.valueProperty().addListener((observable, oldValue, newValue) -> this.changeParticleColor((Color)newValue));
        this.saveButton.setOnMouseClicked(x -> {
            System.out.println("Executed");
            this.saveCustomItems();
        });
        this.saveNpcDataButton.setOnMouseClicked(x -> this.saveCustomNpcData());
        this.fields = new TextField[]{this.textureField1, this.textureField2, this.textureField3};
        this.textureField1.setVisible(false);
        this.textureField2.setVisible(false);
        this.textureField3.setVisible(false);
        this.colors.setCellFactory(param -> new ListCell<ColorWrapper>(){

            protected void updateItem(ColorWrapper item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                ColorPicker picker = new ColorPicker();
                this.setGraphic((Node)picker);
                picker.valueProperty().bindBidirectional(item.targetColor);
            }
        });
        this.npcColorsListView.setCellFactory(param -> new ListCell<ColorWrapper>(){

            protected void updateItem(ColorWrapper item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                ColorPicker colorPicker = new ColorPicker();
                this.setGraphic((Node)colorPicker);
                colorPicker.valueProperty().bindBidirectional(item.targetColor);
            }
        });
        this.remainingColorsListView.setCellFactory(param -> new ListCell<ColorWrapper>(){

            protected void updateItem(ColorWrapper item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                ColorPicker picker = new ColorPicker();
                this.setGraphic((Node)picker);
                picker.valueProperty().bindBidirectional(item.targetColor);
            }
        });
        this.loadModelColors.setOnMouseClicked(x -> {
            this.reset();
            this.readColors(this.modelColors);
            this.foundTextures.clear();
            this.fetchTextures();
            this.readRemainingColors(this.modelColors);
            if (this.foundTextures.size() > 0) {
                this.textureField1.setVisible(true);
            } else {
                this.textureField1.setVisible(false);
                this.textureField2.setVisible(false);
                this.textureField3.setVisible(false);
            }
            if (this.foundTextures.size() > 1) {
                this.textureField2.setVisible(true);
            } else {
                this.textureField2.setVisible(false);
                this.textureField3.setVisible(false);
            }
            if (this.foundTextures.size() > 2) {
                this.textureField3.setVisible(true);
            } else {
                this.textureField3.setVisible(false);
            }
        });
        this.loadNpcColorsButton.setOnMouseClicked(x -> {
            this.resetNpcData();
            this.readNpcColors(this.npcModelColors);
            System.out.println("Reading!");
        });
        this.zoomSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    DefEditorSceneController.this.def.modelZoom = var3.intValue();
                    DefEditorSceneController.this.zoomTextField.setText("" + var3.intValue());
                } else {
                    System.out.println("Aint even item editing lol");
                }
            }
        });
        this.xRotationSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    DefEditorSceneController.this.def.rotationX = var3.intValue();
                    DefEditorSceneController.this.xRotationTextField.setText("" + var3.intValue());
                }
            }
        });
        this.yRotationSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    DefEditorSceneController.this.def.rotationY = var3.intValue();
                    DefEditorSceneController.this.yRotationTextField.setText("" + var3.intValue());
                }
            }
        });
        this.opacitySlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    DefEditorSceneController.this.def.shadow = 400 - var3.intValue();
                    System.out.println("Shadow: " + DefEditorSceneController.this.def.shadow);
                    ItemDef.modelCache.clear();
                    DefEditorSceneController.this.opacityTextField.setText("" + DefEditorSceneController.this.def.shadow);
                }
            }
        });
        this.xAngleSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    xValue = var3.intValue();
                    DefEditorSceneController.this.xAngleTextField.setText("" + xValue);
                    Player.modelCache.clear();
                }
            }
        });
        this.yAngleSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    yValue = var3.intValue();
                    DefEditorSceneController.this.yAngleTextField.setText("" + yValue);
                    Player.modelCache.clear();
                }
            }
        });
        this.zAngleSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    zValue = var3.intValue();
                    DefEditorSceneController.this.zAngleTextField.setText("" + zValue);
                    Player.modelCache.clear();
                    ItemDef.modelCache.clear();
                }
            }
        });
        this.xOffsetMSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    DefEditorSceneController.this.def.maleXOffset = (byte)var3.intValue();
                    DefEditorSceneController.this.xOffsetMTextField.setText("Male X offset: " + var3.intValue());
                    Player.modelCache.clear();
                }
            }
        });
        this.yOffsetMSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    DefEditorSceneController.this.def.maleYOffset = (byte)var3.intValue();
                    DefEditorSceneController.this.yOffsetMTextField.setText("" + var3.intValue());
                    Player.modelCache.clear();
                }
            }
        });
        this.yOffsetFSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> var1, Number var2, Number var3) {
                if (Client.itemEditing) {
                    DefEditorSceneController.this.def.femaleYOffset = (byte)var3.intValue();
                    DefEditorSceneController.this.yOffsetFTextField.setText("" + var3.intValue());
                    Player.modelCache.clear();
                }
            }
        });
        this.textureField1.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.retexture(0);
            }
        });
        this.textureField2.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.retexture(1);
            }
        });
        this.textureField3.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.retexture(2);
            }
        });
        this.npcIdField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef = NPCDef.forID(Integer.parseInt(this.npcIdField.getText()));
                Client.instance.sendTransformationId(this.npcDef.id);
                System.out.println("Transformed to: " + this.npcDef.id);
                this.defaultRunAnim = this.npcDef.runAnim;
                this.defaultStandAnim = this.npcDef.standAnim;
                this.defaultWalkAnim = this.npcDef.walkAnim;
                this.defaultXZSize = this.npcDef.sizeXZ;
                this.defaultYSize = this.npcDef.sizeY;
                this.defaultNpcModels = this.npcDef.models;
                this.defaultDrawDotSetting = this.npcDef.drawMinimapDot;
                this.defaultRenderPri = this.npcDef.hasRenderPriority;
                this.defaultHeadIcon = this.npcDef.headIcon;
                this.defaultCombatLvl = this.npcDef.combatLevel;
                this.defaultNpcName = this.npcDef.name;
                this.defaultSquaresNeeded = this.npcDef.squaresNeeded;
                this.defaultNpcColors = this.npcDef.originalColours;
                this.defaultDestColors = this.npcDef.destColours;
            }
        });
        this.runAnimField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.runAnim = Integer.parseInt(this.runAnimField.getText());
            }
        });
        this.standAnimField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.standAnim = Integer.parseInt(this.standAnimField.getText());
            }
        });
        this.walkAnimField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.walkAnim = Integer.parseInt(this.walkAnimField.getText());
            }
        });
        this.xzSizeField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.sizeXZ = Integer.parseInt(this.xzSizeField.getText());
            }
        });
        this.ySizeField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.sizeY = Integer.parseInt(this.ySizeField.getText());
            }
        });
        this.npcModelsField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                Object[] model = this.npcModelsField.getText().split(",");
                int[] models = new int[model.length];
                System.out.println("models: " + Arrays.toString(model));
                int i = 0;
                while (i < model.length) {
                    models[i] = Integer.parseInt((String)model[i]);
                    ++i;
                }
                this.npcDef.models = models;
                this.clearCaches();
                NPCDef.modelCache.clear();
            }
        });
        this.drawDotField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.drawMinimapDot = Boolean.parseBoolean(this.drawDotField.getText());
            }
        });
        this.renderPriField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.hasRenderPriority = Boolean.parseBoolean(this.renderPriField.getText());
            }
        });
        this.headIconField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.headIcon = Integer.parseInt(this.headIconField.getText());
            }
        });
        this.combatLvlField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.combatLevel = Integer.parseInt(this.combatLvlField.getText());
            }
        });
        this.nameField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.name = this.nameField.getText();
            }
        });
        this.squaresNeededField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                this.npcDef.squaresNeeded = Byte.parseByte(this.squaresNeededField.getText());
            }
        });
        this.changeIDTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                if (this.changeIDTextField.getText().isEmpty()) {
                    System.out.println("Was empty :/");
                    return;
                }
                int newId = Integer.parseInt(this.changeIDTextField.getText());
                if (newId == Client.currentlyEditedItemId) {
                    return;
                }
                Client.currentlyEditedItemId = newId;
                this.setItems();
                Client.itemEditing = true;
                this.def = ItemDef.forID(newId);
                this.defaultInvModel = this.def.modelID;
                this.defaultMaleModel = this.def.maleEquip1;
                this.defaultFemaleModel = this.def.femaleEquip1;
                this.defaultZoom = this.def.modelZoom;
                this.defaultRotationX = this.def.rotationX;
                this.defaultRotationY = this.def.rotationY;
                this.defaultOpacity = this.def.shadow;
                System.out.println("Model zoom: " + this.def.modelZoom);
                System.out.println("Rotation Y: " + this.def.rotationY);
                this.defaultModelColors = this.def.newModelColor;
                this.defaultMaleXOffset = this.def.maleXOffset;
                this.defaultMaleYOffset = this.def.maleYOffset;
                this.defaultFemaleYOffset = this.def.femaleYOffset;
                this.zoomSlider.setValue((double)this.defaultZoom);
                this.xRotationSlider.setValue((double)this.defaultRotationX);
                this.yRotationSlider.setValue((double)this.defaultRotationY);
                this.xOffsetMSlider.setValue((double)this.defaultMaleXOffset);
                this.yOffsetMSlider.setValue((double)this.defaultMaleYOffset);
                this.yOffsetFSlider.setValue((double)this.defaultFemaleYOffset);
                RSInterface rsi = RSInterface.interfaceCache[3214];
                int slot = 0;
                while (slot < 28) {
                    rsi.inv[slot] = Client.currentlyEditedItemId + 1;
                    rsi.invStackSizes[slot] = 1;
                    ++slot;
                }
            }
        });
        this.invModelTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                int id;
                if (this.invModelTextField.getText().isEmpty()) {
                    System.out.println("Enter something too.");
                    return;
                }
                this.def.modelID = id = Integer.parseInt(this.invModelTextField.getText());
                this.clearCaches();
            }
        });
        this.maleEquipTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                int id;
                if (this.maleEquipTextField.getText().isEmpty()) {
                    System.out.println("Enter something too.");
                    return;
                }
                this.def.maleEquip1 = id = Integer.parseInt(this.maleEquipTextField.getText());
                this.clearCaches();
            }
        });
        this.femaleEquipTextField.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER) {
                int id;
                if (this.femaleEquipTextField.getText().isEmpty()) {
                    System.out.println("Enter something too.");
                    return;
                }
                this.def.femaleEquip1 = id = Integer.parseInt(this.femaleEquipTextField.getText());
                this.clearCaches();
            }
        });
        this.defaultsButton.setOnMouseClicked(x -> {
            this.def.modelID = this.defaultInvModel;
            this.def.maleEquip1 = this.defaultMaleModel;
            this.def.femaleEquip1 = this.defaultFemaleModel;
            this.def.modelZoom = this.defaultZoom;
            this.def.rotationX = this.defaultRotationX;
            this.def.rotationY = this.defaultRotationY;
            this.def.shadow = this.defaultOpacity;
            this.def.originalModelColors = this.defaultModelColors;
            this.def.maleXOffset = this.defaultMaleXOffset;
            this.def.maleYOffset = this.defaultMaleYOffset;
            this.def.femaleYOffset = this.defaultFemaleYOffset;
            this.clearCaches();
            System.out.println("Model colors original: " + Arrays.toString(this.def.originalModelColors));
            System.out.println("Model colors new: " + Arrays.toString(this.def.newModelColor));
        });
        this.resetNpcData.setOnMouseClicked(x -> {
            this.npcDef.runAnim = this.defaultRunAnim;
            this.npcDef.standAnim = this.defaultStandAnim;
            this.npcDef.walkAnim = this.defaultWalkAnim;
            this.npcDef.sizeXZ = this.defaultXZSize;
            this.npcDef.sizeY = this.defaultYSize;
            this.npcDef.models = this.defaultNpcModels;
            this.npcDef.drawMinimapDot = this.defaultDrawDotSetting;
            this.npcDef.hasRenderPriority = this.defaultRenderPri;
            this.npcDef.headIcon = this.defaultHeadIcon;
            this.npcDef.combatLevel = this.defaultCombatLvl;
            this.npcDef.name = this.defaultNpcName;
            this.npcDef.squaresNeeded = this.defaultSquaresNeeded;
            this.npcDef.originalColours = this.defaultNpcColors;
            this.npcDef.destColours = this.defaultDestColors;
            NPCDef.modelCache.clear();
        });
    }

    private final class ColorWrapper {
        ItemDef definition;
        NPCDef npcDefinition;
        int initialColor;
        private Property<Color> targetColor;

        ColorWrapper(ItemDef definition, int occurences, int initialColor, int targetColor) {
            this.initialColor = initialColor;
            this.targetColor = new SimpleObjectProperty((Object)DefEditorSceneController.this.convert(targetColor));
            this.definition = definition;
            this.targetColor.addListener((observable, oldValue, newValue) -> this.changeColor((Color)newValue));
        }

        ColorWrapper(NPCDef npcDef, int occurences, int initialColor, int targetColor) {
            this.initialColor = initialColor;
            System.out.println("Set initialColor to: " + initialColor);
            this.targetColor = new SimpleObjectProperty((Object)DefEditorSceneController.this.convert(targetColor));
            this.npcDefinition = npcDef;
            this.targetColor.addListener((observable, oldValue, newValue) -> this.changeNpcColor((Color)newValue));
        }

        private void changeColor(Color color) {
            SwingUtilities.invokeLater(() -> {
                this.definition.recolor(this.initialColor, DefEditorSceneController.this.convert(color));
                System.out.println("Changed from color: " + this.initialColor + " to Color: " + DefEditorSceneController.this.convert((Color)this.targetColor.getValue()));
                DefEditorSceneController.this.clearCaches();
            });
        }

        private void changeNpcColor(Color color) {
            SwingUtilities.invokeLater(() -> {
                this.npcDefinition.recolor(this.initialColor, DefEditorSceneController.this.convert(color));
                System.out.println("Changed from npc color: " + this.initialColor + " to Color: " + DefEditorSceneController.this.convert((Color)this.targetColor.getValue()));
                DefEditorSceneController.this.clearCaches();
                NPCDef.modelCache.clear();
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColorWrapper that = (ColorWrapper)o;
            return this.initialColor == that.initialColor && Objects.equals(this.definition, that.definition) && Objects.equals(this.targetColor.getValue(), that.targetColor.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.definition, this.initialColor, this.targetColor.getValue());
        }
    }
}

