/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.net;

import com.aragon.client.Client;
import com.aragon.util.signlink;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUpdater {
    private static final String SERVER_URL = "https://aragonrsps.com/getLastModify.php";
    private static final String LOCAL_DIR = signlink.findcachedir();
    private static final String SAVE_FILE = String.valueOf(signlink.findcachedir()) + "last_updated.json";
    private static Map<String, Long> localFilesLastUpdated = new HashMap<String, Long>();
    private static final Gson gson = new Gson();
    private Client client;

    public FileUpdater(Client client) {
        this.client = client;
    }

    public void init() {
        System.out.println("Starting FileUpdater...");
        this.loadLastUpdatedTimes();
        try {
            long serverTime;
            String inputLine;
            URL url = new URL(SERVER_URL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            HashMap<String, Long> serverFilesLastUpdated = new HashMap<String, Long>();
            while ((inputLine = in.readLine()) != null) {
                String[] parts = inputLine.split("\\|");
                String fileName = parts[0];
                String serverLastModified = parts[1];
                if (serverLastModified.equals("not_found")) continue;
                serverTime = Long.parseLong(serverLastModified);
                serverFilesLastUpdated.put(fileName, serverTime);
            }
            in.close();
            for (Map.Entry entry : serverFilesLastUpdated.entrySet()) {
                long localTime;
                String fileName = (String)entry.getKey();
                serverTime = (Long)entry.getValue();
                if (serverTime <= (localTime = localFilesLastUpdated.getOrDefault(fileName, 0L).longValue())) continue;
                try {
                    this.downloadAndUpdateFile(fileName, serverTime);
                }
                catch (Exception e) {
                    System.err.println("Error downloading/updating file " + fileName + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
            this.saveLastUpdatedTimes();
        }
        catch (Exception e) {
            System.err.println("Error in main process: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("FileUpdater process completed.");
    }

    private void update(int percent, String status) {
        if (percent >= 100) {
            percent = 100;
        }
        this.client.setLoadingText(percent, String.valueOf(percent) + "% - " + status);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadAndUpdateFile(String fileName, long serverTime) {
        System.out.println("Starting download of " + fileName);
        try {
            block16: {
                URL url = new URL("https://aragonrsps.com/Aragon/" + fileName);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                int fileSize = conn.getContentLength();
                Throwable throwable = null;
                Object var8_9 = null;
                try {
                    InputStream inputStream = conn.getInputStream();
                    try {
                        try (FileOutputStream outputStream = new FileOutputStream(String.valueOf(LOCAL_DIR) + fileName);){
                            int bytesRead;
                            byte[] buffer = new byte[4096];
                            long totalBytesRead = 0L;
                            while ((bytesRead = inputStream.read(buffer)) != -1) {
                                outputStream.write(buffer, 0, bytesRead);
                                int progress = (int)((totalBytesRead += (long)bytesRead) * 100L / (long)fileSize);
                                this.update(progress, "Downloading " + fileName);
                                System.out.println("Downloading " + fileName + ": " + progress + "%");
                            }
                        }
                        if (inputStream == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            System.out.println("Finished downloading " + fileName);
            System.out.println("Starting to unzip " + fileName);
            this.unzipFile(String.valueOf(LOCAL_DIR) + fileName, fileName, LOCAL_DIR);
            Files.delete(Paths.get(String.valueOf(LOCAL_DIR) + fileName, new String[0]));
            localFilesLastUpdated.put(fileName, serverTime);
            return;
        }
        catch (Exception e) {
            System.err.println("Error downloading/updating file " + fileName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void unzipFile(String zipFilePath, String fileName, String destDir) {
        System.out.println("Unzipping file " + zipFilePath);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(Paths.get(zipFilePath, new String[0]), new OpenOption[0]));){
                ZipEntry entry;
                long totalSize = Files.size(Paths.get(zipFilePath, new String[0]));
                long extractedSize = 0L;
                int fileCount = 0;
                while ((entry = zipIn.getNextEntry()) != null) {
                    block24: {
                        String filePath = String.valueOf(destDir) + File.separator + entry.getName();
                        if (!entry.isDirectory()) {
                            File parentDir = new File(filePath).getParentFile();
                            if (parentDir != null && !parentDir.exists()) {
                                parentDir.mkdirs();
                            }
                            Throwable throwable2 = null;
                            Object var16_18 = null;
                            try (FileOutputStream fos = new FileOutputStream(filePath);){
                                int read;
                                byte[] bytesIn = new byte[4096];
                                while ((read = zipIn.read(bytesIn)) != -1) {
                                    fos.write(bytesIn, 0, read);
                                    int progress = (int)((extractedSize += (long)read) * 100L / totalSize);
                                    this.update(progress, "Unzipping " + fileName);
                                    System.out.println("Unzipping " + zipFilePath + ": " + progress + "%");
                                }
                                break block24;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        Files.createDirectories(Paths.get(filePath, new String[0]), new FileAttribute[0]);
                    }
                    zipIn.closeEntry();
                    ++fileCount;
                }
                System.out.println("Finished unzipping " + zipFilePath + " (" + fileCount + " files)");
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            System.err.println("Error unzipping file " + zipFilePath + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveLastUpdatedTimes() {
        System.out.println("Saving last updated times...");
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileWriter writer = new FileWriter(SAVE_FILE);){
                gson.toJson(localFilesLastUpdated, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Error saving last updated times: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadLastUpdatedTimes() {
        System.out.println("Loading last updated times...");
        File file = new File(SAVE_FILE);
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileReader reader = new FileReader(SAVE_FILE);){
                    Type type = new TypeToken<HashMap<String, Long>>(){}.getType();
                    localFilesLastUpdated = (Map)gson.fromJson((Reader)reader, type);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                System.err.println("Error loading last updated times: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            localFilesLastUpdated.put("sprites.zip", 0L);
            localFilesLastUpdated.put("data.zip", 0L);
            localFilesLastUpdated.put("main_file_cache.zip", 0L);
            localFilesLastUpdated.put("models.zip", 0L);
            localFilesLastUpdated.put("extras.zip", 0L);
        }
    }
}

