/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.net;

import com.aragon.client.Client;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CacheUpdateManager {
    private static final String API_URL = "https://aragonrsps.com";
    public static final String CACHE_DIR = String.valueOf(System.getProperty("user.home")) + "/.aragon-cache/";
    private static final String MANIFEST_FILE = String.valueOf(CACHE_DIR) + "patches-manifest.json";
    private final Gson gson = new Gson();
    private final Client client;

    public CacheUpdateManager(Client client) {
        this.client = client;
    }

    public static void main(String[] args) {
        try {
            CacheUpdateManager cacheUpdateManager = new CacheUpdateManager(null);
            cacheUpdateManager.checkAndUpdateCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkAndUpdateCache() {
        LatestVersionInfo serverInfo;
        String localVersion;
        block9: {
            block8: {
                try {
                    System.out.println("Checking for cache updates...");
                    File manifestFile = new File(MANIFEST_FILE);
                    localVersion = null;
                    if (manifestFile.exists()) {
                        localVersion = this.getLocalVersion();
                        System.out.println("Current local cache version: " + localVersion);
                    } else {
                        System.out.println("No local cache found - will download all patches");
                    }
                    serverInfo = this.getLatestVersionFromServer();
                    if (serverInfo != null && serverInfo.latestVersion != null) break block8;
                    System.err.println("Failed to connect to update server or invalid response.");
                    return false;
                }
                catch (Exception e) {
                    System.err.println("Cache update failed: " + e.getMessage());
                    e.printStackTrace();
                    return false;
                }
            }
            System.out.println("Server cache version: " + serverInfo.latestVersion);
            if (localVersion == null || !localVersion.equals(serverInfo.latestVersion)) break block9;
            System.out.println("Cache is up to date!");
            return true;
        }
        if (localVersion == null) {
            System.out.println("Downloading all patches...");
            this.downloadAllPatches(serverInfo);
        } else {
            System.out.println("Downloading updates from " + localVersion + " to " + serverInfo.latestVersion);
            this.downloadIncrementalPatches(localVersion, serverInfo.latestVersion);
        }
        this.updateLocalManifest(serverInfo.latestVersion);
        System.out.println("Cache update complete! Version: " + serverInfo.latestVersion);
        return true;
    }

    private String getLocalVersion() throws IOException {
        String content = new String(Files.readAllBytes(Paths.get(MANIFEST_FILE, new String[0])));
        JsonObject manifest = (JsonObject)this.gson.fromJson(content, JsonObject.class);
        if (manifest.has("version") && !manifest.get("version").isJsonNull()) {
            return manifest.get("version").getAsString();
        }
        System.err.println("Local manifest missing 'version' field \u2014 treating as fresh install.");
        return null;
    }

    private LatestVersionInfo getLatestVersionFromServer() {
        try {
            URL url = new URL("https://aragonrsps.com/api/cache/patches/latest");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            if (conn.getResponseCode() == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                System.out.println("Server JSON response: " + response);
                return (LatestVersionInfo)this.gson.fromJson(response.toString(), LatestVersionInfo.class);
            }
            System.err.println("Server returned: " + conn.getResponseCode());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void downloadAllPatches(LatestVersionInfo serverInfo) throws IOException {
        System.out.println("Downloading combined patches (all files)...");
        new File(CACHE_DIR).mkdirs();
        String requestBody = String.format("{\"from_version\":\"0.0.0\",\"to_version\":\"%s\"}", serverInfo.latestVersion);
        this.downloadAndExtractPatch("https://aragonrsps.com/api/cache/patches/download-combined", requestBody, "POST");
    }

    private void downloadIncrementalPatches(String fromVersion, String toVersion) throws IOException {
        System.out.println("Downloading incremental patches...");
        LatestVersionInfo serverInfo = this.getLatestVersionFromServer();
        if (serverInfo == null || serverInfo.patches == null) {
            throw new IOException("Failed to get patch list from server");
        }
        ArrayList<LatestVersionInfo.PatchInfo> patchesToDownload = new ArrayList<LatestVersionInfo.PatchInfo>();
        LatestVersionInfo.PatchInfo[] patchInfoArray = serverInfo.patches;
        int n = serverInfo.patches.length;
        int n2 = 0;
        while (n2 < n) {
            LatestVersionInfo.PatchInfo patch = patchInfoArray[n2];
            if (this.compareVersions(patch.version, fromVersion) > 0 && this.compareVersions(patch.version, toVersion) <= 0) {
                patchesToDownload.add(patch);
            }
            ++n2;
        }
        patchesToDownload.sort((p1, p2) -> this.compareVersions(p1.version, p2.version));
        int i = 0;
        while (i < patchesToDownload.size()) {
            LatestVersionInfo.PatchInfo patch = (LatestVersionInfo.PatchInfo)patchesToDownload.get(i);
            System.out.printf("Downloading patch %d/%d: v%s%n", i + 1, patchesToDownload.size(), patch.version);
            this.downloadAndExtractSinglePatch(patch.id);
            ++i;
        }
        System.out.println("All incremental patches downloaded successfully!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadAndExtractSinglePatch(int patchId) throws IOException {
        File tempZip;
        block15: {
            String urlString = "https://aragonrsps.com/api/cache/patches/" + patchId + "/download";
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(30000);
            if (conn.getResponseCode() != 200) throw new IOException("Failed to download patch " + patchId + ": " + conn.getResponseCode());
            tempZip = new File(String.valueOf(CACHE_DIR) + "temp_patch_" + patchId + ".zip");
            Throwable throwable = null;
            Object var7_8 = null;
            try {
                InputStream in = conn.getInputStream();
                try {
                    try (FileOutputStream out = new FileOutputStream(tempZip);){
                        byte[] buffer = new byte[8192];
                        long totalBytes = 0L;
                        while (true) {
                            int bytesRead;
                            if ((bytesRead = in.read(buffer)) == -1) {
                                System.out.println("Downloaded v" + patchId + ": " + totalBytes + " bytes");
                                break;
                            }
                            out.write(buffer, 0, bytesRead);
                            totalBytes += (long)bytesRead;
                        }
                    }
                    if (in == null) break block15;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.extractZipFile(tempZip, new File(CACHE_DIR));
        tempZip.delete();
    }

    private int compareVersions(String v1, String v2) {
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int length = Math.max(parts1.length, parts2.length);
        int i = 0;
        while (i < length) {
            int num2;
            int num1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = num2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (num1 != num2) {
                return num1 - num2;
            }
            ++i;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadAndExtractPatch(String urlString, String requestBody, String method) throws IOException {
        File tempZip;
        block24: {
            Throwable throwable;
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(method);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            if ("POST".equals(method) && requestBody != null) {
                Throwable throwable2 = null;
                throwable = null;
                try (OutputStream os = conn.getOutputStream();){
                    os.write(requestBody.getBytes("UTF-8"));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
            }
            if (conn.getResponseCode() != 200) throw new IOException("Failed to download patch: " + conn.getResponseCode());
            tempZip = new File(String.valueOf(CACHE_DIR) + "temp_patch.zip");
            throwable = null;
            Object var8_11 = null;
            try {
                InputStream in = conn.getInputStream();
                try {
                    try (FileOutputStream out = new FileOutputStream(tempZip);){
                        int fileSize = conn.getContentLength();
                        byte[] buffer = new byte[8192];
                        long totalBytes = 0L;
                        while (true) {
                            int bytesRead;
                            if ((bytesRead = in.read(buffer)) == -1) {
                                System.out.println("Download complete: " + totalBytes + " bytes");
                                break;
                            }
                            out.write(buffer, 0, bytesRead);
                            int progress = (int)((totalBytes += (long)bytesRead) * 100L / (long)fileSize);
                            this.update(progress, "Fetching update from server. ");
                            if (totalBytes % 0x100000L != 0L) continue;
                            System.out.println("Downloaded: " + totalBytes / 1024L / 1024L + " MB");
                        }
                    }
                    if (in == null) break block24;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        this.extractZipFile(tempZip, new File(CACHE_DIR));
        tempZip.delete();
    }

    private void extractZipFile(File zipFile, File destDir) throws IOException {
        System.out.println("Extracting patch files...");
        byte[] buffer = new byte[8192];
        int filesExtracted = 0;
        long totalSize = Files.size(Paths.get(zipFile.getAbsolutePath(), new String[0]));
        long extractedSize = 0L;
        Throwable throwable = null;
        Object var10_9 = null;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = new File(destDir, entry.getName());
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    new File(newFile.getParent()).mkdirs();
                    Throwable throwable2 = null;
                    Object var15_16 = null;
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                            int progress = (int)((extractedSize += (long)len) * 100L / totalSize);
                            this.update(progress, "Unpackaging cache files.");
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    if (++filesExtracted % 100 == 0) {
                        System.out.println("Extracted: " + filesExtracted + " files");
                    }
                }
                zis.closeEntry();
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        System.out.println("Extraction complete: " + filesExtracted + " files extracted");
    }

    private void updateLocalManifest(String version) throws IOException {
        if (version == null || version.isEmpty()) {
            System.err.println("Warning: Tried to update manifest with null/empty version!");
            version = "unknown";
        }
        JsonObject manifest = new JsonObject();
        manifest.addProperty("version", version);
        manifest.addProperty("updated_at", (Number)System.currentTimeMillis());
        Files.write(Paths.get(MANIFEST_FILE, new String[0]), this.gson.toJson((JsonElement)manifest).getBytes(), new OpenOption[0]);
        System.out.println("Updated local manifest to version: " + version);
    }

    private void update(int percent, String status) {
        if (percent >= 100) {
            percent = 100;
        }
        this.client.setLoadingText(percent, String.valueOf(percent) + "% - " + status);
    }

    private static class LatestVersionInfo {
        @SerializedName(value="latest_version")
        String latestVersion;
        PatchInfo[] patches;

        private LatestVersionInfo() {
        }

        static class PatchInfo {
            int id;
            String version;
            @SerializedName(value="is_base")
            boolean isBase;
            long size;
            @SerializedName(value="file_count")
            int fileCount;
            @SerializedName(value="created_at")
            String createdAt;
            String patchType;
            String basedOnVersion;
            long totalSize;
            long compressedSize;

            PatchInfo() {
            }
        }
    }
}

