/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics.sprite;

import com.aragon.cache.CacheArchive;
import com.aragon.cache.FileOperations;
import com.aragon.graphics.sprite.AnimatedSprite;
import com.aragon.graphics.sprite.Sprite;
import com.aragon.util.Stream;
import com.aragon.util.signlink;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class SpriteLoader {
    public static Map<String, AnimatedSprite> animatedSpriteMap = new HashMap<String, AnimatedSprite>();
    public static SpriteLoader[] cache;
    public static Sprite[] sprites;
    public static int totalSprites;
    public String name = "name";
    public int id = -1;
    public int drawOffsetX = 0;
    public int drawOffsetY = 0;
    public byte[] spriteData = null;

    static {
        sprites = null;
    }

    public static void loadSprites(CacheArchive CacheArchive2) {
        FilterInputStream indexFile = null;
        FilterInputStream dataFile = null;
        try {
            try {
                Stream index = new Stream(FileOperations.readFile(String.valueOf(signlink.findcachedir()) + "sprites.idx"));
                Stream data = new Stream(FileOperations.readFile(String.valueOf(signlink.findcachedir()) + "sprites.dat"));
                indexFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(index.buffer)));
                dataFile = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data.buffer)));
                int totalSprites = ((DataInputStream)indexFile).readInt();
                if (cache == null) {
                    cache = new SpriteLoader[totalSprites];
                    sprites = new Sprite[totalSprites];
                }
                int i = 0;
                while (i < totalSprites) {
                    int id = ((DataInputStream)indexFile).readInt();
                    if (cache[id] == null) {
                        SpriteLoader.cache[id] = new SpriteLoader();
                    }
                    cache[id].readValues((DataInputStream)dataFile, (DataInputStream)indexFile);
                    SpriteLoader.createSprite(cache[id], false);
                    ++i;
                }
                indexFile.close();
                dataFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (indexFile != null) {
                        indexFile.close();
                    }
                    if (dataFile != null) {
                        dataFile.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (indexFile != null) {
                    indexFile.close();
                }
                if (dataFile != null) {
                    dataFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void readValues(DataInputStream data, DataInputStream indexFile) throws IOException {
        byte opCode;
        while ((opCode = data.readByte()) != 0) {
            if (opCode == 1) {
                this.id = data.readShort();
                continue;
            }
            if (opCode == 2) {
                this.name = data.readUTF();
                continue;
            }
            if (opCode == 3) {
                this.drawOffsetX = data.readShort();
                continue;
            }
            if (opCode == 4) {
                this.drawOffsetY = data.readShort();
                continue;
            }
            if (opCode != 5) continue;
            byte[] dataread = new byte[indexFile.readInt()];
            data.readFully(dataread);
            this.spriteData = dataread;
        }
        return;
    }

    public static AnimatedSprite fetchAnimatedSprite(String location) {
        AnimatedSprite tempSprite;
        if (!animatedSpriteMap.containsKey(location) && (tempSprite = new AnimatedSprite(location)) != null) {
            animatedSpriteMap.put(location, tempSprite);
        }
        return animatedSpriteMap.get(location);
    }

    public static void createSprite(SpriteLoader sprite, boolean second) {
        File directory = new File(String.valueOf(signlink.findcachedir()) + "sprites");
        if (!directory.exists()) {
            directory.mkdir();
        }
        FileOperations.WriteFile(String.valueOf(directory.getAbsolutePath()) + System.getProperty("file.separator") + sprite.id + ".png", sprite.spriteData);
        if (!second) {
            SpriteLoader.sprites[sprite.id] = new Sprite(sprite.spriteData);
            SpriteLoader.sprites[sprite.id].drawOffsetX = sprite.drawOffsetX;
            SpriteLoader.sprites[sprite.id].drawOffsetY = sprite.drawOffsetY;
        }
    }

    public static String getName(int index) {
        if (SpriteLoader.cache[index].name != null) {
            return SpriteLoader.cache[index].name;
        }
        return "null";
    }

    public static int getOffsetX(int index) {
        return SpriteLoader.cache[index].drawOffsetX;
    }

    public static int getOffsetY(int index) {
        return SpriteLoader.cache[index].drawOffsetY;
    }
}

