/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics.sprite;

import com.aragon.cache.CacheArchive;
import com.aragon.client.Client;
import com.aragon.graphics.Background;
import com.aragon.graphics.DrawingArea;
import com.aragon.ui.RSInterface;
import com.aragon.util.Stream;
import com.aragon.util.signlink;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class Sprite
extends DrawingArea {
    public int movingX;
    public int movingY = 0;
    public boolean movedEnough = false;
    private boolean startedMoving = false;
    public int[] myPixels;
    public int myWidth;
    public int myHeight;
    public int drawOffsetX;
    public int drawOffsetY;
    public int maxWidth;
    public int maxHeight;

    public void outline(int color) {
        int[] raster = new int[this.myWidth * this.myHeight];
        int start = 0;
        int y = 0;
        while (y < this.myHeight) {
            int x = 0;
            while (x < this.myWidth) {
                int outline = this.myPixels[start];
                if (outline == 0) {
                    if (x > 0 && this.myPixels[start - 1] != 0) {
                        outline = color;
                    } else if (y > 0 && this.myPixels[start - this.myWidth] != 0) {
                        outline = color;
                    } else if (x < this.myWidth - 1 && this.myPixels[start + 1] != 0) {
                        outline = color;
                    } else if (y < this.myHeight - 1 && this.myPixels[start + this.myWidth] != 0) {
                        outline = color;
                    }
                }
                raster[start++] = outline;
                ++x;
            }
            ++y;
        }
        this.myPixels = raster;
    }

    public static Sprite fetchSprite(String name) {
        return Sprite.fetchSprite(name, RSInterface.spriteArchive);
    }

    public static Sprite fetchSprite(String name, CacheArchive graphics) {
        int index = name.lastIndexOf(",");
        return RSInterface.getSprite(Integer.parseInt(name.substring(index + 1)), graphics, name.substring(0, index));
    }

    public void shadow(int color) {
        int y = this.myHeight - 1;
        while (y > 0) {
            int pos = y * this.myWidth;
            int x = this.myWidth - 1;
            while (x > 0) {
                if (this.myPixels[x + pos] == 0 && this.myPixels[x + pos - 1 - this.myWidth] != 0) {
                    this.myPixels[x + pos] = color;
                }
                --x;
            }
            --y;
        }
    }

    public void setAlphaTransparency(int a) {
        int pixel = 0;
        while (pixel < this.myPixels.length) {
            if ((this.myPixels[pixel] >> 24 & 0xFF) == a) {
                this.myPixels[pixel] = 0;
            }
            ++pixel;
        }
    }

    public static Image scale(Image image, int width, int height) {
        return image.getScaledInstance(width, height, 1);
    }

    public static BufferedImage getScaledImage(Image loadingSprites, int w, int h, int origW, int origH) {
        BufferedImage resizedImage = new BufferedImage(w, h, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(loadingSprites, 0, 0, origW, origH, null);
        g.dispose();
        return resizedImage;
    }

    public Sprite(String var1, int dummy) {
        try {
            Image var2 = Toolkit.getDefaultToolkit().getImage(String.valueOf(signlink.findcachedir()) + "Sprites/" + var1 + ".png");
            ImageIcon var3 = new ImageIcon(var2);
            this.myWidth = var3.getIconWidth();
            this.maxHeight = this.myHeight = var3.getIconHeight();
            this.drawOffsetX = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber var6 = new PixelGrabber(var2, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            var6.grabPixels();
            var2 = null;
        }
        catch (Exception var5) {
            System.out.println(var5);
        }
    }

    public Sprite(URL url) {
        try {
            if (url == null) {
                return;
            }
            HttpURLConnection httpcon = (HttpURLConnection)url.openConnection();
            httpcon.addRequestProperty("User-Agent", "Mozilla/4.76");
            BufferedImage image = ImageIO.read(httpcon.getInputStream());
            this.myWidth = image.getWidth();
            this.myHeight = image.getHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            Object var3_4 = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Sprite(String string, int clientWidth, int clientHeight, boolean yas) {
        try {
            Image image = Client.resourceLoader.getImage(string);
            if (image == null) {
                return;
            }
            Image resize = Sprite.scale(image, clientWidth, clientHeight);
            ImageIcon sprite = new ImageIcon(resize);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(resize, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            resize = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public static Image downScaleImage(Image image, int width, int height) {
        return image.getScaledInstance(width, height, 4);
    }

    public static Image getImageFromArray(int[] pixels, int width, int height) {
        MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.createImage(mis);
    }

    public static Sprite getCutted(Sprite s, int width, int height) {
        try {
            Sprite sprite = new Sprite();
            Image image = Sprite.getImageFromArray(s.myPixels, s.myWidth, s.myHeight);
            sprite.myWidth = width;
            sprite.myHeight = height;
            sprite.maxWidth = sprite.myWidth;
            sprite.maxHeight = sprite.myHeight;
            sprite.drawOffsetX = 0;
            sprite.drawOffsetY = 0;
            sprite.myPixels = new int[sprite.myWidth * sprite.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, sprite.myWidth, sprite.myHeight, sprite.myPixels, 0, sprite.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            return sprite;
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
            return null;
        }
    }

    public static Sprite getResizedSprite(Sprite spriteParam, int width, int height) {
        if (width == 0) {
            width = 1;
        }
        if (height == 0) {
            height = 1;
        }
        Image img = Sprite.getImageFromArray(spriteParam.myPixels, spriteParam.myWidth, spriteParam.myHeight);
        Image img_2 = Sprite.downScaleImage(img, width, height);
        ImageIcon sprite = new ImageIcon(img_2);
        Sprite toReturn = new Sprite();
        toReturn.myWidth = sprite.getIconWidth();
        toReturn.myHeight = sprite.getIconHeight();
        toReturn.maxWidth = toReturn.myWidth;
        toReturn.maxHeight = toReturn.myHeight;
        toReturn.drawOffsetX = 0;
        toReturn.drawOffsetY = 0;
        toReturn.myPixels = new int[toReturn.myWidth * toReturn.myHeight];
        PixelGrabber pixelgrabber = new PixelGrabber(img_2, 0, 0, toReturn.myWidth, toReturn.myHeight, toReturn.myPixels, 0, toReturn.myWidth);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        img_2 = null;
        img = null;
        toReturn.setTransparency(255, 0, 255);
        toReturn.setTransparency(255, 255, 255);
        return toReturn;
    }

    public Sprite(int i, int j) {
        this.myPixels = new int[i * j];
        this.myWidth = this.maxWidth = i;
        this.myHeight = this.maxHeight = j;
        this.drawOffsetY = 0;
        this.drawOffsetX = 0;
    }

    public Sprite(byte[] spriteData) {
        try {
            Image image = Toolkit.getDefaultToolkit().createImage(spriteData);
            ImageIcon sprite = new ImageIcon(image);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
            this.setTransparency(255, 255, 255);
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public void drawMovingSprite(int finalCoordX, int finalCoordY, int startingX, int startingY, int speed, char coordToMove, boolean advancedSprite) {
        if (!this.startedMoving) {
            this.movingX = startingX;
            this.movingY = startingY;
            this.startedMoving = true;
        }
        if (!this.movedEnough) {
            if (coordToMove == 'y') {
                this.movingY += speed;
            }
            if (coordToMove == 'x') {
                this.movingX += speed;
            }
            if (coordToMove == 'b') {
                this.movingX += speed;
                this.movingY += speed;
            }
            if ((speed < 0 ? this.movingX <= finalCoordX : this.movingX >= finalCoordX) && (coordToMove == 'x' || coordToMove == 'b')) {
                this.movingX = finalCoordX;
                this.movedEnough = true;
            }
            if ((speed < 0 ? this.movingY <= finalCoordY : this.movingY >= finalCoordY) && (coordToMove == 'y' || coordToMove == 'b')) {
                this.movingY = finalCoordY;
                this.movedEnough = true;
            }
            this.setSprite(coordToMove == 'y' ? startingX : this.movingX, coordToMove == 'x' ? startingY : this.movingY, advancedSprite);
        } else {
            this.setSprite(coordToMove == 'y' ? startingX : this.movingX, coordToMove == 'x' ? startingY : this.movingY, advancedSprite);
        }
    }

    public void setSprite(int spriteX, int spriteY, boolean advancedSprite) {
        if (advancedSprite) {
            this.drawAdvancedSprite(spriteX, spriteY);
        } else {
            this.drawSprite(spriteX, spriteY);
        }
    }

    public void drawSprite1(int i, int j, int k) {
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public static Sprite resizeSprite(Sprite originalSprite, int newWidth, int newHeight) {
        int[] resizedPixels = new int[newWidth * newHeight];
        int originalWidth = originalSprite.myWidth;
        int originalHeight = originalSprite.myHeight;
        int[] originalPixels = originalSprite.myPixels;
        int y = 0;
        while (y < newHeight) {
            int scaledY = y * originalHeight / newHeight;
            int x = 0;
            while (x < newWidth) {
                int scaledX = x * originalWidth / newWidth;
                resizedPixels[x + y * newWidth] = originalPixels[scaledX + scaledY * originalWidth];
                ++x;
            }
            ++y;
        }
        Sprite resizedSprite = new Sprite();
        resizedSprite.myWidth = newWidth;
        resizedSprite.myHeight = newHeight;
        resizedSprite.myPixels = resizedPixels;
        resizedSprite.drawOffsetX = originalSprite.drawOffsetX;
        resizedSprite.drawOffsetY = originalSprite.drawOffsetY;
        return resizedSprite;
    }

    public void drawAdvancedSprite(int i, int j, int alpha) {
        int k = alpha;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.drawAlphaGlow(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawAdvancedSprite2(int i, int j, int alpha) {
        int k = alpha;
        int i1 = (i += this.myHeight) + (j += this.myWidth) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.drawAlphaGlow(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    private void drawAlphaGlow(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int op = k1;
        int k2 = -i1;
        while (k2 < 0) {
            int l2 = -j;
            while (l2 < 0) {
                int k;
                k1 = this.myPixels[i] >> 26 & op;
                int j2 = 256 - k1;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    ai[l1++] = ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                } else {
                    ++l1;
                }
                ++l2;
            }
            l1 += j1;
            i += l;
            ++k2;
        }
    }

    public void drawAdvancedSpriteGrayscaled(int i, int j, int alpha) {
        int k = alpha;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.drawGrayscaleAlphaGlow(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    private void drawGrayscaleAlphaGlow(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int op = k1;
        int k2 = -i1;
        while (k2 < 0) {
            int l2 = -j;
            while (l2 < 0) {
                int k;
                k1 = this.myPixels[i] >> 26 & op;
                int j2 = 256 - k1;
                if ((k = ai1[i++]) != 0) {
                    int red = k >> 16 & 0xFF;
                    int green = k >> 8 & 0xFF;
                    int blue = k & 0xFF;
                    int grayscale = (red + green + blue) / 3;
                    k = grayscale << 16 | grayscale << 8 | grayscale;
                    int i3 = ai[l1];
                    ai[l1++] = ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                } else {
                    ++l1;
                }
                ++l2;
            }
            l1 += j1;
            i += l;
            ++k2;
        }
    }

    public void drawHoverSprite(int x, int y, Sprite hover) {
        if (Client.instance.mouseX >= x && Client.instance.mouseX <= x + this.myWidth && Client.instance.mouseY >= y && Client.instance.mouseY <= y + this.myHeight) {
            hover.drawAdvancedSprite(x, y);
        } else {
            this.drawAdvancedSprite(x, y);
        }
    }

    public void drawAdvancedSprite(int i, int j) {
        this.autoUpdate();
        int k = 256;
        int i1 = i + j * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.drawAlphaSprite(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawAdvancedSpriteHover(int i, int j, int hoverAmount) {
        this.autoUpdate();
        int k = 256;
        int i1 = i + j * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.drawAlphaSpriteHover(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1, hoverAmount);
        }
    }

    private void drawAlphaSpriteHover(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1, int hoverAmount) {
        if (hoverAmount < 0) {
            hoverAmount = 0;
        }
        if (hoverAmount > 255) {
            hoverAmount = 255;
        }
        int k2 = -i1;
        while (k2 < 0) {
            int l2 = -j;
            while (l2 < 0) {
                int k;
                k1 = this.myPixels[i] >> 24 & 0xFF;
                int j2 = 256 - k1;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    int r = k >> 16 & 0xFF;
                    int g = k >> 8 & 0xFF;
                    int b = k & 0xFF;
                    r = Math.max(0, r - r * hoverAmount / 255);
                    g = Math.max(0, g - g * hoverAmount / 255);
                    b = Math.max(0, b - b * hoverAmount / 255);
                    int darkenedSprite = r << 16 | g << 8 | b;
                    ai[l1++] = ((darkenedSprite & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((darkenedSprite & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                } else {
                    ++l1;
                }
                ++l2;
            }
            l1 += j1;
            i += l;
            ++k2;
        }
    }

    public void drawCenteredARGBImage(int x, int y) {
        this.drawARGBImage(x - this.myWidth / 2, y - this.myHeight / 2);
    }

    public void drawARGBImage(int xPos, int yPos) {
        this.drawARGBSprite(xPos, yPos, 256);
    }

    public void drawARGBSprite(int xPos, int yPos, int alpha) {
        int alphaValue = alpha;
        int i1 = (xPos += this.drawOffsetX) + (yPos += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int spriteHeight = this.myHeight;
        int spriteWidth = this.myWidth;
        int i2 = DrawingArea.width - spriteWidth;
        int j2 = 0;
        if (yPos < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - yPos;
            spriteHeight -= k2;
            yPos = DrawingArea.clipTop;
            j1 += k2 * spriteWidth;
            i1 += k2 * DrawingArea.width;
        }
        if (yPos + spriteHeight > DrawingArea.clipBottom) {
            spriteHeight -= yPos + spriteHeight - DrawingArea.clipBottom;
        }
        if (xPos < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - xPos;
            spriteWidth -= l2;
            xPos = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + spriteWidth > DrawingArea.clipRight) {
            int i3 = xPos + spriteWidth - DrawingArea.clipRight;
            spriteWidth -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (spriteWidth > 0 && spriteHeight > 0) {
            this.renderARGBPixels(spriteWidth, spriteHeight, this.myPixels, DrawingArea.pixels, i1, alphaValue, j1, j2, i2);
        }
    }

    private void renderARGBPixels(int spriteWidth, int spriteHeight, int[] spritePixels, int[] renderAreaPixels, int pixel, int alphaValue, int i, int l, int j1) {
        int height = -spriteHeight;
        while (height < 0) {
            int width = -spriteWidth;
            while (width < 0) {
                int pixelLevel;
                alphaValue = this.myPixels[i] >> 24 & 0xFF;
                int alphaLevel = 256 - alphaValue;
                if ((pixelLevel = spritePixels[i++]) != 0) {
                    int pixelValue = renderAreaPixels[pixel];
                    renderAreaPixels[pixel++] = ((pixelLevel & 0xFF00FF) * alphaValue + (pixelValue & 0xFF00FF) * alphaLevel & 0xFF00FF00) + ((pixelLevel & 0xFF00) * alphaValue + (pixelValue & 0xFF00) * alphaLevel & 0xFF0000) >> 8;
                } else {
                    ++pixel;
                }
                ++width;
            }
            pixel += j1;
            i += l;
            ++height;
        }
    }

    private void drawAlphaSprite(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int k2 = -i1;
        while (k2 < 0) {
            int l2 = -j;
            while (l2 < 0) {
                int k;
                k1 = this.myPixels[i] >> 24 & 0xFF;
                int j2 = 256 - k1;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    ai[l1++] = ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                } else {
                    ++l1;
                }
                ++l2;
            }
            l1 += j1;
            i += l;
            ++k2;
        }
    }

    public Sprite(Image image) {
        try {
            ImageIcon sprite = new ImageIcon(image);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public Sprite(String img, int width, int height) {
        try {
            Image image;
            try {
                image = Client.resourceLoader.getImage(img);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (image == null) {
                return;
            }
            this.myWidth = width;
            this.myHeight = height;
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public Sprite(Image image, int width, int height) {
        try {
            if (image == null) {
                return;
            }
            this.myWidth = width;
            this.myHeight = height;
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public Sprite(String img) {
        try {
            Image image = Client.resourceLoader.getImage(img);
            if (image == null) {
                return;
            }
            ImageIcon sprite = new ImageIcon(image);
            this.myWidth = sprite.getIconWidth();
            this.myHeight = sprite.getIconHeight();
            this.maxWidth = this.myWidth;
            this.maxHeight = this.myHeight;
            this.drawOffsetX = 0;
            this.drawOffsetY = 0;
            this.myPixels = new int[this.myWidth * this.myHeight];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.myWidth, this.myHeight, this.myPixels, 0, this.myWidth);
            pixelgrabber.grabPixels();
            image = null;
            this.setTransparency(255, 0, 255);
            if (img.contains("Crowns")) {
                this.setTransparency(255, 255, 255);
            }
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
        }
    }

    public void setTransparency(int transRed, int transGreen, int transBlue) {
        int index = 0;
        while (index < this.myPixels.length) {
            if ((this.myPixels[index] >> 16 & 0xFF) == transRed && (this.myPixels[index] >> 8 & 0xFF) == transGreen && (this.myPixels[index] & 0xFF) == transBlue) {
                this.myPixels[index] = 0;
            }
            ++index;
        }
    }

    public Sprite(CacheArchive streamLoader, String s, int i) {
        Stream stream = new Stream(streamLoader.getDataForName(String.valueOf(s) + ".dat"));
        Stream stream_1 = new Stream(streamLoader.getDataForName("index.dat"));
        stream_1.currentOffset = stream.readUnsignedWord();
        this.maxWidth = stream_1.readUnsignedWord();
        this.maxHeight = stream_1.readUnsignedWord();
        int j = stream_1.readUnsignedByte();
        int[] ai = new int[j];
        int k = 0;
        while (k < j - 1) {
            ai[k + 1] = stream_1.read3Bytes();
            if (ai[k + 1] == 0) {
                ai[k + 1] = 1;
            }
            ++k;
        }
        int l = 0;
        while (l < i) {
            stream_1.currentOffset += 2;
            stream.currentOffset += stream_1.readUnsignedWord() * stream_1.readUnsignedWord();
            ++stream_1.currentOffset;
            ++l;
        }
        this.drawOffsetX = stream_1.readUnsignedByte();
        this.drawOffsetY = stream_1.readUnsignedByte();
        this.myWidth = stream_1.readUnsignedWord();
        this.myHeight = stream_1.readUnsignedWord();
        int i1 = stream_1.readUnsignedByte();
        int j1 = this.myWidth * this.myHeight;
        this.myPixels = new int[j1];
        if (i1 == 0) {
            int k1 = 0;
            while (k1 < j1) {
                this.myPixels[k1] = ai[stream.readUnsignedByte()];
                ++k1;
            }
            if (s.equals("mod_icons") && (i == 7 || i == 8 || i == 9)) {
                this.setTransparency(255, 255, 255);
            } else {
                this.setTransparency(255, 0, 255);
            }
            return;
        }
        if (i1 == 1) {
            int l1 = 0;
            while (l1 < this.myWidth) {
                int i2 = 0;
                while (i2 < this.myHeight) {
                    this.myPixels[l1 + i2 * this.myWidth] = ai[stream.readUnsignedByte()];
                    ++i2;
                }
                ++l1;
            }
        }
        if (s.equals("mod_icons") && (i == 7 || i == 8 || i == 9)) {
            this.setTransparency(255, 255, 255);
        } else {
            this.setTransparency(255, 0, 255);
        }
    }

    public void method343() {
        DrawingArea.initDrawingArea(this.myHeight, this.myWidth, this.myPixels);
    }

    public void decodePalette(int i, int j, int k) {
        this.autoUpdate();
        int i1 = 0;
        while (i1 < this.myPixels.length) {
            int j1 = this.myPixels[i1];
            if (j1 != 0) {
                int k1 = j1 >> 16 & 0xFF;
                if ((k1 += i) < 1) {
                    k1 = 1;
                } else if (k1 > 255) {
                    k1 = 255;
                }
                int l1 = j1 >> 8 & 0xFF;
                if ((l1 += j) < 1) {
                    l1 = 1;
                } else if (l1 > 255) {
                    l1 = 255;
                }
                int i2 = j1 & 0xFF;
                if ((i2 += k) < 1) {
                    i2 = 1;
                } else if (i2 > 255) {
                    i2 = 255;
                }
                this.myPixels[i1] = (k1 << 16) + (l1 << 8) + i2;
            }
            ++i1;
        }
    }

    public void method345() {
        this.autoUpdate();
        int[] ai = new int[this.maxWidth * this.maxHeight];
        int j = 0;
        while (j < this.myHeight) {
            System.arraycopy(this.myPixels, j * this.myWidth, ai, j + this.drawOffsetY * this.maxWidth + this.drawOffsetX, this.myWidth);
            ++j;
        }
        this.myPixels = ai;
        this.myWidth = this.maxWidth;
        this.myHeight = this.maxHeight;
        this.drawOffsetX = 0;
        this.drawOffsetY = 0;
    }

    public void method346(int i, int j) {
        this.autoUpdate();
        int l = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int i1 = 0;
        int j1 = this.myHeight;
        int k1 = this.myWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (j < DrawingArea.clipTop) {
            int j2 = DrawingArea.clipTop - j;
            j1 -= j2;
            j = DrawingArea.clipTop;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (j + j1 > DrawingArea.clipBottom) {
            j1 -= j + j1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int k2 = DrawingArea.clipLeft - i;
            k1 -= k2;
            i = DrawingArea.clipLeft;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.clipRight) {
            int l2 = i + k1 - DrawingArea.clipRight;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.block_copy(l, k1, j1, i2, i1, l1, this.myPixels, DrawingArea.pixels);
        }
    }

    public void block_copy(int i, int j, int k, int l, int i1, int k1, int[] ai, int[] ai1) {
        int l1 = -(j >> 2);
        j = -(j & 3);
        int i2 = -k;
        while (i2 < 0) {
            int j2 = l1;
            while (j2 < 0) {
                ai1[i++] = ai[i1++];
                ai1[i++] = ai[i1++];
                ai1[i++] = ai[i1++];
                ai1[i++] = ai[i1++];
                ++j2;
            }
            int k2 = j;
            while (k2 < 0) {
                ai1[i++] = ai[i1++];
                ++k2;
            }
            i += k1;
            i1 += l;
            ++i2;
        }
    }

    public void drawSprite1(int i, int j) {
        this.autoUpdate();
        int k = 128;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void saveSprite(int i, int j, String fileName) {
        this.autoUpdate();
        int k = 128;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            BufferedImage bufferedImage = new BufferedImage(l1, k1, 2);
            this.block_copy_alpha_to_image(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1, bufferedImage);
            try {
                File outputFile = new File(String.valueOf(signlink.findcachedir()) + "rsimg/dump/" + fileName + ".png");
                ImageIO.write((RenderedImage)bufferedImage, "png", outputFile);
                System.out.println("Sprite saved successfully to: " + outputFile.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void block_copy_alpha_to_image(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1, BufferedImage image) {
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                image.setRGB(x, y, 0);
                ++x;
            }
            ++y;
        }
        int j2 = 256 - k1;
        int k2 = 0;
        while (k2 < i1) {
            int l2 = 0;
            while (l2 < j) {
                int k;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    int pixelColor = ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                    int alpha = k != 0 ? 255 : 0;
                    int color = alpha << 24 | pixelColor & 0xFFFFFF;
                    image.setRGB(l2, k2, color);
                }
                ++l1;
                ++l2;
            }
            l1 += j1;
            i += l;
            ++k2;
        }
    }

    public void saveSpriteToImage(String filename) {
        BufferedImage image = new BufferedImage(this.myWidth, this.myHeight, 2);
        this.block_copy_alpha_to_image(0, this.myWidth, DrawingArea.pixels, this.myPixels, 0, this.myHeight, 0, 256, 0, image);
        try {
            File outFile = new File(String.valueOf(signlink.findcachedir()) + "rsimg/dump/" + filename + ".png");
            ImageIO.write((RenderedImage)image, "png", outFile);
            System.out.println("Saved sprite as " + filename + ".png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void drawTransparentSprite(int i, int j, int opacity) {
        int k = opacity;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void drawSpriteTEST(int i, int k) {
        int l = (i += this.drawOffsetX) + (k += this.drawOffsetY) * DrawingArea.width;
        int i1 = 0;
        int j1 = this.myHeight;
        int k1 = this.myWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (k < DrawingArea.clipTop) {
            int j2 = DrawingArea.clipTop - k;
            j1 -= j2;
            k = DrawingArea.clipTop;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (k + j1 > DrawingArea.clipBottom) {
            j1 -= k + j1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int k2 = DrawingArea.clipLeft - i;
            k1 -= k2;
            i = DrawingArea.clipLeft;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.clipRight) {
            int l2 = i + k1 - DrawingArea.clipRight;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.block_copy_trans(DrawingArea.pixels, this.myPixels, i1, l, k1, j1, l1, i2);
        }
    }

    public void drawSprite(int i, int k) {
        int l = (i += this.drawOffsetX) + (k += this.drawOffsetY) * DrawingArea.width;
        int i1 = 0;
        int j1 = this.myHeight;
        int k1 = this.myWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (k < DrawingArea.clipTop) {
            int j2 = DrawingArea.clipTop - k;
            j1 -= j2;
            k = DrawingArea.clipTop;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (k + j1 > DrawingArea.clipBottom) {
            j1 -= k + j1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int k2 = DrawingArea.clipLeft - i;
            k1 -= k2;
            i = DrawingArea.clipLeft;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.clipRight) {
            int l2 = i + k1 - DrawingArea.clipRight;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            try {
                this.block_copy_trans(DrawingArea.pixels, this.myPixels, i1, l, k1, j1, l1, i2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void drawSprite3(int x, int y, int opacity) {
        int alpha = opacity;
        int destOffset = (x += this.drawOffsetX) + (y += this.drawOffsetY) * DrawingArea.width;
        int srcOffset = 0;
        int height = this.myHeight;
        int width = this.myWidth;
        int destStep = DrawingArea.width - width;
        int srcStep = 0;
        if (y < DrawingArea.clipTop) {
            int trimHeight = DrawingArea.clipTop - y;
            height -= trimHeight;
            y = DrawingArea.clipTop;
            srcOffset += trimHeight * width;
            destOffset += trimHeight * DrawingArea.width;
        }
        if (y + height > DrawingArea.clipBottom) {
            height -= y + height - DrawingArea.clipBottom;
        }
        if (x < DrawingArea.clipLeft) {
            int trimLeft = DrawingArea.clipLeft - x;
            width -= trimLeft;
            x = DrawingArea.clipLeft;
            srcOffset += trimLeft;
            destOffset += trimLeft;
            srcStep += trimLeft;
            destStep += trimLeft;
        }
        if (x + width > DrawingArea.clipRight) {
            int trimRight = x + width - DrawingArea.clipRight;
            width -= trimRight;
            srcStep += trimRight;
            destStep += trimRight;
        }
        if (width > 0 && height > 0) {
            this.setPixels(width, height, DrawingArea.pixels, this.myPixels, alpha, destOffset, srcOffset, destStep, srcStep);
        }
    }

    private void setPixels(int width, int height, int[] destPixels, int[] srcPixels, int srcAlpha, int destOffset, int srcOffset, int destStep, int srcStep) {
        int rofl = srcAlpha;
        int loop = -height;
        while (loop < 0) {
            int loop2 = -width;
            while (loop2 < 0) {
                int srcColor;
                srcAlpha = this.myPixels[srcOffset] >> 24 & rofl;
                int destAlpha = 256 - srcAlpha;
                if ((srcColor = srcPixels[srcOffset++]) != 0 && srcColor != 0xFFFFFF) {
                    int destColor = destPixels[destOffset];
                    destPixels[destOffset++] = ((srcColor & 0xFF00FF) * srcAlpha + (destColor & 0xFF00FF) * destAlpha & 0xFF00FF00) + ((srcColor & 0xFF00) * srcAlpha + (destColor & 0xFF00) * destAlpha & 0xFF0000) >> 8;
                } else {
                    ++destOffset;
                }
                ++loop2;
            }
            destOffset += destStep;
            srcOffset += srcStep;
            ++loop;
        }
    }

    public void drawSprite(int i, int k, int color) {
        int y;
        this.autoUpdate();
        int tempWidth = this.myWidth + 2;
        int tempHeight = this.myHeight + 2;
        int[] tempArray = new int[tempWidth * tempHeight];
        int x = 0;
        while (x < this.myWidth) {
            y = 0;
            while (y < this.myHeight) {
                if (this.myPixels[x + y * this.myWidth] != 0) {
                    tempArray[x + 1 + (y + 1) * tempWidth] = this.myPixels[x + y * this.myWidth];
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < tempWidth) {
            y = 0;
            while (y < tempHeight) {
                if (tempArray[x + y * tempWidth] == 0) {
                    if (x < tempWidth - 1 && tempArray[x + 1 + y * tempWidth] > 0 && tempArray[x + 1 + y * tempWidth] != 0xFFFFFF) {
                        tempArray[x + y * tempWidth] = color;
                    }
                    if (x > 0 && tempArray[x - 1 + y * tempWidth] > 0 && tempArray[x - 1 + y * tempWidth] != 0xFFFFFF) {
                        tempArray[x + y * tempWidth] = color;
                    }
                    if (y < tempHeight - 1 && tempArray[x + (y + 1) * tempWidth] > 0 && tempArray[x + (y + 1) * tempWidth] != 0xFFFFFF) {
                        tempArray[x + y * tempWidth] = color;
                    }
                    if (y > 0 && tempArray[x + (y - 1) * tempWidth] > 0 && tempArray[x + (y - 1) * tempWidth] != 0xFFFFFF) {
                        tempArray[x + y * tempWidth] = color;
                    }
                }
                ++y;
            }
            ++x;
        }
        --i;
        --k;
        int l = (i += this.drawOffsetX) + (k += this.drawOffsetY) * DrawingArea.width;
        int i1 = 0;
        int j1 = tempHeight;
        int k1 = tempWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (k < DrawingArea.clipTop) {
            int j2 = DrawingArea.clipTop - k;
            j1 -= j2;
            k = DrawingArea.clipTop;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (k + j1 > DrawingArea.clipBottom) {
            j1 -= k + j1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int k2 = DrawingArea.clipLeft - i;
            k1 -= k2;
            i = DrawingArea.clipLeft;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.clipRight) {
            int l2 = i + k1 - DrawingArea.clipRight;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.block_copy_trans(DrawingArea.pixels, tempArray, i1, l, k1, j1, l1, i2);
        }
    }

    public void drawSprite2(int i, int j) {
        int k = 225;
        int i1 = (i += this.drawOffsetX) + (j += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (j < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - j;
            k1 -= k2;
            j = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (j + k1 > DrawingArea.clipBottom) {
            k1 -= j + k1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - i;
            l1 -= l2;
            i = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (i + l1 > DrawingArea.clipRight) {
            int i3 = i + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, k, i1);
        }
    }

    public void block_copy_trans(int[] ai, int[] ai1, int j, int k, int l, int i1, int j1, int k1) {
        int l1 = -(l >> 2);
        l = -(l & 3);
        int i2 = -i1;
        while (i2 < 0) {
            int i;
            int j2 = l1;
            while (j2 < 0) {
                if ((i = ai1[j++]) != 0 && i != -1) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                i = ai1[j++];
                if (i != 0 && i != -1) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                ++j2;
            }
            int k2 = l;
            while (k2 < 0) {
                if ((i = ai1[j++]) != 0 && i != -1) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                ++k2;
            }
            k += j1;
            j += k1;
            ++i2;
        }
    }

    public void block_copy_alpha(int i, int j, int[] ai, int[] ai1, int l, int i1, int j1, int k1, int l1) {
        int j2 = 256 - k1;
        int k2 = -i1;
        while (k2 < 0) {
            int l2 = -j;
            while (l2 < 0) {
                int k;
                if ((k = ai1[i++]) != 0) {
                    int i3 = ai[l1];
                    ai[l1++] = ((k & 0xFF00FF) * k1 + (i3 & 0xFF00FF) * j2 & 0xFF00FF00) + ((k & 0xFF00) * k1 + (i3 & 0xFF00) * j2 & 0xFF0000) >> 8;
                } else {
                    ++l1;
                }
                ++l2;
            }
            l1 += j1;
            i += l;
            ++k2;
        }
    }

    public void rotate(int dimension, int rotation, int[] yPosArray, int zoom, int[] xPosArray, int basePosition, int yPosition, int xPosition, int dimension_1, int middle) {
        this.autoUpdate();
        try {
            int j2 = -dimension_1 / 2;
            int k2 = -dimension / 2;
            int l2 = (int)(Math.sin((double)rotation / 326.11) * 65536.0);
            int i3 = (int)(Math.cos((double)rotation / 326.11) * 65536.0);
            l2 = l2 * zoom >> 8;
            i3 = i3 * zoom >> 8;
            int j3 = (middle << 16) + (k2 * l2 + j2 * i3);
            int k3 = (basePosition << 16) + (k2 * i3 - j2 * l2);
            int l3 = xPosition + yPosition * DrawingArea.width;
            yPosition = 0;
            while (yPosition < dimension) {
                int i4 = xPosArray[yPosition];
                int j4 = l3 + i4;
                int k4 = j3 + i3 * i4;
                int l4 = k3 - l2 * i4;
                xPosition = -yPosArray[yPosition];
                while (xPosition < 0) {
                    DrawingArea.pixels[j4++] = this.myPixels[(k4 >> 16) + (l4 >> 16) * this.myWidth];
                    k4 += i3;
                    l4 -= l2;
                    ++xPosition;
                }
                j3 += l2;
                k3 += i3;
                l3 += DrawingArea.width;
                ++yPosition;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rotate(int y, double d, int x) {
        this.autoUpdate();
        int j = 15;
        int k = 20;
        int l = 15;
        int j1 = 256;
        int k1 = 20;
        try {
            int i2 = -k / 2;
            int j2 = -k1 / 2;
            int k2 = (int)(Math.sin(d) * 65536.0);
            int l2 = (int)(Math.cos(d) * 65536.0);
            k2 = k2 * j1 >> 8;
            l2 = l2 * j1 >> 8;
            int i3 = (l << 16) + (j2 * k2 + i2 * l2);
            int j3 = (j << 16) + (j2 * l2 - i2 * k2);
            int k3 = x + y * DrawingArea.width;
            y = 0;
            while (y < k1) {
                int l3 = k3;
                int i4 = i3;
                int j4 = j3;
                x = -k;
                while (x < 0) {
                    int k4 = this.myPixels[(i4 >> 16) + (j4 >> 16) * this.myWidth];
                    if (k4 != 0) {
                        DrawingArea.pixels[l3++] = k4;
                    } else {
                        ++l3;
                    }
                    i4 += l2;
                    j4 -= k2;
                    ++x;
                }
                i3 += k2;
                j3 += l2;
                k3 += DrawingArea.width;
                ++y;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawSpriteRotated(int i, int k, double angle) {
        i += this.drawOffsetX;
        k += this.drawOffsetY;
        double radians = Math.toRadians(angle);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        int centerX = this.myWidth / 2;
        int centerY = this.myHeight / 2;
        int[] cornersX = new int[4];
        int[] cornersY = new int[4];
        int[][] corners = new int[][]{{-centerX, -centerY}, {this.myWidth - centerX, -centerY}, {this.myWidth - centerX, this.myHeight - centerY}, {-centerX, this.myHeight - centerY}};
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int c = 0;
        while (c < 4) {
            cornersX[c] = (int)((double)corners[c][0] * cos - (double)corners[c][1] * sin);
            cornersY[c] = (int)((double)corners[c][0] * sin + (double)corners[c][1] * cos);
            minX = Math.min(minX, cornersX[c]);
            maxX = Math.max(maxX, cornersX[c]);
            minY = Math.min(minY, cornersY[c]);
            maxY = Math.max(maxY, cornersY[c]);
            ++c;
        }
        int rotatedWidth = maxX - minX;
        int rotatedHeight = maxY - minY;
        int startX = i + minX;
        int startY = k + minY;
        int clipLeft = Math.max(startX, DrawingArea.clipLeft);
        int clipRight = Math.min(startX + rotatedWidth, DrawingArea.clipRight);
        int clipTop = Math.max(startY, DrawingArea.clipTop);
        int clipBottom = Math.min(startY + rotatedHeight, DrawingArea.clipBottom);
        if (clipLeft >= clipRight || clipTop >= clipBottom) {
            return;
        }
        int y = clipTop;
        while (y < clipBottom) {
            int x = clipLeft;
            while (x < clipRight) {
                int pixelIndex;
                int pixel;
                int relX = x - i;
                int relY = y - k;
                int srcX = (int)((double)relX * cos + (double)relY * sin + (double)centerX);
                int srcY = (int)((double)(-relX) * sin + (double)relY * cos + (double)centerY);
                if (srcX >= 0 && srcX < this.myWidth && srcY >= 0 && srcY < this.myHeight && (pixel = this.myPixels[pixelIndex = srcX + srcY * this.myWidth]) != 0 && pixel != -1) {
                    int destIndex = x + y * DrawingArea.width;
                    DrawingArea.pixels[destIndex] = pixel;
                }
                ++x;
            }
            ++y;
        }
    }

    public void drawSpriteRotatedScaled(int i, int k, double angle, double scale) {
        i += this.drawOffsetX;
        k += this.drawOffsetY;
        double radians = Math.toRadians(angle);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        int centerX = this.myWidth / 2;
        int centerY = this.myHeight / 2;
        int scaledWidth = (int)((double)this.myWidth * scale);
        int scaledHeight = (int)((double)this.myHeight * scale);
        int scaledCenterX = scaledWidth / 2;
        int scaledCenterY = scaledHeight / 2;
        int[][] corners = new int[][]{{-scaledCenterX, -scaledCenterY}, {scaledWidth - scaledCenterX, -scaledCenterY}, {scaledWidth - scaledCenterX, scaledHeight - scaledCenterY}, {-scaledCenterX, scaledHeight - scaledCenterY}};
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int c = 0;
        while (c < 4) {
            int rotX = (int)((double)corners[c][0] * cos - (double)corners[c][1] * sin);
            int rotY = (int)((double)corners[c][0] * sin + (double)corners[c][1] * cos);
            minX = Math.min(minX, rotX);
            maxX = Math.max(maxX, rotX);
            minY = Math.min(minY, rotY);
            maxY = Math.max(maxY, rotY);
            ++c;
        }
        int rotatedWidth = maxX - minX;
        int rotatedHeight = maxY - minY;
        int startX = i + minX;
        int startY = k + minY;
        int clipLeft = Math.max(startX, DrawingArea.clipLeft);
        int clipRight = Math.min(startX + rotatedWidth, DrawingArea.clipRight);
        int clipTop = Math.max(startY, DrawingArea.clipTop);
        int clipBottom = Math.min(startY + rotatedHeight, DrawingArea.clipBottom);
        if (clipLeft >= clipRight || clipTop >= clipBottom) {
            return;
        }
        int y = clipTop;
        while (y < clipBottom) {
            int x = clipLeft;
            while (x < clipRight) {
                int pixelIndex;
                int pixel;
                int relX = x - i;
                int relY = y - k;
                double unrotX = (double)relX * cos + (double)relY * sin;
                double unrotY = (double)(-relX) * sin + (double)relY * cos;
                int srcX = (int)(unrotX / scale + (double)centerX);
                int srcY = (int)(unrotY / scale + (double)centerY);
                if (srcX >= 0 && srcX < this.myWidth && srcY >= 0 && srcY < this.myHeight && (pixel = this.myPixels[pixelIndex = srcX + srcY * this.myWidth]) != 0 && pixel != -1) {
                    int destIndex = x + y * DrawingArea.width;
                    DrawingArea.pixels[destIndex] = pixel;
                }
                ++x;
            }
            ++y;
        }
    }

    public void draw(Background background, int i, int j) {
        this.autoUpdate();
        int k = (j += this.drawOffsetX) + (i += this.drawOffsetY) * DrawingArea.width;
        int l = 0;
        int i1 = this.myHeight;
        int j1 = this.myWidth;
        int k1 = DrawingArea.width - j1;
        int l1 = 0;
        if (i < DrawingArea.clipTop) {
            int i2 = DrawingArea.clipTop - i;
            i1 -= i2;
            i = DrawingArea.clipTop;
            l += i2 * j1;
            k += i2 * DrawingArea.width;
        }
        if (i + i1 > DrawingArea.clipBottom) {
            i1 -= i + i1 - DrawingArea.clipBottom;
        }
        if (j < DrawingArea.clipLeft) {
            int j2 = DrawingArea.clipLeft - j;
            j1 -= j2;
            j = DrawingArea.clipLeft;
            l += j2;
            k += j2;
            l1 += j2;
            k1 += j2;
        }
        if (j + j1 > DrawingArea.clipRight) {
            int k2 = j + j1 - DrawingArea.clipRight;
            j1 -= k2;
            l1 += k2;
            k1 += k2;
        }
        if (j1 > 0 && i1 > 0) {
            this.block_copy_mask(this.myPixels, j1, background.imgPixels, i1, DrawingArea.pixels, 0, k1, k, l1, l);
        }
    }

    public void greyScale() {
        int index = 0;
        while (index < this.myWidth * this.myHeight) {
            int alpha = this.myPixels[index] >>> 24;
            int red = this.myPixels[index] >>> 16 & 0xFF;
            int green = this.myPixels[index] >>> 8 & 0xFF;
            int blue = this.myPixels[index] & 0xFF;
            int delta = (red + green + blue) / 3;
            this.myPixels[index] = delta | delta << 8 | delta << 16 | alpha << 24;
            ++index;
        }
    }

    public void drawSpriteWithOpacity(int xPos, int yPos, int o) {
        int opacity = o;
        int i1 = (xPos += this.drawOffsetX) + (yPos += this.drawOffsetY) * DrawingArea.width;
        int j1 = 0;
        int k1 = this.myHeight;
        int l1 = this.myWidth;
        int i2 = DrawingArea.width - l1;
        int j2 = 0;
        if (yPos < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - yPos;
            k1 -= k2;
            yPos = DrawingArea.clipTop;
            j1 += k2 * l1;
            i1 += k2 * DrawingArea.width;
        }
        if (yPos + k1 > DrawingArea.clipBottom) {
            k1 -= yPos + k1 - DrawingArea.clipBottom;
        }
        if (xPos < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - xPos;
            l1 -= l2;
            xPos = DrawingArea.clipLeft;
            j1 += l2;
            i1 += l2;
            j2 += l2;
            i2 += l2;
        }
        if (xPos + l1 > DrawingArea.clipRight) {
            int i3 = xPos + l1 - DrawingArea.clipRight;
            l1 -= i3;
            j2 += i3;
            i2 += i3;
        }
        if (l1 > 0 && k1 > 0) {
            this.block_copy_alpha(j1, l1, DrawingArea.pixels, this.myPixels, j2, k1, i2, opacity, i1);
        }
    }

    public void block_copy_mask(int[] ai, int i, int[] abyte0, int j, int[] ai1, int k, int l, int i1, int j1, int k1) {
        int l1 = -(i >> 2);
        i = -(i & 3);
        int j2 = -j;
        while (j2 < 0) {
            int k2 = l1;
            while (k2 < 0) {
                if ((k = ai[k1++]) != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                } else {
                    ++i1;
                }
                k = ai[k1++];
                if (k != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                } else {
                    ++i1;
                }
                ++k2;
            }
            int l2 = i;
            while (l2 < 0) {
                if ((k = ai[k1++]) != 0 && abyte0[i1] == 0) {
                    ai1[i1++] = k;
                } else {
                    ++i1;
                }
                ++l2;
            }
            i1 += l;
            k1 += j1;
            ++j2;
        }
    }

    public void drawARGBSprite(int xPos, int yPos) {
        this.drawARGBSprite(xPos, yPos, 256);
    }

    public void autoUpdate() {
    }

    public Sprite() {
    }

    public void repeatBoth(int x, int y, int width, int height) {
        int rows = (int)Math.ceil((float)height / (float)this.myHeight);
        int cols = (int)Math.ceil((float)width / (float)this.myWidth);
        int yy = 0;
        while (yy < rows) {
            int xx = 0;
            while (xx < cols) {
                int xDraw = this.myWidth * xx;
                int yDraw = this.myHeight * yy;
                if (xDraw + this.myWidth > width) {
                    xDraw = width - this.myWidth;
                }
                if (yDraw + this.myHeight > height) {
                    yDraw = height - this.myHeight;
                }
                this.drawSprite(x + xDraw, y + yDraw);
                ++xx;
            }
            ++yy;
        }
    }

    public int repeatX(int x, int y, int width) {
        int count = (int)Math.ceil((float)width / (float)this.myWidth);
        int x2 = 0;
        int i = 0;
        while (i < count) {
            if (x2 + this.myWidth > width) {
                x2 = width - this.myWidth;
            }
            this.drawSprite(x + x2, y);
            x2 += this.myWidth;
            ++i;
        }
        return x2;
    }

    public int repeatY(int x, int y, int height) {
        int count = (int)Math.ceil((float)height / (float)this.myHeight);
        int y2 = 0;
        int i = 0;
        while (i < count) {
            if (y2 + this.myHeight > height) {
                y2 = height - this.myHeight;
            }
            this.drawSprite(x, y + y2);
            y2 += this.myHeight;
            ++i;
        }
        return y2;
    }

    public int repeatYRotated(int x, int y, int height, double angle) {
        int count = (int)Math.ceil((float)height / (float)this.myHeight);
        int y2 = 0;
        int i = 0;
        while (i < count) {
            if (y2 + this.myHeight > height) {
                y2 = height - this.myHeight;
            }
            this.drawSpriteRotated(x, y + y2, angle);
            y2 += this.myHeight;
            ++i;
        }
        return y2;
    }

    public int repeatXRotated(int x, int y, int width, double angle) {
        int count = (int)Math.ceil((float)width / (float)this.myWidth);
        int x2 = 0;
        int i = 0;
        while (i < count) {
            if (x2 + this.myWidth > width) {
                x2 = width - this.myWidth;
            }
            this.drawSpriteRotated(x + x2, y, angle);
            x2 += this.myWidth;
            ++i;
        }
        return x2;
    }

    public void repeatGridRotated(int x, int y, int width, int height, double angle) {
        double radians = Math.toRadians(angle);
        double cos = Math.abs(Math.cos(radians));
        double sin = Math.abs(Math.sin(radians));
        int rotatedWidth = (int)((double)this.myWidth * cos + (double)this.myHeight * sin);
        int rotatedHeight = (int)((double)this.myWidth * sin + (double)this.myHeight * cos);
        int countX = (int)Math.ceil((float)width / (float)rotatedWidth);
        int countY = (int)Math.ceil((float)height / (float)rotatedHeight);
        int row = 0;
        while (row < countY) {
            int y2 = row * rotatedHeight;
            if (y2 + rotatedHeight > height) {
                y2 = height - rotatedHeight;
            }
            int col = 0;
            while (col < countX) {
                int x2 = col * rotatedWidth;
                if (x2 + rotatedWidth > width) {
                    x2 = width - rotatedWidth;
                }
                this.drawSpriteRotated(x + x2, y + y2, angle);
                ++col;
            }
            ++row;
        }
    }
}

