/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics.particle;

public class ParticleVector {
    public static final ParticleVector ZERO = new ParticleVector(0, 0, 0);
    private int x;
    private int y;
    private int z;

    public ParticleVector(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    public final ParticleVector subtract(ParticleVector other) {
        return new ParticleVector(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public final ParticleVector divide(float scalar) {
        return new ParticleVector((int)((float)this.x / scalar), (int)((float)this.y / scalar), (int)((float)this.z / scalar));
    }

    public final ParticleVector addLocal(ParticleVector other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public final ParticleVector clone() {
        return new ParticleVector(this.x, this.y, this.z);
    }

    public final String toString() {
        return "ParticleVector{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

