/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics.particle;

import com.aragon.graphics.particle.ParticleVector;
import com.aragon.graphics.particle.PointSpawnShape;
import com.aragon.graphics.particle.SpawnShape;
import com.aragon.graphics.sprite.Sprite;
import java.util.Random;

public class ParticleDefinition {
    public static final Random RANDOM = new Random(System.currentTimeMillis());
    private ParticleVector gravity;
    private float startSize = 1.0f;
    private float endSize = 1.0f;
    public int particleDepth;
    private int startColor = -1;
    private int firstColor = -1;
    private int secondColor = -1;
    private int thirdColor = -1;
    private int fourthColor = -1;
    private int fifthColor = -1;
    private boolean changingColors;
    private int endColor = -1;
    private ParticleVector startVelocity = ParticleVector.ZERO;
    private ParticleVector endVelocity = ParticleVector.ZERO;
    private SpawnShape spawnShape = new PointSpawnShape(ParticleVector.ZERO);
    private float startAlpha = 1.0f;
    private float endAlpha = 0.05f;
    private int lifeSpan = 1;
    private int spawnRate = 1;
    private Sprite sprite;
    private ParticleVector velocityStep;
    private int colorStep;
    private float sizeStep;
    private float alphaStep;
    public int colorIndex = 0;
    public int[] colors;
    public static ParticleDefinition[] cache = new ParticleDefinition[]{new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -2, 0));
            this.setEndVelocity(new ParticleVector(0, -2, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(2840219);
            this.setSpawnRate(4);
            this.setStartSize(1.25f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.095f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -2, 0));
            this.setEndVelocity(new ParticleVector(0, -2, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(16767232);
            this.setSpawnRate(4);
            this.setStartSize(1.25f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.095f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(1, -1, 1));
            this.setEndVelocity(new ParticleVector(1, -1, 1));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(9883875);
            this.setSpawnRate(1);
            this.setStartSize(1.7f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(0);
            this.setSpawnRate(4);
            this.setStartSize(1.25f);
            this.setEndSize(0.11f);
            this.setStartAlpha(0.02f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(40);
            this.setSpawnRate(1);
            this.setStartColor(16747520);
            this.setStartSize(1.0f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(1, -1, 0));
            this.setEndVelocity(new ParticleVector(1, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(250);
            this.setStartColor(6889425);
            this.setSpawnRate(1);
            this.setStartSize(1.7f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(40);
            this.setStartColor(5178115);
            this.setSpawnRate(1);
            this.setStartSize(0.7f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(19);
            this.setStartColor(14696468);
            this.setSpawnRate(1);
            this.setStartSize(0.6f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(75);
            this.setStartColor(14696468);
            this.setSpawnRate(1);
            this.setStartSize(1.1f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColors(16545804, 15041033, 16753458, 13531666, 14372122, 16728832, 15039010);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(50);
            this.setStartColor(16194820);
            this.setSpawnRate(1);
            this.setStartSize(1.05f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColors(16194820, 15541003, 11901848);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(30);
            this.setStartColor(16352536);
            this.setSpawnRate(1);
            this.setStartSize(0.55f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(40);
            this.setStartColor(3116098);
            this.setSpawnRate(1);
            this.setStartSize(0.7f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(30);
            this.setStartColor(8306926);
            this.setSpawnRate(1);
            this.setStartSize(0.55f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(141);
            this.setStartColor(15865109);
            this.setEndColor(0);
            this.setSpawnRate(1);
            this.setStartSize(1.2f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColorStep(0);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(135);
            this.setStartColor(15865109);
            this.setSpawnRate(1);
            this.setStartSize(1.1f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColors(15865109, 9184549, 7495262);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(48);
            this.setStartColor(15865109);
            this.setSpawnRate(1);
            this.setStartSize(0.85f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColors(15865109, 9184549, 7495262);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(48);
            this.setStartColor(15567895);
            this.setSpawnRate(1);
            this.setStartSize(0.85f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColors(6709595, 6709595, 15567895);
        }
    }, new ParticleDefinition(){
        {
            this.setStartVelocity(new ParticleVector(0, -1, 0));
            this.setEndVelocity(new ParticleVector(0, -1, 0));
            this.setGravity(new ParticleVector(0, 0, 0));
            this.setLifeSpan(300);
            this.setStartColor(15567895);
            this.setSpawnRate(1);
            this.setStartSize(0.85f);
            this.setEndSize(0.0f);
            this.setStartAlpha(0.1f);
            this.initializeSteps();
            this.setColors(6709595, 6709595, 15567895);
        }
    }};

    public void setColors(int ... colors) {
        this.colors = colors;
    }

    public boolean hasChangingColors() {
        return this.changingColors;
    }

    public void setChangingColors() {
        this.changingColors = true;
    }

    public int getNextColor() {
        int index = this.colorIndex++ % this.colors.length;
        int color = this.colors[index];
        return color;
    }

    public void increaseColor() {
        if (++this.colorIndex >= this.colors.length) {
            this.colorIndex = 0;
        }
    }

    public int getColor() {
        return this.colors[this.colorIndex];
    }

    public boolean areColorsSet() {
        return this.colors != null;
    }

    public final SpawnShape getSpawnedShape() {
        return this.spawnShape;
    }

    public final float getStartAlpha() {
        return this.startAlpha;
    }

    public final void setStartAlpha(float startAlpha) {
        this.startAlpha = startAlpha;
    }

    public final float getAlphaStep() {
        return this.alphaStep;
    }

    public final Sprite getSprite() {
        return this.sprite;
    }

    public final void setSprite(Sprite sprite) {
        this.sprite = sprite;
    }

    public final int getSpawnRate() {
        return this.spawnRate;
    }

    public final void setSpawnRate(int spawnRate) {
        this.spawnRate = spawnRate;
    }

    public final void setStartSize(float startSize) {
        this.startSize = startSize;
    }

    public final float getStartSize() {
        return this.startSize;
    }

    public float getEndSize() {
        return this.endSize;
    }

    public int getEndColor() {
        return this.endColor;
    }

    public final void setEndSize(float endSize) {
        this.endSize = endSize;
    }

    public final int getStartColor() {
        return this.startColor;
    }

    public final int getFirstColor() {
        return this.firstColor;
    }

    public final int getSecondColor() {
        return this.secondColor;
    }

    public final int getThirdColor() {
        return this.thirdColor;
    }

    public final int getFourthColor() {
        return this.fourthColor;
    }

    public final int getFifthColor() {
        return this.fifthColor;
    }

    public final void setFirstColor(int firstColor) {
        this.firstColor = firstColor;
    }

    public final void setSecondColor(int secondColor) {
        this.secondColor = secondColor;
    }

    public final void setThirdColor(int thirdColor) {
        this.thirdColor = thirdColor;
    }

    public final void setFourthColor(int fourthColor) {
        this.fourthColor = fourthColor;
    }

    public final void setFifthColor(int fifthColor) {
        this.fifthColor = fifthColor;
    }

    public final void setStartColor(int startColor) {
        this.startColor = startColor;
    }

    public final void setEndColor(int endColor) {
        this.endColor = endColor;
    }

    public int randomWithRange(int min, int max) {
        int range = max - min + 1;
        return (int)(Math.random() * (double)range) + min;
    }

    public final ParticleVector getStartVelocity(int id) {
        return new ParticleVector(this.startVelocity.getX() + this.randomWithRange(-1, 1), this.startVelocity.getY() + this.randomWithRange(0, 0), this.startVelocity.getZ() + this.randomWithRange(-1, 1));
    }

    public ParticleVector getGravity() {
        return this.gravity;
    }

    public void setGravity(ParticleVector gravity) {
        this.gravity = gravity;
    }

    public final void setStartVelocity(ParticleVector startVelocity) {
        this.startVelocity = startVelocity;
    }

    public ParticleVector getEndVelocity() {
        return this.endVelocity;
    }

    public final void setEndVelocity(ParticleVector endVelocity) {
        this.endVelocity = endVelocity;
    }

    public final int getLifeSpan() {
        return this.lifeSpan;
    }

    public final void setLifeSpan(int lifeSpan) {
        this.lifeSpan = lifeSpan;
    }

    public final void setColorStep(int colorStep) {
        this.colorStep = colorStep;
    }

    public final float getSizeStep() {
        return this.sizeStep;
    }

    public final ParticleVector getVelocityStep() {
        return this.velocityStep;
    }

    public final int getColorStep() {
        return this.colorStep;
    }

    public void redrawParticle() {
        this.velocityStep = this.endVelocity.subtract(this.startVelocity).divide(this.lifeSpan);
        this.alphaStep = (this.endAlpha - this.startAlpha) / (float)this.lifeSpan;
        this.sizeStep = (this.endSize - this.startSize) / ((float)this.lifeSpan * 1.0f);
    }

    public void initializeSteps() {
        this.sizeStep = (this.endSize - this.startSize) / ((float)this.lifeSpan * 1.0f);
        this.colorStep = (this.endColor - this.startColor) / this.lifeSpan;
        this.velocityStep = this.endVelocity.subtract(this.startVelocity).divide(this.lifeSpan);
        this.alphaStep = (this.endAlpha - this.startAlpha) / (float)this.lifeSpan;
    }
}

