/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics.animation;

import com.aragon.entity.Animable;
import com.aragon.graphics.animation.FrameReader;
import com.aragon.graphics.animation.SpotAnim;
import com.aragon.graphics.model.Model;

public final class StillGraphic
extends Animable {
    public final int plane;
    public final int xTile;
    public final int yTile;
    public final int drawHeight;
    public final int startTime;
    public boolean animFinished = false;
    private final SpotAnim gfx;
    private int currentFrame;
    private int tick;

    public StillGraphic(int i, int j, int l, int gfxId, int height, int k1, int l1) {
        this.gfx = SpotAnim.cache[gfxId];
        this.plane = i;
        this.xTile = l1;
        this.yTile = k1;
        this.drawHeight = height;
        this.startTime = j + l;
        this.animFinished = false;
    }

    @Override
    public Model getRotatedModel() {
        Model model = this.gfx.getModel();
        if (model == null) {
            return null;
        }
        int frameToPlay = this.gfx.animation.frameIDs[this.currentFrame];
        Model animableModel = new Model(true, FrameReader.isNullFrame(frameToPlay), false, model);
        if (!this.animFinished) {
            animableModel.createBones();
            animableModel.applyTransform(frameToPlay);
            animableModel.triangleSkin = null;
            animableModel.vertexSkin = null;
        }
        if (this.gfx.getSizeXY() != 128 || this.gfx.getSizeZ() != 128) {
            animableModel.scaleT(this.gfx.getSizeXY(), this.gfx.getSizeXY(), this.gfx.getSizeZ());
        }
        if (this.gfx.rotation != 0) {
            if (this.gfx.rotation == 90) {
                animableModel.rotateBy90();
            }
            if (this.gfx.rotation == 180) {
                animableModel.rotateBy90();
                animableModel.rotateBy90();
            }
            if (this.gfx.rotation == 270) {
                animableModel.rotateBy90();
                animableModel.rotateBy90();
                animableModel.rotateBy90();
            }
        }
        animableModel.light(64 + this.gfx.shadow, 5050 + this.gfx.lightness, -90, -580, -90, true);
        return animableModel;
    }

    public void processAnimation(int i) {
        this.tick += i;
        while (this.tick > this.gfx.animation.getFrameLength(this.currentFrame)) {
            this.tick -= this.gfx.animation.getFrameLength(this.currentFrame) + 1;
            ++this.currentFrame;
            if (this.currentFrame < this.gfx.animation.frameCount || this.currentFrame >= 0 && this.currentFrame < this.gfx.animation.frameCount) continue;
            this.currentFrame = 0;
            this.animFinished = true;
        }
    }
}

