/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics.animation;

import com.aragon.cache.CacheArchive;
import com.aragon.graphics.animation.Animation;
import com.aragon.graphics.model.Model;
import com.aragon.util.MemCache;
import com.aragon.util.Stream;
import com.aragon.util.signlink;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;

public final class SpotAnim {
    private static final int CUSTOM_GFX_COUNT = 100;
    private static int FIRST_CUSTOM_GFX_ID;
    private static int LAST_CUSTOM_GFX_ID;
    private static int smallRot;
    private static int bigRot;
    public int anInt400;
    public static SpotAnim[] cache;
    @Expose
    private int id;
    @Expose
    private int modelId;
    @Expose
    private int animationId;
    public Animation animation;
    @Expose
    public int[] originalColours;
    @Expose
    public int[] destColours;
    @Expose
    private int sizeXY;
    @Expose
    private int sizeZ;
    @Expose
    public int rotation;
    @Expose
    public int shadow;
    @Expose
    public int lightness;
    public static MemCache modelCache;
    @Expose
    public double multiplierWidth = 1.0;
    @Expose
    public double multiplierHeight = 1.0;
    private static final Gson GSON;
    private static final Type TYPE;
    private static final Path PATH;

    static {
        smallRot = 0;
        bigRot = 0;
        modelCache = new MemCache(30);
        GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
        TYPE = new TypeToken<HashSet<SpotAnim>>(){}.getType();
        PATH = Paths.get(signlink.findcachedir(), "custom_gfx.json");
    }

    public static void unpackConfig(CacheArchive streamLoader) {
        Stream stream = new Stream(streamLoader.getDataForName("spotanim.dat"));
        int length = stream.readUnsignedWord();
        if (cache == null) {
            cache = new SpotAnim[length + 100];
        }
        FIRST_CUSTOM_GFX_ID = LAST_CUSTOM_GFX_ID = length;
        int j = 0;
        while (j < length) {
            if (cache[j] == null) {
                SpotAnim.cache[j] = new SpotAnim(j);
            }
            cache[j].setId(j);
            cache[j].readValues(stream);
            ++j;
        }
        SpotAnim.editExistinGFX();
        System.out.println("GFX: " + smallRot + ", " + bigRot);
        try {
            SpotAnim.loadCustomGFXes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SpotAnim createNewGFX() {
        SpotAnim newGfx = new SpotAnim(++LAST_CUSTOM_GFX_ID);
        return newGfx;
    }

    public static SpotAnim createNewGFXFrom(int toCopy) {
        SpotAnim newGfx = cache[toCopy].copy(++LAST_CUSTOM_GFX_ID);
        return newGfx;
    }

    public void setTexture(Model model, int gfxId) {
        switch (gfxId) {
            case 2998: 
            case 3012: {
                model.setTexture(51);
                break;
            }
            case 3003: {
                model.setTexture(40);
                break;
            }
            case 3002: {
                model.setTexture(58);
                break;
            }
            case 3004: 
            case 3010: {
                model.setTexture(59);
                break;
            }
            case 3005: {
                model.setTexture(52);
                break;
            }
            case 3006: {
                model.setTexture(57);
                break;
            }
            case 3009: {
                model.setTexture(40);
            }
        }
    }

    private static void editExistinGFX() {
        cache[500].setSizeXY(250);
        cache[500].setSizeZ(250);
        cache[1044].setModelId(20390);
        SpotAnim.cache[1044].animationId = 5358;
        cache[1044].setSizeXY(112);
        cache[1044].setSizeZ(112);
        SpotAnim.cache[1044].rotation = 0;
        SpotAnim.cache[1044].shadow = 0;
        SpotAnim.cache[1044].lightness = 0;
        int[] nArray = new int[6];
        nArray[0] = 22476;
        nArray[1] = 25511;
        SpotAnim.cache[1044].originalColours = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = 30608;
        nArray2[1] = 30236;
        SpotAnim.cache[1044].destColours = nArray2;
        SpotAnim.cache[1044].animation = Animation.anims[5358];
        cache[1048].setModelId(14116);
        SpotAnim.cache[1048].animationId = 5358;
        cache[1048].setSizeXY(60);
        cache[1048].setSizeZ(60);
        SpotAnim.cache[1048].shadow = 60;
        cache[1050].setModelId(14117);
        SpotAnim.cache[1050].animationId = 5358;
        cache[1050].setSizeXY(40);
        cache[1050].setSizeZ(40);
        SpotAnim.cache[1050].shadow = 60;
        cache[1051].setModelId(14119);
        SpotAnim.cache[1051].animationId = 3358;
        cache[1051].setSizeXY(40);
        cache[1051].setSizeZ(40);
        SpotAnim.cache[1051].shadow = 90;
        cache[1052].setModelId(25090);
        SpotAnim.cache[1052].animationId = 5358;
        cache[1052].setSizeXY(120);
        cache[1052].setSizeZ(120);
        SpotAnim.cache[1052].shadow = 60;
        cache[1053].setModelId(20390);
        SpotAnim.cache[1053].animationId = 5358;
        cache[1053].setSizeXY(112);
        cache[1053].setSizeZ(112);
        SpotAnim.cache[1053].rotation = 0;
        SpotAnim.cache[1053].shadow = 0;
        SpotAnim.cache[1053].lightness = 0;
        int[] nArray3 = new int[6];
        nArray3[0] = 22476;
        nArray3[1] = 25511;
        SpotAnim.cache[1053].originalColours = nArray3;
        int[] nArray4 = new int[6];
        nArray4[0] = 818;
        nArray4[1] = 6199;
        SpotAnim.cache[1053].destColours = nArray4;
        SpotAnim.cache[1053].animation = Animation.anims[5358];
        cache[1054].setModelId(21590);
        SpotAnim.cache[1054].animationId = 5358;
        SpotAnim.cache[1054].animationId = 5358;
        cache[1054].setSizeXY(112);
        cache[1054].setSizeZ(112);
        SpotAnim.cache[1054].rotation = 0;
        SpotAnim.cache[1054].shadow = 0;
        SpotAnim.cache[1054].lightness = 0;
        int[] nArray5 = new int[6];
        nArray5[0] = 22476;
        nArray5[1] = 25511;
        SpotAnim.cache[1054].originalColours = nArray5;
        int[] nArray6 = new int[6];
        nArray6[0] = 818;
        nArray6[1] = 6199;
        SpotAnim.cache[1054].destColours = nArray6;
        SpotAnim.cache[1054].animation = Animation.anims[5358];
        cache[1055].setModelId(27968);
        SpotAnim.cache[1055].animationId = 5358;
        SpotAnim.cache[1055].animationId = 5358;
        cache[1055].setSizeXY(32);
        cache[1055].setSizeZ(32);
        SpotAnim.cache[1055].rotation = 30;
        SpotAnim.cache[1055].shadow = 60;
        SpotAnim.cache[1055].lightness = 60;
        SpotAnim.cache[1055].animation = Animation.anims[5358];
        cache[1056].setModelId(1109);
        SpotAnim.cache[1056].rotation = 0;
        cache[1049].setModelId(14118);
        SpotAnim.cache[1049].animationId = 5358;
        cache[1049].setSizeXY(60);
        cache[1049].setSizeZ(60);
        SpotAnim.cache[1049].shadow = 60;
        cache[1047].setModelId(20390);
        SpotAnim.cache[1047].animationId = 5358;
        cache[1047].setSizeXY(112);
        cache[1047].setSizeZ(112);
        SpotAnim.cache[1047].rotation = 0;
        SpotAnim.cache[1047].shadow = 0;
        SpotAnim.cache[1047].lightness = 0;
        int[] nArray7 = new int[6];
        nArray7[0] = 22476;
        nArray7[1] = 25511;
        SpotAnim.cache[1047].originalColours = nArray7;
        int[] nArray8 = new int[6];
        nArray8[0] = 127;
        nArray8[1] = 10355;
        SpotAnim.cache[1047].destColours = nArray8;
        SpotAnim.cache[1047].animation = Animation.anims[5358];
        cache[2274].setModelId(cache[2281].getModelId());
        SpotAnim.cache[2274].animationId = SpotAnim.cache[2281].animationId;
        SpotAnim.cache[2274].rotation = 90;
        SpotAnim.cache[2274].animation = SpotAnim.cache[2281].animation;
    }

    private void readValues(Stream stream) {
        int i;
        block0: while ((i = stream.readUnsignedByte()) != 0) {
            if (i == 1) {
                this.setModelId(stream.readUnsignedWord());
                continue;
            }
            if (i == 2) {
                this.animationId = stream.readUnsignedWord();
                if (Animation.anims == null) continue;
                this.animation = Animation.anims[this.animationId];
                continue;
            }
            if (i == 4) {
                this.setSizeXY(stream.readUnsignedWord());
                continue;
            }
            if (i == 5) {
                this.setSizeZ(stream.readUnsignedWord());
                continue;
            }
            if (i == 6) {
                this.rotation = stream.readUnsignedWord();
                if (this.rotation > bigRot) {
                    bigRot = this.rotation;
                }
                if (this.rotation >= smallRot) continue;
                smallRot = this.rotation;
                continue;
            }
            if (i == 7) {
                this.shadow = stream.readUnsignedByte();
                continue;
            }
            if (i == 8) {
                this.lightness = stream.readUnsignedByte();
                continue;
            }
            if (i == 40) {
                int j = stream.readUnsignedByte();
                int k = 0;
                while (true) {
                    if (k >= j) continue block0;
                    this.originalColours[k] = stream.readUnsignedWord();
                    this.destColours[k] = stream.readUnsignedWord();
                    ++k;
                }
            }
            System.out.println("Error unrecognised spotanim config code: " + i);
        }
        return;
    }

    public Model getModel() {
        Model model = (Model)modelCache.get(this.getId());
        if (model != null) {
            return model;
        }
        model = Model.fetchModel(this.getModelId());
        if (model == null) {
            return null;
        }
        int length = Math.max(this.originalColours.length, this.destColours.length);
        int i = 0;
        while (i < length) {
            if (i < this.originalColours.length && i < this.destColours.length) {
                model.recolour(this.originalColours[i], this.destColours[i]);
            }
            ++i;
        }
        this.setTexture(model, this.getId());
        modelCache.put(model, this.getId());
        return model;
    }

    public SpotAnim copy(int newId) {
        SpotAnim copied = new SpotAnim(newId);
        copied.anInt400 = this.anInt400;
        copied.setModelId(this.modelId);
        copied.animationId = this.animationId;
        copied.animation = this.animation;
        copied.originalColours = new int[this.originalColours.length];
        copied.destColours = new int[this.destColours.length];
        System.arraycopy(this.originalColours, 0, copied.originalColours, 0, this.originalColours.length);
        System.arraycopy(this.destColours, 0, copied.destColours, 0, this.destColours.length);
        copied.setSizeXY(this.sizeXY);
        copied.setSizeZ(this.sizeZ);
        copied.rotation = this.rotation;
        copied.shadow = this.shadow;
        copied.lightness = this.lightness;
        return copied;
    }

    public void removeRecolors() {
        this.originalColours = new int[6];
        this.destColours = new int[6];
    }

    public void brighten(double multiplier) {
        this.lightness = (int)((double)this.lightness * multiplier);
    }

    public void darken(double multiplier) {
        this.shadow *= this.shadow;
    }

    public void rotate(int angleAmount) {
        this.rotation += angleAmount;
    }

    public void setMultiplierWidth(double multiplierWidth) {
        this.multiplierWidth = multiplierWidth;
    }

    public void setMultiplierHeight(double multiplierHeight) {
        this.multiplierHeight = multiplierHeight;
    }

    public void recolor(int targetColor, int newColor) {
        int firstFreeSlot = this.originalColours.length;
        int i = 0;
        while (i < this.originalColours.length) {
            if (this.originalColours[i] == 0) {
                firstFreeSlot = i;
            }
            if (this.originalColours[i] == targetColor) {
                this.destColours[i] = newColor;
                return;
            }
            ++i;
        }
        if (firstFreeSlot == this.originalColours.length) {
            int newLength = firstFreeSlot + 1;
            int[] targetColors = new int[newLength];
            int[] newColors = new int[newLength];
            System.arraycopy(this.originalColours, 0, targetColors, 0, firstFreeSlot);
            System.arraycopy(this.destColours, 0, newColors, 0, firstFreeSlot);
            this.originalColours = targetColors;
            this.destColours = newColors;
        }
        this.originalColours[firstFreeSlot] = targetColor;
        this.destColours[firstFreeSlot] = newColor;
    }

    public void setAnimation(int animationId) {
        this.animationId = animationId;
        this.animation = Animation.anims[animationId];
    }

    public void cacheAnimation() {
        if (this.animationId >= 0) {
            this.animation = Animation.anims[this.animationId];
        }
    }

    public void cache() {
        SpotAnim.cache[this.getId()] = this;
    }

    private SpotAnim(int id) {
        this.setId(id);
        this.anInt400 = 9;
        this.animationId = -1;
        this.originalColours = new int[6];
        this.destColours = new int[6];
        this.setSizeXY(128);
        this.setSizeZ(128);
    }

    public int getModelId() {
        return this.modelId;
    }

    public void setModelId(int modelId) {
        this.modelId = modelId;
    }

    public int getSizeXY() {
        return (int)((double)this.sizeXY * this.multiplierWidth);
    }

    public void setSizeXY(int sizeXY) {
        this.sizeXY = sizeXY;
    }

    public int getSizeZ() {
        return (int)((double)this.sizeZ * this.multiplierHeight);
    }

    public void setSizeZ(int sizeZ) {
        this.sizeZ = sizeZ;
    }

    public String toString() {
        return "SpotAnim [anInt400=" + this.anInt400 + ", id=" + this.getId() + ", modelId=" + this.modelId + ", animationId=" + this.animationId + ", " + (this.animation != null ? "animation=" + this.animation + ", " : "") + (this.originalColours != null ? "originalColours=" + Arrays.toString(this.originalColours) + ", " : "") + (this.destColours != null ? "destColours=" + Arrays.toString(this.destColours) + ", " : "") + "sizeXY=" + this.getSizeXY() + ", sizeZ=" + this.getSizeZ() + ", rotation=" + this.rotation + ", shadow=" + this.shadow + ", lightness=" + this.lightness + "]";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private static void loadCustomGFXes() throws IOException {
        File file = PATH.toFile();
        FileReader reader = new FileReader(file);
        HashSet customGFXs = (HashSet)GSON.fromJson((Reader)reader, TYPE);
        for (SpotAnim custom : customGFXs) {
            if (custom == null) continue;
            custom.cacheAnimation();
            custom.cache();
            if (custom.id <= LAST_CUSTOM_GFX_ID) continue;
            LAST_CUSTOM_GFX_ID = custom.id;
        }
        System.out.println("[SpotAnim]: loaded " + customGFXs.size() + " customs.");
    }

    public static void saveCustomGFXes() throws IOException {
        HashSet<SpotAnim> customGFXs = new HashSet<SpotAnim>();
        File file = PATH.toFile();
        if (file.createNewFile()) {
            System.out.println("[SpotAnim] Created a new file for custom gfxes at '" + PATH.toString() + "'");
        }
        FileWriter writer = new FileWriter(file);
        int i = FIRST_CUSTOM_GFX_ID;
        while (i <= LAST_CUSTOM_GFX_ID) {
            SpotAnim custom = cache[i];
            if (custom != null) {
                customGFXs.add(custom);
            }
            ++i;
        }
        GSON.toJson(customGFXs, TYPE, (Appendable)writer);
        writer.flush();
        writer.close();
    }
}

