/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics;

import com.aragon.client.Client;
import com.aragon.util.Stream;

public final class Texture {
    private static Texture[] cache = new Texture[678];
    public int[][] mipmaps = new int[8][];
    private static double brightness;

    public static final Texture get(int index) {
        if (index < 0 || index >= cache.length) {
            return null;
        }
        if (cache[index] == null) {
            Client.instance.onDemandFetcher.requestFileData(5, index);
            return null;
        }
        return cache[index];
    }

    public static final void decode(int index, byte[] data) {
        Texture texture = Texture.cache[index] = new Texture();
        Stream buffer = new Stream(data);
        int width = buffer.readUnsignedWord();
        int height = buffer.readUnsignedWord();
        texture.mipmaps[0] = new int[16384];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int rgb = buffer.read3Bytes();
                if (width <= 64 && height <= 64) {
                    int x2 = x << 1;
                    int y2 = y << 1;
                    texture.set(x2, y2, rgb);
                    texture.set(x2 + 1, y2, rgb);
                    texture.set(x2 + 1, y2 + 1, rgb);
                    texture.set(x2, y2 + 1, rgb);
                } else {
                    texture.set(x, y, rgb);
                }
                ++x;
            }
            ++y;
        }
        texture.generate();
    }

    public static void setBrightness(double value) {
        brightness = value;
    }

    private void set(int x, int y, int rgb) {
        if (x < 128 && y < 128) {
            this.mipmaps[0][x + (y << 7)] = Texture.adjustBrightness(rgb, brightness / 1.25);
        }
    }

    private static int adjustBrightness(int rgb, double brightness) {
        int r = (int)(Math.pow((double)(rgb >>> 16) / 256.0, brightness) * 256.0) << 16;
        int g = (int)(Math.pow((double)(rgb >>> 8 & 0xFF) / 256.0, brightness) * 256.0) << 8;
        int b = (int)(Math.pow((double)(rgb & 0xFF) / 256.0, brightness) * 256.0);
        return r | g | b;
    }

    private void generate() {
        int level = 1;
        int size = 64;
        while (level < 8) {
            int[] src = this.mipmaps[level - 1];
            this.mipmaps[level] = new int[size * size];
            int[] dst = this.mipmaps[level];
            int x = 0;
            while (x < size) {
                int y = 0;
                while (y < size) {
                    double r = 0.0;
                    double g = 0.0;
                    double b = 0.0;
                    int count = 0;
                    int[] nArray = new int[]{src[x + (y * size << 1) << 1], src[(x + (y * size << 1) << 1) + 1], src[(x + (y * size << 1) << 1) + (size << 1)], src[(x + (y * size << 1) << 1) + (size << 1) + 1]};
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int rgb = nArray[n2];
                        if (rgb != 0) {
                            double dr = (double)(rgb >> 16 & 0xFF) / 255.0;
                            double dg = (double)(rgb >> 8 & 0xFF) / 255.0;
                            double db = (double)(rgb & 0xFF) / 255.0;
                            r += dr * dr;
                            g += dg * dg;
                            b += db * db;
                            ++count;
                        }
                        ++n2;
                    }
                    if (count != 0) {
                        int ri = Math.round(255.0f * (float)Math.sqrt(r / (double)count));
                        int gi = Math.round(255.0f * (float)Math.sqrt(g / (double)count));
                        int bi = Math.round(255.0f * (float)Math.sqrt(b / (double)count));
                        dst[x + y * size] = ri << 16 | gi << 8 | bi;
                    }
                    ++y;
                }
                ++x;
            }
            size >>= 1;
            ++level;
        }
    }

    public static final void reset() {
        cache = null;
    }
}

