/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics;

import com.aragon.cache.CacheArchive;
import com.aragon.graphics.DrawingArea;
import com.aragon.util.Stream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class TextDrawingArea
extends DrawingArea {
    int hexColor = 0;
    public byte[][] aByteArrayArray1491;
    public int[] anIntArray1492;
    public int[] anIntArray1493;
    public int[] anIntArray1494;
    public int[] anIntArray1495;
    public int[] anIntArray1496;
    public int[] rsb;
    public int anInt1497;
    public Random aRandom1498;
    public boolean aBoolean1499;

    public TextDrawingArea(boolean flag, String s, CacheArchive streamLoader) {
        try {
            int length = s.equals("hit_full") || s.equals("critical_full") ? 58 : 256;
            this.aByteArrayArray1491 = new byte[length][];
            this.anIntArray1492 = new int[length];
            this.anIntArray1493 = new int[length];
            this.anIntArray1494 = new int[length];
            this.anIntArray1495 = new int[length];
            this.rsb = new int[length];
            this.aRandom1498 = new Random();
            this.aBoolean1499 = false;
            Stream stream = new Stream(streamLoader.getDataForName(String.valueOf(s) + ".dat"));
            Stream stream_1 = new Stream(streamLoader.getDataForName("index.dat"));
            stream_1.currentOffset = stream.readUnsignedWord() + 4;
            int k = stream_1.readUnsignedByte();
            if (k > 0) {
                stream_1.currentOffset += 3 * (k - 1);
            }
            int l = 0;
            while (l < length) {
                this.anIntArray1494[l] = stream_1.readUnsignedByte();
                this.anIntArray1495[l] = stream_1.readUnsignedByte();
                int i1 = this.anIntArray1492[l] = stream_1.readUnsignedWord();
                int j1 = this.anIntArray1493[l] = stream_1.readUnsignedWord();
                int k1 = stream_1.readUnsignedByte();
                int l1 = i1 * j1;
                this.aByteArrayArray1491[l] = new byte[l1];
                if (k1 == 0) {
                    int i2 = 0;
                    while (i2 < l1) {
                        this.aByteArrayArray1491[l][i2] = stream.readSignedByte();
                        ++i2;
                    }
                } else if (k1 == 1) {
                    int j2 = 0;
                    while (j2 < i1) {
                        int l2 = 0;
                        while (l2 < j1) {
                            this.aByteArrayArray1491[l][j2 + l2 * i1] = stream.readSignedByte();
                            ++l2;
                        }
                        ++j2;
                    }
                }
                if (j1 > this.anInt1497 && l < 128) {
                    this.anInt1497 = j1;
                }
                this.anIntArray1494[l] = 1;
                this.rsb[l] = i1 + 2;
                int k2 = 0;
                int i3 = j1 / 7;
                while (i3 < j1) {
                    k2 += this.aByteArrayArray1491[l][i3 * i1];
                    ++i3;
                }
                if (k2 <= j1 / 7) {
                    int n = l;
                    this.rsb[n] = this.rsb[n] - 1;
                    this.anIntArray1494[l] = 0;
                }
                k2 = 0;
                int j3 = j1 / 7;
                while (j3 < j1) {
                    k2 += this.aByteArrayArray1491[l][i1 - 1 + j3 * i1];
                    ++j3;
                }
                if (k2 <= j1 / 7) {
                    int n = l;
                    this.rsb[n] = this.rsb[n] - 1;
                }
                ++l;
            }
            if (flag) {
                if (this.rsb.length > 73) {
                    this.rsb[32] = this.rsb[73];
                }
            } else if (this.rsb.length > 105) {
                this.rsb[32] = this.rsb[105];
            }
        }
        catch (Exception _ex) {
            _ex.printStackTrace();
            System.out.println("Error loading font: " + s);
        }
    }

    public void method389(boolean flag, int i, int j, String s, int k) {
        this.aBoolean1499 = false;
        int l = i;
        if (s == null) {
            return;
        }
        k -= this.anInt1497;
        int i1 = 0;
        while (i1 < s.length()) {
            if (s.charAt(i1) == '@' && i1 + 4 < s.length() && s.charAt(i1 + 4) == '@') {
                int j1 = this.getColorByName(s.substring(i1 + 1, i1 + 4));
                if (j1 != -1) {
                    j = j1;
                }
                i1 += 4;
            } else {
                char c = s.charAt(i1);
                if (c != ' ') {
                    if (flag) {
                        this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] + 1, k + this.anIntArray1495[c] + 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    }
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c], k + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], j);
                }
                i += this.anIntArray1496[c];
            }
            ++i1;
        }
        if (this.aBoolean1499) {
            DrawingArea.method339(k + (int)((double)this.anInt1497 * 0.7), 0x800000, i - l, l);
        }
    }

    public void method38(String s, int i, int j, int colour, boolean flag) {
        int l = this.getTextWidth(s) / 2;
        int i1 = this.method44();
        if (i - l > DrawingArea.clipBottom) {
            return;
        }
        if (i + l < DrawingArea.clipLeft) {
            return;
        }
        if (j - i1 > DrawingArea.clipRight) {
            return;
        }
        if (j < 0) {
            return;
        }
        this.drawText(colour, s, i - l, j);
    }

    public int method40() {
        return this.rsb[8] - 1;
    }

    public int method44() {
        return this.rsb[6];
    }

    public void method380(String s, int i, int j, int k) {
        this.method385(j, s, k, i - this.method384(s));
    }

    public void drawText(int colour, String txt, int x, int y) {
        this.method385(colour, txt, x, y - this.method384(txt) / 2);
    }

    public void drawTextTopAligned(int colour, String txt, int x, int y) {
        this.method385New(colour, txt, x, y);
    }

    public void method385New(int i, String text, int j, int l) {
        if (text == null) {
            return;
        }
        j -= this.anInt1497;
        int i1 = 0;
        while (i1 < text.length()) {
            char c = text.charAt(i1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], l + this.anIntArray1494[c], j + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], i);
            }
            l += this.rsb[c];
            ++i1;
        }
    }

    public void method591(String s, int i, int j, int k) {
        this.method385(j, s, k, i);
    }

    public void method592(int i, int j, String s, int l, boolean flag) {
        this.drawRegularText(flag, j, i, s, l);
    }

    public void setPixelsInfo(int width, int height, int transparancy, int[] newPixels, byte[] oldPixels, int newOffset, int oldOffset, int place1, int place2, int color) {
        color = ((color & 0xFF00FF) * transparancy & 0xFF00FF00) + ((color & 0xFF00) * transparancy & 0xFF0000) >> 8;
        transparancy = 256 - transparancy;
        int j2 = -height;
        while (j2 < 0) {
            int k2 = -width;
            while (k2 < 0) {
                if (oldPixels[oldOffset++] != 0) {
                    int l2 = newPixels[newOffset];
                    newPixels[newOffset++] = (((l2 & 0xFF00FF) * transparancy & 0xFF00FF00) + ((l2 & 0xFF00) * transparancy & 0xFF0000) >> 8) + color;
                } else {
                    ++newOffset;
                }
                ++k2;
            }
            newOffset += place1;
            oldOffset += place2;
            ++j2;
        }
    }

    private void drawChar(byte[] text, int x, int y, int width, int height, int color, int opacity) {
        int newOffset = x + y * DrawingArea.width;
        int place1 = DrawingArea.width - width;
        int place2 = 0;
        int oldOffset = 0;
        if (y < DrawingArea.clipTop) {
            int Height2 = DrawingArea.clipTop - y;
            height -= Height2;
            y = DrawingArea.clipTop;
            oldOffset += Height2 * width;
            newOffset += Height2 * DrawingArea.width;
        }
        if (y + height >= DrawingArea.clipBottom) {
            height -= y + height - DrawingArea.clipBottom;
        }
        if (x < DrawingArea.clipLeft) {
            int toLeft = DrawingArea.clipLeft - x;
            width -= toLeft;
            x = DrawingArea.clipLeft;
            oldOffset += toLeft;
            newOffset += toLeft;
            place2 += toLeft;
            place1 += toLeft;
        }
        if (x + width >= DrawingArea.clipRight) {
            int toRight = x + width - DrawingArea.clipRight;
            width -= toRight;
            place2 += toRight;
            place1 += toRight;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        this.setPixelsInfo(width, height, opacity, DrawingArea.pixels, text, newOffset, oldOffset, place1, place2, color);
    }

    public void drawTransparentText(int i, String s, int j, int k, int l, int opacity) {
        if (s == null) {
            return;
        }
        j -= this.anInt1497;
        int i1 = 0;
        while (i1 < s.length()) {
            char c = s.charAt(i1);
            if (c != ' ') {
                this.drawChar(this.aByteArrayArray1491[c], l + this.anIntArray1494[c], j + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], i, opacity);
            }
            l += this.rsb[c];
            ++i1;
        }
        k = 50 / k;
    }

    public void drawOpacityText(int color, String text, int yCoord, int xCoord, int alpha) {
        this.drawTransparentText(color, text, yCoord, 822, xCoord - this.method384(text) / 2, alpha);
    }

    public void drawCenteredText(int colour, int x, String text, int y, boolean center) {
        this.drawRegularText(center, x - this.getTextWidth(text) / 2, colour, text, y);
    }

    public void drawChatInput(int i, int j, String s, int l, boolean flag) {
        this.drawRegularText(flag, j, i, s, l);
    }

    public void drawCenteredTextDoubleShadow(int colour, int x, String text, int y) {
        this.drawRegularTextDoubleShadow(x - this.getTextWidth(text) / 2, colour, text, y);
    }

    public void drawRightAlignedString(String s, int x, int y, int color, boolean shadow) {
        this.drawRegularText(shadow, x - this.method384(s), color, s, y);
    }

    public int getTextWidth(String s) {
        if (s == null) {
            return 0;
        }
        int j = 0;
        int k = 0;
        while (k < s.length()) {
            if (s.charAt(k) == '@' && k + 4 < s.length() && s.charAt(k + 4) == '@') {
                k += 4;
            } else if (s.charAt(k) == '@' && k + 7 < s.length() && s.charAt(k + 7) == '@') {
                k += 7;
            } else {
                j += this.rsb[s.charAt(k)];
            }
            ++k;
        }
        return j;
    }

    public void drawWrappedText(boolean shadow, int x, int y, int color, String text, int maxWidth, int lineHeight) {
        List<String> lines = this.wrapTextWithSpacing(text, maxWidth, false);
        int currentY = y;
        for (String line : lines) {
            this.drawRegularText(shadow, x, color, line, currentY);
            currentY += lineHeight;
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<String> wrapText(String text, int maxWidth) {
        result = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            result.add("");
            return result;
        }
        activeColorTag = "";
        text = text.replace("\\n", "\n");
        currentLine = new StringBuilder(activeColorTag);
        word = new StringBuilder();
        currentWidth = this.getTextWidth(activeColorTag);
        i = 0;
        while (i < text.length()) {
            block17: {
                block16: {
                    c = text.charAt(i);
                    if (c != '\n') break block16;
                    if (word.length() > 0) {
                        wordWidth = this.getTextWidth(word.toString());
                        if (currentWidth + wordWidth > maxWidth && currentLine.length() > activeColorTag.length()) {
                            result.add(currentLine.toString());
                            currentLine = new StringBuilder(activeColorTag);
                            currentWidth = this.getTextWidth(activeColorTag);
                        }
                        currentLine.append((CharSequence)word);
                        word.setLength(0);
                    }
                    result.add(currentLine.toString());
                    if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                        result.add("");
                        ++i;
                    }
                    currentLine = new StringBuilder(activeColorTag);
                    currentWidth = this.getTextWidth(activeColorTag);
                    break block17;
                }
                if (c != '@') ** GOTO lbl-1000
                if (i + 4 < text.length() && text.charAt(i + 4) == '@') {
                    activeColorTag = tag = text.substring(i, i + 5);
                    word.append(tag);
                    i += 4;
                } else if (i + 7 < text.length() && text.charAt(i + 7) == '@') {
                    activeColorTag = tag = text.substring(i, i + 8);
                    word.append(tag);
                    i += 7;
                } else if (c == ' ') {
                    if (word.length() > 0) {
                        wordWidth = this.getTextWidth(String.valueOf(word.toString()) + " ");
                        if (currentWidth + wordWidth > maxWidth && currentLine.length() > activeColorTag.length()) {
                            result.add(currentLine.toString());
                            currentLine = new StringBuilder(activeColorTag);
                            currentWidth = this.getTextWidth(activeColorTag);
                        }
                        currentLine.append((CharSequence)word).append(" ");
                        currentWidth += wordWidth;
                        word.setLength(0);
                    }
                } else {
                    word.append(c);
                }
            }
            ++i;
        }
        if (word.length() > 0) {
            wordWidth = this.getTextWidth(word.toString());
            if (currentWidth + wordWidth > maxWidth && currentLine.length() > activeColorTag.length()) {
                result.add(currentLine.toString());
                currentLine = new StringBuilder(activeColorTag);
            }
            currentLine.append((CharSequence)word);
        }
        if (currentLine.length() > activeColorTag.length() || result.isEmpty()) {
            result.add(currentLine.toString());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public List<String> wrapTextWithSpacing(String text, int maxWidth, boolean paragraphSpacing) {
        if (!paragraphSpacing) {
            return this.wrapText(text, maxWidth);
        }
        result = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            result.add("");
            return result;
        }
        lines = text.split("\n");
        activeColorTag = "";
        lineIndex = 0;
        while (lineIndex < lines.length) {
            block15: {
                block14: {
                    line = lines[lineIndex];
                    if (!line.isEmpty()) break block14;
                    result.add("");
                    break block15;
                }
                currentLine = new StringBuilder(activeColorTag);
                word = new StringBuilder();
                currentWidth = this.getTextWidth(activeColorTag);
                i = 0;
                while (i < line.length()) {
                    c = line.charAt(i);
                    if (c != '@') ** GOTO lbl-1000
                    if (i + 4 < line.length() && line.charAt(i + 4) == '@') {
                        activeColorTag = tag = line.substring(i, i + 5);
                        word.append(tag);
                        i += 4;
                    } else if (i + 7 < line.length() && line.charAt(i + 7) == '@') {
                        activeColorTag = tag = line.substring(i, i + 8);
                        word.append(tag);
                        i += 7;
                    } else if (c == ' ') {
                        if (word.length() > 0) {
                            wordWidth = this.getTextWidth(String.valueOf(word.toString()) + " ");
                            if (currentWidth + wordWidth > maxWidth && currentLine.length() > activeColorTag.length()) {
                                result.add(currentLine.toString());
                                currentLine = new StringBuilder(activeColorTag);
                                currentWidth = this.getTextWidth(activeColorTag);
                            }
                            currentLine.append((CharSequence)word).append(" ");
                            currentWidth += wordWidth;
                            word.setLength(0);
                        }
                    } else {
                        word.append(c);
                    }
                    ++i;
                }
                if (word.length() > 0) {
                    wordWidth = this.getTextWidth(word.toString());
                    if (currentWidth + wordWidth > maxWidth && currentLine.length() > activeColorTag.length()) {
                        result.add(currentLine.toString());
                        currentLine = new StringBuilder(activeColorTag);
                    }
                    currentLine.append((CharSequence)word);
                }
                result.add(currentLine.toString());
            }
            ++lineIndex;
        }
        return result;
    }

    public int charFor(int i, String s) {
        int j = 0;
        int k = 0;
        while (k < s.length()) {
            if (s.charAt(k) == '@' && k + 4 < s.length() && s.charAt(k + 4) == '@') {
                k += 4;
            } else if (s.charAt(k) == '@' && k + 7 < s.length() && s.charAt(k + 7) == '@') {
                k += 7;
            } else {
                j += this.rsb[s.charAt(k)];
            }
            if (j >= i - 4 && j <= i + 4) {
                return j;
            }
            ++k;
        }
        return j;
    }

    public int method384(String s) {
        if (s == null) {
            return 0;
        }
        int j = 0;
        int k = 0;
        while (k < s.length()) {
            j += this.rsb[s.charAt(k)];
            ++k;
        }
        return j;
    }

    public void method385(int i, String text, int j, int l) {
        if (text == null) {
            return;
        }
        j -= this.anInt1497;
        int i1 = 0;
        while (i1 < text.length()) {
            char c = text.charAt(i1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], l + this.anIntArray1494[c], j + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], i);
            }
            l += this.rsb[c];
            ++i1;
        }
    }

    public void method386(int i, String s, int j, int k, int l) {
        if (s == null) {
            return;
        }
        j -= this.method384(s) / 2;
        l -= this.anInt1497;
        int i1 = 0;
        while (i1 < s.length()) {
            char c = s.charAt(i1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], j + this.anIntArray1494[c], l + this.anIntArray1495[c] + (int)(Math.sin((double)i1 / 2.0 + (double)k / 5.0) * 5.0), this.anIntArray1492[c], this.anIntArray1493[c], i);
            }
            j += this.rsb[c];
            ++i1;
        }
    }

    public void method387(int i, String s, int j, int k, int l) {
        if (s == null) {
            return;
        }
        i -= this.method384(s) / 2;
        k -= this.anInt1497;
        int i1 = 0;
        while (i1 < s.length()) {
            char c = s.charAt(i1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] + (int)(Math.sin((double)i1 / 5.0 + (double)j / 5.0) * 5.0), k + this.anIntArray1495[c] + (int)(Math.sin((double)i1 / 3.0 + (double)j / 5.0) * 5.0), this.anIntArray1492[c], this.anIntArray1493[c], l);
            }
            i += this.rsb[c];
            ++i1;
        }
    }

    public void method388(int i, String s, int j, int k, int l, int i1) {
        if (s == null) {
            return;
        }
        double d = 7.0 - (double)i / 8.0;
        if (d < 0.0) {
            d = 0.0;
        }
        l -= this.method384(s) / 2;
        k -= this.anInt1497;
        int k1 = 0;
        while (k1 < s.length()) {
            char c = s.charAt(k1);
            if (c != ' ') {
                this.method392(this.aByteArrayArray1491[c], l + this.anIntArray1494[c], k + this.anIntArray1495[c] + (int)(Math.sin((double)k1 / 1.5 + (double)j) * d), this.anIntArray1492[c], this.anIntArray1493[c], i1);
            }
            l += this.rsb[c];
            ++k1;
        }
    }

    public void drawRegularText(boolean flag1, int i, int j, String s, int k) {
        this.aBoolean1499 = false;
        int l = i;
        if (s == null) {
            return;
        }
        k -= this.anInt1497;
        int i1 = 0;
        while (i1 < s.length()) {
            if (s.charAt(i1) == '@' && i1 + 4 < s.length() && s.charAt(i1 + 4) == '@') {
                int j1 = this.getColorByName(s.substring(i1 + 1, i1 + 4));
                if (j1 != -1) {
                    j = j1;
                }
                i1 += 4;
            } else if (s.charAt(i1) == '@' && i1 + 7 < s.length() && s.charAt(i1 + 7) == '@') {
                j = Integer.parseInt(s.substring(i1 + 1, i1 + 7), 16);
                i1 += 7;
            } else {
                char c = s.charAt(i1);
                if (c != ' ') {
                    if (flag1) {
                        this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] + 1, k + this.anIntArray1495[c] + 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    }
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c], k + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], j);
                }
                i += this.rsb[c];
            }
            ++i1;
        }
        if (this.aBoolean1499) {
            DrawingArea.drawLine(k + (int)((double)this.anInt1497 * 0.7), 0x800000, i - l, l);
        }
    }

    public void drawRegularTextDoubleShadow(int i, int j, String s, int k) {
        this.aBoolean1499 = false;
        int l = i;
        if (s == null) {
            return;
        }
        k -= this.anInt1497;
        int i1 = 0;
        while (i1 < s.length()) {
            if (s.charAt(i1) == '@' && i1 + 4 < s.length() && s.charAt(i1 + 4) == '@') {
                int j1 = this.getColorByName(s.substring(i1 + 1, i1 + 4));
                if (j1 != -1) {
                    j = j1;
                }
                i1 += 4;
            } else {
                char c = s.charAt(i1);
                if (c != ' ') {
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] - 1, k + this.anIntArray1495[c] - 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] + 1, k + this.anIntArray1495[c] - 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] - 1, k + this.anIntArray1495[c] + 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] + 1, k + this.anIntArray1495[c] + 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c], k + this.anIntArray1495[c] + 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] + 1, k + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c] - 1, k + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c], k + this.anIntArray1495[c] - 1, this.anIntArray1492[c], this.anIntArray1493[c], 0);
                    this.method392(this.aByteArrayArray1491[c], i + this.anIntArray1494[c], k + this.anIntArray1495[c], this.anIntArray1492[c], this.anIntArray1493[c], j);
                }
                i += this.rsb[c];
            }
            ++i1;
        }
        if (this.aBoolean1499) {
            DrawingArea.drawLine(k + (int)((double)this.anInt1497 * 0.7), 0x800000, i - l, l);
        }
    }

    public void method390(int i, int j, String s, int k, int i1) {
        if (s == null) {
            return;
        }
        this.aRandom1498.setSeed(k);
        int j1 = 192 + (this.aRandom1498.nextInt() & 0x1F);
        i1 -= this.anInt1497;
        int k1 = 0;
        while (k1 < s.length()) {
            if (s.charAt(k1) == '@' && k1 + 4 < s.length() && s.charAt(k1 + 4) == '@') {
                int l1 = this.getColorByName(s.substring(k1 + 1, k1 + 4));
                if (l1 != -1) {
                    j = l1;
                }
                k1 += 4;
            } else {
                char c = s.charAt(k1);
                if (c != ' ') {
                    this.method394(192, i + this.anIntArray1494[c] + 1, this.aByteArrayArray1491[c], this.anIntArray1492[c], i1 + this.anIntArray1495[c] + 1, this.anIntArray1493[c], 0);
                    this.method394(j1, i + this.anIntArray1494[c], this.aByteArrayArray1491[c], this.anIntArray1492[c], i1 + this.anIntArray1495[c], this.anIntArray1493[c], j);
                }
                i += this.rsb[c];
                if ((this.aRandom1498.nextInt() & 3) == 0) {
                    ++i;
                }
            }
            ++k1;
        }
    }

    private int getColorByName(String s) {
        if (s.equals("369")) {
            return 0x336699;
        }
        if (s.equals("mon")) {
            return 65408;
        }
        if (s.equals("red")) {
            return 0xFF0000;
        }
        if (s.equals("red")) {
            return 0xFF0000;
        }
        if (s.equals("pnk")) {
            return 16733897;
        }
        if (s.equals("pr2")) {
            return 8331232;
        }
        if (s.equals("or7")) {
            return 16752647;
        }
        if (s.equals("gry")) {
            return 6118487;
        }
        if (s.equals("bl2")) {
            return 8900331;
        }
        if (s.equals("pr3")) {
            return 12128956;
        }
        if (s.equals("gre")) {
            return 65280;
        }
        if (s.equals("skb")) {
            return 9417192;
        }
        if (s.equals("blu")) {
            return 255;
        }
        if (s.equals("yel")) {
            return 0xFFFF00;
        }
        if (s.equals("cya")) {
            return 65535;
        }
        if (s.equals("mag")) {
            return 0xFF00FF;
        }
        if (s.equals("whi")) {
            return 0xFFFFFF;
        }
        if (s.equals("bla")) {
            return 0;
        }
        if (s.equals("lre")) {
            return 16748608;
        }
        if (s.equals("dre")) {
            return 0x800000;
        }
        if (s.equals("dbl")) {
            return 128;
        }
        if (s.equals("or1")) {
            return 0xFFB000;
        }
        if (s.equals("or2")) {
            return 0xFF7000;
        }
        if (s.equals("or3")) {
            return 0xFF3000;
        }
        if (s.equals("gr1")) {
            return 0xC0FF00;
        }
        if (s.equals("gr2")) {
            return 0x80FF00;
        }
        if (s.equals("gr3")) {
            return 0x40FF00;
        }
        if (s.equals("re4")) {
            return 0x8D8D8D;
        }
        if (s.equals("re1")) {
            return 9543924;
        }
        if (s.equals("re2")) {
            return 8899712;
        }
        if (s.equals("re3")) {
            return 15690346;
        }
        if (s.equals("enc")) {
            return 14916585;
        }
        if (s.equals("str")) {
            this.aBoolean1499 = true;
        }
        if (s.equals("end")) {
            this.aBoolean1499 = false;
        }
        return -1;
    }

    private void method392(byte[] abyte0, int i, int j, int k, int l, int i1) {
        int j1 = i + j * DrawingArea.width;
        int k1 = DrawingArea.width - k;
        int l1 = 0;
        int i2 = 0;
        if (j < DrawingArea.clipTop) {
            int j2 = DrawingArea.clipTop - j;
            l -= j2;
            j = DrawingArea.clipTop;
            i2 += j2 * k;
            j1 += j2 * DrawingArea.width;
        }
        if (j + l >= DrawingArea.clipBottom) {
            l -= j + l - DrawingArea.clipBottom + 1;
        }
        if (i < DrawingArea.clipLeft) {
            int k2 = DrawingArea.clipLeft - i;
            k -= k2;
            i = DrawingArea.clipLeft;
            i2 += k2;
            j1 += k2;
            l1 += k2;
            k1 += k2;
        }
        if (i + k >= DrawingArea.clipRight) {
            int l2 = i + k - DrawingArea.clipRight + 1;
            k -= l2;
            l1 += l2;
            k1 += l2;
        }
        if (k > 0 && l > 0) {
            this.method393(DrawingArea.pixels, abyte0, i1, i2, j1, k, l, k1, l1);
        }
    }

    private void method393(int[] ai, byte[] abyte0, int i, int j, int k, int l, int i1, int j1, int k1) {
        int l1 = -(l >> 2);
        l = -(l & 3);
        int i2 = -i1;
        while (i2 < 0) {
            int j2 = l1;
            while (j2 < 0) {
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                ++j2;
            }
            int k2 = l;
            while (k2 < 0) {
                if (abyte0[j++] != 0) {
                    ai[k++] = i;
                } else {
                    ++k;
                }
                ++k2;
            }
            k += j1;
            j += k1;
            ++i2;
        }
    }

    private void method394(int i, int j, byte[] abyte0, int k, int l, int i1, int j1) {
        int k1 = j + l * DrawingArea.width;
        int l1 = DrawingArea.width - k;
        int i2 = 0;
        int j2 = 0;
        if (l < DrawingArea.clipTop) {
            int k2 = DrawingArea.clipTop - l;
            i1 -= k2;
            l = DrawingArea.clipTop;
            j2 += k2 * k;
            k1 += k2 * DrawingArea.width;
        }
        if (l + i1 >= DrawingArea.clipBottom) {
            i1 -= l + i1 - DrawingArea.clipBottom + 1;
        }
        if (j < DrawingArea.clipLeft) {
            int l2 = DrawingArea.clipLeft - j;
            k -= l2;
            j = DrawingArea.clipLeft;
            j2 += l2;
            k1 += l2;
            i2 += l2;
            l1 += l2;
        }
        if (j + k >= DrawingArea.clipRight) {
            int i3 = j + k - DrawingArea.clipRight + 1;
            k -= i3;
            i2 += i3;
            l1 += i3;
        }
        if (k <= 0 || i1 <= 0) {
            return;
        }
        this.method395(abyte0, i1, k1, DrawingArea.pixels, j2, k, i2, l1, j1, i);
    }

    private void method395(byte[] abyte0, int i, int j, int[] ai, int l, int i1, int j1, int k1, int l1, int i2) {
        l1 = ((l1 & 0xFF00FF) * i2 & 0xFF00FF00) + ((l1 & 0xFF00) * i2 & 0xFF0000) >> 8;
        i2 = 256 - i2;
        int j2 = -i;
        while (j2 < 0) {
            int k2 = -i1;
            while (k2 < 0) {
                if (abyte0[l++] != 0) {
                    int l2 = ai[j];
                    ai[j++] = (((l2 & 0xFF00FF) * i2 & 0xFF00FF00) + ((l2 & 0xFF00) * i2 & 0xFF0000) >> 8) + l1;
                } else {
                    ++j;
                }
                ++k2;
            }
            j += k1;
            l += j1;
            ++j2;
        }
    }

    public static void drawAlphaFilledPixels(int xPos, int yPos, int pixelWidth, int pixelHeight, int color, int alpha) {
        if (xPos < clipLeft) {
            pixelWidth -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            pixelHeight -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + pixelWidth > clipRight) {
            pixelWidth = clipRight - xPos;
        }
        if (yPos + pixelHeight > clipBottom) {
            pixelHeight = clipBottom - yPos;
        }
        color = ((color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((color & 0xFF00) * alpha >> 8 & 0xFF00);
        int k1 = 256 - alpha;
        int l1 = width - pixelWidth;
        int i2 = xPos + yPos * width;
        int j2 = 0;
        while (j2 < pixelHeight) {
            int k2 = -pixelWidth;
            while (k2 < 0) {
                int l2 = pixels[i2];
                l2 = ((l2 & 0xFF00FF) * k1 >> 8 & 0xFF00FF) + ((l2 & 0xFF00) * k1 >> 8 & 0xFF00);
                TextDrawingArea.pixels[i2++] = color + l2;
                ++k2;
            }
            i2 += l1;
            ++j2;
        }
    }
}

