/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics;

import com.aragon.graphics.DrawingArea;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;

public final class RSImageProducer
implements ImageProducer,
ImageObserver {
    public final int[] myPixels;
    public final int width;
    public final int height;
    private final ColorModel colorModel;
    private ImageConsumer imageConsumer;
    private final Image image;

    public RSImageProducer(int i, int j, Component component) {
        this.width = i;
        this.height = j;
        this.myPixels = new int[i * j];
        this.colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255);
        this.image = component.createImage(this);
        this.update();
        component.prepareImage(this.image, this);
        this.update();
        component.prepareImage(this.image, this);
        this.update();
        component.prepareImage(this.image, this);
        this.initDrawingArea();
    }

    public void initDrawingArea() {
        DrawingArea.initDrawingArea(this.height, this.width, this.myPixels);
    }

    public void drawGraphics(int i, Graphics g, int k) {
        this.update();
        g.drawImage(this.image, k, i, this);
    }

    @Override
    public synchronized void addConsumer(ImageConsumer imageconsumer) {
        this.imageConsumer = imageconsumer;
        imageconsumer.setDimensions(this.width, this.height);
        imageconsumer.setProperties(null);
        imageconsumer.setColorModel(this.colorModel);
        imageconsumer.setHints(14);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer imageconsumer) {
        return this.imageConsumer == imageconsumer;
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer imageconsumer) {
        if (this.imageConsumer == imageconsumer) {
            this.imageConsumer = null;
        }
    }

    @Override
    public void startProduction(ImageConsumer imageconsumer) {
        this.addConsumer(imageconsumer);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer imageconsumer) {
    }

    private synchronized void update() {
        if (this.imageConsumer != null) {
            this.imageConsumer.setPixels(0, 0, this.width, this.height, this.colorModel, this.myPixels, 0, this.width);
            this.imageConsumer.imageComplete(2);
        }
    }

    @Override
    public boolean imageUpdate(Image image, int i, int j, int k, int l, int i1) {
        return true;
    }
}

