/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics;

import com.aragon.graphics.DrawingArea;

public class DrawingArea474
extends DrawingArea {
    public static void drawDiagonalLine(int x, int y, int areaWidth, int areaHeight, int color) {
        areaWidth -= x;
        if ((areaHeight -= y) == 0) {
            if (areaWidth >= 0) {
                DrawingArea474.drawHorizontalLine(x, y, areaWidth + 1, color);
                return;
            }
            DrawingArea474.drawHorizontalLine(x + areaWidth, y, -areaWidth + 1, color);
            return;
        }
        if (areaWidth == 0) {
            if (areaHeight >= 0) {
                DrawingArea474.drawVerticalLine(x, y, areaHeight + 1, color);
                return;
            }
            DrawingArea474.drawVerticalLine(x, y + areaHeight, -areaHeight + 1, color);
            return;
        }
        if (areaWidth + areaHeight < 0) {
            x += areaWidth;
            areaWidth = -areaWidth;
            y += areaHeight;
            areaHeight = -areaHeight;
        }
        if (areaWidth > areaHeight) {
            y <<= 16;
            y += 32768;
            int j1 = (int)Math.floor((double)(areaHeight <<= 16) / (double)areaWidth + 0.5);
            areaWidth += x;
            if (x < clipLeft) {
                y += j1 * (clipLeft - x);
                x = clipLeft;
            }
            if (areaWidth >= clipRight) {
                areaWidth = clipRight - 1;
            }
            while (x <= areaWidth) {
                int l1 = y >> 16;
                if (l1 >= clipTop && l1 < clipBottom) {
                    DrawingArea474.pixels[x + l1 * DrawingArea474.width] = color;
                }
                y += j1;
                ++x;
            }
            return;
        }
        x <<= 16;
        x += 32768;
        int k1 = (int)Math.floor((double)(areaWidth <<= 16) / (double)areaHeight + 0.5);
        areaHeight += y;
        if (y < clipTop) {
            x += k1 * (clipTop - y);
            y = clipTop;
        }
        if (areaHeight >= clipBottom) {
            areaHeight = clipBottom - 1;
        }
        while (y <= areaHeight) {
            int i2 = x >> 16;
            if (i2 >= clipLeft && i2 < clipRight) {
                DrawingArea474.pixels[i2 + y * DrawingArea474.width] = color;
            }
            x += k1;
            ++y;
        }
    }

    public static void drawFilledPixels(int x, int y, int pixelWidth, int pixelHeight, int color) {
        if (x < clipLeft) {
            pixelWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            pixelHeight -= clipTop - y;
            y = clipTop;
        }
        if (x + pixelWidth > clipRight) {
            pixelWidth = clipRight - x;
        }
        if (y + pixelHeight > clipBottom) {
            pixelHeight = clipBottom - y;
        }
        int j1 = width - pixelWidth;
        int k1 = x + y * width;
        int l1 = -pixelHeight;
        while (l1 < 0) {
            int i2 = -pixelWidth;
            while (i2 < 0) {
                DrawingArea474.pixels[k1++] = color;
                ++i2;
            }
            k1 += j1;
            ++l1;
        }
    }

    public static void method579() {
        int i = 0;
        int j = width * height - 7;
        while (i < j) {
            DrawingArea474.pixels[i++] = 0;
            DrawingArea474.pixels[i++] = 0;
            DrawingArea474.pixels[i++] = 0;
            DrawingArea474.pixels[i++] = 0;
            DrawingArea474.pixels[i++] = 0;
            DrawingArea474.pixels[i++] = 0;
            DrawingArea474.pixels[i++] = 0;
            DrawingArea474.pixels[i++] = 0;
        }
        j += 7;
        while (i < j) {
            DrawingArea474.pixels[i++] = 0;
        }
    }

    public static void drawHorizontalLine(int x, int y, int lineWidth, int color) {
        if (y < clipTop || y >= clipBottom) {
            return;
        }
        if (x < clipLeft) {
            lineWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (x + lineWidth > clipRight) {
            lineWidth = clipRight - x;
        }
        int pixelCount = x + y * width;
        int j1 = 0;
        while (j1 < lineWidth) {
            DrawingArea474.pixels[pixelCount + j1] = color;
            ++j1;
        }
    }

    public static void drawVerticalLine(int x, int y, int lineHeight, int color) {
        if (x < clipLeft || x >= clipRight) {
            return;
        }
        if (y < clipTop) {
            lineHeight -= clipTop - y;
            y = clipTop;
        }
        if (y + lineHeight > clipBottom) {
            lineHeight = clipBottom - y;
        }
        int pixelCount = x + y * width;
        int j1 = 0;
        while (j1 < lineHeight) {
            DrawingArea474.pixels[pixelCount + j1 * DrawingArea474.width] = color;
            ++j1;
        }
    }

    public static void method582() {
        pixels = null;
    }

    public static void drawGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < clipLeft) {
            gradientWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            k1 += (clipTop - y) * l1;
            gradientHeight -= clipTop - y;
            y = clipTop;
        }
        if (x + gradientWidth > clipRight) {
            gradientWidth = clipRight - x;
        }
        if (y + gradientHeight > clipBottom) {
            gradientHeight = clipBottom - y;
        }
        int i2 = width - gradientWidth;
        int j2 = x + y * width;
        int k2 = -gradientHeight;
        while (k2 < 0) {
            int l2 = 65536 - k1 >> 8;
            int i3 = k1 >> 8;
            int j3 = ((startColor & 0xFF00FF) * l2 + (endColor & 0xFF00FF) * i3 & 0xFF00FF00) + ((startColor & 0xFF00) * l2 + (endColor & 0xFF00) * i3 & 0xFF0000) >>> 8;
            int k3 = -gradientWidth;
            while (k3 < 0) {
                DrawingArea474.pixels[j2++] = j3;
                ++k3;
            }
            j2 += i2;
            k1 += l1;
            ++k2;
        }
    }

    @Override
    public void drawAlphaGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor, int alpha) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < clipLeft) {
            gradientWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            k1 += (clipTop - y) * l1;
            gradientHeight -= clipTop - y;
            y = clipTop;
        }
        if (x + gradientWidth > clipRight) {
            gradientWidth = clipRight - x;
        }
        if (y + gradientHeight > clipBottom) {
            gradientHeight = clipBottom - y;
        }
        int i2 = width - gradientWidth;
        int result_alpha = 256 - alpha;
        int total_pixels = x + y * width;
        int k2 = -gradientHeight;
        while (k2 < 0) {
            int gradient1 = 65536 - k1 >> 8;
            int gradient2 = k1 >> 8;
            int gradient_color = ((startColor & 0xFF00FF) * gradient1 + (endColor & 0xFF00FF) * gradient2 & 0xFF00FF00) + ((startColor & 0xFF00) * gradient1 + (endColor & 0xFF00) * gradient2 & 0xFF0000) >>> 8;
            int color = ((gradient_color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((gradient_color & 0xFF00) * alpha >> 8 & 0xFF00);
            int k3 = -gradientWidth;
            while (k3 < 0) {
                int pixel_pixels = pixels[total_pixels];
                pixel_pixels = ((pixel_pixels & 0xFF00FF) * result_alpha >> 8 & 0xFF00FF) + ((pixel_pixels & 0xFF00) * result_alpha >> 8 & 0xFF00);
                DrawingArea474.pixels[total_pixels++] = color + pixel_pixels;
                ++k3;
            }
            total_pixels += i2;
            k1 += l1;
            ++k2;
        }
    }

    public static void drawAlphaHorizontalLine(int x, int y, int lineWidth, int color, int alpha) {
        if (y < clipTop || y >= clipBottom) {
            return;
        }
        if (x < clipLeft) {
            lineWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (x + lineWidth > clipRight) {
            lineWidth = clipRight - x;
        }
        int j1 = 256 - alpha;
        int k1 = (color >> 16 & 0xFF) * alpha;
        int l1 = (color >> 8 & 0xFF) * alpha;
        int i2 = (color & 0xFF) * alpha;
        int i3 = x + y * width;
        int j3 = 0;
        while (j3 < lineWidth) {
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            DrawingArea474.pixels[i3++] = k3;
            ++j3;
        }
    }

    public static void drawAlphaVerticalLine(int x, int y, int lineHeight, int color, int alpha) {
        if (x < clipLeft || x >= clipRight) {
            return;
        }
        if (y < clipTop) {
            lineHeight -= clipTop - y;
            y = clipTop;
        }
        if (y + lineHeight > clipBottom) {
            lineHeight = clipBottom - y;
        }
        int j1 = 256 - alpha;
        int k1 = (color >> 16 & 0xFF) * alpha;
        int l1 = (color >> 8 & 0xFF) * alpha;
        int i2 = (color & 0xFF) * alpha;
        int i3 = x + y * width;
        int j3 = 0;
        while (j3 < lineHeight) {
            int k3;
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            DrawingArea474.pixels[i3] = k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            i3 += width;
            ++j3;
        }
    }

    public static void drawAlphaFilledPixels(int xPos, int yPos, int pixelWidth, int pixelHeight, int color, int alpha) {
        if (xPos < clipLeft) {
            pixelWidth -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            pixelHeight -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + pixelWidth > clipRight) {
            pixelWidth = clipRight - xPos;
        }
        if (yPos + pixelHeight > clipBottom) {
            pixelHeight = clipBottom - yPos;
        }
        color = ((color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((color & 0xFF00) * alpha >> 8 & 0xFF00);
        int k1 = 256 - alpha;
        int l1 = width - pixelWidth;
        int i2 = xPos + yPos * width;
        int j2 = 0;
        while (j2 < pixelHeight) {
            int k2 = -pixelWidth;
            while (k2 < 0) {
                int l2 = pixels[i2];
                l2 = ((l2 & 0xFF00FF) * k1 >> 8 & 0xFF00FF) + ((l2 & 0xFF00) * k1 >> 8 & 0xFF00);
                DrawingArea474.pixels[i2++] = color + l2;
                ++k2;
            }
            i2 += l1;
            ++j2;
        }
    }

    public static void method587(int[] ai, int i, int j) {
        pixels = ai;
        width = i;
        height = j;
        DrawingArea474.method589(0, 0, i, j);
    }

    public static void drawAlphaUnfilledPixels(int x, int y, int width, int height, int color, int alpha) {
        DrawingArea474.drawAlphaHorizontalLine(x, y, width, color, alpha);
        DrawingArea474.drawAlphaHorizontalLine(x, y + height - 1, width, color, alpha);
        if (height >= 3) {
            DrawingArea474.drawAlphaVerticalLine(x, y + 1, height - 2, color, alpha);
            DrawingArea474.drawAlphaVerticalLine(x + width - 1, y + 1, height - 2, color, alpha);
        }
    }

    public static void method589(int i, int j, int k, int l) {
        if (i < 0) {
            i = 0;
        }
        if (j < 0) {
            j = 0;
        }
        if (k > width) {
            k = width;
        }
        if (l > height) {
            l = height;
        }
        clipLeft = i;
        clipTop = j;
        clipRight = k;
        clipBottom = l;
    }

    public static void method590() {
        clipLeft = 0;
        clipTop = 0;
        clipRight = width;
        clipBottom = height;
    }

    public static void method591(int[] ai) {
        clipLeft = ai[0];
        clipTop = ai[1];
        clipRight = ai[2];
        clipBottom = ai[3];
    }

    public static void method592(int i, int j, int k, int l) {
        if (clipLeft < i) {
            clipLeft = i;
        }
        if (clipTop < j) {
            clipTop = j;
        }
        if (clipRight > k) {
            clipRight = k;
        }
        if (clipBottom > l) {
            clipBottom = l;
        }
    }

    public static void method593(int i, int j, int k, int[] ai, int[] ai1) {
        int l = i + j * width;
        j = 0;
        while (j < ai.length) {
            int i1 = l + ai[j];
            i = -ai1[j];
            while (i < 0) {
                DrawingArea474.pixels[i1++] = k;
                ++i;
            }
            l += width;
            ++j;
        }
    }

    public static void method594(int[] ai) {
        ai[0] = clipLeft;
        ai[1] = clipTop;
        ai[2] = clipRight;
        ai[3] = clipBottom;
    }

    public static void drawUnfilledPixels(int x, int y, int width, int height, int color) {
        DrawingArea474.drawHorizontalLine(x, y, width, color);
        DrawingArea474.drawHorizontalLine(x, y + height - 1, width, color);
        DrawingArea474.drawVerticalLine(x, y, height, color);
        DrawingArea474.drawVerticalLine(x + width - 1, y, height, color);
    }

    public static void drawRoundedRectangle(int x, int y, int width, int height, int color, int alpha, boolean filled, boolean shadowed) {
        if (shadowed) {
            DrawingArea474.drawRoundedRectangle(x + 1, y + 1, width, height, 0, alpha, filled, false);
        }
        if (alpha == -1) {
            if (filled) {
                DrawingArea474.drawHorizontalLine(y + 1, color, width - 4, x + 2);
                DrawingArea474.drawHorizontalLine(y + height - 2, color, width - 4, x + 2);
                DrawingArea474.drawPixels(height - 4, y + 2, x + 1, color, width - 2);
            }
            DrawingArea474.drawHorizontalLine(y, color, width - 4, x + 2);
            DrawingArea474.drawHorizontalLine(y + height - 1, color, width - 4, x + 2);
            DrawingArea474.drawLineVertical(y + 2, color, height - 4, x);
            DrawingArea474.drawLineVertical(y + 2, color, height - 4, x + width - 1);
            DrawingArea474.drawPixels(1, y + 1, x + 1, color, 1);
            DrawingArea474.drawPixels(1, y + 1, x + width - 2, color, 1);
            DrawingArea474.drawPixels(1, y + height - 2, x + width - 2, color, 1);
            DrawingArea474.drawPixels(1, y + height - 2, x + 1, color, 1);
        } else if (alpha != -1) {
            if (filled) {
                DrawingArea474.drawHLine(color, width - 4, y + 1, alpha, x + 2);
                DrawingArea474.drawHLine(color, width - 4, y + height - 2, alpha, x + 2);
                DrawingArea474.fillRectangle(color, y + 2, width - 2, height - 4, alpha, x + 1);
            }
            DrawingArea474.drawHLine(color, width - 4, y, alpha, x + 2);
            DrawingArea474.drawHLine(color, width - 4, y + height - 1, alpha, x + 2);
            DrawingArea474.drawVLine(color, x, alpha, y + 2, height - 4);
            DrawingArea474.drawVLine(color, x + width - 1, alpha, y + 2, height - 4);
            DrawingArea474.fillRectangle(color, y + 1, 1, 1, alpha, x + 1);
            DrawingArea474.fillRectangle(color, y + 1, 1, 1, alpha, x + width - 2);
            DrawingArea474.fillRectangle(color, y + height - 2, 1, 1, alpha, x + 1);
            DrawingArea474.fillRectangle(color, y + height - 2, 1, 1, alpha, x + width - 2);
        }
    }
}

