/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics;

import com.aragon.client.Client;
import com.aragon.util.MathUtils;
import com.aragon.util.QueueNode;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.util.Arrays;
import java.util.Hashtable;

public class DrawingArea
extends QueueNode {
    private static final ColorModel COLOR_MODEL = new DirectColorModel(32, 0xFF0000, 65280, 255);
    public static float[] depthBuffer = new float[1];
    public static int[] pixels;
    public static int width;
    public static int height;
    public static int clipTop;
    public static int clipBottom;
    public static int clipLeft;
    public static int clipRight;
    public static int viewportRX;
    public static int viewport_centerX;
    public static int viewport_centerY;

    public static void initDrawingArea(int i, int j, int[] ai) {
        pixels = ai;
        width = j;
        height = i;
        DrawingArea.setDrawingArea(i, 0, j, 0);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return (r << 16) + (g << 8) + b;
    }

    public static void drawCircle(double x, double y, double width, double height, int color, int alpha, boolean fill) {
        if (x < (double)clipLeft) {
            width -= (double)clipLeft - x;
            x = clipLeft;
        }
        if (y < (double)clipTop) {
            height -= (double)clipTop - y;
            y = clipTop;
        }
        if (x + width > (double)clipRight) {
            width = (double)clipRight - x;
        }
        if (y + height > (double)clipBottom) {
            height = (double)clipBottom - y;
        }
        Graphics2D graphics = DrawingArea.createGraphics(pixels, DrawingArea.width, DrawingArea.height);
        Color CONVERTED_COLOR = new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha);
        graphics.setColor(CONVERTED_COLOR);
        RenderingHints render = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        render.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHints(render);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Ellipse2D.Double ellipse = new Ellipse2D.Double(x, y, width, height);
        if (fill) {
            graphics.fill(ellipse);
        }
        graphics.draw(ellipse);
    }

    public static void drawBox(int x, int y, int width, int height, int border, int borderColor, int color, int alpha) {
        DrawingArea.drawHorizontalLine(x + 1, y, width, color, alpha);
        DrawingArea.drawHorizontalLine(x, y + height - 2, width, color, alpha);
        DrawingArea.drawVerticalLine(x, y, height - 2, color, alpha);
        DrawingArea.drawVerticalLine(x + width, y + 1, height - 2, color, alpha);
        int i = 1;
        while (i < border) {
            DrawingArea.drawHorizontalLine(x + 1, y + i, width - 1, borderColor, alpha);
            DrawingArea.drawHorizontalLine(x + border, y + height - i - 2, width - border * 2 + 1, borderColor, alpha);
            DrawingArea.drawVerticalLine(x + i, y + border, height - border - 2, borderColor, alpha);
            DrawingArea.drawVerticalLine(x + width - border + i, y + border, height - border - 2, borderColor, alpha);
            ++i;
        }
    }

    public static void drawCheckMark(int x, int y, int size, int color, int alpha) {
        int halfSize = size / 2;
        DrawingArea.drawLine(x, y + halfSize, x + halfSize, y + size, color, alpha);
        DrawingArea.drawLine(x + halfSize, y + size, x + size, y, color, alpha);
    }

    public static void drawLine(int x1, int y1, int x2, int y2, int color, int alpha) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            DrawingArea.drawPixel(x1, y1, color, alpha);
            if (x1 == x2 && y1 == y2) break;
            int e2 = err * 2;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    private static void drawPixel(int x, int y, int color, int alpha) {
        if (x >= clipLeft && x < clipRight && y >= clipTop && y < clipBottom) {
            int index = x + y * width;
            int j1 = 256 - alpha;
            int r = (color >> 16 & 0xFF) * alpha;
            int g = (color >> 8 & 0xFF) * alpha;
            int b = (color & 0xFF) * alpha;
            int currentPixel = pixels[index];
            int pixelR = (currentPixel >> 16 & 0xFF) * j1;
            int pixelG = (currentPixel >> 8 & 0xFF) * j1;
            int pixelB = (currentPixel & 0xFF) * j1;
            int finalColor = (r + pixelR >> 8 << 16) + (g + pixelG >> 8 << 8) + (b + pixelB >> 8);
            DrawingArea.drawAlpha(pixels, index, finalColor, finalColor, alpha);
        }
    }

    public static void drawLock(int x, int y, int width, int height, int color, int alpha) {
        int lockWidth = width / 2;
        int lockHeight = height / 3;
        DrawingArea.fillRectangle(color, y + lockHeight, lockWidth, height - lockHeight, alpha, x);
        DrawingArea.drawArc(x + lockWidth / 2, y + lockHeight - 1, lockWidth / 2, lockHeight + lockHeight / 5, 180, 180, color, alpha);
    }

    public static void fillLock(int x, int y, int width, int height, int color, int alpha) {
        DrawingArea.drawLock(x, y, width, height, color, alpha);
    }

    public static void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, int color, int alpha) {
        double startRad = Math.toRadians(startAngle);
        double endRad = Math.toRadians(startAngle + arcAngle);
        double angle = startRad;
        while (angle < endRad) {
            int arcX = (int)((double)x + (double)width * Math.cos(angle));
            int arcY = (int)((double)y + (double)height * Math.sin(angle));
            DrawingArea.drawPixel(arcX, arcY, color, alpha);
            angle += Math.PI / 180;
        }
    }

    public static void drawColorPicker(int x, int y, int w, int h, int hueWidth, float hue) {
        if (x < clipLeft) {
            w -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            h -= clipTop - y;
            y = clipTop;
        }
        if (x + w > clipRight) {
            w = clipRight - x;
        }
        if (y + h > clipBottom) {
            h = clipBottom - y;
        }
        DrawingArea.createSB(x, y, w, h, hue);
        DrawingArea.createHueRGB(x + w, y, hueWidth, h);
        DrawingArea.drawStroke(x, y, w + hueWidth, h, 0, 1);
    }

    private static void createHueRGB(int x, int y, int hueWidth, int hueHeight) {
        int pX = x;
        while (pX < x + hueWidth) {
            int pY = y;
            while (pY < y + hueHeight) {
                float hue = MathUtils.map(pY, y, y + hueHeight, 1.0f, 0.0f);
                DrawingArea.pixels[pX + pY * DrawingArea.width] = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                ++pY;
            }
            ++pX;
        }
    }

    private static void createSB(int x, int y, int pickerWidth, int pickerHeight, float hue) {
        int pX = x;
        while (pX < x + pickerWidth) {
            int pY = y;
            while (pY < y + pickerHeight) {
                float saturation = MathUtils.map(pX, x, x + pickerWidth, 0.0f, 1.0f);
                float brightness = MathUtils.map(pY, y, y + pickerHeight, 1.0f, 0.0f);
                DrawingArea.pixels[pX + pY * DrawingArea.width] = Color.HSBtoRGB(hue, saturation, brightness);
                ++pY;
            }
            ++pX;
        }
    }

    public static void renderGlow(int drawX, int drawY, int glowColor, int r) {
        int startX = (drawX += r / 2) - r;
        int endX = drawX + r;
        int startY = (drawY += r / 2) - r;
        int endY = drawY + r;
        if (startX < clipLeft) {
            startX = clipLeft;
        }
        if (endX > clipRight) {
            endX = clipRight;
        }
        if (startY < clipTop) {
            startY = clipTop;
        }
        if (endY > clipBottom) {
            endY = clipBottom;
        }
        float edge0 = -((float)r / 2.0f);
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                int newColor;
                int index = x + y * width;
                float d = MathUtils.dist(x, y, drawX, drawY);
                float dist = MathUtils.smoothstep(edge0, r, d);
                int oldColor = pixels[index];
                DrawingArea.pixels[index] = newColor = MathUtils.blend(oldColor, glowColor, 1.0f - dist);
                ++y;
            }
            ++x;
        }
    }

    public static void drawStroke(int xPos, int yPos, int width, int height, int color, int strokeWidth) {
        DrawingArea.drawVerticalStrokeLine(xPos, yPos, height, color, strokeWidth);
        DrawingArea.drawVerticalStrokeLine(xPos + width - strokeWidth, yPos, height, color, strokeWidth);
        DrawingArea.drawHorizontalStrokeLine(xPos, yPos, width, color, strokeWidth);
        DrawingArea.drawHorizontalStrokeLine(xPos, yPos + height - strokeWidth, width, color, strokeWidth);
    }

    private static void drawVerticalStrokeLine(int xPosition, int yPosition, int height, int hexColor, int strokeWidth) {
        if (xPosition < clipLeft || xPosition >= clipRight) {
            return;
        }
        if (yPosition < clipTop) {
            height -= clipTop - yPosition;
            yPosition = clipTop;
        }
        if (yPosition + height > clipBottom) {
            height = clipBottom - yPosition;
        }
        int pixelIndex = xPosition + yPosition * width;
        int rowIndex = 0;
        while (rowIndex < height) {
            int x = 0;
            while (x < strokeWidth) {
                DrawingArea.pixels[pixelIndex + x + rowIndex * DrawingArea.width] = hexColor;
                ++x;
            }
            ++rowIndex;
        }
    }

    private static void drawHorizontalStrokeLine(int xPos, int yPos, int w, int hexColor, int strokeWidth) {
        if (yPos < clipTop || yPos >= clipBottom) {
            return;
        }
        if (xPos < clipLeft) {
            w -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (xPos + w > clipRight) {
            w = clipRight - xPos;
        }
        int index = xPos + yPos * width;
        int leftWidth = width - w;
        int x = 0;
        while (x < strokeWidth) {
            int y = 0;
            while (y < w) {
                DrawingArea.pixels[index++] = hexColor;
                ++y;
            }
            index += leftWidth;
            ++x;
        }
    }

    public static Graphics2D createGraphics(int[] pixels, int width, int height) {
        return new BufferedImage(COLOR_MODEL, Raster.createWritableRaster(COLOR_MODEL.createCompatibleSampleModel(width, height), new DataBufferInt(pixels, width * height), null), false, new Hashtable()).createGraphics();
    }

    public static Graphics2D createGraphics(boolean renderingHints) {
        Graphics2D g2d = DrawingArea.createGraphics(pixels, width, height);
        if (renderingHints) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return g2d;
    }

    public void drawCenteredString(Graphics g, String text, Rectangle rect, Font font) {
        FontMetrics metrics = g.getFontMetrics(font);
        int x = rect.x + (rect.width - metrics.stringWidth(text)) / 2;
        int y = rect.y + (rect.height - metrics.getHeight()) / 2 + metrics.getAscent();
        g.setFont(font);
        g.drawString(text, x, y);
    }

    public static void drawArc(double x, double y, double width, double height, int stroke, double start, double sweep, int color, int alpha, int closure, boolean fill) {
        Graphics2D graphics = DrawingArea.createGraphics(pixels, DrawingArea.width, DrawingArea.height);
        Color CONVERTED_COLOR = new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha);
        graphics.setColor(CONVERTED_COLOR);
        RenderingHints render = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        render.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHints(render);
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics.setStroke(new BasicStroke(Math.max(stroke, 1)));
        Arc2D.Double arc = new Arc2D.Double(x + (double)stroke, y + (double)stroke, width, height, start, sweep, closure);
        if (fill) {
            graphics.fill(arc);
            graphics.setColor(Color.decode("0x3f372c").darker());
        }
        graphics.draw(arc);
    }

    public static void drawTransparentBox(int leftX, int topY, int width, int height, int rgbColour, int opacity) {
        if (leftX < clipLeft) {
            width -= clipLeft - leftX;
            leftX = clipLeft;
        }
        if (topY < clipTop) {
            height -= clipTop - topY;
            topY = clipTop;
        }
        if (leftX + width > clipRight) {
            width = clipRight - leftX;
        }
        if (topY + height > clipBottom) {
            height = clipBottom - topY;
        }
        int transparency = 256 - opacity;
        int red = (rgbColour >> 16 & 0xFF) * opacity;
        int green = (rgbColour >> 8 & 0xFF) * opacity;
        int blue = (rgbColour & 0xFF) * opacity;
        int leftOver = DrawingArea.width - width;
        int pixelIndex = leftX + topY * DrawingArea.width;
        int rowIndex = 0;
        while (rowIndex < height) {
            int columnIndex = 0;
            while (columnIndex < width) {
                int otherRed = (pixels[pixelIndex] >> 16 & 0xFF) * transparency;
                int otherGreen = (pixels[pixelIndex] >> 8 & 0xFF) * transparency;
                int otherBlue = (pixels[pixelIndex] & 0xFF) * transparency;
                int transparentColour = (red + otherRed >> 8 << 16) + (green + otherGreen >> 8 << 8) + (blue + otherBlue >> 8);
                DrawingArea.pixels[pixelIndex++] = transparentColour;
                ++columnIndex;
            }
            pixelIndex += leftOver;
            ++rowIndex;
        }
    }

    public static void drawAlphaFilledPixels(int xPos, int yPos, int pixelWidth, int pixelHeight, int color, int alpha) {
        if (xPos < clipLeft) {
            pixelWidth -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            pixelHeight -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + pixelWidth > clipRight) {
            pixelWidth = clipRight - xPos;
        }
        if (yPos + pixelHeight > clipBottom) {
            pixelHeight = clipBottom - yPos;
        }
        color = ((color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((color & 0xFF00) * alpha >> 8 & 0xFF00);
        int k1 = 256 - alpha;
        int l1 = width - pixelWidth;
        int i2 = xPos + yPos * width;
        int j2 = 0;
        while (j2 < pixelHeight) {
            int k2 = -pixelWidth;
            while (k2 < 0) {
                int l2 = pixels[i2];
                l2 = ((l2 & 0xFF00FF) * k1 >> 8 & 0xFF00FF) + ((l2 & 0xFF00) * k1 >> 8 & 0xFF00);
                DrawingArea.pixels[i2++] = color + l2;
                ++k2;
            }
            i2 += l1;
            ++j2;
        }
    }

    public static void drawBoxOutline(int leftX, int topY, int width, int height, int rgbColour) {
        DrawingArea.drawHorizontalLine(leftX, topY, width, rgbColour);
        DrawingArea.drawHorizontalLine(leftX, topY + height - 1, width, rgbColour);
        DrawingArea.drawVerticalLine(leftX, topY, height, rgbColour);
        DrawingArea.drawVerticalLine(leftX + width - 1, topY, height, rgbColour);
    }

    public static void drawVerticalLine(int xPosition, int yPosition, int height, int rgbColour) {
        if (xPosition < clipLeft || xPosition >= clipRight) {
            return;
        }
        if (yPosition < clipTop) {
            height -= clipTop - yPosition;
            yPosition = clipTop;
        }
        if (yPosition + height > clipBottom) {
            height = clipBottom - yPosition;
        }
        int pixelIndex = xPosition + yPosition * width;
        int rowIndex = 0;
        while (rowIndex < height) {
            DrawingArea.pixels[pixelIndex + rowIndex * DrawingArea.width] = rgbColour;
            ++rowIndex;
        }
    }

    public static void drawVerticalLine(int x, int y, int length, int color, int alpha) {
        if (x < clipLeft || x >= clipRight) {
            return;
        }
        if (y < clipTop) {
            length -= clipTop - y;
            y = clipTop;
        }
        if (y + length > clipBottom) {
            length = clipBottom - y;
        }
        int j1 = 256 - alpha;
        int k1 = (color >> 16 & 0xFF) * alpha;
        int l1 = (color >> 8 & 0xFF) * alpha;
        int i2 = (color & 0xFF) * alpha;
        int i3 = x + y * width;
        int pixelIndex = x + y * width;
        int rowIndex = 0;
        while (rowIndex < length) {
            int dest_red = (pixels[i3] >> 16 & 0xFF) * j1;
            int dest_green = (pixels[i3] >> 8 & 0xFF) * j1;
            int dest_blue = (pixels[i3] & 0xFF) * j1;
            int result_rgb = (k1 + dest_red >> 8 << 16) + (l1 + dest_green >> 8 << 8) + (i2 + dest_blue >> 8);
            DrawingArea.drawAlpha(pixels, pixelIndex + rowIndex * width, result_rgb, result_rgb, 255);
            ++rowIndex;
        }
    }

    public static void drawLineSimple(int x1, int y1, int x2, int y2, int color, int alpha) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        while (true) {
            DrawingArea.drawAlpha(pixels, x1 + y1 * width, color, color, alpha);
            if (x1 == x2 && y1 == y2) break;
            int e2 = err * 2;
            if (e2 > -dy) {
                err -= dy;
                x1 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y1 += sy;
        }
    }

    public static void fillPolygon(int[] xPoints, int[] yPoints, int nPoints, int color, int alpha) {
        if (nPoints < 3) {
            return;
        }
        int minY = yPoints[0];
        int maxY = yPoints[0];
        int i = 1;
        while (i < nPoints) {
            if (yPoints[i] < minY) {
                minY = yPoints[i];
            }
            if (yPoints[i] > maxY) {
                maxY = yPoints[i];
            }
            ++i;
        }
        if (minY < clipTop) {
            minY = clipTop;
        }
        if (maxY > clipBottom) {
            maxY = clipBottom;
        }
        int y = minY;
        while (y < maxY) {
            int j;
            int[] intersections = new int[nPoints];
            int count = 0;
            int i2 = 0;
            while (i2 < nPoints) {
                j = (i2 + 1) % nPoints;
                int y1 = yPoints[i2];
                int y2 = yPoints[j];
                if (y1 <= y && y < y2 || y2 <= y && y < y1) {
                    int x1 = xPoints[i2];
                    int x2 = xPoints[j];
                    int x = x1 + (y - y1) * (x2 - x1) / (y2 - y1);
                    intersections[count++] = x;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < count - 1) {
                j = i2 + 1;
                while (j < count) {
                    if (intersections[i2] > intersections[j]) {
                        int temp = intersections[i2];
                        intersections[i2] = intersections[j];
                        intersections[j] = temp;
                    }
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < count) {
                if (i2 + 1 < count) {
                    int x1 = intersections[i2];
                    int x2 = intersections[i2 + 1];
                    if (x1 < clipLeft) {
                        x1 = clipLeft;
                    }
                    if (x2 > clipRight) {
                        x2 = clipRight;
                    }
                    int x = x1;
                    while (x < x2) {
                        DrawingArea.drawPixel(x, y, color, alpha);
                        ++x;
                    }
                }
                i2 += 2;
            }
            ++y;
        }
    }

    public static void method339(int i, int j, int k, int l) {
        if (i < clipTop || i >= clipBottom) {
            return;
        }
        if (l < clipLeft) {
            k -= clipLeft - l;
            l = clipLeft;
        }
        if (l + k > clipRight) {
            k = clipRight - l;
        }
        int i1 = l + i * width;
        int j1 = 0;
        while (j1 < k) {
            DrawingArea.pixels[i1 + j1] = j;
            ++j1;
        }
    }

    public static void drawPixelsWithOpacity(int color, int yPos, int pixelWidth, int pixelHeight, int opacityLevel, int xPos) {
        if (xPos < clipLeft) {
            pixelWidth -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            pixelHeight -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + pixelWidth > clipRight) {
            pixelWidth = clipRight - xPos;
        }
        if (yPos + pixelHeight > clipBottom) {
            pixelHeight = clipBottom - yPos;
        }
        int l1 = 256 - opacityLevel;
        int i2 = (color >> 16 & 0xFF) * opacityLevel;
        int j2 = (color >> 8 & 0xFF) * opacityLevel;
        int k2 = (color & 0xFF) * opacityLevel;
        int k3 = width - pixelWidth;
        int l3 = xPos + yPos * width;
        if (l3 > pixels.length - 1) {
            l3 = pixels.length - 1;
        }
        int i4 = 0;
        while (i4 < pixelHeight) {
            int j4 = -pixelWidth;
            while (j4 < 0) {
                int l2 = (pixels[l3] >> 16 & 0xFF) * l1;
                int i3 = (pixels[l3] >> 8 & 0xFF) * l1;
                int j3 = (pixels[l3] & 0xFF) * l1;
                int k4 = (i2 + l2 >> 8 << 16) + (j2 + i3 >> 8 << 8) + (k2 + j3 >> 8);
                DrawingArea.pixels[l3++] = k4;
                ++j4;
            }
            l3 += k3;
            ++i4;
        }
    }

    public static void drawAlphaPixels(int x, int y, int w, int h, int color, int alpha) {
        if (x < clipLeft) {
            w -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            h -= clipTop - y;
            y = clipTop;
        }
        if (x + w > clipRight) {
            w = clipRight - x;
        }
        if (y + h > clipBottom) {
            h = clipBottom - y;
        }
        int l1 = 256 - alpha;
        int i2 = (color >> 16 & 0xFF) * alpha;
        int j2 = (color >> 8 & 0xFF) * alpha;
        int k2 = (color & 0xFF) * alpha;
        int k3 = width - w;
        int l3 = x + y * width;
        int i4 = 0;
        while (i4 < h) {
            int j4 = -w;
            while (j4 < 0) {
                int l2 = (pixels[l3] >> 16 & 0xFF) * l1;
                int i3 = (pixels[l3] >> 8 & 0xFF) * l1;
                int j3 = (pixels[l3] & 0xFF) * l1;
                int k4 = (i2 + l2 >> 8 << 16) + (j2 + i3 >> 8 << 8) + (k2 + j3 >> 8);
                DrawingArea.drawAlpha(pixels, l3++, k4, k4, alpha);
                ++j4;
            }
            l3 += k3;
            ++i4;
        }
    }

    public static void defaultDrawingAreaSize() {
        clipLeft = 0;
        clipTop = 0;
        clipRight = width;
        clipBottom = height;
        viewportRX = clipRight;
        viewport_centerX = clipRight / 1;
    }

    public static void setDrawingArea(int yBottom, int xTop, int xBottom, int yTop) {
        if (xTop < 0) {
            xTop = 0;
        }
        if (yTop < 0) {
            yTop = 0;
        }
        if (xBottom > width) {
            xBottom = width;
        }
        if (yBottom > height) {
            yBottom = height;
        }
        clipLeft = xTop;
        clipTop = yTop;
        clipRight = xBottom;
        clipBottom = yBottom;
        viewportRX = clipRight;
        viewport_centerX = clipRight / 2;
        viewport_centerY = clipBottom / 2;
    }

    public static int clamp(int x, int a, int b) {
        return x < a ? a : (x > b ? b : x);
    }

    public static void blur(int[] in, int[] out, int width, int height, int radius) {
        int widthMinus1 = width - 1;
        int tableSize = 2 * radius + 1;
        int[] divide = new int[256 * tableSize];
        int i = 0;
        while (i < 256 * tableSize) {
            divide[i] = i / tableSize;
            ++i;
        }
        int inIndex = 0;
        int y = 0;
        while (y < height) {
            int outIndex = y;
            int ta = 0;
            int tr = 0;
            int tg = 0;
            int tb = 0;
            int i2 = -radius;
            while (i2 <= radius) {
                int rgb = in[inIndex + DrawingArea.clamp(i2, 0, width - 1)];
                ta += rgb >> 24 & 0xFF;
                tr += rgb >> 16 & 0xFF;
                tg += rgb >> 8 & 0xFF;
                tb += rgb & 0xFF;
                ++i2;
            }
            int x = 0;
            while (x < width) {
                int i22;
                out[outIndex] = divide[ta] << 24 | divide[tr] << 16 | divide[tg] << 8 | divide[tb];
                int i1 = x + radius + 1;
                if (i1 > widthMinus1) {
                    i1 = widthMinus1;
                }
                if ((i22 = x - radius) < 0) {
                    i22 = 0;
                }
                int rgb1 = in[inIndex + i1];
                int rgb2 = in[inIndex + i22];
                ta += (rgb1 >> 24 & 0xFF) - (rgb2 >> 24 & 0xFF);
                tr += (rgb1 & 0xFF0000) - (rgb2 & 0xFF0000) >> 16;
                tg += (rgb1 & 0xFF00) - (rgb2 & 0xFF00) >> 8;
                tb += (rgb1 & 0xFF) - (rgb2 & 0xFF);
                outIndex += height;
                ++x;
            }
            inIndex += width;
            ++y;
        }
    }

    public static void drawDiagonalLine(int x, int y, int areaWidth, int areaHeight, int color) {
        areaWidth -= x;
        if ((areaHeight -= y) == 0) {
            if (areaWidth >= 0) {
                DrawingArea.drawHorizontalLine(x, y, areaWidth + 1, color);
                return;
            }
            DrawingArea.drawHorizontalLine(x + areaWidth, y, -areaWidth + 1, color);
            return;
        }
        if (areaWidth == 0) {
            if (areaHeight >= 0) {
                DrawingArea.drawVLine(x, y, areaHeight + 1, color);
                return;
            }
            DrawingArea.drawHLine(x, y + areaHeight, -areaHeight + 1, color);
            return;
        }
        if (areaWidth + areaHeight < 0) {
            x += areaWidth;
            areaWidth = -areaWidth;
            y += areaHeight;
            areaHeight = -areaHeight;
        }
        if (areaWidth > areaHeight) {
            y <<= 16;
            y += 32768;
            int j1 = (int)Math.floor((double)(areaHeight <<= 16) / (double)areaWidth + 0.5);
            areaWidth += x;
            if (x < clipLeft) {
                y += j1 * (clipLeft - x);
                x = clipLeft;
            }
            if (areaWidth >= clipRight) {
                areaWidth = clipRight - 1;
            }
            while (x <= areaWidth) {
                int l1 = y >> 16;
                if (l1 >= clipTop && l1 < clipBottom) {
                    DrawingArea.pixels[x + l1 * DrawingArea.width] = color;
                }
                y += j1;
                ++x;
            }
            return;
        }
        x <<= 16;
        x += 32768;
        int k1 = (int)Math.floor((double)(areaWidth <<= 16) / (double)areaHeight + 0.5);
        areaHeight += y;
        if (y < clipTop) {
            x += k1 * (clipTop - y);
            y = clipTop;
        }
        if (areaHeight >= clipBottom) {
            areaHeight = clipBottom - 1;
        }
        while (y <= areaHeight) {
            int i2 = x >> 16;
            if (i2 >= clipLeft && i2 < clipRight) {
                DrawingArea.pixels[i2 + y * DrawingArea.width] = color;
            }
            x += k1;
            ++y;
        }
    }

    public static void drawGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < clipLeft) {
            gradientWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            k1 += (clipTop - y) * l1;
            gradientHeight -= clipTop - y;
            y = clipTop;
        }
        if (x + gradientWidth > clipRight) {
            gradientWidth = clipRight - x;
        }
        if (y + gradientHeight > clipBottom) {
            gradientHeight = clipBottom - y;
        }
        int i2 = width - gradientWidth;
        int j2 = x + y * width;
        int k2 = -gradientHeight;
        while (k2 < 0) {
            int l2 = 65536 - k1 >> 8;
            int i3 = k1 >> 8;
            int j3 = ((startColor & 0xFF00FF) * l2 + (endColor & 0xFF00FF) * i3 & 0xFF00FF00) + ((startColor & 0xFF00) * l2 + (endColor & 0xFF00) * i3 & 0xFF0000) >>> 8;
            int k3 = -gradientWidth;
            while (k3 < 0) {
                DrawingArea.pixels[j2++] = j3;
                ++k3;
            }
            j2 += i2;
            k1 += l1;
            ++k2;
        }
    }

    public static void drawAlphaGradient2(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor, int alpha) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < clipLeft) {
            gradientWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            k1 -= (clipTop - y) * l1;
            gradientHeight -= clipTop - y;
            y = clipTop;
        }
        if (x + gradientWidth > clipRight) {
            gradientWidth = clipRight - x;
        }
        if (y + gradientHeight > clipBottom) {
            gradientHeight = clipBottom - y;
        }
        int i2 = width - gradientWidth;
        int total_pixels = x + y * width;
        int k2 = -gradientHeight;
        while (k2 < 0) {
            int alpha2 = (gradientHeight + k2) * (gradientHeight / alpha);
            int result_alpha = 256 - alpha2;
            int gradient1 = 65536 - k1 >> 8;
            int gradient2 = k1 >> 8;
            int gradient_color = ((startColor & 0xFF00FF) * gradient1 + (endColor & 0xFF00FF) * gradient2 & 0xFF00FF00) + ((startColor & 0xFF00) * gradient1 + (endColor & 0xFF00) * gradient2 & 0xFF0000) >>> 8;
            int color = ((gradient_color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((gradient_color & 0xFF00) * alpha >> 8 & 0xFF00);
            int k3 = -gradientWidth;
            while (k3 < 0) {
                int colored_pixel = pixels[total_pixels];
                colored_pixel = ((colored_pixel & 0xFF00FF) * result_alpha >> 8 & 0xFF00FF) + ((colored_pixel & 0xFF00) * result_alpha >> 8 & 0xFF00);
                DrawingArea.pixels[total_pixels++] = color + colored_pixel;
                ++k3;
            }
            total_pixels += i2;
            k1 -= l1;
            ++k2;
        }
    }

    public static void method336(int i, int j, int k, int l, int i1) {
        if (k < clipLeft) {
            i1 -= clipLeft - k;
            k = clipLeft;
        }
        if (j < clipTop) {
            i -= clipTop - j;
            j = clipTop;
        }
        if (k + i1 > clipRight) {
            i1 = clipRight - k;
        }
        if (j + i > clipBottom) {
            i = clipBottom - j;
        }
        int k1 = width - i1;
        int l1 = k + j * width;
        int i2 = -i;
        while (i2 < 0) {
            int j2 = -i1;
            while (j2 < 0) {
                DrawingArea.pixels[l1++] = l;
                ++j2;
            }
            l1 += k1;
            ++i2;
        }
    }

    public void drawAlphaGradient(int x, int y, int gradientWidth, int gradientHeight, int startColor, int endColor, int alpha) {
        int k1 = 0;
        int l1 = 65536 / gradientHeight;
        if (x < clipLeft) {
            gradientWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            k1 += (clipTop - y) * l1;
            gradientHeight -= clipTop - y;
            y = clipTop;
        }
        if (x + gradientWidth > clipRight) {
            gradientWidth = clipRight - x;
        }
        if (y + gradientHeight > clipBottom) {
            gradientHeight = clipBottom - y;
        }
        int i2 = width - gradientWidth;
        int result_alpha = 256 - alpha;
        int total_pixels = x + y * width;
        int k2 = -gradientHeight;
        while (k2 < 0) {
            int gradient1 = 65536 - k1 >> 8;
            int gradient2 = k1 >> 8;
            int gradient_color = ((startColor & 0xFF00FF) * gradient1 + (endColor & 0xFF00FF) * gradient2 & 0xFF00FF00) + ((startColor & 0xFF00) * gradient1 + (endColor & 0xFF00) * gradient2 & 0xFF0000) >>> 8;
            int color = ((gradient_color & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((gradient_color & 0xFF00) * alpha >> 8 & 0xFF00);
            int k3 = -gradientWidth;
            while (k3 < 0) {
                int colored_pixel = pixels[total_pixels];
                colored_pixel = ((colored_pixel & 0xFF00FF) * result_alpha >> 8 & 0xFF00FF) + ((colored_pixel & 0xFF00) * result_alpha >> 8 & 0xFF00);
                DrawingArea.pixels[total_pixels++] = color + colored_pixel;
                ++k3;
            }
            total_pixels += i2;
            k1 += l1;
            ++k2;
        }
    }

    public static void drawAlphaHorizontalLine2(int x, int y, int lineWidth, int color, int alpha) {
        if (y < clipTop || y >= clipBottom) {
            return;
        }
        if (x < clipLeft) {
            lineWidth -= clipLeft - x;
            x = clipLeft;
        }
        if (x + lineWidth > clipRight) {
            lineWidth = clipRight - x;
        }
        int i3 = x + y * width;
        int j3 = 0;
        while (j3 < lineWidth) {
            int alpha2 = (lineWidth - j3) / (lineWidth / alpha);
            int j1 = 256 - alpha2;
            int k1 = (color >> 16 & 0xFF) * alpha2;
            int l1 = (color >> 8 & 0xFF) * alpha2;
            int i2 = (color & 0xFF) * alpha2;
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            DrawingArea.pixels[i3++] = k3;
            ++j3;
        }
    }

    public static void resetDepthBuffer() {
        int i = width * height;
        if (depthBuffer.length != i) {
            depthBuffer = new float[i];
        }
        Arrays.fill(depthBuffer, (float)i);
    }

    public static void resetImage() {
        Arrays.fill(pixels, 0);
    }

    public static void drawVLine(int x, int y, int height, int colour) {
        if (x < clipLeft || x >= clipBottom) {
            return;
        }
        if (y < clipTop) {
            height -= clipTop - y;
            y = clipTop;
        }
        if (y + height > clipRight) {
            height = clipRight - y;
        }
        int ptr = x + y * width;
        int y_off = 0;
        while (y_off < height) {
            DrawingArea.pixels[ptr + y_off * DrawingArea.width] = colour;
            ++y_off;
        }
    }

    public static void blur(int x, int y, int width, int height, int speed) {
        try {
            DrawingArea.blur(pixels, pixels, width, height, speed);
            DrawingArea.blur(pixels, pixels, height, width, speed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void drawHLine(int x, int y, int width, int colour) {
        if (y < clipTop || y >= clipBottom) {
            return;
        }
        if (x < clipLeft) {
            width -= clipLeft - x;
            x = clipLeft;
        }
        if (x + width > clipRight) {
            width = clipRight - x;
        }
        int i1 = x + y * DrawingArea.width;
        int x_off = 0;
        while (x_off < width) {
            DrawingArea.pixels[i1 + x_off] = colour;
            ++x_off;
        }
    }

    public static void drawCheckbox(int x, int y, boolean checked, boolean hovered, String label, int[] colors, boolean rightAlignedText) {
        int boxSize = 23;
        int border = 2;
        int opacity = 256;
        int bg0 = colors[0];
        int bg1 = colors[1];
        int bg2 = colors[2];
        int bg3 = colors[3];
        int hoverColor = colors[4];
        int textColor = 16684830;
        int innerColor = hovered ? hoverColor : bg2;
        DrawingArea.drawPixels(boxSize, y, x, bg0, boxSize);
        DrawingArea.drawPixels(boxSize - 2, y + 1, x + 1, bg1, boxSize - 2);
        DrawingArea.drawPixels(boxSize - 4, y + 2, x + 2, innerColor, boxSize - 4);
        if (checked) {
            DrawingArea.drawCheckMark(x + boxSize / 4 + 2, y + boxSize / 4 + 2, 8, 0xFFFFFF, 255);
        }
        if (label != null && !label.isEmpty()) {
            if (rightAlignedText) {
                Client.getClient().smallText.drawRightAlignedString(label, x - boxSize + 20, y + boxSize / 2 + 5, textColor, true);
            } else {
                Client.getClient().smallText.drawChatInput(textColor, x + boxSize + 5, label, y + boxSize / 2 + 5, true);
            }
        }
    }

    public static void drawHorizontalLine(int x, int y, int length, int color, int alpha) {
        if (y < clipTop || y >= clipBottom) {
            return;
        }
        if (x < clipLeft) {
            length -= clipLeft - x;
            x = clipLeft;
        }
        if (x + length > clipRight) {
            length = clipRight - x;
        }
        int j1 = 256 - alpha;
        int k1 = (color >> 16 & 0xFF) * alpha;
        int l1 = (color >> 8 & 0xFF) * alpha;
        int i2 = (color & 0xFF) * alpha;
        int i3 = x + y * width;
        int j3 = 0;
        while (j3 < length) {
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            DrawingArea.drawAlpha(pixels, i3++, k3, k3, alpha);
            ++j3;
        }
    }

    protected static void drawAlpha(int[] pixels, int index, int value, int color, int alpha) {
        if (alpha == 0) {
            return;
        }
        int prevColor = pixels[index];
        if ((prevColor & 0xFF000000) == 0 || alpha == 255) {
            pixels[index] = color & 0xFFFFFF | alpha << 24;
            return;
        }
        if ((prevColor & 0xFF000000) == -16777216) {
            pixels[index] = value | 0xFF000000;
            return;
        }
        int prevAlpha = (prevColor >>> 24) * (255 - alpha) >>> 8;
        int finalAlpha = alpha + prevAlpha;
        int relativeAlpha1 = (alpha << 8) / finalAlpha;
        int relativeAlpha2 = (prevAlpha << 8) / finalAlpha;
        int finalColor = ((color & 0xFF00FF) * relativeAlpha1 + (prevColor & 0xFF00FF) * relativeAlpha2 & 0xFF00FF00 | (color & 0xFF00) * relativeAlpha1 + (prevColor & 0xFF00) * relativeAlpha2 & 0xFF0000) >>> 8;
        pixels[index] = finalColor | finalAlpha << 24;
    }

    public static void fillRectangle(int color, int y, int widthz, int heightz, int opacity, int x) {
        if (x < clipLeft) {
            widthz -= clipLeft - x;
            x = clipLeft;
        }
        if (y < clipTop) {
            heightz -= clipTop - y;
            y = clipTop;
        }
        if (x + widthz > clipRight) {
            widthz = clipRight - x;
        }
        if (y + heightz > clipBottom) {
            heightz = clipBottom - y;
        }
        int decodedOpacity = 256 - opacity;
        int red = (color >> 16 & 0xFF) * opacity;
        int green = (color >> 8 & 0xFF) * opacity;
        int blue = (color & 0xFF) * opacity;
        int pixelWidthStep = width - widthz;
        int startPixel = x + y * width;
        int h = 0;
        while (h < heightz) {
            int w = -widthz;
            while (w < 0) {
                int pixelRed = (pixels[startPixel] >> 16 & 0xFF) * decodedOpacity;
                int pixelBlue = (pixels[startPixel] >> 8 & 0xFF) * decodedOpacity;
                int pixelGreen = (pixels[startPixel] & 0xFF) * decodedOpacity;
                int pixelRGB = (red + pixelRed >> 8 << 16) + (green + pixelBlue >> 8 << 8) + (blue + pixelGreen >> 8);
                DrawingArea.pixels[startPixel++] = pixelRGB;
                ++w;
            }
            startPixel += pixelWidthStep;
            ++h;
        }
    }

    public static void drawPixels(int height_, int yPos, int xPos, int color, int width_, int alpha) {
        if (xPos < clipLeft) {
            width_ -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            height_ -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + width_ > clipRight) {
            width_ = clipRight - xPos;
        }
        if (yPos + height_ > clipBottom) {
            height_ = clipBottom - yPos;
        }
        int decodedOpacity = 256 - alpha;
        int widthPixelStep = width - width_;
        int startPixel = xPos + yPos * width;
        int red = (color >> 16 & 0xFF) * alpha;
        int green = (color >> 8 & 0xFF) * alpha;
        int blue = (color & 0xFF) * alpha;
        int i2 = -height_;
        while (i2 < 0) {
            int j2 = -width_;
            while (j2 < 0) {
                int pixelRed = (pixels[startPixel] >> 16 & 0xFF) * decodedOpacity;
                int pixelBlue = (pixels[startPixel] >> 8 & 0xFF) * decodedOpacity;
                int pixelGreen = (pixels[startPixel] & 0xFF) * decodedOpacity;
                int pixelRGB = (red + pixelRed >> 8 << 16) + (green + pixelBlue >> 8 << 8) + (blue + pixelGreen >> 8);
                DrawingArea.pixels[startPixel++] = pixelRGB;
                ++j2;
            }
            startPixel += widthPixelStep;
            ++i2;
        }
    }

    public static void drawPixels(int height_, int yPos, int xPos, int color, int width_) {
        if (xPos < clipLeft) {
            width_ -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            height_ -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + width_ > clipRight) {
            width_ = clipRight - xPos;
        }
        if (yPos + height_ > clipBottom) {
            height_ = clipBottom - yPos;
        }
        int k1 = width - width_;
        int l1 = xPos + yPos * width;
        int i2 = -height_;
        while (i2 < 0) {
            int j2 = -width_;
            while (j2 < 0) {
                int s;
                if ((s = l1++) < pixels.length) {
                    DrawingArea.pixels[s] = color;
                }
                ++j2;
            }
            l1 += k1;
            ++i2;
        }
    }

    public static void drawPixelsDiagonal(int height_, int yPos, int xPos, int color, int width_, boolean diagonal) {
        if (xPos < clipLeft) {
            width_ -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (yPos < clipTop) {
            height_ -= clipTop - yPos;
            yPos = clipTop;
        }
        if (xPos + width_ > clipRight) {
            width_ = clipRight - xPos;
        }
        if (yPos + height_ > clipBottom) {
            height_ = clipBottom - yPos;
        }
        int rowSkip = width - width_;
        int pixelIndex = xPos + yPos * width;
        int y = 0;
        while (y < height_) {
            int x = 0;
            while (x < width_) {
                int cutSize;
                if (diagonal && x >= width_ - (cutSize = 14) && y < x - (width_ - cutSize)) {
                    ++pixelIndex;
                } else {
                    if (pixelIndex < pixels.length) {
                        DrawingArea.pixels[pixelIndex] = color;
                    }
                    ++pixelIndex;
                }
                ++x;
            }
            pixelIndex += rowSkip;
            ++y;
        }
    }

    public static void drawBeveledAngledLine(int x, int y, int width, int height, int angleDeg, int[] colours) {
        double angle = Math.toRadians(angleDeg);
        double dx = Math.sin(angle);
        double dy = -Math.cos(angle);
        DrawingArea.drawAngledLine(x, y, width, height, dx, dy, colours[0]);
        DrawingArea.drawAngledLine((int)((double)x + dx), (int)((double)y + dy), width - 2, height - 2, dx, dy, colours[1]);
        DrawingArea.drawAngledLine((int)((double)x + dx * 2.0), (int)((double)y + dy * 2.0), width - 4, height - 4, dx, dy, colours[2]);
    }

    public static void drawAngledLine(int x, int y, int width, int height, double dx, double dy, int color) {
        double px = -dy;
        double py = dx;
        int halfWidth = width / 2;
        int cLeft = clipLeft;
        int cRight = clipRight;
        int cTop = clipTop;
        int cBottom = clipBottom;
        int canvasWidth = DrawingArea.width;
        int[] pixelBuffer = pixels;
        int i = 0;
        while (i < height) {
            double centerX = (double)x + dx * (double)i;
            double centerY = (double)y + dy * (double)i;
            int t = -halfWidth;
            while (t <= halfWidth) {
                int lx = (int)(centerX + px * (double)t);
                int ly = (int)(centerY + py * (double)t);
                if (lx >= cLeft && lx < cRight && ly >= cTop && ly < cBottom) {
                    pixelBuffer[lx + ly * canvasWidth] = color;
                }
                ++t;
            }
            ++i;
        }
    }

    public static void drawTick(int x, int y, int width, int height, int color, int alpha, int thickness) {
        if (width < 10) {
            width = 10;
        }
        if (height < 10) {
            height = 10;
        }
        int leftX = x;
        int midX = x + width * 2 / 5;
        int rightX = x + width;
        int topY = y;
        int midY = y + height * 3 / 4;
        int bottomY = y + height;
        int t = 0;
        while (t < thickness) {
            DrawingArea.drawLine(leftX, midY - t, midX + t, bottomY - t, color, alpha);
            DrawingArea.drawLine(midX + t, bottomY - t, rightX, topY + t, color, alpha);
            if (t > 0) {
                DrawingArea.drawLine(leftX + t, midY, midX, bottomY, color, alpha);
                DrawingArea.drawLine(midX, bottomY, rightX - t, topY, color, alpha);
            }
            ++t;
        }
    }

    public static void drawCross(int x, int y, int width, int height, int color, int alpha, int thickness) {
        if (width < 6) {
            width = 6;
        }
        if (height < 6) {
            height = 6;
        }
        int leftX = x;
        int rightX = x + width;
        int topY = y;
        int bottomY = y + height;
        int t = 0;
        while (t < thickness) {
            DrawingArea.drawLine(leftX + t, topY + t, rightX - t, bottomY - t, color, alpha);
            DrawingArea.drawLine(rightX - t, topY + t, leftX + t, bottomY - t, color, alpha);
            if (t > 0) {
                DrawingArea.drawLine(leftX, topY + t, rightX - t, bottomY, color, alpha);
                DrawingArea.drawLine(leftX + t, topY, rightX, bottomY - t, color, alpha);
                DrawingArea.drawLine(rightX - t, topY, leftX, bottomY - t, color, alpha);
                DrawingArea.drawLine(rightX, topY + t, leftX + t, bottomY, color, alpha);
            }
            ++t;
        }
    }

    public static void fillPixels(int i, int j, int k, int l, int i1) {
        DrawingArea.drawLine(i1, l, j, i);
        DrawingArea.drawLine(i1 + k - 1, l, j, i);
        DrawingArea.drawLineVertical(i1, l, k, i);
        DrawingArea.drawLineVertical(i1, l, k, i + j - 1);
    }

    public static void drawRectangle(int y, int height, int opacity, int color, int width, int x) {
        DrawingArea.drawHLine(color, width, y, opacity, x);
        DrawingArea.drawHLine(color, width, y + height - 1, opacity, x);
        if (height >= 3) {
            DrawingArea.drawVLine(color, x, opacity, y + 1, height - 2);
            DrawingArea.drawVLine(color, x + width - 1, opacity, y + 1, height - 2);
        }
    }

    public static void drawRectangle(int x, int y, int width, int height, int color) {
        DrawingArea.drawHorizontalLine(x, y, width, color);
        DrawingArea.drawHorizontalLine(x, y + height - 1, width, color);
        DrawingArea.drawVerticalLine(x, y, height, color);
        DrawingArea.drawVerticalLine(x + width - 1, y, height, color);
    }

    public static void drawLine(int yPos, int color, int widthToDraw, int xPos) {
        if (yPos < clipTop || yPos >= clipBottom) {
            return;
        }
        if (xPos < clipLeft) {
            widthToDraw -= clipLeft - xPos;
            xPos = clipLeft;
        }
        if (xPos + widthToDraw > clipRight) {
            widthToDraw = clipRight - xPos;
        }
        int base = xPos + yPos * width;
        int ptr = 0;
        while (ptr < widthToDraw) {
            DrawingArea.pixels[base + ptr] = color;
            ++ptr;
        }
    }

    public static void drawHorizontalLine(int i, int j, int k, int l) {
        if (i < clipTop || i >= clipBottom) {
            return;
        }
        if (l < clipLeft) {
            k -= clipLeft - l;
            l = clipLeft;
        }
        if (l + k > clipRight) {
            k = clipRight - l;
        }
        int i1 = l + i * width;
        int j1 = 0;
        while (j1 < k) {
            DrawingArea.pixels[i1 + j1] = j;
            ++j1;
        }
    }

    public static void drawCircle(int centerX, int centerY, int radius, int borderColor, int alpha) {
        int x = radius;
        int y = 0;
        int radiusError = 1 - x;
        while (x >= y) {
            DrawingArea.plotCirclePoints(centerX, centerY, x, y, borderColor, alpha);
            ++y;
            if (radiusError < 0) {
                radiusError += 2 * y + 1;
                continue;
            }
            radiusError += 2 * (y - --x + 1);
        }
    }

    private static void plotCirclePoints(int centerX, int centerY, int x, int y, int color, int alpha) {
        DrawingArea.plotPixel(centerX + x, centerY + y, color, alpha);
        DrawingArea.plotPixel(centerX - x, centerY + y, color, alpha);
        DrawingArea.plotPixel(centerX + x, centerY - y, color, alpha);
        DrawingArea.plotPixel(centerX - x, centerY - y, color, alpha);
        DrawingArea.plotPixel(centerX + y, centerY + x, color, alpha);
        DrawingArea.plotPixel(centerX - y, centerY + x, color, alpha);
        DrawingArea.plotPixel(centerX + y, centerY - x, color, alpha);
        DrawingArea.plotPixel(centerX - y, centerY - x, color, alpha);
    }

    private static void plotPixel(int x, int y, int color, int alpha) {
        if (x >= clipLeft && x < clipRight && y >= clipTop && y < clipBottom) {
            int decodedOpacity = 256 - alpha;
            int red = (color >> 16 & 0xFF) * alpha;
            int green = (color >> 8 & 0xFF) * alpha;
            int blue = (color & 0xFF) * alpha;
            int pixelIndex = x + y * width;
            int pixelRed = (pixels[pixelIndex] >> 16 & 0xFF) * decodedOpacity;
            int pixelGreen = (pixels[pixelIndex] >> 8 & 0xFF) * decodedOpacity;
            int pixelBlue = (pixels[pixelIndex] & 0xFF) * decodedOpacity;
            DrawingArea.pixels[pixelIndex] = (red + pixelRed >> 8 << 16) + (green + pixelGreen >> 8 << 8) + (blue + pixelBlue >> 8);
        }
    }

    public static void fillCircleNew(int centerX, int centerY, int radius, int color, int alpha) {
        int x = radius;
        int y = 0;
        int radiusError = 1 - x;
        while (x >= y) {
            DrawingArea.drawHorizontalLine(centerX - x, centerY + y, 2 * x + 1, color, alpha);
            DrawingArea.drawHorizontalLine(centerX - x, centerY - y, 2 * x + 1, color, alpha);
            DrawingArea.drawHorizontalLine(centerX - y, centerY + x, 2 * y + 1, color, alpha);
            DrawingArea.drawHorizontalLine(centerX - y, centerY - x, 2 * y + 1, color, alpha);
            ++y;
            if (radiusError < 0) {
                radiusError += 2 * y + 1;
                continue;
            }
            radiusError += 2 * (y - --x + 1);
        }
    }

    protected static void drawHLine(int i, int j, int k, int l, int i1) {
        if (k < clipTop || k >= clipBottom) {
            return;
        }
        if (i1 < clipLeft) {
            j -= clipLeft - i1;
            i1 = clipLeft;
        }
        if (i1 + j > clipRight) {
            j = clipRight - i1;
        }
        int j1 = 256 - l;
        int k1 = (i >> 16 & 0xFF) * l;
        int l1 = (i >> 8 & 0xFF) * l;
        int i2 = (i & 0xFF) * l;
        int i3 = i1 + k * width;
        int j3 = 0;
        while (j3 < j) {
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            int k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            DrawingArea.pixels[i3++] = k3;
            ++j3;
        }
    }

    public static void drawRoundedRectangle(int x, int y, int width, int height, int color, int radius, int opacity) {
        DrawingArea.drawCircleSegment(x + radius, y + radius, radius, 1, color, opacity);
        DrawingArea.drawCircleSegment(x + width - radius, y + radius, radius, 2, color, opacity);
        DrawingArea.drawCircleSegment(x + radius, y + height - radius, radius, 3, color, opacity);
        DrawingArea.drawCircleSegment(x + width - radius, y + height - radius, radius, 4, color, opacity);
        DrawingArea.drawHorizontalLine(x + radius, y, width - 2 * radius, color, opacity);
        DrawingArea.drawHorizontalLine(x + radius, y + height - 1, width - 2 * radius, color, opacity);
        DrawingArea.drawVerticalLine(x, y + radius, height - 2 * radius, color, opacity);
        DrawingArea.drawVerticalLine(x + width - 1, y + radius, height - 2 * radius, color, opacity);
    }

    public static void drawCircleSegment(int centerX, int centerY, int radius, int segment, int color, int opacity) {
        int squareRadius = radius * radius;
        int y = -radius;
        while (y <= radius) {
            int x = -radius;
            while (x <= radius) {
                if (x * x + y * y <= squareRadius) {
                    switch (segment) {
                        case 1: {
                            if (x > 0 || y > 0) break;
                            DrawingArea.blendPixel(centerX + x, centerY + y, color, opacity);
                            break;
                        }
                        case 2: {
                            if (x < 0 || y > 0) break;
                            DrawingArea.blendPixel(centerX + x, centerY + y, color, opacity);
                            break;
                        }
                        case 3: {
                            if (x > 0 || y < 0) break;
                            DrawingArea.blendPixel(centerX + x, centerY + y, color, opacity);
                            break;
                        }
                        case 4: {
                            if (x < 0 || y < 0) break;
                            DrawingArea.blendPixel(centerX + x, centerY + y, color, opacity);
                        }
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    public static void blendPixel(int x, int y, int color, int opacity) {
        int index;
        if (x >= clipLeft && x < clipRight && y >= clipTop && y < clipBottom && (index = x + y * width) >= 0 && index < pixels.length) {
            int backgroundColor = pixels[index];
            int bgR = backgroundColor >> 16 & 0xFF;
            int bgG = backgroundColor >> 8 & 0xFF;
            int bgB = backgroundColor & 0xFF;
            int fgR = color >> 16 & 0xFF;
            int fgG = color >> 8 & 0xFF;
            int fgB = color & 0xFF;
            int blendedR = (fgR * opacity + bgR * (255 - opacity)) / 255;
            int blendedG = (fgG * opacity + bgG * (255 - opacity)) / 255;
            int blendedB = (fgB * opacity + bgB * (255 - opacity)) / 255;
            DrawingArea.pixels[index] = blendedR << 16 | blendedG << 8 | blendedB;
        }
    }

    public static void fillRoundedRectangle(int x, int y, int width, int height, int radius, int color, int opacity) {
        DrawingArea.fillPixelsWithOpacity(x + radius, y, width - radius * 2, height, color, opacity);
        DrawingArea.fillPixelsWithOpacity(x, y + radius, radius, height - radius * 2, color, opacity);
        DrawingArea.fillPixelsWithOpacity(x + width - radius, y + radius, radius, height - radius * 2, color, opacity);
        DrawingArea.fillPixelsWithOpacity(x + radius, y, width - radius * 2, radius, color, opacity);
        DrawingArea.fillPixelsWithOpacity(x + radius, y + height - radius, width - radius * 2, radius, color, opacity);
        DrawingArea.fillRoundedCornerWithOpacity(x + radius, y + radius, radius, color, opacity, true, true);
        DrawingArea.fillRoundedCornerWithOpacity(x + width - radius - 1, y + radius, radius, color, opacity, false, true);
        DrawingArea.fillRoundedCornerWithOpacity(x + radius, y + height - radius - 1, radius, color, opacity, true, false);
        DrawingArea.fillRoundedCornerWithOpacity(x + width - radius - 1, y + height - radius - 1, radius, color, opacity, false, false);
    }

    public static void fillRoundedCornerWithOpacity(int centerX, int centerY, int radius, int color, int opacity, boolean left, boolean top) {
        int y = -radius;
        while (y <= radius) {
            int x = -radius;
            while (x <= radius) {
                if (x * x + y * y <= radius * radius) {
                    int pixelX = centerX + (left ? -x : x);
                    int pixelY = centerY + (top ? -y : y);
                    if (pixelX >= clipLeft && pixelX < clipRight && pixelY >= clipTop && pixelY < clipBottom) {
                        DrawingArea.blendPixel(pixelX, pixelY, color, opacity);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    public static void fillPixelsWithOpacity(int x, int y, int width, int height, int color, int opacity) {
        int yOffset = 0;
        while (yOffset < height) {
            int xOffset = 0;
            while (xOffset < width) {
                int pixelX = x + xOffset;
                int pixelY = y + yOffset;
                if (pixelX >= clipLeft && pixelX < clipRight && pixelY >= clipTop && pixelY < clipBottom) {
                    DrawingArea.blendPixel(pixelX, pixelY, color, opacity);
                }
                ++xOffset;
            }
            ++yOffset;
        }
    }

    public static void drawLineVertical(int heights, int color, int yPos, int xPos) {
        if (xPos < clipLeft || xPos >= clipRight) {
            return;
        }
        if (heights < clipTop) {
            yPos -= clipTop - heights;
            heights = clipTop;
        }
        if (heights + yPos > clipBottom) {
            yPos = clipBottom - heights;
        }
        int j1 = xPos + heights * width;
        int k1 = 0;
        while (k1 < yPos) {
            if (j1 + k1 * width < pixels.length) {
                DrawingArea.pixels[j1 + k1 * DrawingArea.width] = color;
            }
            ++k1;
        }
    }

    protected static void drawVLine(int i, int j, int k, int l, int i1) {
        if (j < clipLeft || j >= clipRight) {
            return;
        }
        if (l < clipTop) {
            i1 -= clipTop - l;
            l = clipTop;
        }
        if (l + i1 > clipBottom) {
            i1 = clipBottom - l;
        }
        int j1 = 256 - k;
        int k1 = (i >> 16 & 0xFF) * k;
        int l1 = (i >> 8 & 0xFF) * k;
        int i2 = (i & 0xFF) * k;
        int i3 = j + l * width;
        int j3 = 0;
        while (j3 < i1) {
            int k3;
            int j2 = (pixels[i3] >> 16 & 0xFF) * j1;
            int k2 = (pixels[i3] >> 8 & 0xFF) * j1;
            int l2 = (pixels[i3] & 0xFF) * j1;
            DrawingArea.pixels[i3] = k3 = (k1 + j2 >> 8 << 16) + (l1 + k2 >> 8 << 8) + (i2 + l2 >> 8);
            i3 += width;
            ++j3;
        }
    }

    public static void fillCircle(int posX, int posY, int radius, int colour, int alpha) {
        int max;
        int dest_intensity = 256 - alpha;
        int src_red = (colour >> 16 & 0xFF) * alpha;
        int src_green = (colour >> 8 & 0xFF) * alpha;
        int src_blue = (colour & 0xFF) * alpha;
        int radiusPixels = posY - radius;
        if (radiusPixels < 0) {
            radiusPixels = 0;
        }
        if ((max = posY + radius) >= height) {
            max = height - 1;
        }
        int y = radiusPixels;
        while (y <= max) {
            int maxPixelX;
            int beginYPos = y - posY;
            int heighestXPos = (int)Math.sqrt(radius * radius - beginYPos * beginYPos);
            int x = posX - heighestXPos;
            if (x < 0) {
                x = 0;
            }
            if ((maxPixelX = posX + heighestXPos) >= width) {
                maxPixelX = width - 1;
            }
            int pixel_offset = x + y * width;
            int pixelX = x;
            while (pixelX <= maxPixelX) {
                int dest_red = (pixels[pixel_offset] >> 16 & 0xFF) * dest_intensity;
                int dest_green = (pixels[pixel_offset] >> 8 & 0xFF) * dest_intensity;
                int dest_blue = (pixels[pixel_offset] & 0xFF) * dest_intensity;
                int result_rgb = (src_red + dest_red >> 8 << 16) + (src_green + dest_green >> 8 << 8) + (src_blue + dest_blue >> 8);
                DrawingArea.pixels[pixel_offset++] = result_rgb;
                ++pixelX;
            }
            ++y;
        }
    }
}

