/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class BackgroundPanel
extends JPanel {
    public static final int SCALED = 0;
    public static final int TILED = 1;
    public static final int ACTUAL = 2;
    private Paint painter;
    private Image image;
    private int style = 0;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;
    private boolean isTransparentAdd = true;

    public BackgroundPanel(Image image) {
        this(image, 0);
    }

    public BackgroundPanel(Image image, int style) {
        this.setImage(image);
        this.setStyle(style);
        this.setLayout(new BorderLayout());
    }

    public BackgroundPanel(Image image, int style, float alignmentX, float alignmentY) {
        this.setImage(image);
        this.setStyle(style);
        this.setImageAlignmentX(alignmentX);
        this.setImageAlignmentY(alignmentY);
        this.setLayout(new BorderLayout());
    }

    public BackgroundPanel(Paint painter) {
        this.setPaint(painter);
        this.setLayout(new BorderLayout());
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setStyle(int style) {
        this.style = style;
        this.repaint();
    }

    public void setPaint(Paint painter) {
        this.painter = painter;
        this.repaint();
    }

    public void setImageAlignmentX(float alignmentX) {
        this.alignmentX = alignmentX > 1.0f ? 1.0f : (alignmentX < 0.0f ? 0.0f : alignmentX);
        this.repaint();
    }

    public void setImageAlignmentY(float alignmentY) {
        this.alignmentY = alignmentY > 1.0f ? 1.0f : (alignmentY < 0.0f ? 0.0f : alignmentY);
        this.repaint();
    }

    public void add(JComponent component) {
        this.add(component, null);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.image == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    public void add(JComponent component, Object constraints) {
        if (this.isTransparentAdd) {
            this.makeComponentTransparent(component);
        }
        super.add((Component)component, constraints);
    }

    public void setTransparentAdd(boolean isTransparentAdd) {
        this.isTransparentAdd = isTransparentAdd;
    }

    private void makeComponentTransparent(JComponent component) {
        component.setOpaque(false);
        if (component instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)component;
            JViewport viewport = scrollPane.getViewport();
            viewport.setOpaque(false);
            Component c = viewport.getView();
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(false);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.painter != null) {
            Dimension d = this.getSize();
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.painter);
            g2.fill(new Rectangle(0, 0, d.width, d.height));
        }
        if (this.image == null) {
            return;
        }
        switch (this.style) {
            case 0: {
                this.drawScaled(g);
                break;
            }
            case 1: {
                this.drawTiled(g);
                break;
            }
            case 2: {
                this.drawActual(g);
                break;
            }
            default: {
                this.drawScaled(g);
            }
        }
    }

    private void drawScaled(Graphics g) {
        Dimension d = this.getSize();
        g.drawImage(this.image, 0, 0, d.width, d.height, null);
    }

    private void drawTiled(Graphics g) {
        Dimension d = this.getSize();
        int width = this.image.getWidth(null);
        int height = this.image.getHeight(null);
        int x = 0;
        while (x < d.width) {
            int y = 0;
            while (y < d.height) {
                g.drawImage(this.image, x, y, null, null);
                y += height;
            }
            x += width;
        }
    }

    private void drawActual(Graphics g) {
        Dimension d = this.getSize();
        Insets insets = this.getInsets();
        int width = d.width - insets.left - insets.right;
        int height = d.height - insets.top - insets.left;
        float x = (float)(width - this.image.getWidth(null)) * this.alignmentX;
        float y = (float)(height - this.image.getHeight(null)) * this.alignmentY;
        g.drawImage(this.image, (int)x + insets.left, (int)y + insets.top, this);
    }
}

