/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.graphics;

import com.aragon.cache.CacheArchive;
import com.aragon.graphics.DrawingArea;
import com.aragon.util.Stream;

public final class Background
extends DrawingArea {
    public int[] imgPixels;
    public final int[] palette;
    public int imgWidth;
    public int imgHeight;
    public int xDrawOffset;
    public int yDrawOffset;
    public int libWidth;
    private int libHeight;

    public Background(int width, int height, int[] palette, int[] pixels) {
        this.imgWidth = this.libWidth = width;
        this.imgHeight = this.libHeight = height;
        this.palette = palette;
        this.imgPixels = pixels;
    }

    public Background(CacheArchive streamLoader, String s, int i) {
        Stream stream = new Stream(streamLoader.getDataForName(String.valueOf(s) + ".dat"));
        Stream stream_1 = new Stream(streamLoader.getDataForName("index.dat"));
        stream_1.currentOffset = stream.readUnsignedWord();
        this.libWidth = stream_1.readUnsignedWord();
        this.libHeight = stream_1.readUnsignedWord();
        int j = stream_1.readUnsignedByte();
        this.palette = new int[j];
        int k = 0;
        while (k < j - 1) {
            this.palette[k + 1] = stream_1.read3Bytes();
            ++k;
        }
        int l = 0;
        while (l < i) {
            stream_1.currentOffset += 2;
            stream.currentOffset += stream_1.readUnsignedWord() * stream_1.readUnsignedWord();
            ++stream_1.currentOffset;
            ++l;
        }
        this.xDrawOffset = stream_1.readUnsignedByte();
        this.yDrawOffset = stream_1.readUnsignedByte();
        this.imgWidth = stream_1.readUnsignedWord();
        this.imgHeight = stream_1.readUnsignedWord();
        int type = stream_1.readUnsignedByte();
        int j1 = this.imgWidth * this.imgHeight;
        this.imgPixels = new int[j1];
        if (type == 0) {
            int k1 = 0;
            while (k1 < j1) {
                this.imgPixels[k1] = stream.readSignedByte();
                ++k1;
            }
            return;
        }
        if (type == 1) {
            int l1 = 0;
            while (l1 < this.imgWidth) {
                int i2 = 0;
                while (i2 < this.imgHeight) {
                    this.imgPixels[l1 + i2 * this.imgWidth] = stream.readSignedByte();
                    ++i2;
                }
                ++l1;
            }
        }
    }

    public void reduceSetOffset() {
        this.libWidth /= 2;
        this.libHeight /= 2;
        int[] pixelBuffer = new int[this.libWidth * this.libHeight];
        int i = 0;
        int j = 0;
        while (j < this.imgHeight) {
            int k = 0;
            while (k < this.imgWidth) {
                pixelBuffer[(k + this.xDrawOffset >> 1) + (j + this.yDrawOffset >> 1) * this.libWidth] = this.imgPixels[i++];
                ++k;
            }
            ++j;
        }
        this.imgPixels = pixelBuffer;
        this.imgWidth = this.libWidth;
        this.imgHeight = this.libHeight;
        this.xDrawOffset = 0;
        this.yDrawOffset = 0;
    }

    public void setOffset() {
        if (this.imgWidth == this.libWidth && this.imgHeight == this.libHeight) {
            return;
        }
        int[] pixelBuffer = new int[this.libWidth * this.libHeight];
        int i = 0;
        int y = 0;
        while (y < this.imgHeight) {
            int x = 0;
            while (x < this.imgWidth) {
                pixelBuffer[x + this.xDrawOffset + (y + this.yDrawOffset) * this.libWidth] = this.imgPixels[i++];
                ++x;
            }
            ++y;
        }
        this.imgPixels = pixelBuffer;
        this.imgWidth = this.libWidth;
        this.imgHeight = this.libHeight;
        this.xDrawOffset = 0;
        this.yDrawOffset = 0;
    }

    public void spriteClip(int x, int y, int stretchWidth, int stretchHeight) {
        try {
            int width = this.imgWidth;
            int height = this.imgHeight;
            int k1 = 0;
            int l1 = 0;
            int i2 = (width << 16) / stretchWidth;
            int j2 = (height << 16) / stretchHeight;
            int k2 = this.libWidth;
            int l2 = this.libHeight;
            i2 = (k2 << 16) / stretchWidth;
            j2 = (l2 << 16) / stretchHeight;
            x += (this.xDrawOffset * stretchWidth + k2 - 1) / k2;
            y += (this.yDrawOffset * stretchHeight + l2 - 1) / l2;
            if (this.xDrawOffset * stretchWidth % k2 != 0) {
                k1 = (k2 - this.xDrawOffset * stretchWidth % k2 << 16) / stretchWidth;
            }
            if (this.yDrawOffset * stretchHeight % l2 != 0) {
                l1 = (l2 - this.yDrawOffset * stretchHeight % l2 << 16) / stretchHeight;
            }
            stretchWidth = stretchWidth * (this.imgWidth - (k1 >> 16)) / k2;
            stretchHeight = stretchHeight * (this.imgHeight - (l1 >> 16)) / l2;
            int i3 = x + y * DrawingArea.width;
            int j3 = DrawingArea.width - stretchWidth;
            if (y < DrawingArea.clipTop) {
                int k3 = DrawingArea.clipTop - y;
                stretchHeight -= k3;
                y = 0;
                i3 += k3 * DrawingArea.width;
                l1 += j2 * k3;
            }
            if (y + stretchHeight > DrawingArea.clipRight) {
                stretchHeight -= y + stretchHeight - DrawingArea.clipRight;
            }
            if (x < DrawingArea.clipLeft) {
                int width2 = DrawingArea.clipLeft - x;
                stretchWidth -= width2;
                x = 0;
                i3 += width2;
                k1 += i2 * width2;
                j3 += width2;
            }
            if (x + stretchWidth > DrawingArea.clipBottom) {
                int i4 = x + stretchWidth - DrawingArea.clipBottom;
                stretchWidth -= i4;
                j3 += i4;
            }
            this.plotScale(DrawingArea.pixels, this.imgPixels, this.palette, k1, l1, i3, j3, stretchWidth, stretchHeight, i2, j2, width);
        }
        catch (Exception exception) {
            System.out.println("error in sprite clipping routine");
        }
    }

    public void plotScale(int[] pixels, int[] imgPixels, int[] palette, int i, int j, int k, int l, int stretchWidth, int stretchHeight, int k1, int l1, int width) {
        try {
            int j2 = i;
            int k2 = -stretchHeight;
            while (k2 < 0) {
                int l2 = (j >> 16) * width;
                int i3 = -stretchWidth;
                while (i3 < 0) {
                    int byte0 = imgPixels[(i >> 16) + l2];
                    if (byte0 != 0) {
                        pixels[k++] = palette[byte0 & 0xFF];
                    } else {
                        ++k;
                    }
                    i += k1;
                    ++i3;
                }
                j += l1;
                i = j2;
                k += l;
                ++k2;
            }
        }
        catch (Exception exception) {
            System.out.println("error in plot_scale");
        }
    }

    public void decodePalette(int r, int g, int b) {
        int i1 = 0;
        while (i1 < this.palette.length) {
            int j1 = this.palette[i1] >> 16 & 0xFF;
            if ((j1 += r) < 0) {
                j1 = 0;
            } else if (j1 > 255) {
                j1 = 255;
            }
            int k1 = this.palette[i1] >> 8 & 0xFF;
            if ((k1 += g) < 0) {
                k1 = 0;
            } else if (k1 > 255) {
                k1 = 255;
            }
            int l1 = this.palette[i1] & 0xFF;
            if ((l1 += b) < 0) {
                l1 = 0;
            } else if (l1 > 255) {
                l1 = 255;
            }
            this.palette[i1] = (j1 << 16) + (k1 << 8) + l1;
            ++i1;
        }
    }

    public void drawBackground(int i, int k) {
        int l = (i += this.xDrawOffset) + (k += this.yDrawOffset) * DrawingArea.width;
        int i1 = 0;
        int j1 = this.imgHeight;
        int k1 = this.imgWidth;
        int l1 = DrawingArea.width - k1;
        int i2 = 0;
        if (k < DrawingArea.clipTop) {
            int j2 = DrawingArea.clipTop - k;
            j1 -= j2;
            k = DrawingArea.clipTop;
            i1 += j2 * k1;
            l += j2 * DrawingArea.width;
        }
        if (k + j1 > DrawingArea.clipBottom) {
            j1 -= k + j1 - DrawingArea.clipBottom;
        }
        if (i < DrawingArea.clipLeft) {
            int k2 = DrawingArea.clipLeft - i;
            k1 -= k2;
            i = DrawingArea.clipLeft;
            i1 += k2;
            l += k2;
            i2 += k2;
            l1 += k2;
        }
        if (i + k1 > DrawingArea.clipRight) {
            int l2 = i + k1 - DrawingArea.clipRight;
            k1 -= l2;
            i2 += l2;
            l1 += l2;
        }
        if (k1 > 0 && j1 > 0) {
            this.drawPixels(j1, DrawingArea.pixels, this.imgPixels, l1, l, k1, i1, this.palette, i2);
        }
    }

    private void drawPixels(int i, int[] ai, int[] abyte0, int j, int k, int l, int i1, int[] ai1, int j1) {
        int k1 = -(l >> 2);
        l = -(l & 3);
        int l1 = -i;
        while (l1 < 0) {
            int i2 = k1;
            while (i2 < 0) {
                int byte1;
                if ((byte1 = abyte0[i1++]) != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                byte1 = abyte0[i1++];
                if (byte1 != 0) {
                    ai[k++] = ai1[byte1 & 0xFF];
                } else {
                    ++k;
                }
                ++i2;
            }
            int j2 = l;
            while (j2 < 0) {
                int byte2;
                if ((byte2 = abyte0[i1++]) != 0) {
                    ai[k++] = ai1[byte2 & 0xFF];
                } else {
                    ++k;
                }
                ++j2;
            }
            k += j;
            i1 += j1;
            ++l1;
        }
    }
}

