/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.entity.definitions;

import com.aragon.client.Client;
import com.aragon.graphics.sprite.Sprite;
import com.aragon.graphics.sprite.SpriteLoader;
import com.aragon.ui.RSInterface;
import com.aragon.util.signlink;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PlayerRights {
    PLAYER(0),
    MODERATOR(1, 680),
    ADMINISTRATOR(2, 681),
    OWNER(3, 682),
    DEVELOPER(4, 683),
    DONATOR(5, String.valueOf(signlink.findcachedir()) + "Interfaces/animatedsprites/rank2.gif", -1),
    SUPER_DONATOR(6, String.valueOf(signlink.findcachedir()) + "Interfaces/animatedsprites/rank1.gif", -1),
    ULTRA_DONATOR(7, 687),
    ELITE_DONATOR(8, 688),
    LEGENDARY_DONATOR(9, 692),
    SUPPORT(10, 689),
    YOUTUBER(11, 690),
    CoolRank(12),
    UBER_DONATOR(13, 697),
    EPIC_DONATOR(14, 694),
    MYTHICAL_DONATOR(15),
    GODLY_DONATOR(16),
    MANAGER(17),
    ETERNAL_DONATOR(18),
    COMMUNITY_MANAGER(22, "Interfaces/Icons/Community", 0),
    EVENT_MANAGER(23);

    private int rights;
    private int spriteId;
    private String spriteLocation;
    public static ImmutableSet<PlayerRights> cachedPlayerRightsValues;
    public static Map<Long, Sprite> sprites;

    static {
        cachedPlayerRightsValues = ImmutableSet.copyOf((Object[])PlayerRights.values());
        sprites = new HashMap<Long, Sprite>();
    }

    private PlayerRights(int rights, String spriteLocation, int spriteId) {
        this.rights = rights;
        this.spriteLocation = spriteLocation;
        this.spriteId = spriteId;
    }

    private PlayerRights(int rights, int spriteId) {
        this(rights, null, spriteId);
    }

    private PlayerRights(int rights) {
        this(rights, -1);
    }

    public int getRights() {
        return this.rights;
    }

    public String getSpriteLocation() {
        return this.spriteLocation;
    }

    public int getSpriteId() {
        return this.spriteId;
    }

    public Sprite getSprite() {
        if (this.spriteId <= 0 && this.spriteLocation == null) {
            return null;
        }
        if (this.getSpriteId() == -1) {
            return SpriteLoader.fetchAnimatedSprite(this.spriteLocation);
        }
        if (this.spriteLocation != null) {
            return RSInterface.imageLoader(this.spriteId, this.spriteLocation);
        }
        return Client.cacheSprite[this.spriteId];
    }

    public static PlayerRights forRightsValue(int rightsValue) {
        Optional<PlayerRights> rights = cachedPlayerRightsValues.stream().filter(right -> right.getRights() == rightsValue).findFirst();
        if (rights.isPresent()) {
            return rights.get();
        }
        System.err.println("No rights for value " + rightsValue);
        return PLAYER;
    }
}

