/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.entity;

import com.aragon.entity.Animable;
import com.aragon.graphics.animation.FrameReader;
import com.aragon.graphics.animation.SpotAnim;
import com.aragon.graphics.model.Model;

public final class Projectile
extends Animable {
    public final int startTime;
    public final int speed;
    private double speedX;
    private double speedY;
    private double speedOverall;
    private double speedZ;
    private double timeLeftTillFinishZ;
    private boolean isMoving = false;
    private final int startX;
    private final int startY;
    private final int drawHeight;
    public final int endHeight;
    public double currentPositionX;
    public double currentPositionY;
    public double currentPositionZ;
    private final int slopeHeight;
    private final int radius;
    public final int lockOn;
    private final SpotAnim gfx;
    private int currentFrame;
    private int tick;
    public int rotationY;
    private int rotationX;
    public final int plane;

    public void calculateTracking(int currentTime, int targetY, int targetZ, int targetX) {
        if (!this.isMoving) {
            double distanceX = targetX - this.startX;
            double distanceY = targetY - this.startY;
            double distanceOverall = Math.sqrt(distanceX * distanceX + distanceY * distanceY);
            this.currentPositionX = (double)this.startX + distanceX * (double)this.radius / distanceOverall;
            this.currentPositionY = (double)this.startY + distanceY * (double)this.radius / distanceOverall;
            this.currentPositionZ = this.drawHeight;
        }
        double d1 = this.speed + 1 - currentTime;
        this.speedX = ((double)targetX - this.currentPositionX) / d1;
        this.speedY = ((double)targetY - this.currentPositionY) / d1;
        this.speedOverall = Math.sqrt(this.speedX * this.speedX + this.speedY * this.speedY);
        if (!this.isMoving) {
            this.speedZ = -this.speedOverall * Math.tan((double)this.slopeHeight * 0.02454369);
        }
        this.timeLeftTillFinishZ = 2.0 * ((double)targetZ - this.currentPositionZ - this.speedZ * d1) / (d1 * d1);
    }

    @Override
    public Model getRotatedModel() {
        Model model = this.gfx.getModel();
        if (model == null) {
            return null;
        }
        int j = -1;
        if (this.gfx.animation != null) {
            j = this.gfx.animation.frameIDs[this.currentFrame];
        }
        Model model_1 = new Model(true, FrameReader.isNullFrame(j), false, model);
        if (j != -1) {
            model_1.createBones();
            model_1.applyTransform(j);
            model_1.triangleSkin = null;
            model_1.vertexSkin = null;
        }
        if (this.gfx.getSizeXY() != 128 || this.gfx.getSizeZ() != 128) {
            model_1.scaleT(this.gfx.getSizeXY(), this.gfx.getSizeXY(), this.gfx.getSizeZ());
        }
        model_1.rotateX(this.rotationX);
        model_1.light(64 + this.gfx.shadow, 5050 + this.gfx.lightness, -90, -580, -90, true);
        return model_1;
    }

    public Projectile(int i, int j, int l, int i1, int j1, int k1, int l1, int i2, int j2, int k2, int gfxId) {
        this.gfx = SpotAnim.cache[gfxId];
        this.plane = k1;
        this.startX = j2;
        this.startY = i2;
        this.drawHeight = l1;
        this.startTime = l;
        this.speed = i1;
        this.slopeHeight = i;
        this.radius = j1;
        this.lockOn = k2;
        this.endHeight = j;
        this.isMoving = false;
    }

    public void processMovement(int nextFrame) {
        this.isMoving = true;
        this.currentPositionX += this.speedX * (double)nextFrame;
        this.currentPositionY += this.speedY * (double)nextFrame;
        this.currentPositionZ += this.speedZ * (double)nextFrame + 0.5 * this.timeLeftTillFinishZ * (double)nextFrame * (double)nextFrame;
        this.speedZ += this.timeLeftTillFinishZ * (double)nextFrame;
        this.rotationY = (int)(Math.atan2(this.speedX, this.speedY) * 325.949) + 1024 & 0x7FF;
        this.rotationX = (int)(Math.atan2(this.speedZ, this.speedOverall) * 325.949) & 0x7FF;
        if (this.gfx.animation != null) {
            this.tick += nextFrame;
            while (this.tick > this.gfx.animation.getFrameLength(this.currentFrame)) {
                this.tick -= this.gfx.animation.getFrameLength(this.currentFrame) + 1;
                ++this.currentFrame;
                if (this.currentFrame < this.gfx.animation.frameCount) continue;
                this.currentFrame = 0;
            }
        }
    }
}

