/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.content.talents;

import com.aragon.client.Client;
import com.aragon.content.talents.Talent;
import com.aragon.content.talents.TalentManager;
import com.aragon.graphics.DrawingArea;
import com.aragon.graphics.TextDrawingArea;
import com.aragon.ui.RSInterface;
import com.aragon.util.ColorUtils;
import java.util.List;

public class TalentWidget {
    private String hoveredTalentName = null;
    private int tooltipX = 0;
    private int tooltipY = 0;
    public Talent selectedTalent = null;

    public void draw(RSInterface widget, int childX, int childY, int mouseX, int mouseY) {
        int baseX = childX;
        int baseY = childY;
        int tierHeight = 55;
        int tierSpacing = 10;
        int talentWidth = 75;
        this.hoveredTalentName = null;
        int tier = 6;
        while (tier >= 1) {
            List<Talent> talents = TalentManager.getTalentsByTier(tier);
            if (!talents.isEmpty()) {
                int y = baseY + (5 - tier) * (tierHeight + tierSpacing);
                int talentBoxHeight = 40;
                int circleRadius = 14;
                int circleCenterX = baseX + 10 + circleRadius;
                int circleCenterY = y + talentBoxHeight / 2;
                if (circleCenterY >= 40 && circleCenterY < widget.height) {
                    this.drawTierCircle(circleCenterX, circleCenterY, circleRadius, tier);
                }
                int totalWidth = talents.size() * talentWidth + (talents.size() - 1) * 20;
                int startX = baseX + (widget.width - totalWidth) / 2;
                if (!talents.isEmpty()) {
                    int firstTalentX = startX;
                    int lineWidth = firstTalentX - (circleCenterX + circleRadius);
                    this.drawConnection(circleCenterX + circleRadius, circleCenterY - 2, lineWidth, 4, false);
                }
                int i = 0;
                while (i < talents.size()) {
                    Talent talent = talents.get(i);
                    int x = startX + i * (talentWidth + 20);
                    boolean unlocked = this.isTalentUnlocked(talent.getId());
                    boolean hovered = this.isHovered(mouseX, mouseY, x, y, talentWidth, 40) && mouseY >= 40 && mouseY < widget.height;
                    this.drawTalentBox(x, y, talentWidth, 40, talent.getName(), unlocked, hovered);
                    if (hovered && this.selectedTalent == null) {
                        this.hoveredTalentName = "Select " + talent.getName();
                        this.tooltipX = mouseX + 10;
                        this.tooltipY = mouseY + 20;
                        if (this.tooltipX > 360) {
                            this.tooltipX = 360;
                        }
                        if (this.tooltipY > 300) {
                            this.tooltipY = 300;
                        }
                    }
                    if (i < talents.size() - 1) {
                        int connX = x + talentWidth;
                        int connY = y + 20;
                        this.drawConnection(connX, connY, 20, 4, unlocked);
                    }
                    ++i;
                }
            }
            --tier;
        }
        if (this.selectedTalent != null) {
            this.drawTalentDetailsWindow(this.selectedTalent, mouseX, mouseY);
        }
        this.drawTooltip();
    }

    private void drawTierCircle(int centerX, int centerY, int radius, int tier) {
        int borderColor = 3682339;
        int fillColor = 5919301;
        int textColor = 16758847;
        DrawingArea.drawCircle(centerX, centerY, radius, borderColor, 150);
        DrawingArea.fillCircle(centerX, centerY, radius - 2, fillColor, 150);
        String text = String.valueOf(tier);
        Client.getClient().newSmallFont.drawBasicString(text, centerX - 2, centerY + 5, textColor, -1);
    }

    public boolean isTalentUnlocked(int id) {
        return false;
    }

    private boolean isHovered(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
    }

    private void drawTalentBox(int x, int y, int w, int h, String name, boolean unlocked, boolean hovered) {
        int inner;
        int[] colors = new int[]{3682339, 5919301, ColorUtils.lightenColor(3946542, 1.1)};
        int n = inner = unlocked ? 6989903 : colors[2];
        if (hovered) {
            inner = ColorUtils.lightenColor(inner, 1.1);
        }
        DrawingArea.drawPixels(h, y, x, colors[0], w);
        DrawingArea.drawPixels(h - 2, y + 1, x + 1, colors[1], w - 2);
        DrawingArea.drawPixels(h - 4, y + 2, x + 2, inner, w - 4);
        int textHeight = 10;
        int textY = y + (h - textHeight) / 2 + textHeight;
        Client.normalFont.drawCenteredText(16758847, x + w / 2, name, textY, true);
    }

    private void drawConnection(int x, int y, int width, int height, boolean unlocked) {
        int[] colors = new int[]{3682339, 5919301, ColorUtils.lightenColor(3946542, 1.1)};
        int inner = unlocked ? 6989903 : colors[2];
        DrawingArea.drawPixels(height, y, x, colors[0], width);
        DrawingArea.drawPixels(height - 2, y + 1, x + 1, colors[1], width - 2);
        DrawingArea.drawPixels(height - 4, y + 2, x + 2, inner, width - 4);
    }

    private void drawTooltip() {
        if (this.hoveredTalentName == null || this.tooltipY > 310) {
            return;
        }
        int padding = 4;
        int textWidth = Client.normalFont.getTextWidth(this.hoveredTalentName);
        int boxWidth = textWidth + padding * 2;
        int boxHeight = 16;
        DrawingArea.drawPixels(boxHeight, this.tooltipY, this.tooltipX, 0, boxWidth);
        DrawingArea.drawPixels(boxHeight - 2, this.tooltipY + 1, this.tooltipX + 1, 0x3B3B3B, boxWidth - 2);
        DrawingArea.drawPixels(boxHeight - 4, this.tooltipY + 2, this.tooltipX + 2, 0x282828, boxWidth - 4);
        Client.normalFont.drawChatInput(0xFFCC66, this.tooltipX + padding, this.hoveredTalentName, this.tooltipY + 12, true);
    }

    private void drawTalentDetailsWindow(Talent talent, int mouseX, int mouseY) {
        int boxWidth = 180;
        int boxHeight = 100;
        int boxX = 150;
        int boxY = 120;
        int[] colors = new int[]{3682339, 5919301, ColorUtils.lightenColor(3946542, 1.1)};
        int inner = this.isTalentUnlocked(talent.getId()) ? 6989903 : colors[2];
        DrawingArea.drawPixels(boxHeight, boxY, boxX, colors[0], boxWidth);
        DrawingArea.drawPixels(boxHeight - 2, boxY + 1, boxX + 1, colors[1], boxWidth - 2);
        DrawingArea.drawPixels(boxHeight - 4, boxY + 2, boxX + 2, inner, boxWidth - 4);
        int titleY = boxY + 16;
        Client.boldFont.drawCenteredText(16758847, boxX + boxWidth / 2, talent.getName(), titleY, true);
        int textY = titleY + 14;
        String wrappedText = TalentWidget.getWrappedText(Client.normalFont, talent.getDescription(), boxWidth - 10);
        String[] lines = wrappedText.split("\n");
        int i = 0;
        while (i < Math.min(3, lines.length)) {
            Client.normalFont.drawChatInput(0xDDDDDD, boxX + 11, lines[i], textY + i * 12, true);
            ++i;
        }
        int buttonY = boxY + boxHeight - 24;
        if (this.isTalentUnlocked(talent.getId())) {
            int btnW = 80;
            this.drawTalentButton(boxX + boxWidth / 2 - btnW / 2, buttonY, btnW, 16, "Close", mouseX, mouseY);
        } else {
            this.drawTalentButton(boxX + 10, buttonY, 70, 16, "Cancel", mouseX, mouseY);
            this.drawTalentButton(boxX + boxWidth - 80, buttonY, 70, 16, "Unlock", mouseX, mouseY);
        }
    }

    private void drawTalentButton(int x, int y, int w, int h, String label, int mouseX, int mouseY) {
        int[] colors = new int[]{3682339, 5919301, ColorUtils.lightenColor(3946542, 1.1)};
        DrawingArea.drawPixels(h, y, x, colors[0], w);
        DrawingArea.drawPixels(h - 2, y + 1, x + 1, colors[1], w - 2);
        DrawingArea.drawPixels(h - 4, y + 2, x + 2, colors[2], w - 4);
        Client.normalFont.drawCenteredText(0xFFCC66, x + w / 2, label, y + 12, true);
        boolean hovered = this.isHovered(mouseX, mouseY, x, y, w, h);
        if (hovered && label != null) {
            this.hoveredTalentName = label;
            this.tooltipX = mouseX + 10;
            this.tooltipY = mouseY + 20;
            if (this.tooltipX > 360) {
                this.tooltipX = 360;
            }
            if (this.tooltipY > 300) {
                this.tooltipY = 300;
            }
        }
    }

    public static String getWrappedText(TextDrawingArea tda, String text, int width) {
        boolean last;
        if (text.contains("\\n") || tda.getTextWidth(text) <= width) {
            return text.replace("\\n", "\n");
        }
        int spaceWidth = tda.getTextWidth(" ");
        StringBuilder result = new StringBuilder(text.length());
        StringBuilder line = new StringBuilder();
        int lineLength = 0;
        int curIndex = 0;
        do {
            String curWord;
            int spaceIndex;
            if ((spaceIndex = text.indexOf(32, curIndex)) < 0) {
                last = true;
                curWord = text.substring(curIndex);
            } else {
                last = false;
                curWord = text.substring(curIndex, spaceIndex);
            }
            curIndex = spaceIndex + 1;
            int wordWidth = tda.getTextWidth(curWord);
            int newLength = lineLength + wordWidth + (line.length() > 0 ? spaceWidth : 0);
            if (newLength > width) {
                result.append(line.toString().trim()).append("\n");
                line = new StringBuilder(String.valueOf(curWord) + " ");
                lineLength = wordWidth + spaceWidth;
                continue;
            }
            line.append(curWord).append(" ");
            lineLength = newLength;
        } while (!last);
        if (line.length() > 0) {
            result.append(line.toString().trim());
        }
        return result.toString();
    }
}

