/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.content;

import com.aragon.entity.definitions.NPCDef;
import com.aragon.graphics.animation.Animation;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PetSystem {
    private final int[] modelArray;
    private final int modelArrayLength;
    private final int primaryModel;
    private final String name;
    private final String description;
    private static int animation;
    private static int animationDelay;
    public static int animationFrame;
    public static boolean updatePetAnimations;
    public static int setPetCombat;
    public static boolean isPetAnimationRunning;
    public static int petSelected;

    static {
        updatePetAnimations = false;
        isPetAnimationRunning = false;
        petSelected = 6260;
    }

    public PetSystem(NPCDef entity) {
        this.modelArray = entity.models;
        this.modelArrayLength = entity.models.length;
        this.primaryModel = entity.models[0];
        this.name = entity.name;
        this.description = entity.description;
        animation = entity.walkAnim;
        animationDelay = Animation.anims[PetSystem.animation].delays[animationFrame];
    }

    public static void petAnimationStep() {
        if (updatePetAnimations) {
            return;
        }
        if (++animationFrame >= Animation.anims[PetSystem.animation].frameIDs.length) {
            animationFrame = 0;
        }
    }

    public static void updateAnimations() {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                isPetAnimationRunning = true;
                PetSystem.petAnimationStep();
            }
        }, 0L, animationDelay == 0 ? 100 : animationDelay * 100, TimeUnit.MILLISECONDS);
    }

    public int getAnimationDelay() {
        return animationDelay;
    }

    public int getPrimaryModel() {
        return this.primaryModel;
    }

    public int getAnimation() {
        return animation;
    }

    public String getName() {
        return this.name;
    }

    public int getAnimationFrame() {
        return animationFrame;
    }

    public String getDescription() {
        return this.description;
    }

    public int getModelArrayLength() {
        return this.modelArrayLength;
    }

    public int[] getModelArray() {
        return this.modelArray;
    }

    public int getPetSelected() {
        return petSelected;
    }

    public void setPetSelected(int petID) {
        petSelected = petID;
    }
}

