/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.content;

import com.aragon.client.Client;
import java.util.ArrayList;
import java.util.List;

public class OverlayTimers {
    public static List<OverlayTimers> overlayTimers = new ArrayList<OverlayTimers>();
    public static final int WHITE = 0xFFFFFF;
    private int spriteId;
    private long timeStarted;
    private long timeToEnd;

    public OverlayTimers(int spriteId, long timeStarted, long timeToEnd) {
        this.spriteId = spriteId;
        this.timeStarted = timeStarted;
        this.timeToEnd = timeToEnd;
    }

    public static void remove(int spriteIdToRemove) {
        int index = 0;
        while (index < overlayTimers.size()) {
            OverlayTimers data = overlayTimers.get(index);
            if (data.spriteId == spriteIdToRemove) {
                overlayTimers.remove(index);
                break;
            }
            ++index;
        }
    }

    public static void clearAllTimers() {
        overlayTimers.clear();
    }

    public static void drawOverlayTimers() {
        if (!Client.overlayTimers) {
            return;
        }
        int xOffset = 0;
        int index = 0;
        while (index < overlayTimers.size()) {
            OverlayTimers data = overlayTimers.get(index);
            long currentTime = System.currentTimeMillis();
            if (currentTime > data.timeToEnd) {
                OverlayTimers.remove(data.spriteId);
            } else {
                int duration = (int)((data.timeToEnd - data.timeStarted) / 1000L);
                if (duration == 0) {
                    OverlayTimers.remove(data.spriteId);
                } else {
                    int seconds = (int)((long)duration - (currentTime - data.timeStarted) / 1000L);
                    int x = Client.clientSize == 0 ? 0 : Client.clientWidth - 300;
                    int y = Client.clientSize == 0 ? 235 : Client.clientHeight - 225;
                    Client.cacheSprite[1266].drawSprite3(x + 7, y - xOffset - 15, 100);
                    Client.cacheSprite[data.spriteId].drawSprite(x + 19, y - xOffset - 10);
                    Client.instance.newSmallFont.drawBasicString1(OverlayTimers.getTimeLeft(seconds), x + 26, y - xOffset + 26, true, 0xFFFFFF, true);
                    xOffset += 46;
                }
            }
            ++index;
        }
    }

    public static void addNewOverlay(int spriteId, int secondsDuration) {
        int index = 0;
        while (index < overlayTimers.size()) {
            OverlayTimers data = overlayTimers.get(index);
            if (data.spriteId == spriteId) {
                data.timeStarted = System.currentTimeMillis();
                data.timeToEnd = System.currentTimeMillis() + (long)(secondsDuration * 1000);
                return;
            }
            ++index;
        }
        overlayTimers.add(new OverlayTimers(spriteId, System.currentTimeMillis(), System.currentTimeMillis() + (long)(secondsDuration * 1000)));
    }

    public static String getTimeLeft(int seconds) {
        int value2;
        int hours = 0;
        int minutes = 0;
        int secondsLeft = 0;
        String time = "";
        if (seconds > 3600) {
            hours = seconds / 3600;
            time = String.valueOf(hours) + "h";
        }
        int value1 = 0;
        value1 = seconds - hours * 3600;
        if (value1 > 0 && (minutes = value1 / 60) > 0) {
            if (!time.isEmpty()) {
                time = String.valueOf(time) + " ";
            }
            time = String.valueOf(time) + minutes + "m";
        }
        if ((value2 = value1 - minutes * 60) >= 0) {
            secondsLeft = value2;
            if (!time.isEmpty()) {
                time = String.valueOf(time) + " ";
            }
            time = String.valueOf(time) + secondsLeft + "s";
        }
        return time;
    }
}

