/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.content;

import com.aragon.content.CustomItemDefinition;
import com.aragon.content.ItemHovers;
import java.io.FileReader;
import java.io.Reader;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CustomItemDefinitionLoader {
    public static void loadDefinitionsFromJson(String filePath) {
        long start = System.currentTimeMillis();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileReader reader = new FileReader(filePath);){
                JSONTokener tokener = new JSONTokener((Reader)reader);
                JSONArray array = new JSONArray(tokener);
                int i = 0;
                while (i < array.length()) {
                    JSONObject obj = array.getJSONObject(i);
                    int id = obj.getInt("id");
                    String name = obj.getString("name");
                    int[] bonuses = new int[18];
                    JSONObject bonusObj = obj.getJSONObject("bonus");
                    Iterator keys = bonusObj.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        Integer index = CustomItemDefinition.BONUS_INDEXES.get(key);
                        if (index == null) continue;
                        bonuses[index.intValue()] = (int)bonusObj.getDouble(key);
                    }
                    int aoe = obj.optInt("areaOfEffect", 0);
                    int critChance = obj.optInt("criticalStrikeChance", 0);
                    int critDamage = obj.optInt("criticalStrikeDamageBoost", 0);
                    int dropRate = obj.optInt("dropRateBoost", 0);
                    int hitCount = obj.optInt("hitCount", 0);
                    int speed = obj.optInt("attackSpeed", 0);
                    String equipmetType = obj.optString("equipmentType", "WEAPON");
                    Boolean isWeapon = obj.optBoolean("isWeapon", false);
                    ItemHovers.storeDefinition(id, name, bonuses, aoe, critChance, critDamage, dropRate, hitCount, speed, equipmetType, isWeapon);
                    ++i;
                }
                System.out.println("Loaded " + ItemHovers.getCache().size() + " item definitions.");
                System.out.println("Loading item definitions took " + (System.currentTimeMillis() - start) + "ms");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

