/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.content;

import com.aragon.content.CustomItemDefinitionLoader;
import com.aragon.util.signlink;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;

public class CustomItemDefinition {
    public int id;
    public String name;
    public String equipmentType = null;
    public boolean isWeapon = false;
    public int[] bonuses = new int[18];
    public int aoe = 0;
    public int critChance = 0;
    public int critDamage = 0;
    public int dropRate = 0;
    public int hitCount = 0;
    public int attackSpeed = 0;
    public static final Map<String, Integer> BONUS_INDEXES = new HashMap<String, Integer>();

    public String getFormattedBonuses() {
        StringBuilder builder = new StringBuilder();
        String[] names = new String[]{"Attack Stab", "Attack Slash", "Attack Crush", "Attack Magic", "Attack Ranged", "Stab Defence", "Slash Defence", "Crush Defence", "Magic Defence", "Ranged Defence", "Summoning Defence", "Absorb Melee", "Absorb Magic", "Absorb Ranged", "Strength", "Ranged Strength", "Prayer", "Magic Damage"};
        int i = 0;
        while (i < this.bonuses.length) {
            if (this.bonuses[i] != 0) {
                builder.append(names[i]).append(": ").append(this.bonuses[i]).append("\n");
            }
            ++i;
        }
        return builder.toString();
    }

    public static void init() {
        BONUS_INDEXES.put("attack_stab", 0);
        BONUS_INDEXES.put("attack_slash", 1);
        BONUS_INDEXES.put("attack_crush", 2);
        BONUS_INDEXES.put("attack_magic", 3);
        BONUS_INDEXES.put("attack_range", 4);
        BONUS_INDEXES.put("defence_stab", 5);
        BONUS_INDEXES.put("defence_slash", 6);
        BONUS_INDEXES.put("defence_crush", 7);
        BONUS_INDEXES.put("defence_magic", 8);
        BONUS_INDEXES.put("defence_range", 9);
        BONUS_INDEXES.put("defence_summoning", 10);
        BONUS_INDEXES.put("absorb_melee", 11);
        BONUS_INDEXES.put("absorb_magic", 12);
        BONUS_INDEXES.put("absorb_ranged", 13);
        BONUS_INDEXES.put("strength", 14);
        BONUS_INDEXES.put("ranged_strength", 15);
        BONUS_INDEXES.put("prayer", 16);
        BONUS_INDEXES.put("magic_damage", 17);
        Path path = Paths.get(String.valueOf(signlink.findcachedir()) + "items.json", new String[0]);
        CustomItemDefinitionLoader.loadDefinitionsFromJson(path.toString());
    }

    public String getCustomStats() {
        StringBuilder builder = new StringBuilder();
        if (this.aoe > 0) {
            builder.append("AOE Radius: ").append(this.aoe).append("\n");
        }
        if (this.critChance > 0) {
            builder.append("Crit Chance: ").append(this.critChance).append("%\n");
        }
        if (this.critDamage > 0) {
            builder.append("Crit Damage: ").append(this.critDamage).append("%\n");
        }
        if (this.dropRate > 0) {
            builder.append("Drop Rate Boost: ").append(this.dropRate).append("%\n");
        }
        if (this.hitCount > 0) {
            builder.append("Hit Count: ").append(this.hitCount).append("\n");
        }
        if (this.attackSpeed > 0) {
            builder.append("Attack Speed: ").append(this.attackSpeed).append("\n");
        }
        return builder.toString();
    }

    public boolean hasStats() {
        return IntStream.of(this.bonuses).anyMatch(bonus -> bonus > 0);
    }

    public int[] getBonuses() {
        return this.bonuses;
    }

    public String toString() {
        return String.valueOf(this.name) + " (ID: " + this.id + ")\n" + this.getFormattedBonuses() + this.getCustomStats();
    }
}

