/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.content;

public class AutoLoginManager {
    private static boolean usedLoginAttempt = false;
    private static LoginDetails loginDetails;

    public static void store(String username, String password) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Username cannot be null or empty.");
        }
        loginDetails = new LoginDetails(username, password);
        usedLoginAttempt = false;
    }

    public static LoginDetails get() {
        return loginDetails;
    }

    public static boolean hasLoginDetails() {
        return loginDetails != null && loginDetails.getUsername() != null;
    }

    public static void markLoginUsed() {
        usedLoginAttempt = true;
    }

    public static boolean hasUsedLoginAttempt() {
        return usedLoginAttempt;
    }

    public static void clear() {
        loginDetails = null;
        usedLoginAttempt = false;
    }

    public static class LoginDetails {
        private final String username;
        private final String password;

        public LoginDetails(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

