/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client.plugins;

import com.aragon.client.Client;
import com.aragon.client.api.config.ConfigGroup;
import com.aragon.client.api.config.ConfigItem;
import com.aragon.client.api.event.ConfigChangedEvent;
import com.aragon.client.api.event.Subscribe;
import com.aragon.client.api.event.TileMarkerAddedEvent;
import com.aragon.client.api.event.TileMarkerEditedEvent;
import com.aragon.client.api.plugin.Plugin;
import com.aragon.client.api.plugin.PluginInfo;
import com.aragon.client.api.plugin.PluginManager;
import com.aragon.world.HighlightTile;
import java.awt.Color;

@PluginInfo(name="Tile Marker", description="Customize appearance of tile markers", enabledByDefault=false)
public class TileMarkerEditor
implements Plugin {
    public TileMarkerEditorConfig config;
    private int currentMarkerId = -1;
    private int currentWorldX = -1;
    private int currentWorldY = -1;
    private int currentPlane = -1;

    @Override
    public void onStart() {
        System.out.println("Tile Marker Editor plugin started!");
    }

    @Override
    public void onStop() {
        System.out.println("Tile Marker Editor plugin stopped!");
    }

    @Override
    public Object getConfig() {
        return this.config;
    }

    @Subscribe
    public void onTileMarkerAdded(TileMarkerAddedEvent event) {
        this.currentMarkerId = event.getMarkerId();
        this.currentWorldX = event.getWorldX();
        this.currentWorldY = event.getWorldY();
        this.currentPlane = event.getPlane();
        System.out.println("\u2705 Marker #" + this.currentMarkerId + " added! Updating config panel...");
        PluginManager pluginManager = Client.getPluginManager();
        Color oldColor = this.config.getMarkerColor();
        Color newColor = new Color(255, 0, 0);
        this.config.setMarkerColor(newColor);
        if (pluginManager != null) {
            pluginManager.triggerEvent(new ConfigChangedEvent("tileMarkerEditor", "markerColor", oldColor, newColor));
        }
        int oldAlpha = this.config.getMarkerAlpha();
        int newAlpha = 80;
        this.config.setMarkerAlpha(newAlpha);
        if (pluginManager != null) {
            pluginManager.triggerEvent(new ConfigChangedEvent("tileMarkerEditor", "markerAlpha", oldAlpha, newAlpha));
        }
        int oldBorderSize = this.config.getBorderSize();
        int newBorderSize = 2;
        this.config.setBorderSize(newBorderSize);
        if (pluginManager != null) {
            pluginManager.triggerEvent(new ConfigChangedEvent("tileMarkerEditor", "borderSize", oldBorderSize, newBorderSize));
        }
        String oldLabel = this.config.getMarkerLabel();
        String newLabel = "Marker #" + this.currentMarkerId;
        this.config.setMarkerLabel(newLabel);
        if (pluginManager != null) {
            pluginManager.triggerEvent(new ConfigChangedEvent("tileMarkerEditor", "markerLabel", oldLabel, newLabel));
        }
        this.applyChangesToMarker();
    }

    @Subscribe
    public void onTileMarkerEdited(TileMarkerEditedEvent event) {
        this.currentMarkerId = event.getMarkerId();
        this.currentWorldX = event.getWorldX();
        this.currentWorldY = event.getWorldY();
        this.currentPlane = event.getPlane();
        System.out.println("\u2705 Marker #" + this.currentMarkerId + " added! Updating config panel...");
        PluginManager pluginManager = Client.getPluginManager();
        Color oldColor = this.config.getMarkerColor();
        Color newColor = new Color(event.getColor());
        this.config.setMarkerColor(newColor);
        if (pluginManager != null) {
            pluginManager.triggerEvent(new ConfigChangedEvent("tileMarkerEditor", "markerColor", oldColor, newColor));
        }
        int oldAlpha = this.config.getMarkerAlpha();
        int newAlpha = event.getAlpha();
        this.config.setMarkerAlpha(newAlpha);
        if (pluginManager != null) {
            pluginManager.triggerEvent(new ConfigChangedEvent("tileMarkerEditor", "markerAlpha", oldAlpha, newAlpha));
        }
        int oldBorderSize = this.config.getBorderSize();
        int newBorderSize = event.getBorderSize();
        this.config.setBorderSize(newBorderSize);
        if (pluginManager != null) {
            pluginManager.triggerEvent(new ConfigChangedEvent("tileMarkerEditor", "borderSize", oldBorderSize, newBorderSize));
        }
        String oldLabel = this.config.getMarkerLabel();
        String newLabel = event.getLabel();
        this.config.setMarkerLabel(newLabel);
        if (pluginManager != null) {
            pluginManager.triggerEvent(new ConfigChangedEvent("tileMarkerEditor", "markerLabel", oldLabel, newLabel));
        }
        this.applyChangesToMarker();
    }

    @Subscribe
    public void onConfigChanged(ConfigChangedEvent event) {
        if (!"tileMarkerEditor".equals(event.getConfigGroup())) {
            return;
        }
        System.out.println("Config changed: " + event.getKey() + " = " + event.getNewValue());
        this.applyChangesToMarker();
    }

    private void applyChangesToMarker() {
        if (this.currentMarkerId == -1 || Client.getClient() == null || Client.getClient().worldController == null) {
            return;
        }
        HighlightTile marker = Client.getClient().worldController.userMarkers.get(this.currentMarkerId);
        if (marker == null) {
            return;
        }
        marker.color = this.config.getMarkerColor().getRGB();
        marker.alpha = this.config.getMarkerAlpha();
        marker.borderSize = this.config.getBorderSize();
        marker.markerLabel = this.config.getMarkerLabel();
        int localX = this.currentWorldX - Client.getBaseX();
        int localY = this.currentWorldY - Client.getBaseY();
        if (localX >= 0 && localY >= 0 && localX < 104 && localY < 104) {
            Client.getClient().worldController.highlightTiles[this.currentPlane][localX][localY] = marker;
        }
        System.out.println("\u2705 Applied changes to marker #" + this.currentMarkerId);
    }

    public void deleteCurrentMarker() {
        if (this.currentMarkerId == -1 || Client.getClient() == null || Client.getClient().worldController == null) {
            System.out.println("No active marker to delete");
            return;
        }
        Client.getClient().worldController.removeUserMarker(this.currentMarkerId);
        System.out.println("Deleted marker #" + this.currentMarkerId);
        this.currentMarkerId = -1;
        this.currentWorldX = -1;
        this.currentWorldY = -1;
        this.currentPlane = -1;
    }

    @ConfigGroup(value="tileMarkerEditor")
    public static class TileMarkerEditorConfig {
        private String markerLabel = "";
        private Color markerColor = new Color(255, 0, 0);
        private int markerAlpha = 150;
        private int borderSize = 2;

        @ConfigItem(key="markerLabel", name="Marker Label", description="Text label for this marker")
        public String getMarkerLabel() {
            return this.markerLabel;
        }

        public void setMarkerLabel(String markerLabel) {
            this.markerLabel = markerLabel;
        }

        @ConfigItem(key="markerColor", name="Marker Color", description="Color of the tile marker")
        public Color getMarkerColor() {
            return this.markerColor;
        }

        public void setMarkerColor(Color markerColor) {
            this.markerColor = markerColor;
        }

        @ConfigItem(key="markerAlpha", name="Transparency", description="Alpha/transparency value (0-255)", min=0, max=255)
        public int getMarkerAlpha() {
            return this.markerAlpha;
        }

        public void setMarkerAlpha(int markerAlpha) {
            this.markerAlpha = markerAlpha;
        }

        @ConfigItem(key="borderSize", name="Border Size", description="Thickness of the marker border", min=0, max=20)
        public int getBorderSize() {
            return this.borderSize;
        }

        public void setBorderSize(int borderSize) {
            this.borderSize = borderSize;
        }
    }
}

