/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client.plugins;

import com.aragon.client.Client;
import com.aragon.client.api.config.ConfigGroup;
import com.aragon.client.api.config.ConfigItem;
import com.aragon.client.api.event.GameTick;
import com.aragon.client.api.event.RenderEvent;
import com.aragon.client.api.event.Subscribe;
import com.aragon.client.api.plugin.Plugin;
import com.aragon.client.api.plugin.PluginInfo;
import com.aragon.entity.Player;
import com.aragon.world.HighlightTile;
import java.awt.Color;

@PluginInfo(name="Tile Indicator", description="Marks the tile you last clicked on and the tile you're hovering over.", enabledByDefault=false)
public class TileIndicator
implements Plugin {
    public TileIndicatorConfig config;
    private boolean isRunning = false;
    private int playerLastX = -1;
    private int playerLastY = -1;
    private int ticksSinceLastMove = 0;
    private boolean hasDestinationMarker = false;
    private static final int TICKS_BEFORE_REMOVE = 2;

    @Override
    public void onStart() {
        System.out.println("Tile Indicator plugin started!");
        this.isRunning = true;
        this.playerLastX = -1;
        this.playerLastY = -1;
        this.ticksSinceLastMove = 0;
        this.hasDestinationMarker = false;
    }

    @Override
    public void onStop() {
        System.out.println("Tile Indicator plugin stopped!");
        this.isRunning = false;
        this.cleanupAllHighlights();
    }

    private void cleanupAllHighlights() {
        if (Client.getClient() == null || Client.getClient().worldController == null) {
            return;
        }
        if (this.hasDestinationMarker) {
            this.removeDestinationMarker();
            this.hasDestinationMarker = false;
        }
        if (Client.getClient().worldController.playerStandingHighlight != null) {
            HighlightTile standing = Client.getClient().worldController.playerStandingHighlight;
            Client.getClient().worldController.removeHighlightLocal(standing.plane, standing.localX, standing.localY);
        }
        System.out.println("Cleaned up all tile highlights");
    }

    @Override
    public Object getConfig() {
        return this.config;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.isRunning) {
            return;
        }
        Player myPlayer = Client.myPlayer;
        if (myPlayer == null) {
            return;
        }
        int currentX = myPlayer.x;
        int currentY = myPlayer.y;
        if (this.playerLastX == -1 || this.playerLastY == -1) {
            this.playerLastX = currentX;
            this.playerLastY = currentY;
            this.ticksSinceLastMove = 0;
            return;
        }
        if (currentX != this.playerLastX || currentY != this.playerLastY) {
            this.ticksSinceLastMove = 0;
            this.hasDestinationMarker = true;
        } else {
            ++this.ticksSinceLastMove;
            if (this.ticksSinceLastMove >= 2 && this.hasDestinationMarker) {
                this.removeDestinationMarker();
                this.hasDestinationMarker = false;
            }
        }
        this.playerLastX = currentX;
        this.playerLastY = currentY;
    }

    private void removeDestinationMarker() {
        if (Client.getClient() == null || Client.getClient().worldController == null) {
            return;
        }
        int destWorldX = Client.getClient().bigX[0] + Client.getBaseX();
        int destWorldY = Client.getClient().bigY[0] + Client.getBaseY();
        Client.getClient().worldController.removeHighlightWorld(Client.getClient().plane, destWorldX, destWorldY);
    }

    @Subscribe
    public void onRender(RenderEvent event) {
        if (!this.isRunning || this.config == null) {
            return;
        }
        Player myPlayer = Client.myPlayer;
        if (myPlayer == null) {
            return;
        }
        int worldTileX = myPlayer.x / 128 + Client.getBaseX();
        int worldTileY = myPlayer.y / 128 + Client.getBaseY();
        if (this.config.isEnablePlayerDestinationTile() && this.hasDestinationMarker) {
            Client.getClient().worldController.addHighlightWorld(Client.getClient().plane, Client.getClient().bigX[0] + Client.getBaseX(), Client.getClient().bigY[0] + Client.getBaseY(), this.config.getPlayerDestinationTileColor().getRGB(), this.config.getPlayerDestinationTileAlpha(), this.config.getPlayerDestinationTileBorderSize(), HighlightTile.HighlightType.WALK_DESTINATION);
        }
        if (this.config.isEnablePlayerStandingTile()) {
            Client.getClient().worldController.addHighlightWorld(Client.getClient().plane, worldTileX, worldTileY, this.config.getPlayerStandingTileColor().getRGB(), this.config.getPlayerStandingTileAlpha(), this.config.getPlayerStandingTileBorderSize(), HighlightTile.HighlightType.PLAYER_STANDING);
        }
    }

    @ConfigGroup(value="tileIndicator")
    public static class TileIndicatorConfig {
        private boolean enablePlayerStandingTile = true;
        private Color playerStandingTileColor = Color.YELLOW;
        private int playerStandingTileAlpha = 80;
        private int playerStandingTileBorderSize = 2;
        private boolean enablePlayerDestinationTile = true;
        private Color playerDestinationTileColor = Color.CYAN;
        private int playerDestinationTileAlpha = 80;
        private int playerDestinationTileBorderSize = 2;
        private boolean enableHoveredTile = false;
        private Color hoveredTileColor = Color.BLACK;
        private int hoveredTileAlpha = 60;
        private int hoveredTileBorderSize = 2;

        @ConfigItem(key="enablePlayerStandingTile", name="Show Player Tile Indicator", description="Display Player Tile Indicator")
        public boolean isEnablePlayerStandingTile() {
            return this.enablePlayerStandingTile;
        }

        public void setEnablePlayerStandingTile(boolean enablePlayerStandingTile) {
            this.enablePlayerStandingTile = enablePlayerStandingTile;
        }

        @ConfigItem(key="playerStandingTileColor", name="Player Tile Color", description="Color of the tile player is standing on")
        public Color getPlayerStandingTileColor() {
            return this.playerStandingTileColor;
        }

        public void setPlayerStandingTileColor(Color playerStandingTileColor) {
            this.playerStandingTileColor = playerStandingTileColor;
        }

        @ConfigItem(key="playerStandingTileAlpha", name="Player Tile Alpha", description="Transparency of player tile (0-255)", min=0, max=255)
        public int getPlayerStandingTileAlpha() {
            return this.playerStandingTileAlpha;
        }

        public void setPlayerStandingTileAlpha(int playerStandingTileAlpha) {
            this.playerStandingTileAlpha = playerStandingTileAlpha;
        }

        @ConfigItem(key="playerStandingTileBorderSize", name="Player Tile Border", description="Border thickness for player tile", min=0, max=20)
        public int getPlayerStandingTileBorderSize() {
            return this.playerStandingTileBorderSize;
        }

        public void setPlayerStandingTileBorderSize(int playerStandingTileBorderSize) {
            this.playerStandingTileBorderSize = playerStandingTileBorderSize;
        }

        @ConfigItem(key="enablePlayerDestinationTile", name="Show Destination Tile", description="Display destination tile indicator")
        public boolean isEnablePlayerDestinationTile() {
            return this.enablePlayerDestinationTile;
        }

        public void setEnablePlayerDestinationTile(boolean enablePlayerDestinationTile) {
            this.enablePlayerDestinationTile = enablePlayerDestinationTile;
        }

        @ConfigItem(key="playerDestinationTileColor", name="Destination Tile Color", description="Color of the destination tile")
        public Color getPlayerDestinationTileColor() {
            return this.playerDestinationTileColor;
        }

        public void setPlayerDestinationTileColor(Color playerDestinationTileColor) {
            this.playerDestinationTileColor = playerDestinationTileColor;
        }

        @ConfigItem(key="playerDestinationTileAlpha", name="Destination Tile Alpha", description="Transparency of destination tile (0-255)", min=0, max=255)
        public int getPlayerDestinationTileAlpha() {
            return this.playerDestinationTileAlpha;
        }

        public void setPlayerDestinationTileAlpha(int playerDestinationTileAlpha) {
            this.playerDestinationTileAlpha = playerDestinationTileAlpha;
        }

        @ConfigItem(key="playerDestinationTileBorderSize", name="Destination Tile Border", description="Border thickness for destination tile", min=0, max=20)
        public int getPlayerDestinationTileBorderSize() {
            return this.playerDestinationTileBorderSize;
        }

        public void setPlayerDestinationTileBorderSize(int playerDestinationTileBorderSize) {
            this.playerDestinationTileBorderSize = playerDestinationTileBorderSize;
        }
    }
}

