/*
 * Decompiled with CFR 0.152.
 */
package com.aragon.client.plugins;

import com.aragon.client.api.config.ConfigGroup;
import com.aragon.client.api.config.ConfigItem;
import com.aragon.client.api.event.GameTick;
import com.aragon.client.api.event.RenderEvent;
import com.aragon.client.api.event.Subscribe;
import com.aragon.client.api.plugin.Plugin;
import com.aragon.client.api.plugin.PluginInfo;
import com.aragon.graphics.TextDrawingArea;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

@PluginInfo(name="FPS Counter", description="Displays frames per second on the game screen.", enabledByDefault=false)
public class FPSCounterPlugin
implements Plugin {
    public FPSCounterConfig config;
    private long lastTime = System.nanoTime();
    private int frames = 0;
    private int fps = 0;

    @Override
    public void onStart() {
        System.out.println("FPS Counter plugin started!");
    }

    @Override
    public void onStop() {
        System.out.println("FPS Counter plugin stopped!");
    }

    @Override
    public Object getConfig() {
        return this.config;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        long currentTime = System.nanoTime();
        if (currentTime - this.lastTime >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.lastTime = currentTime;
        }
    }

    @Subscribe
    public void onRender(RenderEvent event) {
        if (this.config == null || !this.config.isEnabled()) {
            return;
        }
        ++this.frames;
        TextDrawingArea textDrawingArea = event.getTextDrawingArea();
        Graphics2D g = event.getGraphics();
        String fpsText = "FPS: " + this.fps;
        int x = this.config.getXPosition();
        int y = this.config.getYPosition();
        Color textColor = this.config.getTextColor();
        if (textDrawingArea != null) {
            textDrawingArea.drawChatInput(textColor.getRGB(), x, fpsText, y, this.config.isShowBackground());
        } else if (g != null) {
            Font font = new Font("Arial", 1, 12);
            g.setFont(font);
            FontMetrics metrics = g.getFontMetrics(font);
            int textWidth = metrics.stringWidth(fpsText);
            int textHeight = metrics.getHeight();
            if (this.config.isShowBackground()) {
                g.setColor(new Color(0, 0, 0, 150));
                g.fillRect(x - 5, y - textHeight + 5, textWidth + 10, textHeight);
            }
            g.setColor(textColor);
            g.drawString(fpsText, x, y);
        }
    }

    @ConfigGroup(value="fpscounter")
    public static class FPSCounterConfig {
        private boolean enabled = true;
        private int xPosition = 10;
        private int yPosition = 30;
        private Color textColor = Color.YELLOW;
        private boolean showBackground = true;

        @ConfigItem(key="enabled", name="Show FPS Counter", description="Display FPS counter on screen")
        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @ConfigItem(key="xPosition", name="X Position", description="Horizontal position of the FPS counter", min=0, max=800)
        public int getXPosition() {
            return this.xPosition;
        }

        public void setXPosition(int xPosition) {
            this.xPosition = xPosition;
        }

        @ConfigItem(key="yPosition", name="Y Position", description="Vertical position of the FPS counter", min=0, max=600)
        public int getYPosition() {
            return this.yPosition;
        }

        public void setYPosition(int yPosition) {
            this.yPosition = yPosition;
        }

        @ConfigItem(key="textColor", name="Text Color", description="Color of the FPS counter text (RGB)")
        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color textColor) {
            this.textColor = textColor;
        }

        @ConfigItem(key="showBackground", name="Show Shadow", description="Display a dark background behind the text")
        public boolean isShowBackground() {
            return this.showBackground;
        }

        public void setShowBackground(boolean showBackground) {
            this.showBackground = showBackground;
        }
    }
}

